/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.comm.snmp.raid;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.comm.CommVarBind;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBindList;
import com.sanrad.nms.server.comm.snmp.raid.NexsanRaidMibItem;
import com.sanrad.nms.server.comm.snmp.raid.NexsanRaidSubsystem;
import com.sanrad.nms.server.comm.snmp.raid.RaidConfigurationException;
import com.sanrad.nms.server.comm.snmp.raid.RaidController;
import com.sanrad.nms.server.comm.snmp.raid.RaidSubsystem;
import com.sanrad.nms.server.util.types.SrIpAddress;
import com.sanrad.nms.server.util.types.SrString;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class NexsanRaidController
implements RaidController {
    private static SrLogger theLogger = SrLogger.getLogger();
    Map<String, NexsanRaidSubsystem> myIpToRaidSystemMap = new HashMap<String, NexsanRaidSubsystem>();
    private static NexsanRaidController theInstance = new NexsanRaidController();
    private final String myStorageMgmtApplicationPath = "./raid/nexsan";
    private final String myStorageMgmtApplicationName = "nexsan";
    private static final String COMMAND_SUCCESS_MSG = "Registration Completed";

    private NexsanRaidController() {
    }

    public static NexsanRaidController getInstance() {
        return theInstance;
    }

    @Override
    public RaidSubsystem addOrReplaceRaid(char aAgentIndex, SrString raidName, SrIpAddress ... aRaidIPs) throws RaidConfigurationException {
        SrIpAddress raidIP = null;
        if (aRaidIPs == null) {
            throw new RaidConfigurationException(aAgentIndex, "Failed Adding RAID because the IPs list which was sent is null. AgentIndex = " + aAgentIndex);
        }
        if (aRaidIPs.length == 0) {
            throw new RaidConfigurationException(aAgentIndex, "The number of IPs = " + aRaidIPs.length + " received for setting the RAID is invalid. AgentIndex = " + aAgentIndex);
        }
        raidIP = aRaidIPs[0];
        if (raidIP == null) {
            throw new RaidConfigurationException(aAgentIndex, "The IP for the RAID is null. AgentIndex = " + aAgentIndex);
        }
        NexsanRaidSubsystem newRaid = new NexsanRaidSubsystem(raidName, raidIP);
        NexsanRaidSubsystem existingRaid = this.myIpToRaidSystemMap.get(newRaid.getRaidSysID());
        if (existingRaid != null) {
            theLogger.info(SrLogCategories.RAID, "The RAID ", existingRaid.getRaidSysID(), " Will be replaced by the RAID ", newRaid.getRaidSysID(), " for Agentindex=", Character.valueOf(aAgentIndex));
        }
        this.myIpToRaidSystemMap.put(newRaid.getRaidSysID(), newRaid);
        return newRaid;
    }

    @Override
    public void registerSnmpManager(SrIpAddress snmpMgrIpAddr, RaidSubsystem aRaidSys, char agentIndex) throws RaidConfigurationException {
        this.executeSnmpManagerOperation(snmpMgrIpAddr, aRaidSys.getIPAddresses().get(0), agentIndex);
    }

    @Override
    public void unregisterSnmpManager(SrIpAddress snmpMgrIpAddr, RaidSubsystem aRaidSys, char agentIndex) throws RaidConfigurationException {
        this.executeSnmpManagerOperation(null, aRaidSys.getIPAddresses().get(0), agentIndex);
    }

    @Override
    public void removeRaid(char agentIndex, RaidSubsystem existingRaid) throws RaidConfigurationException {
        this.myIpToRaidSystemMap.remove(existingRaid.getRaidSysID());
    }

    @Override
    public void renameRaid(char agentIndex, RaidSubsystem existingRaid, String raidName) throws RaidConfigurationException {
        throw new UnsupportedOperationException("Renaming Nexsan RAID is not supported");
    }

    @Override
    public String extractRaidId(SrSnmpVarBindList aSrVbList) {
        if (aSrVbList == null) {
            return null;
        }
        CommVarBind raidIdVarbind = aSrVbList.getVarBind(NexsanRaidMibItem.DEVICE_HOST_IP);
        if (raidIdVarbind == null) {
            return null;
        }
        return raidIdVarbind.getValue().toString();
    }

    private void executeSnmpManagerOperation(SrIpAddress aSnmpMgrIpAddr, SrIpAddress aRaidIP, char aAgentIndex) throws RaidConfigurationException {
        String osName = System.getProperty("os.name");
        if (osName == null || !osName.toLowerCase().contains("windows")) {
            theLogger.error(SrLogCategories.RAID, "Only internal attach RAID is performed for the Nexsan RAID (", aRaidIP, ") since the OS is ", osName);
            return;
        }
        StringBuilder logStr = null;
        try {
            StringBuilder command = new StringBuilder();
            command.append("nexsan");
            command.append(" -l ");
            command.append("http://" + aRaidIP.toString() + "/admin/snmpconf.asp");
            command.append(" -ip ");
            if (aSnmpMgrIpAddr != null) {
                command.append(aSnmpMgrIpAddr.toString());
            } else {
                command.append("\" \"");
            }
            logStr = new StringBuilder("Nexsan>").append((CharSequence)command);
            String[] splits = command.toString().split(" ");
            splits[0] = "./raid/nexsan" + File.separator + splits[0];
            ProcessBuilder procBuilder = new ProcessBuilder(splits);
            procBuilder.directory(new File("./raid/nexsan"));
            Process process = procBuilder.start();
            ArrayList<String> processOutput = this.getProcessOutput(process, aAgentIndex);
            logStr.append(" --> ").append(processOutput);
            if (!NexsanRaidController.isSuccess(processOutput)) {
                throw new RaidConfigurationException(aAgentIndex, "Failed to register Snmp manager " + aSnmpMgrIpAddr + " to RAID " + aRaidIP);
            }
        }
        catch (IOException e) {
            try {
                throw new RaidConfigurationException(aAgentIndex, "Failed to register Snmp manager " + aSnmpMgrIpAddr + " to RAID " + aRaidIP, e);
            }
            catch (Throwable throwable) {
                theLogger.info(SrLogCategories.RAID, logStr);
                throw throwable;
            }
        }
        theLogger.info(SrLogCategories.RAID, logStr);
    }

    private ArrayList<String> getProcessOutput(Process aProcess, char aAgentIndex) throws RaidConfigurationException {
        BufferedReader processInput = new BufferedReader(new InputStreamReader(aProcess.getInputStream()));
        ArrayList<String> result = new ArrayList<String>();
        String line = null;
        try {
            while ((line = processInput.readLine()) != null) {
                result.add(line);
            }
            return result;
        }
        catch (IOException e) {
            throw new RaidConfigurationException(aAgentIndex, "Failed to read all RAID sub-systems", e);
        }
    }

    private static boolean isSuccess(ArrayList<String> aProcessOutput) {
        return aProcessOutput.contains(COMMAND_SUCCESS_MSG);
    }
}

