/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.comm.snmp.raid;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.comm.snmp.raid.RaidSubsystem;
import com.sanrad.nms.server.util.types.SrIpAddress;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class IbmRaidSubsystem
implements RaidSubsystem {
    private static SrLogger theLogger = SrLogger.getLogger();
    private String myName;
    private List<SrIpAddress> myIPAddresses;
    private String myWWN;

    private IbmRaidSubsystem(String aName, String aWWN, List<SrIpAddress> aIpAddresses) {
        if (aName == null || aName.length() == 0) {
            throw new IllegalArgumentException("RaidSubsystem doesn't have a name; the given name is " + aName);
        }
        if (aIpAddresses == null || aIpAddresses.isEmpty()) {
            throw new IllegalArgumentException("RaidSubsystem " + aName + " need at least one IP address; the gives addresses are " + aIpAddresses);
        }
        this.myName = aName;
        this.myWWN = aWWN;
        this.myIPAddresses = Collections.unmodifiableList(aIpAddresses);
    }

    @Override
    public List<SrIpAddress> getIPAddresses() {
        return new ArrayList<SrIpAddress>(this.myIPAddresses);
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public String getWWN() {
        return this.myWWN;
    }

    public void setWWN(String aWWN) {
        this.myWWN = aWWN;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RaidSubsystem ").append(this.myName).append(this.myIPAddresses);
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        IbmRaidSubsystem other = (IbmRaidSubsystem)obj;
        boolean nameMatch = this.myName.equals(other.myName);
        boolean ipMatchFound = false;
        if (this.myIPAddresses.size() == other.myIPAddresses.size() || this.myIPAddresses.size() > other.myIPAddresses.size()) {
            ipMatchFound = this.myIPAddresses.containsAll(other.myIPAddresses);
        } else if (this.myIPAddresses.size() < other.myIPAddresses.size()) {
            ipMatchFound = other.myIPAddresses.containsAll(this.myIPAddresses);
        }
        return nameMatch && ipMatchFound;
    }

    public boolean containsIPs(SrIpAddress ... aIPs) {
        if (aIPs == null || aIPs.length == 0) {
            return false;
        }
        for (SrIpAddress ip : aIPs) {
            if (ip == null || this.myIPAddresses.contains(ip)) continue;
            return false;
        }
        return true;
    }

    public boolean containsIPs(String ... aIPs) {
        if (aIPs == null || aIPs.length == 0) {
            return false;
        }
        ArrayList<SrIpAddress> ipList = new ArrayList<SrIpAddress>();
        for (String ip : aIPs) {
            if (ip == null) continue;
            ipList.add(new SrIpAddress(ip));
        }
        return this.containsIPs(ipList.toArray(new SrIpAddress[ipList.size()]));
    }

    static boolean containsSubsystemParams(String aInput) {
        return Parser.isMatch(aInput);
    }

    static IbmRaidSubsystem createRaidSubsystem(String aInput) {
        return Parser.createRaidSystem(aInput);
    }

    @Override
    public String getRaidSysID() {
        return this.getName();
    }

    private static class Parser {
        private static String NAME = "(\\S+)";
        private static String WWN = "(\\w+)";
        private static String IP_LAST_TOKEN = "\\d{1,3}";
        private static String IP_TOKEN = "\\d{1,3}\\.";
        private static String IP;
        private static String DELIMITERS;
        private static Pattern theIpPattern;
        private static Pattern theNamePattern;
        private static Pattern theWWNPattern;

        private Parser() {
        }

        static boolean isMatch(String aInput) {
            String[] tokens = aInput.split("\t");
            if (tokens.length < 3) {
                return false;
            }
            if (!theNamePattern.matcher(tokens[0]).matches()) {
                return false;
            }
            if (!theWWNPattern.matcher(tokens[1]).matches()) {
                return false;
            }
            for (int i = 2; i < tokens.length; ++i) {
                String nextToken = tokens[i];
                if (theIpPattern.matcher(nextToken).matches()) continue;
                try {
                    InetAddress.getByName(nextToken);
                    continue;
                }
                catch (UnknownHostException e) {
                    return false;
                }
            }
            return true;
        }

        static IbmRaidSubsystem createRaidSystem(String aInput) {
            if (Parser.isMatch(aInput)) {
                String[] tokens = aInput.split("\t");
                String raidName = tokens[0];
                String raidWWN = tokens[1];
                ArrayList<SrIpAddress> ipAddresses = new ArrayList<SrIpAddress>();
                for (int i = 2; i < tokens.length; ++i) {
                    String nextToken = tokens[i];
                    if (!theIpPattern.matcher(nextToken).matches()) {
                        try {
                            InetAddress inetAddr = InetAddress.getByName(nextToken);
                            ipAddresses.add(new SrIpAddress(inetAddr.getHostAddress()));
                        }
                        catch (UnknownHostException e) {
                            theLogger.error(SrLogCategories.EXCEPTION, e, "Input string,\"", aInput, "\" is matching for RaidSubsystem input but", " IP address wasn't found for \"", nextToken, "\"");
                        }
                        continue;
                    }
                    ipAddresses.add(new SrIpAddress(nextToken));
                }
                return new IbmRaidSubsystem(raidName, raidWWN, ipAddresses);
            }
            throw new IllegalArgumentException(aInput + " does not match a RaidSubsystem data");
        }

        static {
            DELIMITERS = " \\s\t";
            StringBuilder ipBuilder = new StringBuilder();
            ipBuilder.append(IP_TOKEN).append(IP_TOKEN).append(IP_TOKEN).append(IP_LAST_TOKEN);
            IP = ipBuilder.toString();
            theIpPattern = Pattern.compile(IP);
            theNamePattern = Pattern.compile(NAME);
            theWWNPattern = Pattern.compile(WWN);
        }
    }
}

