/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.comm.snmp.raid;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.Server;
import com.sanrad.nms.server.ServerPropertiesFetcher;
import com.sanrad.nms.server.SrServerBundleKeys;
import com.sanrad.nms.server.comm.snmp.raid.IbmRaidSubsystem;
import com.sanrad.nms.server.comm.snmp.raid.RaidConfigurationException;
import com.sanrad.nms.server.comm.snmp.raid.RaidSubsystem;
import com.sanrad.nms.server.util.types.SrIpAddress;
import com.sanrad.util.BundleKeysInterface;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IbmRaidControllerExecutor {
    private static SrLogger theLogger = SrLogger.getLogger();
    private static final String COMMAND_SUCCESS_MSG = "SMcli completed successfully.";
    private static final String NO_STORAGE_SUBSYSTEMS_MGS = "There are currently no storage subsystems listed in the configuration file";
    private static String myStorageMgmtApplicationPath;
    private static String myStorageMgmtApplicationName;
    private static final String SNMP_MGR_REMOVE_PARAM = "x";
    private static final String SNMP_MGR_ADD_PARAM = "a";
    private static final String WORLD_WIDE_NODE_ID_STR = "World-wide node identifier";
    private static final String WWN_ID_REG_EX = "World-wide node identifier\\S+\\s+(([0-9a-fA-F]){2}[:])+([0-9a-fA-F]){2}";
    private static final Pattern myWWNIdPattern;

    private IbmRaidControllerExecutor() {
    }

    static void registerSnmpManager(SrIpAddress aSnmpMgrIpAddr, String aRaidName, char aAgentIndex) throws RaidConfigurationException {
        IbmRaidControllerExecutor.executeSnmpManagerOperation(aSnmpMgrIpAddr, aRaidName, aAgentIndex, SNMP_MGR_ADD_PARAM);
    }

    static void unregisterSnmpManager(SrIpAddress aSnmpMgrIpAddr, String aRaidName, char aAgentIndex) throws RaidConfigurationException {
        IbmRaidControllerExecutor.executeSnmpManagerOperation(aSnmpMgrIpAddr, aRaidName, aAgentIndex, SNMP_MGR_REMOVE_PARAM);
    }

    static void executeSnmpManagerOperation(SrIpAddress aSnmpMgrIpAddr, String aRaidName, char aAgentIndex, String aOperationParam) throws RaidConfigurationException {
        StringBuilder logStr = null;
        try {
            StringBuilder command = new StringBuilder();
            command.append(IbmRaidControllerExecutor.getApplicationName());
            command.append(" -");
            command.append(aOperationParam);
            command.append(" trap:public,");
            command.append(aSnmpMgrIpAddr.toString());
            command.append(" -n ");
            command.append(aRaidName);
            logStr = new StringBuilder("SMcli>").append((CharSequence)command);
            Process process = IbmRaidControllerExecutor.executeCommand(command.toString());
            ArrayList<String> processOutput = IbmRaidControllerExecutor.getProcessOutput(process, aAgentIndex);
            logStr.append(" --> ").append(processOutput);
            if (!IbmRaidControllerExecutor.isSuccess(processOutput)) {
                throw new RaidConfigurationException(aAgentIndex, "Failed to register Snmp manager " + aSnmpMgrIpAddr + " to RAID " + aRaidName);
            }
        }
        catch (IOException e) {
            try {
                throw new RaidConfigurationException(aAgentIndex, "Failed to register Snmp manager " + aSnmpMgrIpAddr + " to RAID " + aRaidName, e);
            }
            catch (Throwable throwable) {
                theLogger.info(SrLogCategories.SM_CLI, logStr);
                throw throwable;
            }
        }
        theLogger.info(SrLogCategories.SM_CLI, logStr);
    }

    static void renameStorageSubsystem(String aRaidOldName, String aRaidNewName, char aAgentIndex) throws RaidConfigurationException {
        StringBuilder logStr = null;
        try {
            StringBuilder command = new StringBuilder();
            command.append(IbmRaidControllerExecutor.getApplicationName());
            command.append(" -n ");
            command.append(aRaidOldName);
            command.append(" -c \"set storagesubsystem userLabel=\\\"");
            command.append(aRaidNewName);
            command.append("\\\";\" -e");
            logStr = new StringBuilder("SMcli>").append((CharSequence)command);
            Process process = IbmRaidControllerExecutor.executeCommand(command.toString());
            ArrayList<String> processOutput = IbmRaidControllerExecutor.getProcessOutput(process, aAgentIndex);
            logStr.append(" --> ").append(processOutput);
            if (!IbmRaidControllerExecutor.isSuccess(processOutput)) {
                throw new RaidConfigurationException(aAgentIndex, "Failed to rename " + aRaidOldName + " to " + aRaidNewName);
            }
        }
        catch (IOException e) {
            try {
                throw new RaidConfigurationException(aAgentIndex, "Failed to rename " + aRaidOldName + " to " + aRaidNewName, e);
            }
            catch (Throwable throwable) {
                theLogger.info(SrLogCategories.SM_CLI, logStr);
                throw throwable;
            }
        }
        theLogger.info(SrLogCategories.SM_CLI, logStr);
    }

    static RaidSubsystem addStorageSubsystem(String aRaidName, String aIp1, String aIp2, char aAgentIndex) throws RaidConfigurationException {
        StringBuilder logStr = null;
        IbmRaidSubsystem result = null;
        try {
            StringBuilder command = new StringBuilder();
            command.append(IbmRaidControllerExecutor.getApplicationName());
            command.append(" -A ");
            if (aIp1 != null) {
                command.append(aIp1);
                if (aIp2 != null) {
                    command.append(' ');
                    command.append(aIp2);
                }
            } else {
                command.append(aIp2);
            }
            logStr = new StringBuilder("SMcli>").append((CharSequence)command);
            Process process = IbmRaidControllerExecutor.executeCommand(command.toString());
            ArrayList<String> processOutput = IbmRaidControllerExecutor.getProcessOutput(process, aAgentIndex);
            logStr.append(" --> ").append(processOutput);
            if (!IbmRaidControllerExecutor.isSuccess(processOutput)) {
                throw new RaidConfigurationException(aAgentIndex, "Failed to add RAID sub-system [" + aIp1 + ',' + aIp2 + ']');
            }
            result = IbmRaidControllerExecutor.getStorageSubsystem(aIp1, aIp2, aAgentIndex);
            if (result == null) {
                String msg = Server.BUNDLE.getString((BundleKeysInterface)SrServerBundleKeys.RAID_SUBSYSTEM_FAILED_TO_ADD, aIp1, aIp2);
                theLogger.error(SrLogCategories.RAID, msg, " ", Server.BUNDLE.getString(SrServerBundleKeys.RAID_SUBSYSTEM_RAID_MGMT_QUERY_FAILED));
                throw new RaidConfigurationException(aAgentIndex, msg);
            }
            if (!result.containsIPs(aIp1, aIp2)) {
                String msg = Server.BUNDLE.getString((BundleKeysInterface)SrServerBundleKeys.RAID_SUBSYSTEM_FAILED_TO_ADD, aIp1, aIp2);
                theLogger.error(SrLogCategories.RAID, msg, " ", Server.BUNDLE.getString(SrServerBundleKeys.RAID_SUBSYSTEM_RAID_ADDED_NOT_ALL_IPS));
                throw new RaidConfigurationException(aAgentIndex, msg);
            }
            if (aRaidName != null && !aRaidName.equals(result.getName())) {
                IbmRaidControllerExecutor.renameStorageSubsystem(result.getName(), aRaidName, aAgentIndex);
            }
            result = IbmRaidControllerExecutor.getStorageSubsystem(aIp1, aIp2, aAgentIndex);
        }
        catch (IOException e) {
            try {
                throw new RaidConfigurationException(aAgentIndex, "Failed to add RAID sub-system [" + aIp1 + ',' + aIp2 + ']');
            }
            catch (Throwable throwable) {
                theLogger.info(SrLogCategories.SM_CLI, logStr);
                throw throwable;
            }
        }
        theLogger.info(SrLogCategories.SM_CLI, logStr);
        return result;
    }

    static void removeStorageSubsystem(String aRaidName, char aAgentIndex) throws RaidConfigurationException {
        StringBuilder logStr = null;
        try {
            StringBuilder command = new StringBuilder();
            command.append(IbmRaidControllerExecutor.getApplicationName());
            command.append(" -X -n ");
            command.append(aRaidName);
            logStr = new StringBuilder("SMcli>").append((CharSequence)command);
            Process process = IbmRaidControllerExecutor.executeCommand(command.toString());
            ArrayList<String> processOutput = IbmRaidControllerExecutor.getProcessOutput(process, aAgentIndex);
            logStr.append(" --> ").append(processOutput);
            if (!IbmRaidControllerExecutor.isSuccess(processOutput)) {
                throw new RaidConfigurationException(aAgentIndex, "Failed to remove RAID sub-system [" + aRaidName + ']');
            }
        }
        catch (IOException e) {
            try {
                throw new RaidConfigurationException(aAgentIndex, "Failed to remove RAID sub-system [" + aRaidName + ']');
            }
            catch (Throwable throwable) {
                theLogger.info(SrLogCategories.SM_CLI, logStr);
                throw throwable;
            }
        }
        theLogger.info(SrLogCategories.SM_CLI, logStr);
    }

    static IbmRaidSubsystem getStorageSubsystem(String aIp1, String aIp2, char aAgentIndex) throws RaidConfigurationException {
        List<IbmRaidSubsystem> raids = IbmRaidControllerExecutor.getAllStorageSubsystems(aAgentIndex);
        for (IbmRaidSubsystem raid : raids) {
            if ((aIp1 == null || !raid.getIPAddresses().contains(new SrIpAddress(aIp1))) && (aIp2 == null || !raid.getIPAddresses().contains(new SrIpAddress(aIp2)))) continue;
            return raid;
        }
        return null;
    }

    static List<IbmRaidSubsystem> getAllStorageSubsystems(char aAgentIndex) throws RaidConfigurationException {
        StringBuilder logStr = null;
        ArrayList<IbmRaidSubsystem> raids = new ArrayList<IbmRaidSubsystem>();
        try {
            StringBuilder command = new StringBuilder();
            command.append(IbmRaidControllerExecutor.getApplicationName());
            command.append(" -d -w");
            logStr = new StringBuilder("SMcli>").append((CharSequence)command);
            Process process = IbmRaidControllerExecutor.executeCommand(command.toString());
            ArrayList<String> processOutput = IbmRaidControllerExecutor.getProcessOutput(process, aAgentIndex);
            logStr.append(" --> ").append(processOutput);
            if (!IbmRaidControllerExecutor.isSuccess(processOutput) && !processOutput.toString().contains(NO_STORAGE_SUBSYSTEMS_MGS)) {
                throw new RaidConfigurationException(aAgentIndex, "Failed to read all RAID sub-systems", null);
            }
            for (String line : processOutput) {
                if (!IbmRaidSubsystem.containsSubsystemParams(line)) continue;
                IbmRaidSubsystem ibmRaidSys = IbmRaidSubsystem.createRaidSubsystem(line);
                raids.add(ibmRaidSys);
                StringBuilder wwnPortIdcmd = new StringBuilder();
                wwnPortIdcmd.append(IbmRaidControllerExecutor.getApplicationName());
                wwnPortIdcmd.append(" " + ibmRaidSys.getIPAddresses().get(0) + " -c \"show controller [A];\"");
                logStr = new StringBuilder("SMcli>").append((CharSequence)wwnPortIdcmd);
                process = IbmRaidControllerExecutor.executeCommand(wwnPortIdcmd.toString());
                processOutput = IbmRaidControllerExecutor.getProcessOutput(process, aAgentIndex);
                logStr.append(" --> ").append(processOutput);
                String ctrlInfo = processOutput.toString();
                boolean isSuccess = IbmRaidControllerExecutor.isSuccess(processOutput);
                boolean containsWwn = ctrlInfo.contains(WORLD_WIDE_NODE_ID_STR);
                if (!isSuccess || !containsWwn) {
                    throw new RaidConfigurationException(aAgentIndex, "Failed to read RAID controller information. isSuccess = " + isSuccess + " containsWwn = " + containsWwn, null);
                }
                Matcher wwnIdMatcher = myWWNIdPattern.matcher(ctrlInfo);
                if (!wwnIdMatcher.find()) continue;
                String wwnPortId = wwnIdMatcher.group().split("\\:\\s+")[1];
                ibmRaidSys.setWWN(wwnPortId.toUpperCase());
            }
        }
        catch (IOException e) {
            try {
                throw new RaidConfigurationException(aAgentIndex, "Failed to read all RAID sub-systems", e);
            }
            catch (Throwable throwable) {
                theLogger.info(SrLogCategories.SM_CLI, logStr);
                throw throwable;
            }
        }
        theLogger.info(SrLogCategories.SM_CLI, logStr);
        return raids;
    }

    private static ArrayList<String> getProcessOutput(Process aProcess, char aAgentIndex) throws RaidConfigurationException {
        BufferedReader processInput = new BufferedReader(new InputStreamReader(aProcess.getInputStream()));
        ArrayList<String> result = new ArrayList<String>();
        String line = null;
        try {
            while ((line = processInput.readLine()) != null) {
                result.add(line);
            }
            return result;
        }
        catch (IOException e) {
            throw new RaidConfigurationException(aAgentIndex, "Failed to read all RAID sub-systems", e);
        }
    }

    private static boolean isSuccess(ArrayList<String> aProcessOutput) {
        return aProcessOutput.contains(COMMAND_SUCCESS_MSG);
    }

    private static boolean isSuccess(Process aProcess, char aAgentIndex) throws RaidConfigurationException {
        return IbmRaidControllerExecutor.isSuccess(IbmRaidControllerExecutor.getProcessOutput(aProcess, aAgentIndex));
    }

    private static Process executeCommand(String aCommand) throws IOException {
        String[] splits = aCommand.split(" ");
        splits[0] = IbmRaidControllerExecutor.getApplicationPath() + File.separator + splits[0];
        ProcessBuilder procBuilder = new ProcessBuilder(splits);
        procBuilder.directory(new File(IbmRaidControllerExecutor.getApplicationPath()));
        return procBuilder.start();
    }

    private static String getApplicationName() throws FileNotFoundException, IOException {
        if (myStorageMgmtApplicationName == null) {
            myStorageMgmtApplicationName = ServerPropertiesFetcher.getStorageMgmtCliApplicationName();
        }
        return myStorageMgmtApplicationName;
    }

    private static String getApplicationPath() throws FileNotFoundException, IOException {
        if (myStorageMgmtApplicationPath == null) {
            myStorageMgmtApplicationPath = ServerPropertiesFetcher.getStorageMgmtApplicationPath();
        }
        return myStorageMgmtApplicationPath;
    }

    static {
        myWWNIdPattern = Pattern.compile(WWN_ID_REG_EX);
    }
}

