/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.comm.snmp.raid;

import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.comm.CommVarBind;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBindList;
import com.sanrad.nms.server.comm.snmp.raid.IbmRaidControllerExecutor;
import com.sanrad.nms.server.comm.snmp.raid.IbmRaidMibItem;
import com.sanrad.nms.server.comm.snmp.raid.IbmRaidSubsystem;
import com.sanrad.nms.server.comm.snmp.raid.RaidConfigurationException;
import com.sanrad.nms.server.comm.snmp.raid.RaidController;
import com.sanrad.nms.server.comm.snmp.raid.RaidMgmtInitializationException;
import com.sanrad.nms.server.comm.snmp.raid.RaidSnmpMgr;
import com.sanrad.nms.server.comm.snmp.raid.RaidSubsystem;
import com.sanrad.nms.server.util.types.SrIpAddress;
import com.sanrad.nms.server.util.types.SrString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class IbmRaidController
implements RaidController {
    private static SrLogger theLogger = SrLogger.getLogger();
    private static IbmRaidController theInstance = new IbmRaidController();

    private IbmRaidController() {
    }

    public static IbmRaidController getInstance() {
        return theInstance;
    }

    @Override
    public RaidSubsystem addOrReplaceRaid(char aAgentIndex, SrString aRaidName, SrIpAddress ... aRaidIPs) throws RaidConfigurationException, RaidMgmtInitializationException {
        String ip2DspStr;
        SrIpAddress raidIp1 = null;
        SrIpAddress raidIp2 = null;
        if (aRaidIPs != null) {
            switch (aRaidIPs.length) {
                case 2: {
                    raidIp2 = aRaidIPs[1] == null ? null : aRaidIPs[1];
                }
                case 1: {
                    raidIp1 = aRaidIPs[0] == null ? null : aRaidIPs[0];
                    break;
                }
                default: {
                    throw new RaidConfigurationException(aAgentIndex, "The number of IPs = " + aRaidIPs.length + " received for setting the RAID is invalid");
                }
            }
        }
        String raidName = aRaidName == null ? null : aRaidName.toString();
        RaidSubsystem alreadyExistsRaid = null;
        RaidSubsystem registeredRaid = RaidSnmpMgr.getInstance().getRaidSubsystem(aAgentIndex, raidIp1, raidIp2);
        if (registeredRaid != null) {
            alreadyExistsRaid = this.renameOrRemoveRaid(aAgentIndex, registeredRaid, raidName, raidIp1, raidIp2);
        }
        String ip1DspStr = raidIp1 != null ? raidIp1.toDisplayString() : null;
        String string = ip2DspStr = raidIp2 != null ? raidIp2.toDisplayString() : null;
        if (alreadyExistsRaid == null) {
            IbmRaidSubsystem smAppRaid = null;
            if (raidIp1 != null || raidIp2 != null) {
                smAppRaid = IbmRaidControllerExecutor.getStorageSubsystem(ip1DspStr, ip2DspStr, aAgentIndex);
            }
            if (smAppRaid != null) {
                alreadyExistsRaid = this.renameOrRemoveRaid(aAgentIndex, smAppRaid, raidName, raidIp1, raidIp2);
            }
        }
        RaidSubsystem newRaid = null;
        newRaid = alreadyExistsRaid == null ? IbmRaidControllerExecutor.addStorageSubsystem(raidName, ip1DspStr, ip2DspStr, aAgentIndex) : alreadyExistsRaid;
        if (newRaid == null) {
            throw new RaidConfigurationException(aAgentIndex, "Failed to find RAID " + raidName + "[" + raidIp1 + "," + raidIp2 + "]");
        }
        return newRaid;
    }

    @Override
    public void removeRaid(char aAgentIndex, RaidSubsystem aExistingRaid) throws RaidConfigurationException {
        IbmRaidControllerExecutor.removeStorageSubsystem(aExistingRaid.getName(), aAgentIndex);
    }

    @Override
    public void renameRaid(char aAgentIndex, RaidSubsystem aExistingRaid, String aRaidName) throws RaidConfigurationException {
        IbmRaidControllerExecutor.renameStorageSubsystem(aExistingRaid.getName(), aRaidName, aAgentIndex);
    }

    private RaidSubsystem renameOrRemoveRaid(char aAgentIndex, RaidSubsystem aExistingRaid, String aRaidName, SrIpAddress ... aRaidIPs) throws RaidConfigurationException {
        ArrayList<String> existsRaidIPs = new ArrayList<String>();
        for (SrIpAddress addr : aExistingRaid.getIPAddresses()) {
            existsRaidIPs.add(addr.toDisplayString());
        }
        ArrayList<String> newRaidIPs = new ArrayList<String>();
        if (aRaidIPs != null) {
            switch (aRaidIPs.length) {
                case 2: {
                    if (aRaidIPs[1] != null) {
                        newRaidIPs.add(aRaidIPs[1].toString());
                    }
                }
                case 1: {
                    if (aRaidIPs[0] == null) break;
                    newRaidIPs.add(aRaidIPs[0].toString());
                    break;
                }
                default: {
                    throw new RaidConfigurationException(aAgentIndex, "The number of IPs = " + aRaidIPs.length + " received for setting the RAID is invalid");
                }
            }
        }
        Collections.sort(existsRaidIPs);
        Collections.sort(newRaidIPs);
        if (((Object)existsRaidIPs).equals(newRaidIPs)) {
            if (aRaidName != null && !aExistingRaid.getName().equals(aRaidName)) {
                this.renameRaid(aAgentIndex, aExistingRaid, aRaidName);
                List<SrIpAddress> ips = aExistingRaid.getIPAddresses();
                String ip1 = ips.size() > 0 ? ips.get(0).toDisplayString() : null;
                String ip2 = ips.size() > 1 ? ips.get(1).toDisplayString() : null;
                return IbmRaidControllerExecutor.getStorageSubsystem(ip1, ip2, aAgentIndex);
            }
            return aExistingRaid;
        }
        this.removeRaid(aAgentIndex, aExistingRaid);
        return null;
    }

    @Override
    public String extractRaidId(SrSnmpVarBindList aSrVbList) {
        if (aSrVbList == null) {
            return null;
        }
        CommVarBind raidIdVarbind = aSrVbList.getVarBind(IbmRaidMibItem.DEVICE_USER_LABEL);
        if (raidIdVarbind == null) {
            return null;
        }
        return raidIdVarbind.getValue().toString();
    }

    @Override
    public void registerSnmpManager(SrIpAddress aSnmpMgrIpAddr, RaidSubsystem aRaidSys, char aAgentIndex) throws RaidConfigurationException {
        IbmRaidControllerExecutor.registerSnmpManager(aSnmpMgrIpAddr, aRaidSys.getName(), aAgentIndex);
    }

    @Override
    public void unregisterSnmpManager(SrIpAddress aSnmpMgrIpAddr, RaidSubsystem aRaidSys, char aAgentIndex) throws RaidConfigurationException {
        IbmRaidControllerExecutor.unregisterSnmpManager(aSnmpMgrIpAddr, aRaidSys.getName(), aAgentIndex);
    }
}

