/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.comm.snmp;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.comm.CommVarBindKey;
import com.sanrad.nms.server.comm.snmp.DsnmpUtil;
import com.sanrad.nms.server.mgr.CodeToKeyMap;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.util.Util;
import java.util.StringTokenizer;

public class SrOid
implements CommVarBindKey {
    private String myOid = null;
    private String myIndex = null;
    private static SrLogger theLogger = SrLogger.getLogger();

    public SrOid(String oid, String index) {
        this.myOid = oid;
        this.myIndex = index;
    }

    public SrOid(SrOid oid) {
        this(oid.getOid(), oid.getIndex());
    }

    public SrOid(String oid) {
        if (Util.isNumbersAndDotsSeries(oid)) {
            long[] oidComps = Util.stringToLongArray(oid);
            try {
                this.myOid = DsnmpUtil.getMIBNameFromOidComponents(oidComps);
                this.myIndex = DsnmpUtil.getRowIndexFromOidComponents(oidComps);
            }
            catch (IllegalArgumentException e) {
                this.myIndex = oid;
                StringBuffer buff = new StringBuffer("com.sanrad.nms.server.comm.snmp.SrOid:");
                buff.append("Failed to extract MIB name from ").append(oid).append(", SrOid created with index only");
                theLogger.trace(SrLogCategories.LEGACY, buff);
            }
        } else {
            int indexOfRowIndex = oid.indexOf(46);
            if (indexOfRowIndex >= 0 && indexOfRowIndex < oid.length() - 1) {
                this.myOid = oid.substring(0, indexOfRowIndex);
                this.myIndex = oid.substring(indexOfRowIndex + 1);
            } else {
                this.myOid = oid;
            }
        }
    }

    public SrOid(long[] oidComps) {
        try {
            this.myOid = DsnmpUtil.getMIBNameFromOidComponents(oidComps);
            this.myIndex = DsnmpUtil.getRowIndexFromOidComponents(oidComps);
        }
        catch (IllegalArgumentException e) {
            this.myIndex = Util.longArrayToString(oidComps);
            StringBuffer buff = new StringBuffer("com.sanrad.nms.server.comm.snmp.SrOid:");
            buff.append("Failed to extract MIB name from ").append(this.myIndex).append(", SrOid created with index only");
            theLogger.trace(SrLogCategories.LEGACY, buff);
        }
    }

    @Override
    public String getKey() {
        return this.getFullOid();
    }

    @Override
    public CommKey getCommKey() {
        SnmpCommKey key = new SnmpCommKey(this.getIndex(), '\u0000');
        return key;
    }

    @Override
    public String getVarBindName() {
        return this.getOid();
    }

    @Override
    public String getIndex() {
        return this.myIndex;
    }

    @Override
    public ParameterCode getParameterCode() {
        return CodeToKeyMap.getInstance().getParamCodeBySnmpKey(this.myOid);
    }

    public String getOid() {
        return this.myOid;
    }

    public String getFullOid() {
        String oid = this.myOid == null ? "" : this.myOid;
        String index = this.myIndex == null ? "" : this.myIndex;
        return new StringBuffer().append(oid).append('.').append(index).toString();
    }

    public String getDotedFormat() {
        String index = this.myIndex == null ? "0" : this.myIndex;
        long[] array = DsnmpUtil.convertMibNameToOidComponents(this.myOid, index);
        return Util.longArrayToString(array);
    }

    public long[] getComponents() {
        long[] array = null;
        if (this.myOid != null) {
            String index = this.myIndex == null ? "0" : this.myIndex;
            array = DsnmpUtil.convertMibNameToOidComponents(this.myOid, index);
        } else {
            String index = this.myIndex == null ? "" : this.myIndex;
            array = Util.stringToLongArray(index);
        }
        return array;
    }

    public static long[] getComponents(String oid) {
        StringTokenizer tokens = new StringTokenizer(oid, ".");
        long[] comps = new long[tokens.countTokens()];
        int i = 0;
        while (tokens.hasMoreTokens()) {
            comps[i++] = Long.parseLong(tokens.nextToken());
        }
        return comps;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SrOid) {
            return this.myIndex.equals(((SrOid)obj).getIndex()) && this.myOid.equals(((SrOid)obj).getOid());
        }
        return false;
    }

    public int compareTo(SrOid oid) {
        String otherOidStr = oid.getDotedFormat();
        return this.getDotedFormat().compareTo(otherOidStr);
    }

    public boolean isChildOf(SrOid oid) {
        String otherOidStr = oid.getDotedFormat();
        return this.getDotedFormat().indexOf(otherOidStr) == 0;
    }

    public static boolean isChildOf(String oid, String otherOid) {
        return oid.indexOf(otherOid) == 0;
    }

    public boolean isParentOf(SrOid oid) {
        String otherOidStr = oid.getDotedFormat();
        return otherOidStr.indexOf(this.getDotedFormat()) == 0;
    }

    public static boolean isParentOf(String oid, String otherOid) {
        return otherOid.indexOf(oid) == 0;
    }

    public String toString() {
        return "oid:" + this.myOid + "." + this.myIndex;
    }
}

