/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.comm.snmp;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrConnectionException;
import com.sanrad.nms.server.comm.exception.SrOperationException;
import com.sanrad.nms.server.comm.exception.SrUnknownException;
import java.net.UnknownHostException;
import monfox.toolkit.snmp.SnmpException;
import monfox.toolkit.snmp.engine.SnmpTransportException;
import monfox.toolkit.snmp.mgr.SnmpErrorException;
import monfox.toolkit.snmp.mgr.SnmpTimeoutException;

public class SnmpErrorAnalyzer {
    private static final int TOO_BIG_ERROR = 1;
    private static final int NO_ACCESS_ERROR = 6;
    private static final int WRONG_TYPE_ERROR = 7;
    private static final int WRONG_LENGTH_ERROR = 8;
    private static final int WRONG_ENCODING_ERROR = 9;
    private static final int WRONG_VALUE_ERROR = 10;
    private static final int NO_CREATION_ERROR = 11;
    private static final int INCONSISTENT_VALUE_ERROR = 12;
    private static final int RESOURCE_UNAVAILABLE_ERROR = 13;
    private static final int COMMIT_FAILED_ERROR = 14;
    private static final int UNDO_FAILED_ERROR = 15;
    private static final int AUTHORIZATION_ERROR = 16;
    private static final int NOT_WRITEABLE_ERROR = 17;
    private static final int INCONSISTENT_NAME_ERROR = 18;
    private static SrLogger theLogger = SrLogger.getLogger();
    private static SnmpErrorAnalyzer theInstance = new SnmpErrorAnalyzer();

    private SnmpErrorAnalyzer() {
    }

    public static SnmpErrorAnalyzer getInstance() {
        return theInstance;
    }

    public static void rethrow(SnmpErrorException see, CommVarBindList aVarBindsToSet, char aAgentIndex, String aAgentMgmtIP, String ... aAdditionalInfos) throws SrOperationException {
        theLogger.error(SrLogCategories.ERROR, see, see.getVarBindList(), aAdditionalInfos);
        throw new SrOperationException(aAgentIndex, aVarBindsToSet, see.getErrorIndex(), see.getErrorStatus(), aAgentMgmtIP, see);
    }

    public static void rethrow(SnmpTimeoutException stoe, CommVarBindList aVarBindsToSet, char aAgentIndex, String aAgentMgmtIP, String ... aAdditionalInfos) throws SrConnectionException {
        theLogger.error(SrLogCategories.ERROR, stoe, new Object[]{aAdditionalInfos});
        throw new SrConnectionException(aAgentIndex, aVarBindsToSet, aAgentMgmtIP, stoe);
    }

    public static void rethrow(SnmpTransportException ste, CommVarBindList aVarBindsToSet, char aAgentIndex, String aAgentMgmtIP, String ... aAdditionalInfos) throws SrConnectionException {
        theLogger.error(SrLogCategories.ERROR, ste, new Object[]{aAdditionalInfos});
        throw new SrConnectionException(aAgentIndex, aVarBindsToSet, aAgentMgmtIP, ste);
    }

    public static void rethrow(SnmpException se, CommVarBindList aVarBindsToSet, char aAgentIndex, String aAgentMgmtIP, String ... aAdditionalInfos) throws SrUnknownException {
        theLogger.error(SrLogCategories.ERROR, se, new Object[]{aAdditionalInfos});
        throw new SrUnknownException(aAgentIndex, aVarBindsToSet, aAgentMgmtIP, se);
    }

    public static void rethrow(UnknownHostException uhe, CommVarBindList aVarBindsToSet, char aAgentIndex, String aAgentMgmtIP, String ... aAdditionalInfos) throws SrUnknownException {
        theLogger.error(SrLogCategories.ERROR, uhe, new Object[]{aAdditionalInfos});
        throw new SrUnknownException(aAgentIndex, aVarBindsToSet, aAgentMgmtIP + ", failed connection.", uhe);
    }

    public static String errorStatusToString(int aErrorStatus) {
        String retVal = null;
        switch (aErrorStatus) {
            case 12: {
                retVal = "inconsistentValue.";
                break;
            }
            case 6: {
                retVal = "noAccess.";
                break;
            }
            case 7: {
                retVal = "wrongType.";
                break;
            }
            case 8: {
                retVal = "wrongLength.";
                break;
            }
            case 9: {
                retVal = "wrongEncoding.";
                break;
            }
            case 10: {
                retVal = "wrongValue.";
                break;
            }
            case 11: {
                retVal = "noCreation.";
                break;
            }
            case 13: {
                retVal = "resourceUnavailable.";
                break;
            }
            case 14: {
                retVal = "commitFailed.";
                break;
            }
            case 15: {
                retVal = "undoFailed.";
                break;
            }
            case 16: {
                retVal = "authorizationError.";
                break;
            }
            case 17: {
                retVal = "notWritable.";
                break;
            }
            case 18: {
                retVal = "inconsistentName.";
                break;
            }
            case 1: {
                retVal = "TOOBIGError.";
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid SNMP error status: " + aErrorStatus);
            }
        }
        return retVal;
    }
}

