/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.comm.snmp;

import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.util.types.SrBITS;
import com.sanrad.nms.server.util.types.SrDateAndTime;
import com.sanrad.nms.server.util.types.SrEntityNameFormat;
import com.sanrad.nms.server.util.types.SrFcNameIdOrZero;
import com.sanrad.nms.server.util.types.SrGauge;
import com.sanrad.nms.server.util.types.SrISCSISessionISID;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrIpAddress;
import com.sanrad.nms.server.util.types.SrLunFormat;
import com.sanrad.nms.server.util.types.SrPhysicalAddress;
import com.sanrad.nms.server.util.types.SrScsiLUNFormat;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrTAddress;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.CFErrorReasonConstant;
import com.sanrad.nms.server.util.types.constants.CFStateConstant;
import com.sanrad.nms.server.util.types.constants.DRActivateConstant;
import com.sanrad.nms.server.util.types.constants.DRGroupOwnedByConstant;
import com.sanrad.nms.server.util.types.constants.DRInitialSyncStateConstant;
import com.sanrad.nms.server.util.types.constants.DRModeConstant;
import com.sanrad.nms.server.util.types.constants.DRPairInitialSyncTypeConstant;
import com.sanrad.nms.server.util.types.constants.DRPairTypeConstant;
import com.sanrad.nms.server.util.types.constants.DRPiTStateConstant;
import com.sanrad.nms.server.util.types.constants.DRReplicationStateConstant;
import com.sanrad.nms.server.util.types.constants.DRRoleConstant;
import com.sanrad.nms.server.util.types.constants.DRStateConstant;
import com.sanrad.nms.server.util.types.constants.DirectAccessDeviceWCEStateConstants;
import com.sanrad.nms.server.util.types.constants.DirectAccessDeviceWPStateConstants;
import com.sanrad.nms.server.util.types.constants.FcAdminSpeedConstant;
import com.sanrad.nms.server.util.types.constants.FcConnectModeConstant;
import com.sanrad.nms.server.util.types.constants.FcPortTypeConstant;
import com.sanrad.nms.server.util.types.constants.ForceStateSyncConstant;
import com.sanrad.nms.server.util.types.constants.IANAifTypeConstant;
import com.sanrad.nms.server.util.types.constants.ISCSIRemotePortalDiscoveryStateConstant;
import com.sanrad.nms.server.util.types.constants.IdentityPurposeConstant;
import com.sanrad.nms.server.util.types.constants.IfOperStatConstant;
import com.sanrad.nms.server.util.types.constants.InterfaceSFPConnectorConstant;
import com.sanrad.nms.server.util.types.constants.IscsiPortalRolesConstant;
import com.sanrad.nms.server.util.types.constants.IscsiTgtQosActivityConstant;
import com.sanrad.nms.server.util.types.constants.IscsiTgtQosRateTypeConstant;
import com.sanrad.nms.server.util.types.constants.JournalErrorStatusConstant;
import com.sanrad.nms.server.util.types.constants.JournalOperStatusConstant;
import com.sanrad.nms.server.util.types.constants.JournalVolumeActivityConstants;
import com.sanrad.nms.server.util.types.constants.LUOperStatusConstant;
import com.sanrad.nms.server.util.types.constants.MirrorSyncAdminStatusConstant;
import com.sanrad.nms.server.util.types.constants.NetConfigActivityConstant;
import com.sanrad.nms.server.util.types.constants.PhysStorTransportTypeConstant;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageComAdminStatusConstant;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageComOperStatusConstant;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageDriveTypeConstant;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageOperStatusConstant;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageRaidLevelConstant;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageRaidStatusConstant;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageTypeConstant;
import com.sanrad.nms.server.util.types.constants.RemoteTargetLoginStatusConstant;
import com.sanrad.nms.server.util.types.constants.ResetConstant;
import com.sanrad.nms.server.util.types.constants.RowStatusConstants;
import com.sanrad.nms.server.util.types.constants.SCSIDeviceRoleConstant;
import com.sanrad.nms.server.util.types.constants.SCSILunStatusConstant;
import com.sanrad.nms.server.util.types.constants.SCSIPortRoleConstant;
import com.sanrad.nms.server.util.types.constants.SCSITargetDeviceStatusConstant;
import com.sanrad.nms.server.util.types.constants.SDNeighborStatusConstant;
import com.sanrad.nms.server.util.types.constants.SDTakeOverStateConstant;
import com.sanrad.nms.server.util.types.constants.SnapshotConfigFlagsConstant;
import com.sanrad.nms.server.util.types.constants.SnapshotSchedulerStateConstant;
import com.sanrad.nms.server.util.types.constants.StorageDiscoveryOperationConstant;
import com.sanrad.nms.server.util.types.constants.StorageDiscoveryStatusConstant;
import com.sanrad.nms.server.util.types.constants.SubDirectAccessDeviceOperStatusConstant;
import com.sanrad.nms.server.util.types.constants.TargetTypeConstants;
import com.sanrad.nms.server.util.types.constants.VSwitchCapabilityConstant;
import com.sanrad.nms.server.util.types.constants.VSwitchStatusConstant;
import com.sanrad.nms.server.util.types.constants.VirtualGroupStateConstant;
import com.sanrad.nms.server.util.types.constants.VirtualGroupTypeConstant;
import com.sanrad.nms.server.util.types.constants.VolumeOperationAdminStatusConstant;
import com.sanrad.nms.server.util.types.constants.VolumeOperationOperStatusConstant;
import com.sanrad.nms.server.util.types.constants.VolumeStateConstant;
import com.sanrad.nms.server.util.types.constants.VolumeTypeConstants;
import java.util.HashMap;
import java.util.Map;

public class MibNameToSrType {
    private static Map<String, Integer> map = new HashMap<String, Integer>();
    static final int RS_TYPE = 1;
    static final int PHYS_STOR_ADMIN_STAT_TYPE = 3;
    static final int PHYS_STOR_OPER_STAT_TYPE = 4;
    static final int BLOCK_SIZE_TYPE = 5;
    static final int VOLUME_TYPE = 6;
    static final int INET_ADDRESS = 7;
    static final int NET_CONFIG_ACTIVITY = 8;
    static final int ENTITY_NAME_FORMAT = 9;
    static final int LUN_FORMAT = 10;
    static final int DATE_AND_TIME = 11;
    static final int IANA_TYPE = 12;
    static final int IF_OPERETIONAL_STAT = 13;
    static final int BITS = 14;
    static final int SR_SCSI3_TYPE = 15;
    static final int PHYS_STOR_TRANSPORT_TYPE = 16;
    static final int PHYSICAL_ADDRESS_TYPE = 17;
    static final int RESET_TYPE = 18;
    static final int VIRT_VOL_STATE = 19;
    static final int ISCSI_PORTAL_ROLE = 20;
    static final int NEIGHBOR_STATUS = 21;
    static final int TIMETICKS = 22;
    static final int TADDRESS = 23;
    static final int TAKE_OVER_STATE = 24;
    static final int MIRROR_SYNCH_ADMIN_STATUS = 25;
    static final int MIRROR_SYNCH_OPER_STATUS = 26;
    static final int LU_OPER_STATUS = 27;
    static final int VOL_OPERATION_ADMIN_STATUS = 28;
    static final int VOL_OPERATION_OPER_STATUS = 29;
    static final int PHYS_STOR_COM_OPER_STAT_TYPE = 30;
    static final int PHYS_STOR_COM_ADMIN_STAT_TYPE = 31;
    static final int TARGET_TYPE = 32;
    private static final int DIRECT_ACCESS_DEVICE_WCE_STATE = 33;
    private static final int DIRECT_ACCESS_DEVICE_WP_STATE = 34;
    static final int FC_NAME_ID_OR_ZERO = 35;
    static final int FC_PORT_OPER_TYPE = 36;
    static final int FC_CONNECT_MODE = 37;
    static final int FC_ADMIN_SPEED = 38;
    static final int ISCSI_SESSION_ISID = 39;
    static final int DR_VIRT_GROUP_TYPE = 40;
    static final int DR_VIRT_GROUP_STATE = 41;
    static final int DR_GROUP_ROLE = 42;
    static final int DR_GROUP_REPLICATION_STATE = 43;
    static final int DR_GROUP_OWNED_BY = 44;
    static final int DR_GROUP_MODE = 45;
    static final int DR_GROUP_INITIAL_SYNC_STATE = 46;
    static final int DR_PAIR_TYPE = 47;
    static final int DR_PAIR_STATE = 48;
    static final int DR_PAIR_MODE = 49;
    static final int DR_PAIR_INITIAL_SYNC_TYPE = 50;
    static final int DR_PAIR_INITIAL_SYNC_STATE = 51;
    static final int DR_SYNC_PAIR_ROLE = 52;
    static final int DR_SYNC_PAIR_REPLICATION_STATE = 53;
    static final int DR_ASYNC_PAIR_REPLICATION_STATE = 54;
    static final int DR_GROUP_PIT_STATE = 55;
    static final int DR_ASYNC_PAIR_PIT_STATE = 56;
    static final int JOURNAL_ACTIVITY_TYPE = 57;
    static final int SCSI_PORT_ROLE = 58;
    static final int SCSI_DEVICE_ROLE = 59;
    static final int SCSI_REMOTE_TARGET_LOGIN_STATUS = 60;
    static final int SCSI_TARGET_DEVICE_STATUS = 61;
    static final int SCSI_LUN_FORMAT = 62;
    static final int SCSI_LUN_STATUS = 63;
    static final int IDENTITY_PURPOSE = 64;
    static final int REMOTE_PORTAL_DISCOVERY_STATE_TYPE = 65;
    static final int SUB_DIRECT_ACCESS_DEVICE_OPER_STATUS = 66;
    static final int CF_STATE = 67;
    static final int CF_ERROR_REASON = 68;
    static final int DR_ACTIVATE_CONSTANT = 69;
    static final int DR_INITIAL_SYNC_STATE = 70;
    static final int VSWITCH_CAPABILITY = 71;
    static final int VSWITCH_LICENSE_PACK = 72;
    static final int FORCE_STATE_SYNC_SHARING = 73;
    static final int SFP_INTERFACE_CONNECTOR = 74;
    static final int VSWITCH_STATUS = 75;
    static final int PHYS_STOR_DRIVE_TYPE = 76;
    static final int ISCSI_TGT_QOS_ENABLE_CONSTANT = 77;
    static final int PHYS_STOR_RAID_STATUS = 78;
    static final int PHYS_STOR_RAID_LEVEL = 79;
    static final int PHYSICAL_STORAGE_MANUAL_DISCOVERY = 80;
    static final int PHYSICAL_STORAGE_MANUAL_DISCOVERY_STATUS = 81;
    static final int JOURNAL_OPER_STATUS = 82;
    static final int JOURNAL_ERROR_STATUS = 83;
    static final int ISCSI_TGT_QOS_RATE_TYPE = 84;
    static final int SNAPSHOT_SCHEDULER_STATE = 85;
    static final int SNAPSHOT_CONFIG_FLAGS = 86;

    public static SrType get(String name, int val) {
        Integer intVal = map.get(name);
        if (intVal == null) {
            return new SrInteger(val);
        }
        switch (intVal) {
            case 1: {
                return RowStatusConstants.getRS(val);
            }
            case 4: {
                return PhysicalStorageOperStatusConstant.valueOf(val);
            }
            case 30: {
                return PhysicalStorageComOperStatusConstant.getOperStat(val);
            }
            case 31: {
                return PhysicalStorageComAdminStatusConstant.getOperStat(val);
            }
            case 6: {
                return VolumeTypeConstants.getVolumeType(val);
            }
            case 8: {
                return NetConfigActivityConstant.getNetConfigState(val);
            }
            case 12: {
                return IANAifTypeConstant.getIfType(val);
            }
            case 13: {
                return IfOperStatConstant.getIfOperStat(val);
            }
            case 15: {
                return PhysicalStorageTypeConstant.getPhyStorType(val);
            }
            case 16: {
                return PhysStorTransportTypeConstant.getPhyStorTransportType(val);
            }
            case 18: {
                return ResetConstant.getResetVal(val);
            }
            case 21: {
                return SDNeighborStatusConstant.getNeighborStatus(val);
            }
            case 24: {
                return SDTakeOverStateConstant.getTakeOverState(val);
            }
            case 26: {
                return VolumeOperationOperStatusConstant.getVolumeOperationOperStatus(val);
            }
            case 25: {
                return MirrorSyncAdminStatusConstant.getMirrorSynchAdminStatus(val);
            }
            case 27: {
                return LUOperStatusConstant.getLUOperStatusType(val);
            }
            case 29: {
                return VolumeOperationOperStatusConstant.getVolumeOperationOperStatus(val);
            }
            case 28: {
                return VolumeOperationAdminStatusConstant.getVolumeOperationAdminStatus(val);
            }
            case 32: {
                return TargetTypeConstants.getTargetType(val);
            }
            case 33: {
                return DirectAccessDeviceWCEStateConstants.getWECState(val);
            }
            case 34: {
                return DirectAccessDeviceWPStateConstants.getWPState(val);
            }
            case 36: {
                return FcPortTypeConstant.getType(val);
            }
            case 38: {
                return FcAdminSpeedConstant.getSpeed(val);
            }
            case 37: {
                return FcConnectModeConstant.getMode(val);
            }
            case 40: {
                return VirtualGroupTypeConstant.valueOf(val);
            }
            case 41: {
                return VirtualGroupStateConstant.valueOf(val);
            }
            case 42: {
                return DRRoleConstant.valueOf(val);
            }
            case 44: {
                return DRGroupOwnedByConstant.valueOf(val);
            }
            case 45: {
                return DRModeConstant.valueOf(val);
            }
            case 46: {
                return DRInitialSyncStateConstant.valueOf(val);
            }
            case 47: {
                return DRPairTypeConstant.valueOf(val);
            }
            case 48: {
                return DRStateConstant.valueOf(val);
            }
            case 49: {
                return DRModeConstant.valueOf(val);
            }
            case 50: {
                return DRPairInitialSyncTypeConstant.valueOf(val);
            }
            case 51: {
                return DRInitialSyncStateConstant.valueOf(val);
            }
            case 52: {
                return DRRoleConstant.valueOf(val);
            }
            case 55: {
                return DRPiTStateConstant.valueOf(val);
            }
            case 56: {
                return DRPiTStateConstant.valueOf(val);
            }
            case 57: {
                return JournalVolumeActivityConstants.getActivityType(val);
            }
            case 60: {
                return RemoteTargetLoginStatusConstant.getLoginStatus(val);
            }
            case 61: {
                return SCSITargetDeviceStatusConstant.valueOf(val);
            }
            case 63: {
                return SCSILunStatusConstant.valueOf(val);
            }
            case 64: {
                return IdentityPurposeConstant.valueOf(val);
            }
            case 65: {
                return ISCSIRemotePortalDiscoveryStateConstant.valueOf(val);
            }
            case 66: {
                return SubDirectAccessDeviceOperStatusConstant.valueOf(val);
            }
            case 69: {
                return DRActivateConstant.valueOf(val);
            }
            case 70: {
                return DRInitialSyncStateConstant.valueOf(val);
            }
            case 68: {
                return CFErrorReasonConstant.valueOf(val);
            }
            case 67: {
                return CFStateConstant.valueOf(val);
            }
            case 73: {
                return ForceStateSyncConstant.valueOf(val);
            }
            case 75: {
                return VSwitchStatusConstant.valueOf(val);
            }
            case 76: {
                return PhysicalStorageDriveTypeConstant.valueOf(val);
            }
            case 77: {
                return IscsiTgtQosActivityConstant.valueOf(val);
            }
            case 79: {
                return PhysicalStorageRaidLevelConstant.valueOf(val);
            }
            case 80: {
                return StorageDiscoveryOperationConstant.valueOf(val);
            }
            case 81: {
                return StorageDiscoveryStatusConstant.valueOf(val);
            }
            case 82: {
                return JournalOperStatusConstant.valueOf(val);
            }
            case 83: {
                return JournalErrorStatusConstant.valueOf(val);
            }
            case 84: {
                return IscsiTgtQosRateTypeConstant.valueOf(val);
            }
            case 85: {
                return SnapshotSchedulerStateConstant.valueOf(val);
            }
        }
        return new SrInteger(val);
    }

    static SrType get(String name, String val) {
        Integer intVal = map.get(name);
        if (intVal == null) {
            return new SrString(val);
        }
        switch (intVal) {
            case 7: {
                return new SrIpAddress(val);
            }
            case 9: {
                return new SrEntityNameFormat(val);
            }
            case 10: {
                return new SrLunFormat(val);
            }
            case 11: {
                return new SrDateAndTime(val);
            }
            case 17: {
                return new SrPhysicalAddress(val);
            }
            case 14: {
                return new SrBITS(val);
            }
            case 20: {
                return IscsiPortalRolesConstant.valueOf(val);
            }
            case 19: {
                return VolumeStateConstant.getSuperSetValueOf(val);
            }
            case 23: {
                return new SrTAddress(val);
            }
            case 35: {
                return new SrFcNameIdOrZero(val);
            }
            case 39: {
                return new SrISCSISessionISID(val);
            }
            case 58: {
                return SCSIPortRoleConstant.valueOf(val);
            }
            case 59: {
                return SCSIDeviceRoleConstant.valueOf(val);
            }
            case 62: {
                return new SrScsiLUNFormat(val);
            }
            case 54: {
                return DRReplicationStateConstant.getSuperSetValueOf(val);
            }
            case 53: {
                return DRReplicationStateConstant.getSuperSetValueOf(val);
            }
            case 43: {
                return DRReplicationStateConstant.getSuperSetValueOf(val);
            }
            case 71: {
                return VSwitchCapabilityConstant.getSuperSetValueOf(val);
            }
            case 72: {
                return VSwitchCapabilityConstant.getSuperSetValueOf(val);
            }
            case 78: {
                return PhysicalStorageRaidStatusConstant.getSuperSetValueOf(val);
            }
            case 86: {
                return SnapshotConfigFlagsConstant.valueOf(val);
            }
        }
        return new SrString(val);
    }

    static SrType get(String aName, SrGauge aValue) {
        Integer intVal = map.get(aName);
        if (intVal == null) {
            return aValue;
        }
        switch (intVal) {
            case 74: {
                return InterfaceSFPConnectorConstant.valueOf(aValue.longValue());
            }
        }
        return aValue;
    }

    private MibNameToSrType() {
    }

    static {
        map.put("RowStatus", new Integer(1));
        map.put("srPhysStorAdminStatus", new Integer(3));
        map.put(MibItem.PHYSICAL_STORAGE_OPERATIONAL_STATUS.toString(), new Integer(4));
        map.put(MibItem.PHYSICAL_STORAGE_COM_OPER_STATUS.toString(), new Integer(30));
        map.put(MibItem.PHYSICAL_STORAGE_COM_ADMIN_STATUS.toString(), new Integer(31));
        map.put("SrBlockSize", new Integer(5));
        map.put(MibItem.VIRTUAL_VOLUME_TYPE.toString(), new Integer(6));
        map.put("InetAddress", new Integer(7));
        map.put(MibItem.IP_TABLE_ACTIVITY.toString(), new Integer(8));
        map.put("SrEntityNameFormat", new Integer(9));
        map.put("SrLUNFormat", new Integer(10));
        map.put("DateAndTime", new Integer(11));
        map.put("ifType", new Integer(12));
        map.put("IANAifType", new Integer(12));
        map.put("ifOperStatus", new Integer(13));
        map.put("iscsiPortalRoles", new Integer(20));
        map.put("srVirtVolState", new Integer(19));
        map.put("SrSCSI3Type", new Integer(15));
        map.put("srPhysStorTrnsType", new Integer(16));
        map.put("PhysAddress", new Integer(17));
        map.put("srGenReset", new Integer(18));
        map.put("srSDNeighboursStatus", new Integer(21));
        map.put("TimeStamp", new Integer(22));
        map.put("TAddress", new Integer(23));
        map.put("srStorageDomainTakeOverState", new Integer(24));
        map.put("srVirtVolSpecMirrorOperStatus", new Integer(26));
        map.put("srVirtVolSpecMirrorAdminStatus", new Integer(25));
        map.put("srVirtLogUnOperStatus", new Integer(27));
        map.put("srVirtVolOperOperStatus", new Integer(29));
        map.put("srVirtVolOperAdminStatus", new Integer(28));
        map.put("SrTgtType", new Integer(32));
        map.put(MibItem.DIRECT_ACCESS_DEVICE_WCE_STATE.toString(), new Integer(33));
        map.put(MibItem.DIRECT_ACCESS_DEVICE_WP.toString(), new Integer(34));
        map.put("FcNameIdOrZero", new Integer(35));
        map.put("fcmPortOperType", new Integer(36));
        map.put("srFCConnectMode", new Integer(37));
        map.put("fcmPortAdminSpeed", new Integer(38));
        map.put("iscsiSsnISID", new Integer(39));
        map.put(MibItem.DR_VIRT_GROUP_TYPE.toString(), new Integer(40));
        map.put(MibItem.DR_VIRT_GROUP_STATE.toString(), new Integer(41));
        map.put(MibItem.DR_GROUP_ROLE.toString(), new Integer(42));
        map.put(MibItem.DR_GROUP_REPLICATION_STATE.toString(), new Integer(43));
        map.put(MibItem.DR_GROUP_OWNED_BY.toString(), new Integer(44));
        map.put(MibItem.DR_GROUP_MODE.toString(), new Integer(45));
        map.put(MibItem.DR_GROUP_INITIAL_SYNC_STATE.toString(), new Integer(46));
        map.put(MibItem.DR_PAIR_TYPE.toString(), new Integer(47));
        map.put(MibItem.DR_PAIR_STATE.toString(), new Integer(48));
        map.put(MibItem.DR_PAIR_MODE.toString(), new Integer(49));
        map.put(MibItem.DR_PAIR_INITIAL_SYNC_TYPE.toString(), new Integer(50));
        map.put(MibItem.DR_PAIR_INITIAL_SYNC_STATE.toString(), new Integer(51));
        map.put(MibItem.DR_SYNC_PAIR_ROLE.toString(), new Integer(52));
        map.put(MibItem.DR_SYNC_PAIR_REPLICATION_STATE.toString(), new Integer(53));
        map.put(MibItem.DR_ASYNC_PAIR_REPLICATION_STATE.toString(), new Integer(54));
        map.put(MibItem.DR_GROUP_PIT_STATE.toString(), new Integer(55));
        map.put(MibItem.DR_ASYNC_PAIR_PIT_STATE.toString(), new Integer(56));
        map.put(MibItem.ASYNC_PAIR_CF_STATE.toString(), new Integer(67));
        map.put(MibItem.SYNC_PAIR_CF_STATE.toString(), new Integer(67));
        map.put(MibItem.CONSISTENCY_GROUP_CF_STATE.toString(), new Integer(67));
        map.put(MibItem.SYNC_PAIR_CF_RETURN_ERROR.toString(), new Integer(68));
        map.put(MibItem.ASYNC_PAIR_CF_RETURN_ERROR.toString(), new Integer(68));
        map.put(MibItem.CONSISTENCY_GROUP_CF_RETURN_ERROR.toString(), new Integer(68));
        map.put(MibItem.DR_ASYNC_PAIR_PIT_STATE.toString(), new Integer(56));
        map.put("srVirtVolSpecJournalActivity", new Integer(57));
        map.put("scsiPortRole", new Integer(58));
        map.put("scsiDeviceRole", new Integer(59));
        map.put("srRemoteTgtLoginStatus", new Integer(60));
        map.put(MibItem.SCSI_TARGET_DEVICE_STATUS.toString(), new Integer(61));
        map.put(SrScsiLUNFormat.getSnmpFormatName(), new Integer(62));
        map.put(MibItem.SCSI_LUN_STATUS.toString(), new Integer(63));
        map.put(MibItem.IDENTITY_PURPOSE.toString(), new Integer(64));
        map.put(MibItem.REMOTE_PORTAL_DISC_STATE.toString(), new Integer(65));
        map.put(MibItem.REMOTE_PORTAL_DISC_ACTIVATE.toString(), new Integer(65));
        map.put(MibItem.SUB_DIRECT_ACCESS_DEVICE_OPER_STATUS.toString(), new Integer(66));
        map.put(MibItem.VSWITCH_CAPABILITY.toString(), new Integer(71));
        map.put(MibItem.VSWITCH_LICENSE_PACK.toString(), new Integer(72));
        map.put(MibItem.DR_SYNC_PAIR_ACTIVATE.toString(), new Integer(69));
        map.put(MibItem.DR_ASYNC_PAIR_ACTIVATE.toString(), new Integer(69));
        map.put(MibItem.DR_GROUP_ACTIVATE.toString(), new Integer(69));
        map.put(MibItem.DR_PAIR_INITIAL_SYNC_STATE.toString(), new Integer(70));
        map.put(MibItem.FORCE_STATE_SYNC_SHARING.toString(), new Integer(73));
        map.put(MibItem.IF_CONNECTED_SFP_CONNECTOR.toString(), 74);
        map.put(MibItem.VSWITCH_STATUS.toString(), 75);
        map.put(MibItem.PHYSICAL_STORAGE_DRIVE_TYPE.toString(), 76);
        map.put(MibItem.TARGET_QOS_ACTIVITY.toString(), 77);
        map.put(MibItem.PHYSICAL_STORAGE_RAID_STATUS.toString(), 78);
        map.put(MibItem.PHYSICAL_STORAGE_RAID_LEVEL.toString(), 79);
        map.put(MibItem.PHYSICAL_STORAGE_MANUAL_DISCOVERY.toString(), 80);
        map.put(MibItem.PHYSICAL_STORAGE_MANUAL_DISCOVERY_STATUS.toString(), 81);
        map.put(MibItem.JOURNAL_VOLUME_OPER_STATUS.toString(), 82);
        map.put(MibItem.JOURNAL_VOLUME_ERROR_STATUS.toString(), 83);
        map.put(MibItem.TARGET_QOS_RATE_TYPE.toString(), 84);
        map.put(MibItem.SNAPSHOT_SCHEDULER_STATE.toString(), 85);
        map.put(MibItem.SNAPSHOT_VOLUME_CONFIG_FLAGS.toString(), 86);
    }
}

