/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.comm.snmp;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.comm.CommVarBind;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.snmp.DefaultSnmpMgr;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.comm.snmp.MibNameToSrType;
import com.sanrad.nms.server.comm.snmp.SnmpVersion;
import com.sanrad.nms.server.comm.snmp.SrOid;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBind;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBindList;
import com.sanrad.nms.server.comm.snmp.exception.SnmpOidFormatErrorException;
import com.sanrad.nms.server.comm.snmp.exception.SnmpUnknownValueTypeException;
import com.sanrad.nms.server.comm.snmp.exception.SrSnmpConversionException;
import com.sanrad.nms.server.comm.snmp.trap.SrTrapType;
import com.sanrad.nms.server.util.types.SrBITS;
import com.sanrad.nms.server.util.types.SrCounter32;
import com.sanrad.nms.server.util.types.SrCounter64;
import com.sanrad.nms.server.util.types.SrDateAndTime;
import com.sanrad.nms.server.util.types.SrGauge;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrIpAddress;
import com.sanrad.nms.server.util.types.SrOidType;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrTimeTicks;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.MibItemConstant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import monfox.toolkit.snmp.NoSuchObjectException;
import monfox.toolkit.snmp.SnmpCounter;
import monfox.toolkit.snmp.SnmpCounter64;
import monfox.toolkit.snmp.SnmpGauge;
import monfox.toolkit.snmp.SnmpInt;
import monfox.toolkit.snmp.SnmpIpAddress;
import monfox.toolkit.snmp.SnmpNull;
import monfox.toolkit.snmp.SnmpOid;
import monfox.toolkit.snmp.SnmpString;
import monfox.toolkit.snmp.SnmpTimeTicks;
import monfox.toolkit.snmp.SnmpValue;
import monfox.toolkit.snmp.SnmpValueException;
import monfox.toolkit.snmp.SnmpVarBind;
import monfox.toolkit.snmp.SnmpVarBindList;
import monfox.toolkit.snmp.ext.SnmpRow;
import monfox.toolkit.snmp.metadata.SnmpMetadataException;
import monfox.toolkit.snmp.metadata.SnmpTypeInfo;

public class DsnmpUtil {
    private static SrLogger theLogger = SrLogger.getLogger();

    private DsnmpUtil() {
    }

    public static SrSnmpVarBindList convertDSnmpVarBindListToSrSnmpVarBindList(SnmpVarBindList dList) throws SrSnmpConversionException {
        if (dList == null) {
            return null;
        }
        SrSnmpVarBindList srList = new SrSnmpVarBindList();
        for (int i = 0; i < dList.size(); ++i) {
            srList.add(DsnmpUtil.convertDSnmpVarBindToSrSnmpVarBind(dList.get(i)));
        }
        return srList;
    }

    public static SrSnmpVarBind convertDSnmpVarBindToSrSnmpVarBind(SnmpVarBind varBind) throws SrSnmpConversionException {
        SrSnmpVarBind srVarBind = null;
        String oid = "";
        try {
            String index = DsnmpUtil.getIndexStringFromOid(varBind.getOid());
            int indexOfDot = varBind.getOid().toString().indexOf(".");
            String oidStr = varBind.getOid().toString();
            oid = oidStr.substring(0, indexOfDot < 0 ? oidStr.length() : indexOfDot);
            SrOid srOid = new SrOid(oid, index);
            SrType value = DsnmpUtil.convertDSnmpValueToSrType(varBind);
            srVarBind = new SrSnmpVarBind(srOid, value);
        }
        catch (SnmpOidFormatErrorException e) {
            theLogger.error(SrLogCategories.LEGACY, e, new Object[0]);
            throw new SrSnmpConversionException("SNMP Error - Oid Format Error for " + varBind);
        }
        catch (IndexOutOfBoundsException e) {
            theLogger.error(SrLogCategories.LEGACY, e, new Object[0]);
            throw new SrSnmpConversionException("SNMP Error - Index Out Of Bound for: " + varBind);
        }
        catch (SnmpUnknownValueTypeException e) {
            theLogger.error(SrLogCategories.LEGACY, e, new Object[0]);
            throw new SrSnmpConversionException("SNMP Error - Unknown Value Type for: " + varBind);
        }
        return srVarBind;
    }

    private static String getIndexStringFromOid(SnmpOid oid) {
        String oidByName = oid.toString();
        int indexLocationInOid = oidByName.indexOf(".");
        if (indexLocationInOid == 0) {
            throw new SnmpOidFormatErrorException(oid.toString());
        }
        if (indexLocationInOid < 0) {
            return "0";
        }
        return oid.getString().substring(indexLocationInOid + 1);
    }

    private static SrType convertDSnmpValueToSrType(SnmpVarBind varBind) throws SrSnmpConversionException {
        SnmpValue value = varBind.getValue();
        if (value == null) {
            return null;
        }
        switch (value.getType()) {
            case 70: {
                return new SrCounter64(value.getBigInteger());
            }
            case 64: {
                return new SrIpAddress(value.getByteArray());
            }
            case 65: {
                return new SrCounter32(value.getBigInteger());
            }
            case 66: {
                String name = varBind.getOid().getOidInfo().getName();
                return MibNameToSrType.get(name, new SrGauge(value.longValue()));
            }
            case 67: {
                return new SrTimeTicks(value.longValue());
            }
            case 2: {
                String name = varBind.getOid().getOidInfo().getName();
                try {
                    SnmpTypeInfo typeInfo = DefaultSnmpMgr.metaData.getObject(name).getTypeInfo();
                    if (typeInfo != null && typeInfo.getName() != null) {
                        name = typeInfo.getName();
                    }
                }
                catch (SnmpValueException e) {
                    theLogger.warn(SrLogCategories.LEGACY, new Object[]{e});
                    throw new SrSnmpConversionException("Cannot get the oid type name for: " + varBind.toString());
                }
                return MibNameToSrType.get(name, ((SnmpInt)value).intValue());
            }
            case 6: {
                long[] str = value.toLongArray();
                return new SrOidType(str);
            }
            case 4: {
                String name = varBind.getOid().getOidInfo().getName();
                try {
                    SnmpTypeInfo typeInfo;
                    if (MibItem.valueOf(name) != null && (typeInfo = DefaultSnmpMgr.metaData.getObject(name).getTypeInfo()) != null && typeInfo.getName() != null) {
                        name = typeInfo.getName();
                    }
                }
                catch (SnmpValueException e) {
                    String msg = "Cannot get the oid type name for: " + varBind.toString();
                    theLogger.error(SrLogCategories.ERROR, e, msg);
                    throw new SrSnmpConversionException(msg);
                }
                return MibNameToSrType.get(name, varBind.getFormattedString());
            }
            case 5: {
                return null;
            }
        }
        if (value instanceof SnmpNull) {
            return null;
        }
        throw new SrSnmpConversionException("Unknown Value in SnmpValue for: " + varBind.toString());
    }

    public static SrSnmpVarBindList convertDSnmpRowToSrSnmpRow(SnmpRow row) {
        if (row == null) {
            return null;
        }
        SrSnmpVarBindList srRow = new SrSnmpVarBindList();
        for (int i = 0; i < row.size(); ++i) {
            try {
                srRow.addElement(DsnmpUtil.convertDSnmpVarBindToSrSnmpVarBind(row.getVarBind(i)));
                continue;
            }
            catch (NoSuchObjectException e) {
                StringBuffer msg = new StringBuffer("DSNMP Error - cannot get a VarBind from a row at index: ");
                msg.append(i);
                msg.append(" in row: ");
                msg.append(row.toString());
                theLogger.trace(SrLogCategories.LEGACY, new Object[]{e, msg});
                throw new SrSnmpConversionException("DSNMP Error - cannot get a VarBind from row");
            }
        }
        return srRow;
    }

    public static SnmpVarBind convertSrSnmpVarBindToDSnmpVarBInd(SrSnmpVarBind varBind) throws SrSnmpConversionException {
        String oid = ((SrOid)varBind.getVarBindKey()).getFullOid();
        String oidName = ((SrOid)varBind.getVarBindKey()).getOid();
        SnmpValue val = null;
        val = DsnmpUtil.convertSrTypeToDSnmpValue(varBind.getValue(), oidName);
        SnmpVarBind newVarBind = null;
        try {
            newVarBind = new SnmpVarBind(oid, val);
        }
        catch (SnmpValueException e) {
            theLogger.trace(SrLogCategories.LEGACY, new Object[]{e});
            throw new SrSnmpConversionException(e.getMessage() + " for varBind: " + varBind);
        }
        return newVarBind;
    }

    public static SnmpValue convertSrTypeToDSnmpValue(SrType val, String oidName) throws SrSnmpConversionException {
        if (val == null) {
            return null;
        }
        int typeNumber = val.getTypeNumber();
        String errorData = null;
        try {
            switch (typeNumber) {
                case 1: {
                    return new SnmpCounter(((SrCounter32)val).longValue());
                }
                case 2: {
                    return new SnmpGauge(((SrGauge)val).longValue());
                }
                case 5: {
                    return new SnmpTimeTicks(((SrTimeTicks)val).longValue());
                }
                case 4: {
                    return new SnmpInt(((SrInteger)val).intValue());
                }
                case 3: {
                    return new SnmpCounter64(((SrCounter64)val).longValue());
                }
                case 6: {
                    return new SnmpString(val.toString());
                }
                case 8: {
                    return new SnmpOid(((SrOidType)val).toDisplayString());
                }
                case 9: {
                    return new SnmpInt(((MibItemConstant)val).intValue());
                }
                case 10: {
                    return new SnmpString("'" + val.toString() + "'H");
                }
                case 11: {
                    return new SnmpString(((SrDateAndTime)val).getSnmpFormat());
                }
                case 7: {
                    errorData = oidName;
                    SnmpTypeInfo typeInfo = DefaultSnmpMgr.metaData.getObject(oidName).getTypeInfo();
                    if (typeInfo != null && typeInfo.getName().equals("InetAddress")) {
                        return new SnmpString(((SrIpAddress)val).toInetAddressSnmpString());
                    }
                    errorData = null;
                    return new SnmpIpAddress(((SrIpAddress)val).toString());
                }
                case 12: {
                    return new SnmpString("'" + ((SrBITS)val).toHexString() + "'H");
                }
                case 13: {
                    return new SnmpString(val.toString());
                }
                case 18: {
                    int boolValue = (Boolean)val.value() != false ? 1 : 2;
                    return new SnmpInt(boolValue);
                }
            }
            throw new SrSnmpConversionException("Cannot convert unknown type: " + val.toString());
        }
        catch (SnmpValueException e) {
            StringBuffer msg = new StringBuffer("Cannot convert ");
            msg.append(val.getTypeName());
            if (errorData == null) {
                errorData = val.toString();
            }
            msg.append(errorData);
            theLogger.trace(SrLogCategories.LEGACY, new Object[]{e, msg});
            throw new SrSnmpConversionException("Error converting " + val.getTypeName());
        }
    }

    public static int getdsnmpVsrsion(SnmpVersion ver) {
        if (ver.equals(SnmpVersion.V1)) {
            return 0;
        }
        if (ver.equals(SnmpVersion.V2C)) {
            return 1;
        }
        if (ver.equals(SnmpVersion.V3)) {
            return 3;
        }
        throw new IllegalArgumentException("SnmpVersion Error - Unknown version: " + ver);
    }

    public static int getdsnmpVsrsion(SrString ver) {
        if (ver.equals(SnmpVersion.V1.toString())) {
            return 0;
        }
        if (ver.equals(SnmpVersion.V2C.toString())) {
            return 1;
        }
        if (ver.equals(SnmpVersion.V3.toString())) {
            return 3;
        }
        throw new IllegalArgumentException("SnmpVersion Error - Unknown version" + ver.toString());
    }

    public static SrTrapType convertDSnmpTrapTypeToSrTrapType(SnmpOid trapOid) {
        String strTrapOid = trapOid.getString();
        int pos = strTrapOid.indexOf(".");
        if (pos >= 0) {
            strTrapOid = strTrapOid.substring(0, pos);
        }
        return SrTrapType.getSrTrapType(strTrapOid);
    }

    public static String convertSrTableNameToDSnmpTableName(String tableName) {
        return tableName;
    }

    public static long[] convertMibNameToOidComponents(String mibName, String index) {
        try {
            SnmpOid snmpOid = new SnmpOid();
            StringBuffer buff = new StringBuffer();
            buff.append(mibName).append('.').append(index);
            snmpOid.fromString(buff.toString());
            return snmpOid.toLongArray();
        }
        catch (SnmpValueException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static String getMIBNameFromOidComponents(long[] comps) {
        return new SnmpOid(comps).getOidInfo().getName();
    }

    public static String getRowIndexFromOidComponents(long[] comps) {
        try {
            return new SnmpOid(comps).getIndexOid().toString();
        }
        catch (SnmpValueException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (SnmpMetadataException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static SrType getSrValueOfAction(SrOidType action, SrType value) {
        String mibName = DsnmpUtil.getMIBNameFromOidComponents((long[])action.value());
        if (value instanceof SrInteger) {
            return MibNameToSrType.get(mibName, ((SrInteger)value).intValue());
        }
        return MibNameToSrType.get(mibName, value.toString());
    }

    public static List<CommVarBindList> breakVarBindListByIndices(CommVarBindList aVarBindList) {
        ArrayList<CommVarBindList> entriesList = new ArrayList<CommVarBindList>();
        HashMap<MIBEntryKey, CommVarBindList> entriesMap = new HashMap<MIBEntryKey, CommVarBindList>();
        for (CommVarBind varBind : aVarBindList) {
            MIBEntryKey entryKey = null;
            if (varBind instanceof SrSnmpVarBind) {
                SrOid oid = (SrOid)((SrSnmpVarBind)varBind).getVarBindKey();
                entryKey = CommVarBindAnalyzer.getMIBEntryKey(oid);
            } else {
                entryKey = MIBEntryKey.getDBKey();
            }
            CommVarBindList currentVarBindList = (CommVarBindList)entriesMap.get(entryKey);
            if (currentVarBindList == null) {
                currentVarBindList = new CommVarBindList();
                entriesList.add(currentVarBindList);
                entriesMap.put(entryKey, currentVarBindList);
            }
            currentVarBindList.add(varBind);
        }
        return entriesList;
    }

    private static class MIBEntryKey {
        private static MIBEntryKey theDBKey = new MIBEntryKey();
        private static MIBEntryKey theScalarKey = new MIBEntryKey();
        private SnmpOid myTableEntry;
        private String myIndex;

        private MIBEntryKey() {
        }

        MIBEntryKey(SnmpOid aTableEntry, String aIndex) {
            if (aTableEntry == null) {
                throw new IllegalArgumentException("aTableEntry parameter cannot be null");
            }
            if (aIndex == null) {
                throw new IllegalArgumentException("aIndex parameter cannot be null");
            }
            this.myTableEntry = aTableEntry;
            this.myIndex = aIndex;
        }

        private static MIBEntryKey getDBKey() {
            return theDBKey;
        }

        private static MIBEntryKey getScalarKey() {
            return theScalarKey;
        }

        public boolean equals(Object aOther) {
            if (this == aOther) {
                return true;
            }
            if (!(aOther instanceof MIBEntryKey)) {
                return false;
            }
            MIBEntryKey otherKey = (MIBEntryKey)aOther;
            return otherKey.myIndex.equals(this.myIndex) && otherKey.myTableEntry.equals((Object)this.myTableEntry);
        }
    }

    private static class CommVarBindAnalyzer {
        private CommVarBindAnalyzer() {
        }

        private static SnmpOid createSnmpOid(SrOid aOid) {
            return new SnmpOid(aOid.getComponents());
        }

        private static SnmpOid getParentMIBNode(SrOid aOid) {
            return CommVarBindAnalyzer.createSnmpOid(aOid).getParent();
        }

        private static MIBEntryKey getMIBEntryKey(SrOid aOid) {
            if (aOid.getIndex() == null) {
                return MIBEntryKey.getScalarKey();
            }
            return new MIBEntryKey(CommVarBindAnalyzer.getParentMIBNode(aOid), aOid.getIndex());
        }
    }
}

