/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.comm.snmp;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.ServerPropertiesFetcher;
import com.sanrad.nms.server.comm.CommVarBind;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrSnmpInitException;
import com.sanrad.nms.server.comm.snmp.AbstractSnmpMgr;
import com.sanrad.nms.server.comm.snmp.DsnmpUtil;
import com.sanrad.nms.server.comm.snmp.SnmpAgentParams;
import com.sanrad.nms.server.comm.snmp.SnmpVersion;
import com.sanrad.nms.server.comm.snmp.SrOid;
import com.sanrad.nms.server.comm.snmp.SrSnmpTable;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBind;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBindList;
import com.sanrad.nms.server.comm.snmp.exception.SrSnmpConversionException;
import com.sanrad.nms.server.comm.snmp.raid.RaidConfigurationException;
import com.sanrad.nms.server.comm.snmp.raid.RaidMgmtInitializationException;
import com.sanrad.nms.server.comm.snmp.raid.RaidSnmpMgr;
import com.sanrad.nms.server.comm.snmp.raid.RaidSubsystem;
import com.sanrad.nms.server.comm.snmp.trap.TrapListener;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrIpAddress;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.util.NetUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import monfox.toolkit.snmp.NoSuchObjectException;
import monfox.toolkit.snmp.SnmpException;
import monfox.toolkit.snmp.SnmpFramework;
import monfox.toolkit.snmp.SnmpOid;
import monfox.toolkit.snmp.SnmpValue;
import monfox.toolkit.snmp.SnmpValueException;
import monfox.toolkit.snmp.SnmpVarBind;
import monfox.toolkit.snmp.SnmpVarBindList;
import monfox.toolkit.snmp.ext.SnmpRow;
import monfox.toolkit.snmp.ext.SnmpTable;
import monfox.toolkit.snmp.metadata.SnmpMetadata;
import monfox.toolkit.snmp.metadata.SnmpObjectInfo;
import monfox.toolkit.snmp.metadata.SnmpTableInfo;
import monfox.toolkit.snmp.metadata.SnmpTypeInfo;
import monfox.toolkit.snmp.mgr.SnmpPeer;
import monfox.toolkit.snmp.mgr.SnmpSession;
import monfox.toolkit.snmp.mgr.SnmpTimeoutException;
import org.apache.log4j.Level;

public class DefaultSnmpMgr
extends AbstractSnmpMgr {
    private static final int MAX_GET_BULK_REPETITION = 1000;
    protected SnmpSession session = null;
    private SnmpPeer peer = null;
    public static SnmpMetadata metaData = null;
    private InetAddress manager = null;
    private static SrLogger theLogger = SrLogger.getLogger();

    public DefaultSnmpMgr(SnmpAgentParams agentParams, char agentIndex) throws UnknownHostException, SnmpException {
        super(agentParams, agentIndex);
        this.initPeer();
    }

    private void initPeer() throws UnknownHostException, SnmpException {
        this.peer = new SnmpPeer(this.mgrParams.getIpAddress().toString(), this.mgrParams.getSnmpPort().intValue());
        this.peer.setMaxRetries(this.mgrParams.getNumberOfRetries().intValue());
        this.peer.setTimeout(this.mgrParams.getTimeout().longValue());
        this.peer.setParameters(DsnmpUtil.getdsnmpVsrsion(this.mgrParams.getSnmpVersion()), this.mgrParams.getReadCommunity().toString(), this.mgrParams.getWriteCommunity().toString(), this.mgrParams.getInfoCommunity().toString());
        this.session = this.createDefaultSnmpSession();
    }

    private SnmpPeer getSnmpPeer() {
        return this.peer;
    }

    public String getAgentIpAddress() {
        return this.peer.getAddress().getHostAddress();
    }

    @Override
    public String getAgentHostname() {
        return this.peer.getHostName();
    }

    @Override
    public int getSnmpPort() {
        return this.peer.getPort();
    }

    @Override
    public String getReadCommunity() {
        return this.peer.getParameters().getReadProfile().getSecurityName();
    }

    @Override
    public String getWriteCommunity() {
        return this.peer.getParameters().getWriteProfile().getSecurityName();
    }

    public String getInfoCommunity() {
        return this.peer.getParameters().getInformProfile().getSecurityName();
    }

    @Override
    public int getRetries() {
        return this.peer.getMaxRetries();
    }

    @Override
    public long getTimeout() {
        return this.peer.getTimeout();
    }

    @Override
    public SnmpVersion getSnmpVersion() {
        return SnmpVersion.getVersion(String.valueOf(this.peer.getParameters().getDefaultProfile().getSnmpVersion()));
    }

    @Override
    public void setAgentHostname(String hostname) {
        throw new UnsupportedOperationException("Cannot set new Host Name to the agent");
    }

    @Override
    public void setSnmpPort(int port) throws UnknownHostException, SnmpException {
        SrInteger oldPort = this.mgrParams.getSnmpPort();
        this.mgrParams.setSnmpPort(new SrInteger(port));
        try {
            this.initPeer();
        }
        catch (UnknownHostException e) {
            theLogger.error(SrLogCategories.EXCEPTION, "failed to init peer with new port (" + port + "), rolling back old port(" + oldPort + ").", e.getMessage());
            this.mgrParams.setSnmpPort(oldPort);
            throw e;
        }
        catch (SnmpException e) {
            theLogger.error(SrLogCategories.EXCEPTION, "failed to init peer with new port (" + port + "), rolling back old port(" + oldPort + ").", e.getMessage());
            this.mgrParams.setSnmpPort(oldPort);
            throw e;
        }
    }

    @Override
    public void setReadCommunity(String community) {
        this.peer.setParameters(this.peer.getParameters().getDefaultProfile().getSnmpVersion(), community, this.getWriteCommunity(), this.getInfoCommunity());
    }

    @Override
    public void setWriteCommunity(String community) {
        this.peer.setParameters(this.peer.getParameters().getDefaultProfile().getSnmpVersion(), this.getReadCommunity(), community, this.getInfoCommunity());
    }

    public void setInfoCommunity(String community) {
        this.peer.setParameters(this.peer.getParameters().getDefaultProfile().getSnmpVersion(), this.getReadCommunity(), this.getWriteCommunity(), community);
    }

    @Override
    public void setRetries(int retries) {
        this.peer.setMaxRetries(retries);
    }

    @Override
    public void setSnmpVersion(SnmpVersion version) {
        this.peer.setParameters(DsnmpUtil.getdsnmpVsrsion(version), this.getReadCommunity(), this.getWriteCommunity(), this.getInfoCommunity());
    }

    @Override
    public void setTimeout(long timeout) {
        this.peer.setTimeout(timeout);
    }

    public CommVarBindList[] snmpGetBulkList() {
        return null;
    }

    public CommVarBind snmpGetNext() {
        return null;
    }

    public CommVarBindList snmpGetNextList() {
        return null;
    }

    @Override
    public void snmpSendTrap(String enterprise, String Mgrhost, int genericType, int specificType, long uptime, String[] values) {
    }

    public void snmpSetList(CommVarBindList aCommVarBindList) throws SnmpException {
        SnmpVarBind varBind;
        int i;
        SnmpVarBindList snmpList = new SnmpVarBindList();
        for (i = 0; i < aCommVarBindList.size(); ++i) {
            if (!(aCommVarBindList.elementAt(i) instanceof SrSnmpVarBind)) continue;
            varBind = DsnmpUtil.convertSrSnmpVarBindToDSnmpVarBInd((SrSnmpVarBind)aCommVarBindList.elementAt(i));
            snmpList.add(varBind);
        }
        if (snmpList.size() == 0) {
            return;
        }
        for (i = 0; i < snmpList.size(); ++i) {
            varBind = snmpList.get(i);
            String oid = varBind.getOid().getString();
            if (!varBind.getValueString().equals("") || !oid.startsWith("srManagerWriteCommunity") && !oid.startsWith("srManagerReadCommunity")) continue;
            String debugMsg = varBind.getValueString() + " is empty!!!! (class: " + this.getClass() + ")";
            theLogger.trace(SrLogCategories.LEGACY, debugMsg);
            Thread.dumpStack();
        }
        this.session.performSet(this.peer, snmpList);
        theLogger.trace(SrLogCategories.LEGACY, "SNMP: ", this.getAgentIpAddress(), " set list: ", snmpList);
    }

    public SrSnmpVarBindList snmpGetList(CommVarBindList list) throws SnmpException {
        SrSnmpVarBindList newList = null;
        SnmpVarBindList snmpList = new SnmpVarBindList();
        for (int i = 0; i < list.size(); ++i) {
            if (!(list.elementAt(i) instanceof SrSnmpVarBind)) continue;
            SnmpVarBind varBind = DsnmpUtil.convertSrSnmpVarBindToDSnmpVarBInd((SrSnmpVarBind)list.elementAt(i));
            snmpList.add(varBind);
        }
        SnmpVarBindList result = null;
        result = this.session.performGet(this.peer, snmpList);
        newList = DsnmpUtil.convertDSnmpVarBindListToSrSnmpVarBindList(result);
        theLogger.trace(SrLogCategories.LEGACY, "SNMP: ", this.getAgentIpAddress(), " get list: ", snmpList);
        return newList;
    }

    public CommVarBindList[] snmpGetBulk(CommVarBindList vbList) throws SnmpException {
        String[] oidList = new String[vbList.size()];
        CommVarBind vb = null;
        int i = 0;
        Enumeration e = vbList.elements();
        while (e.hasMoreElements()) {
            vb = (CommVarBind)e.nextElement();
            if (!(vb instanceof SrSnmpVarBind)) continue;
            oidList[i++] = ((SrOid)vb.getVarBindKey()).getOid();
        }
        if (i == 0) {
            return null;
        }
        SnmpVarBindList[] tableRowsFromGetBulk = new SnmpVarBindList[]{};
        SnmpVarBindList getBulkOidList = new SnmpVarBindList(oidList);
        tableRowsFromGetBulk = this.session.performBulkGetAllInstances(this.peer, getBulkOidList, 1000);
        int len = tableRowsFromGetBulk.length;
        CommVarBindList[] srTable = new SrSnmpVarBindList[len];
        for (i = 0; i < len; ++i) {
            SnmpVarBindList thisRow = tableRowsFromGetBulk[i];
            SrSnmpVarBindList srList = DsnmpUtil.convertDSnmpVarBindListToSrSnmpVarBindList(thisRow);
            srTable[i] = srList;
        }
        return srTable;
    }

    public CommVarBindList[] snmpGetBulkByKeyPrefix(CommVarBindList vbList, String keyPrefix) throws SnmpException {
        CommVarBindList[] getBulkAllEntries = this.snmpGetBulk(vbList);
        ArrayList<CommVarBindList> getBulkByPrefix = new ArrayList<CommVarBindList>();
        for (int index = 0; index < getBulkAllEntries.length; ++index) {
            CommVarBindList currVarBindList = getBulkAllEntries[index];
            CommVarBind firstVarBind = (CommVarBind)currVarBindList.elementAt(0);
            String varBindOid = firstVarBind.getVarBindKey().getIndex();
            if (!(varBindOid + ".").startsWith(keyPrefix + ".")) continue;
            getBulkByPrefix.add(currVarBindList);
        }
        CommVarBindList[] getBulkPrefixEntries = new CommVarBindList[getBulkByPrefix.size()];
        for (int index = 0; index < getBulkByPrefix.size(); ++index) {
            getBulkPrefixEntries[index] = (CommVarBindList)getBulkByPrefix.get(index);
        }
        return getBulkPrefixEntries;
    }

    public CommVarBindList[] snmpGetTable(CommVarBindList vbList) throws SnmpException {
        String[] oidList = new String[vbList.size()];
        CommVarBind vb = null;
        int i = 0;
        Enumeration e = vbList.elements();
        while (e.hasMoreElements()) {
            vb = (CommVarBind)e.nextElement();
            if (!(vb instanceof SrSnmpVarBind)) continue;
            oidList[i++] = ((SrOid)vb.getVarBindKey()).getOid();
        }
        if (i == 0) {
            return null;
        }
        SnmpVarBindList[] tableRows = new SnmpVarBindList[]{};
        SnmpVarBindList tableOidList = new SnmpVarBindList(oidList);
        tableRows = this.session.performBulkGetAllInstances(tableOidList, 1000);
        int len = tableRows.length;
        CommVarBindList[] srTable = new SrSnmpVarBindList[len];
        for (i = 0; i < len; ++i) {
            SnmpVarBindList thisRow = tableRows[i];
            SrSnmpVarBindList srList = DsnmpUtil.convertDSnmpVarBindListToSrSnmpVarBindList(thisRow);
            srTable[i] = srList;
        }
        return srTable;
    }

    public SrSnmpTable getTableRef(String tableName) {
        try {
            String dSnmpTableName = DsnmpUtil.convertSrTableNameToDSnmpTableName(tableName);
            SnmpTable table = new SnmpTable(this.peer, dSnmpTableName);
            return new SrSnmpTable(table, table.getName());
        }
        catch (SnmpValueException e) {
            theLogger.trace(SrLogCategories.LEGACY, new Object[]{e});
            throw new SrSnmpConversionException("Cannot get Table reference for table: " + tableName + "IP:" + this.peer.getAddress().getHostAddress());
        }
    }

    public void snmpRefreshTable(SrSnmpTable table) throws SnmpException {
        ((SnmpTable)table.getTable()).performUpdate(this.session);
    }

    private CommVarBindList[] getSnmpTableData(SnmpTable table) throws SnmpException {
        CommVarBindList[] srTable = null;
        table.performUpdate(this.session);
        theLogger.trace(SrLogCategories.LEGACY, "Get table: ", table.getName(), " Agent is: ", this.peer.getAddress().getHostAddress(), " Number of Rows: ", table.getRowCount());
        int len = table.getRowCount();
        srTable = new CommVarBindList[len];
        for (int i = 0; i < len; ++i) {
            SnmpRow row = table.getRow(i);
            srTable[i] = DsnmpUtil.convertDSnmpRowToSrSnmpRow(row);
            row.setNotificationMask(0);
            srTable[i].setSnmpAgentIndex(this.snmpAgentIndex);
        }
        return srTable;
    }

    public static CommVarBindList snmpGetTableRow(SrSnmpTable table, CommKey rowIndex) throws SnmpValueException {
        SrSnmpVarBindList varBindList = null;
        SnmpOid index = new SnmpOid(rowIndex.getKey());
        SnmpRow row = ((SnmpTable)table.getTable()).getRow(index);
        varBindList = DsnmpUtil.convertDSnmpRowToSrSnmpRow(row);
        return varBindList;
    }

    public CommVarBindList[] filterTableRowsByValue(SrSnmpTable table, String columnName, SrType value) {
        CommVarBindList[] srRows = null;
        try {
            SnmpValue val = DsnmpUtil.convertSrTypeToDSnmpValue(value, columnName);
            SnmpRow row = ((SnmpTable)table.getTable()).getRow(columnName, val);
            ArrayList<SnmpRow> rows = new ArrayList<SnmpRow>(1);
            if (row != null) {
                rows.add(row);
            }
            srRows = new CommVarBindList[rows.size()];
            for (int i = 0; i < srRows.length; ++i) {
                srRows[i] = DsnmpUtil.convertDSnmpRowToSrSnmpRow((SnmpRow)rows.get(i));
            }
        }
        catch (NoSuchObjectException e) {
            theLogger.trace(SrLogCategories.LEGACY, new Object[]{e});
        }
        catch (SnmpValueException e) {
            theLogger.trace(SrLogCategories.LEGACY, new Object[]{e});
        }
        return srRows;
    }

    public CommVarBindList[] snmpGetTableRowsByFilter(String tableName, String columnName, SrType value, char agentIndex) throws SnmpException {
        SrSnmpTable table = this.getTableRef(tableName);
        table.setAgentIndex(agentIndex);
        this.snmpRefreshTable(table);
        return this.filterTableRowsByValue(table, columnName, value);
    }

    public SrSnmpVarBindList snmpGetOneRow(String[] tableNames, CommKey index) throws SnmpException {
        String rowIndex = index.getKey();
        SnmpVarBindList vbList = new SnmpVarBindList();
        for (int j = 0; j < tableNames.length; ++j) {
            SnmpTableInfo tableInfo = metaData.getTable(tableNames[j]);
            SnmpObjectInfo[] columns = tableInfo.getColumns();
            for (int i = 0; i < columns.length; ++i) {
                SnmpOid oid = new SnmpOid(columns[i].getName() + "." + rowIndex);
                vbList.add(new SnmpVarBind(oid, (String)null));
            }
        }
        SnmpVarBindList newList = this.session.performGet(vbList);
        SrSnmpVarBindList list = DsnmpUtil.convertDSnmpVarBindListToSrSnmpVarBindList(newList);
        list.setSnmpAgentIndex(this.snmpAgentIndex);
        theLogger.trace(SrLogCategories.LEGACY, "SNMP: ", this.getAgentIpAddress(), " get one row: ", newList);
        return list;
    }

    public CommVarBindList[] snmpGetTable(String tableName) throws SnmpException {
        CommVarBindList[] srTable = null;
        String dSnmpTableName = DsnmpUtil.convertSrTableNameToDSnmpTableName(tableName);
        SnmpTable table = new SnmpTable(this.peer, dSnmpTableName);
        srTable = this.getSnmpTableData(table);
        return srTable;
    }

    public boolean equals(Object otherMgr) {
        if (otherMgr instanceof DefaultSnmpMgr) {
            return this.getSnmpPeer().equals((Object)((DefaultSnmpMgr)otherMgr).getSnmpPeer());
        }
        return false;
    }

    private void setSnmpSession() throws SnmpException {
        if (this.manager == null) {
            int port = -1;
            try {
                port = NetUtil.getRandomFreePort();
            }
            catch (IOException ioe) {
                theLogger.fatal(SrLogCategories.LEGACY, ioe, "No free port found to bind snmp session due to: ");
            }
            if (port > -1) {
                SnmpSession tempSession = null;
                InetAddress[] addrs = ServerPropertiesFetcher.getHostAddressList();
                if (addrs.length == 0) {
                    theLogger.error(SrLogCategories.ILLEGAL_STATE, new IllegalStateException("Failed to set manager InetAddress. InetAddress.getAllByName() returned empty array"), new Object[0]);
                }
                StringBuilder inetAddrStrBuilder = new StringBuilder();
                for (int i = 0; i < addrs.length; ++i) {
                    inetAddrStrBuilder.append(addrs[i]).append('|');
                    tempSession = this.createSnmpSession(port, addrs[i]);
                    if (tempSession == null || !this.checkConnectivity(tempSession, addrs[i])) continue;
                    this.manager = addrs[i];
                    break;
                }
                if (this.manager == null) {
                    theLogger.error(SrLogCategories.ILLEGAL_STATE, new IllegalStateException("Failed to set manager InetAddress. Failed to connect through the IPs: " + inetAddrStrBuilder.toString()), new Object[0]);
                }
                if (tempSession != null) {
                    tempSession.shutdown();
                }
            }
        }
    }

    private boolean checkConnectivity(SnmpSession session, InetAddress addr) {
        try {
            String[] snmpList = new String[]{"sysUpTime.0"};
            session.performGet(this.peer, snmpList);
            return true;
        }
        catch (SnmpTimeoutException ste) {
            String hostAddr = addr == null ? "[Default Snmp Session]" : addr.getHostAddress();
            theLogger.trace(SrLogCategories.LEGACY, "Failed to connect to ", this.getAgentHostname(), " with snmp session ip ", hostAddr);
        }
        catch (SnmpException se) {
            theLogger.trace(SrLogCategories.LEGACY, new Object[]{se});
        }
        return false;
    }

    private SnmpSession createDefaultSnmpSession() throws SnmpException {
        theLogger.trace(SrLogCategories.LEGACY, "Trying to open a default SnmpSession");
        SnmpSession session = new SnmpSession(this.peer);
        SnmpSession.getDefaultConfig().setReuseRequestIds(true);
        theLogger.trace(SrLogCategories.LEGACY, "Opening a default SnmpSession succeeded");
        return session;
    }

    private SnmpSession createSnmpSession(int port, InetAddress addr) throws SnmpException {
        theLogger.trace(SrLogCategories.LEGACY, "Trying to bind SnmpSession to ", addr, ":", port);
        SnmpSession session = new SnmpSession(this.peer, port, addr);
        theLogger.trace(SrLogCategories.LEGACY, "Bind SnmpSession to ", addr, ":", port, " succeeded");
        return session;
    }

    public String getManagerIpAddress() throws SnmpException {
        if (this.manager == null) {
            this.setSnmpSession();
        }
        return this.manager == null ? null : this.manager.getHostAddress();
    }

    public void shutdown() {
        this.session.shutdown();
        try {
            RaidSnmpMgr.getInstance().removeAllManagedRaids(this.snmpAgentIndex);
        }
        catch (RaidMgmtInitializationException e) {
            theLogger.error(SrLogCategories.EXCEPTION, e, new Object[0]);
        }
        catch (RaidConfigurationException e) {
            theLogger.error(SrLogCategories.EXCEPTION, e, new Object[0]);
        }
    }

    public void setRaidManager(TrapListener aTrapListener, SrString aVendorName, SrString aRaidName, SrIpAddress aRaidAddr1, SrIpAddress aRaidAddr2) throws RaidConfigurationException {
        if (aTrapListener == null) {
            throw new IllegalArgumentException("You must specify a trap listener");
        }
        try {
            RaidSnmpMgr.getInstance().setOrReplaceManagedRaid(this.snmpAgentIndex, aVendorName, aRaidName, aRaidAddr1, aRaidAddr2);
            RaidSnmpMgr.getInstance().addTrapListener(aTrapListener, this.snmpAgentIndex);
        }
        catch (RaidMgmtInitializationException e) {
            throw new RaidConfigurationException(this.snmpAgentIndex, e.getMessage(), e);
        }
    }

    public void removeRaidManager(SrIpAddress aRaidIp1, SrIpAddress aRaidIp2) throws RaidConfigurationException {
        try {
            RaidSnmpMgr.getInstance().removeManagedRaid(this.snmpAgentIndex, aRaidIp1, aRaidIp2);
        }
        catch (RaidMgmtInitializationException e) {
            throw new RaidConfigurationException(this.snmpAgentIndex, e.getMessage(), e);
        }
    }

    public RaidSubsystem getRaidSubsystem(SrIpAddress aRaidIp1, SrIpAddress aRaidIp2) {
        try {
            return RaidSnmpMgr.getInstance().getRaidSubsystem(this.snmpAgentIndex, aRaidIp1, aRaidIp2);
        }
        catch (RaidMgmtInitializationException e) {
            theLogger.error(SrLogCategories.EXCEPTION, e, new Object[0]);
            return null;
        }
    }

    static {
        try {
            URL url = SnmpAgentParams.getMibDataFileURL();
            if (url == null) {
                // empty if block
            }
            InputStream is = url.openStream();
            metaData = SnmpMetadata.loadXML((InputStream)is, null);
            SnmpFramework.setMetadata((SnmpMetadata)metaData);
            SnmpTypeInfo iNetAddressInfo = metaData.getType("InetAddress");
            iNetAddressInfo.setDisplayHint("1d.1d.1d.1d");
        }
        catch (IOException e) {
            theLogger.trace(SrLogCategories.LEGACY, e);
            throw new SrSnmpInitException("Mibs File not found!!!");
        }
        catch (SnmpException e) {
            theLogger.trace(SrLogCategories.LEGACY, new Object[]{e});
            throw new SrSnmpInitException("Error occured while trying to load metadata files");
        }
        if (theLogger.isEnabledFor(Level.DEBUG)) {
            // empty if block
        }
    }
}

