/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.comm.exception;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.comm.CommVarBind;
import com.sanrad.nms.server.comm.CommVarBindKey;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.util.ParameterCode;

public class SrOperationException
extends SrCommException {
    private static SrLogger theLogger = SrLogger.getLogger();
    private int myErrorIndex;
    private int myErrorStatus;

    public SrOperationException(char aSwitchID, CommVarBindList aCommVarbindList, int aErrorIndex, int aErrorStatus, String aMessage, Throwable aCause) {
        super(aSwitchID, aCommVarbindList, aMessage, aCause);
        this.init(aErrorIndex, aErrorStatus);
    }

    private void init(int aErrorIndex, int aErrorStatus) {
        this.myErrorIndex = aErrorIndex - 1;
        this.myErrorStatus = aErrorStatus;
        if (this.myErrorIndex == -1) {
            return;
        }
        CommVarBindList commVarBindList = this.getCommVarbindList();
        if (this.myErrorIndex + 1 > commVarBindList.size() || commVarBindList.get(this.myErrorIndex) == null) {
            String errorMsg = "Index " + this.myErrorIndex + " is not a valid index in the var bind list: " + this.getCommVarbindList();
            theLogger.logAndThrow(SrLogCategories.ERROR, new IllegalArgumentException(errorMsg), errorMsg);
        }
        this.myErrorMessage = super.getMessage() + ". ";
        if (this.myErrorIndex == -1) {
            this.myErrorMessage = this.myErrorMessage + "Internal problem";
        } else {
            CommVarBind commVarBind = (CommVarBind)this.getCommVarbindList().get(this.myErrorIndex);
            CommVarBindKey comVarBindKey = commVarBind.getVarBindKey();
            ParameterCode parameterCode = comVarBindKey.getParameterCode();
            String property = null;
            if (parameterCode == null) {
                property = "The " + comVarBindKey.getVarBindName();
            } else {
                StringBuilder porpertyBuilder = new StringBuilder(parameterCode.toString());
                char firstChar = Character.toLowerCase(porpertyBuilder.charAt(0));
                porpertyBuilder.setCharAt(0, firstChar);
                property = porpertyBuilder.toString();
            }
            this.myErrorMessage = this.myErrorMessage + SrLogger.LINE_SEPARATOR + "Could not set the value of " + property + " to " + commVarBind.getValue();
        }
        this.myErrorMessage = this.myErrorMessage + ".";
    }

    public int getErrorIndex() {
        return this.myErrorIndex;
    }

    public int getErrorStatus() {
        return this.myErrorStatus;
    }
}

