/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.comm.database;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.Server;
import com.sanrad.nms.server.comm.CommVarBind;
import com.sanrad.nms.server.comm.CommVarBindKey;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.database.DBConnection;
import com.sanrad.nms.server.comm.database.DBItem;
import com.sanrad.nms.server.comm.database.DBKey;
import com.sanrad.nms.server.comm.database.DBVarBind;
import com.sanrad.nms.server.comm.database.DBVarBindList;
import com.sanrad.nms.server.comm.database.exception.SrDatabaseException;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.DataBaseCommKey;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.VSwitchClusterMap;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrIpAddress;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.util.XmlFileUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class XmlDBConnection
implements DBConnection {
    public static final String CONFIG_DIR = "config";
    public static final String DATABASE_FILE_NAME = "san.xml";
    public static final String ALARMS_CONFIG_FILE_NAME = "alarms.xml";
    private static final String DATABASE_FULL_FILE_NAME = "config" + File.separator + "san.xml";
    private static final String ALARMS_CONFIG_FULL_FILE_NAME = "config" + File.separator + "alarms.xml";
    private Document sanConfigurationDoc = null;
    private Document alarmsConfigurationDoc;
    private static final String SITE_TAG = "Site";
    private static final String CLUSTER_TAG = "Cluster";
    private static final String VSWITCH_TAG = "VSwitch";
    private static final String ALARM_TYPES_TAG = "AlarmTypes";
    private static final String ALARM_TYPE_TAG = "AlarmType";
    private static final String ALARMS_TAG = "Alarms";
    private static final String CONTACT_TAG = "Contact";
    private static final String ROOT_TAG = "Root";
    private static final String MAIL_ATTRIBUTE = "mail";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String TO_ATTRIBUTE = "to";
    private static final String FROM_ATTRIBUTE = "from";
    private static final String ID = "id";
    private static SrLogger theLogger = SrLogger.getLogger();

    public DBVarBind DBGet(CommVarBind val) throws SrDatabaseException {
        CommVarBindList list = new CommVarBindList();
        list.add(val);
        DBVarBindList newList = this.dbGetList(list);
        return (DBVarBind)newList.get(0);
    }

    @Override
    public void writeToNewDatabase(HashMap[] newDBValues) throws SrDatabaseException {
        if (newDBValues.length > 0) {
            Element clusterElement = this.createNewClusterElement(CLUSTER_TAG, new Integer(0), null);
            for (int i = 0; i < newDBValues.length; ++i) {
                String vSwitchIp = (String)newDBValues[i].remove(DBItem.VSWITCH_IP_ADDRESS);
                Element vSwitchElement = this.createNewVSwitchElement(vSwitchIp);
                for (DBItem key : newDBValues[i].keySet()) {
                    String value = (String)newDBValues[i].get(key);
                    Element element = new Element(key.toString());
                    element.setText(value);
                    vSwitchElement.addContent(element);
                }
                clusterElement.addContent(vSwitchElement);
            }
            this.saveXMLFile();
        }
    }

    @Override
    public DBVarBindList dbGetList(CommVarBindList list) throws SrDatabaseException {
        DBVarBindList newList = new DBVarBindList();
        for (int i = 0; i < list.size(); ++i) {
            String value;
            if (!(list.elementAt(i) instanceof DBVarBind)) continue;
            CommVarBindKey key = ((DBVarBind)list.elementAt(i)).getVarBindKey();
            String keyName = this.getKeyName(key);
            String vSwitchIp = this.getVSwitchIpFromCommKeyValue(key);
            Element vSwitchElement = this.getVSwitchElement(vSwitchIp);
            if (vSwitchElement == null || (value = this.getValue(vSwitchElement, keyName)) == null) continue;
            DBKey dbKey = (DBKey)((DBVarBind)list.elementAt(i)).getVarBindKey();
            DBItem dbItem = DBItem.convertStringToDBItem(dbKey.getVarBindName());
            newList.addElement(new DBVarBind(dbKey, dbItem.getByType(value)));
        }
        return newList;
    }

    @Override
    public void writeContactDataToDb(Integer clusterId, String fromAddress, String toAddresses, String smtpHost, String smtpUser, String smtpPassword) throws SrDatabaseException {
        Element contactElement;
        Element root = this.sanConfigurationDoc.getRootElement();
        Element alarms = root.getChild(ALARMS_TAG);
        if (alarms == null) {
            alarms = new Element(ALARMS_TAG);
            root.addContent(alarms);
        }
        if ((contactElement = alarms.getChild(CONTACT_TAG)) == null) {
            contactElement = new Element(CONTACT_TAG);
            alarms.addContent(contactElement);
        }
        if (fromAddress != null) {
            Attribute fromAttr = contactElement.getAttribute(FROM_ATTRIBUTE);
            if (fromAttr != null) {
                fromAttr.setValue(fromAddress);
            } else {
                contactElement.addAttribute(FROM_ATTRIBUTE, fromAddress);
            }
        }
        if (toAddresses != null) {
            Attribute toAttr = contactElement.getAttribute(TO_ATTRIBUTE);
            if (toAttr != null) {
                toAttr.setValue(toAddresses);
            } else {
                contactElement.addAttribute(TO_ATTRIBUTE, toAddresses);
            }
        }
        if (smtpHost != null) {
            Attribute hostAttr = contactElement.getAttribute("smtpHost");
            if (hostAttr != null) {
                hostAttr.setValue(smtpHost);
            } else {
                contactElement.addAttribute("smtpHost", smtpHost);
            }
        }
        if (smtpUser != null) {
            Attribute userAttr = contactElement.getAttribute("smtpUser");
            if (userAttr != null) {
                userAttr.setValue(smtpUser);
            } else {
                contactElement.addAttribute("smtpUser", smtpUser);
            }
        }
        if (smtpPassword != null) {
            Attribute passwordAttr = contactElement.getAttribute("smtpPassword");
            if (passwordAttr != null) {
                passwordAttr.setValue(smtpPassword);
            } else {
                contactElement.addAttribute("smtpPassword", smtpPassword);
            }
        }
        this.saveXMLFile();
    }

    @Override
    public void writeAlarmTypeDataToDb(Integer clusterId, String typeName, Boolean emailEnabled) throws SrDatabaseException {
        Element alarmTypesElement;
        Element root = this.sanConfigurationDoc.getRootElement();
        Element alarms = root.getChild(ALARMS_TAG);
        if (alarms == null) {
            alarms = new Element(ALARMS_TAG);
            root.addContent(alarms);
        }
        if ((alarmTypesElement = alarms.getChild(ALARM_TYPES_TAG)) == null) {
            alarmTypesElement = new Element(ALARM_TYPES_TAG);
            alarms.addContent(alarmTypesElement);
        }
        List alarmTypes = alarmTypesElement.getChildren(ALARM_TYPE_TAG);
        for (int j = 0; j < alarmTypes.size(); ++j) {
            Element alarmType = (Element)alarmTypes.get(j);
            if (!typeName.equalsIgnoreCase(alarmType.getAttributeValue(NAME_ATTRIBUTE))) continue;
            alarmType.getAttribute(MAIL_ATTRIBUTE).setValue(emailEnabled.toString());
            this.saveXMLFile();
            return;
        }
        Element typeElement = new Element(ALARM_TYPE_TAG);
        typeElement.addAttribute(NAME_ATTRIBUTE, typeName);
        typeElement.addAttribute(MAIL_ATTRIBUTE, emailEnabled.toString());
        alarmTypesElement.addContent(typeElement);
        this.saveXMLFile();
    }

    @Override
    public CommVarBindList[] readAlarmEmailContact(Integer clusterId) throws SrDatabaseException {
        return this.readAlarmEmailContact(DATABASE_FULL_FILE_NAME, clusterId);
    }

    @Override
    public CommVarBindList[] readAlarmTypesFromDb(Integer clusterId) throws SrDatabaseException {
        return this.readAlarmTypesFromDb(DATABASE_FULL_FILE_NAME, clusterId);
    }

    @Override
    public CommVarBindList[] readClustersDataFromDb() throws SrDatabaseException {
        return this.readClusterDataFromDb(DATABASE_FULL_FILE_NAME);
    }

    @Override
    public CommVarBindList[] readSitesDataFromDb() throws SrDatabaseException {
        return this.readSiteDataFromDb(DATABASE_FULL_FILE_NAME);
    }

    @Override
    public List<String> getVsIPs(String aClusterAlias, String aSiteAlias) throws SrDatabaseException {
        if (aClusterAlias == null || aSiteAlias == null) {
            throw new IllegalArgumentException("The given parameters should not be null. aClusterAlias = " + aClusterAlias + "; aSiteAlias = " + aSiteAlias);
        }
        ArrayList<String> retList = new ArrayList<String>();
        CommVarBindList[] allClusters = null;
        if (!aSiteAlias.equals(Server.SYS_ROOT_SITE_NAME)) {
            Integer id = this.getSiteIdFromAlias(aSiteAlias);
            if (id == null) {
                return retList;
            }
            allClusters = this.readClusterDataFromDb(id);
        } else {
            allClusters = this.readSysRootClusterDataFromDb();
        }
        for (CommVarBindList curList : allClusters) {
            CommVarBindList[] vsList;
            if (!aClusterAlias.equals(curList.getValue(DBItem.CLUSTER_ALIAS).value())) continue;
            Integer clusterId = (Integer)curList.getValue(DBItem.VSWITCH_GROUP_ID).value();
            for (CommVarBindList curBind : vsList = this.getVSwitchesData(this.getClusterElement(clusterId))) {
                SrType curIP = curBind.getValue(DBItem.VSWITCH_IP_ADDRESS);
                retList.add(((Object)curIP).toString());
            }
            break;
        }
        return retList;
    }

    @Override
    public CommVarBindList[] readVSwitchDataFromDb() throws SrDatabaseException {
        return this.readVSwitchDataFromDb((String)null);
    }

    public CommVarBindList[] readClusterDataFromDb(Integer siteId) throws SrDatabaseException {
        Element siteElement = this.getSiteElement(siteId);
        return this.readClusterDataFromDb(siteElement);
    }

    @Override
    public CommVarBindList[] readVSwitchDataFromDb(Integer clusterId) throws SrDatabaseException {
        Element clusterElement = this.getClusterElement(clusterId);
        return this.readVSwitchDataFromDb(clusterElement);
    }

    @Override
    public void removeVSwitch(String ipToRemove) throws SrDatabaseException {
        Element clusterElement = this.getClusterElement(ipToRemove);
        if (clusterElement != null) {
            Element vSwitchElement = this.getVSwitchElement(clusterElement, ipToRemove);
            clusterElement.removeContent(vSwitchElement);
            this.saveXMLFile();
        }
    }

    @Override
    public void removeCluster(Integer vSwitchGroupId) throws SrDatabaseException {
        Element clusterElement = this.getClusterElement(vSwitchGroupId);
        if (clusterElement != null) {
            clusterElement.getParent().removeContent(clusterElement);
            this.saveXMLFile();
        }
    }

    @Override
    public void removeSite(Integer vSwitchGroupId) throws SrDatabaseException {
        Element siteElement = this.getSiteElement(vSwitchGroupId);
        this.sanConfigurationDoc.getRootElement().removeContent(siteElement);
        this.saveXMLFile();
    }

    @Override
    public void writeVSwitchDataToDb(CommVarBindList values) throws SrDatabaseException {
        boolean isChange = false;
        Enumeration e = values.elements();
        while (e.hasMoreElements()) {
            CommVarBind value = (CommVarBind)e.nextElement();
            CommVarBindKey commKey = value.getVarBindKey();
            if (!(commKey instanceof DBKey)) continue;
            String keyName = this.getKeyName(commKey);
            String vSwitchIp = this.getVSwitchIpFromCommKeyValue(commKey);
            SrType val = value.getValue();
            Element vSwitchElement = this.getVSwitchElement(vSwitchIp);
            if (vSwitchElement == null) continue;
            Element valueElement = vSwitchElement.getChild(keyName);
            if (valueElement == null) {
                valueElement = new Element(keyName);
                vSwitchElement.addContent(valueElement);
            }
            if (val != null) {
                valueElement.setText(val.toString());
            } else {
                vSwitchElement.removeChild(keyName);
                SrLogger.getLogger().info(SrLogCategories.INFORMATIVE, "The Element ", vSwitchElement, " with the KeyName ", keyName, " has been removed from the XML since it's value is null");
            }
            isChange = true;
        }
        if (isChange) {
            this.saveXMLFile();
        }
    }

    private void moveClusterToSite(Element clusterElement, CommKeyClassId dstSite) {
        CommKey[] commKeys = dstSite.getCommKeys();
        Integer dstSiteId = null;
        if (commKeys != null) {
            DataBaseCommKey key = (DataBaseCommKey)commKeys[0];
            dstSiteId = new Integer(key.getKey());
        }
        Element dstSiteElement = this.getSiteElement(dstSiteId);
        clusterElement.getParent().removeContent(clusterElement);
        dstSiteElement.addContent(clusterElement);
    }

    @Override
    public void writeSiteDataToDb(CommVarBindList values) throws SrDatabaseException {
        Enumeration e = values.elements();
        while (e.hasMoreElements()) {
            CommVarBind value = (CommVarBind)e.nextElement();
            CommVarBindKey commKey = value.getVarBindKey();
            if (!(commKey instanceof DBKey)) continue;
            Element siteElement = this.getSiteElement(new Integer(commKey.getIndex()));
            String keyName = this.getKeyName(commKey);
            SrType val = value.getValue();
            Attribute attribute = siteElement.getAttribute(keyName);
            attribute.setValue(val.toString());
        }
        this.saveXMLFile();
    }

    @Override
    public void writeClusterDataToDb(CommVarBindList values) throws SrDatabaseException {
        Enumeration e = values.elements();
        while (e.hasMoreElements()) {
            CommVarBind value = (CommVarBind)e.nextElement();
            CommVarBindKey commKey = value.getVarBindKey();
            if (!(commKey instanceof DBKey)) continue;
            Element clusterElement = this.getClusterElement(new Integer(commKey.getIndex()));
            String keyName = this.getKeyName(commKey);
            SrType val = value.getValue();
            if (keyName.equals(DBItem.PARENT_SITE_ID.toString())) {
                this.moveClusterToSite(clusterElement, (CommKeyClassId)val);
                continue;
            }
            Attribute attribute = clusterElement.getAttribute(keyName);
            attribute.setValue(val.toString());
        }
        this.saveXMLFile();
    }

    @Override
    public void addSite(CommVarBindList values) throws SrDatabaseException {
        Integer siteId = (Integer)values.getValue(ParameterCode.VSWITCH_GROUP_ID).value();
        String siteAlias = (String)values.getValue(ParameterCode.SITE_ALIAS).value();
        Integer parentSiteId = (Integer)values.getValue(ParameterCode.PARENT_SITE_ID).value();
        Double generalPollInterval = (Double)values.getValueOfParameterCode(ParameterCode.GENERAL_POLL_INTERVAL);
        Double iscsiPollInterval = (Double)values.getValueOfParameterCode(ParameterCode.ISCSI_POLL_INTERVAL);
        Double virtPollInterval = (Double)values.getValueOfParameterCode(ParameterCode.VIRTUALIZATION_POLL_INTERVAL);
        Double aclPollInterval = (Double)values.getValueOfParameterCode(ParameterCode.ACL_POLL_INTERVAL);
        Double netPollInterval = (Double)values.getValueOfParameterCode(ParameterCode.NET_POLL_INTERVAL);
        Double statisticsPollInterval = (Double)values.getValueOfParameterCode(ParameterCode.STATISTIC_POLL_INTERVAL);
        this.createNewSiteElement(siteAlias, siteId, parentSiteId, generalPollInterval, virtPollInterval, aclPollInterval, netPollInterval, iscsiPollInterval, statisticsPollInterval);
        this.saveXMLFile();
    }

    @Override
    public void addCluster(CommVarBindList values) throws SrDatabaseException {
        Integer clusterId = (Integer)values.getValue(ParameterCode.VSWITCH_GROUP_ID).value();
        String clusterAlias = (String)values.getValue(ParameterCode.CLUSTER_ALIAS).value();
        CommKeyClassId parentSiteCommKeyClassId = (CommKeyClassId)values.getValue(ParameterCode.PARENT_SITE_ID);
        Integer parentSiteId = null;
        if (parentSiteCommKeyClassId.getCommKeys() != null) {
            DataBaseCommKey dbCommKey = (DataBaseCommKey)parentSiteCommKeyClassId.getCommKeys()[0];
            parentSiteId = new Integer(dbCommKey.getKey());
        }
        Double generalPollInterval = (Double)values.getValueOfParameterCode(ParameterCode.GENERAL_POLL_INTERVAL);
        Double iscsiPollInterval = (Double)values.getValueOfParameterCode(ParameterCode.ISCSI_POLL_INTERVAL);
        Double virtPollInterval = (Double)values.getValueOfParameterCode(ParameterCode.VIRTUALIZATION_POLL_INTERVAL);
        Double aclPollInterval = (Double)values.getValueOfParameterCode(ParameterCode.ACL_POLL_INTERVAL);
        Double netPollInterval = (Double)values.getValueOfParameterCode(ParameterCode.NET_POLL_INTERVAL);
        Double statisticsPollInterval = (Double)values.getValueOfParameterCode(ParameterCode.STATISTIC_POLL_INTERVAL);
        this.createNewClusterElement(clusterAlias, clusterId, parentSiteId, generalPollInterval, virtPollInterval, aclPollInterval, netPollInterval, iscsiPollInterval, statisticsPollInterval);
        this.saveXMLFile();
    }

    @Override
    public void addVSwitch(CommVarBindList values) throws SrDatabaseException {
        Element clusterElement = null;
        String vSwitchIp = null;
        CommVarBindList newValues = new CommVarBindList();
        Enumeration e = values.elements();
        while (e.hasMoreElements()) {
            CommVarBind value = (CommVarBind)e.nextElement();
            CommVarBindKey commKey = value.getVarBindKey();
            if (!(commKey instanceof DBKey)) continue;
            String keyName = this.getKeyName(commKey);
            if (keyName.equals(DBItem.VSWITCH_GROUP_ID.toString())) {
                SrInteger clusterId = (SrInteger)value.getValue();
                clusterElement = this.getClusterElement((Integer)clusterId.value());
                continue;
            }
            if (keyName.equals(DBItem.VSWITCH_IP_ADDRESS.toString())) {
                SrIpAddress ip = (SrIpAddress)value.getValue();
                vSwitchIp = ip.toDisplayString();
                continue;
            }
            newValues.add(value);
        }
        Element vSwitchElement = this.createNewVSwitchElement(vSwitchIp);
        Enumeration e2 = newValues.elements();
        while (e2.hasMoreElements()) {
            CommVarBind value = (CommVarBind)e2.nextElement();
            CommVarBindKey commKey = value.getVarBindKey();
            if (!(commKey instanceof DBKey)) continue;
            String keyName = this.getKeyName(commKey);
            SrType val = value.getValue();
            Element element = new Element(keyName);
            element.setText(val.toString());
            vSwitchElement.addContent(element);
        }
        clusterElement.addContent(vSwitchElement);
        this.saveXMLFile();
    }

    private Element createNewVSwitchElement(String vSwitchIp) {
        Element vSwitchElement = new Element(VSWITCH_TAG);
        Attribute ip = new Attribute(DBItem.VSWITCH_IP_ADDRESS.toString(), vSwitchIp);
        vSwitchElement.addAttribute(ip);
        return vSwitchElement;
    }

    private Element createNewClusterElement(String clusterAlias, Integer clusterId, Integer parentSiteId) throws SrDatabaseException {
        return this.createNewClusterElement(clusterAlias, clusterId, parentSiteId, null, null, null, null, null, null);
    }

    private void setElementStringValue(Element element, DBItem dbItem, Object value) {
        if (value != null) {
            Attribute attribute = new Attribute(dbItem.toString(), value.toString());
            element.addAttribute(attribute);
        }
    }

    private void setPollingIntervals(Element element, Double generalPollInterval, Double virtualizationPollInterval, Double aclPollInterval, Double networkingPollInterval, Double iscsiPollInterval, Double statisticsPollInterval) {
        this.setElementStringValue(element, DBItem.GENERAL_POLL_INTERVAL, generalPollInterval);
        this.setElementStringValue(element, DBItem.ISCSI_POLL_INTERVAL, iscsiPollInterval);
        this.setElementStringValue(element, DBItem.VIRTUALIZATION_POLL_INTERVAL, virtualizationPollInterval);
        this.setElementStringValue(element, DBItem.ACL_POLL_INTERVAL, aclPollInterval);
        this.setElementStringValue(element, DBItem.NET_POLL_INTERVAL, networkingPollInterval);
        this.setElementStringValue(element, DBItem.STATISTIC_POLL_INTERVAL, statisticsPollInterval);
    }

    private Element createNewVSwitchGroupElement(String tag, Integer parentSiteId, DBItem aliasKey, String alias, Integer id, Double generalPollInterval, Double virtualizationPollInterval, Double aclPollInterval, Double networkingPollInterval, Double iscsiPollInterval, Double statisticsPollInterval) throws SrDatabaseException {
        Element element = new Element(tag);
        Attribute aliasAttribute = new Attribute(aliasKey.toString(), alias);
        Attribute idAttribute = new Attribute(DBItem.VSWITCH_GROUP_ID.toString(), id.toString());
        element.addAttribute(aliasAttribute);
        element.addAttribute(idAttribute);
        this.setPollingIntervals(element, generalPollInterval, virtualizationPollInterval, aclPollInterval, networkingPollInterval, iscsiPollInterval, statisticsPollInterval);
        this.setXMLDocument(DATABASE_FULL_FILE_NAME);
        return element;
    }

    private Element createNewSiteElement(String siteAlias, Integer siteId, Integer parentSiteId, Double generalPollInterval, Double virtualizationPollInterval, Double aclPollInterval, Double networkingPollInterval, Double iscsiPollInterval, Double statisticsPollInterval) throws SrDatabaseException {
        Element siteElement = this.createNewVSwitchGroupElement(SITE_TAG, parentSiteId, DBItem.SITE_ALIAS, siteAlias, siteId, generalPollInterval, virtualizationPollInterval, aclPollInterval, networkingPollInterval, iscsiPollInterval, statisticsPollInterval);
        this.sanConfigurationDoc.getRootElement().addContent(siteElement);
        return siteElement;
    }

    private Element createNewClusterElement(String clusterAlias, Integer clusterId, Integer parentSiteId, Double generalPollInterval, Double virtualizationPollInterval, Double aclPollInterval, Double networkingPollInterval, Double iscsiPollInterval, Double statisticsPollInterval) throws SrDatabaseException {
        Element clusterElement = this.createNewVSwitchGroupElement(CLUSTER_TAG, parentSiteId, DBItem.CLUSTER_ALIAS, clusterAlias, clusterId, generalPollInterval, virtualizationPollInterval, aclPollInterval, networkingPollInterval, iscsiPollInterval, statisticsPollInterval);
        Element parentSiteElement = this.getSiteElement(parentSiteId);
        parentSiteElement.addContent(clusterElement);
        return clusterElement;
    }

    private Element getClusterElement(String vSwitchIp) {
        Integer clusterId = VSwitchClusterMap.getInstance().getClusterId(vSwitchIp);
        return this.getClusterElement(clusterId);
    }

    private Element getSiteElement(Integer siteId) {
        if (siteId != null) {
            for (Element siteElement : this.sanConfigurationDoc.getRootElement().getChildren(SITE_TAG)) {
                Attribute id = siteElement.getAttribute(DBItem.VSWITCH_GROUP_ID.toString());
                if (id == null || !id.getValue().equals(siteId.toString())) continue;
                return siteElement;
            }
        }
        return this.sanConfigurationDoc.getRootElement();
    }

    private Integer getSiteIdFromAlias(String aAlias) {
        if (aAlias == null) {
            throw new IllegalArgumentException("The given argument should not be null.");
        }
        List allSites = this.sanConfigurationDoc.getRootElement().getChildren(SITE_TAG);
        for (Element curSite : allSites) {
            if (!aAlias.equals(curSite.getAttribute(DBItem.SITE_ALIAS.toString()).getValue())) continue;
            try {
                return curSite.getAttribute(DBItem.VSWITCH_GROUP_ID.toString()).getIntValue();
            }
            catch (DataConversionException exp) {
                theLogger.error(SrLogCategories.EXCEPTION, exp, "The id stored in the DB for the site ", aAlias, " is not an integer.");
                return null;
            }
        }
        return null;
    }

    private Element getClusterElement(Element parentSiteElement, Integer clusterId) {
        for (Element clusterElement : parentSiteElement.getChildren(CLUSTER_TAG)) {
            Attribute id = clusterElement.getAttribute(DBItem.VSWITCH_GROUP_ID.toString());
            if (id == null || !id.getValue().equals(clusterId.toString())) continue;
            return clusterElement;
        }
        return null;
    }

    private Element getClusterElement(Integer clusterId) {
        if (clusterId != null) {
            Element clusterElement = this.getClusterElement(this.sanConfigurationDoc.getRootElement(), clusterId);
            if (clusterElement != null) {
                return clusterElement;
            }
            for (Element siteElement : this.sanConfigurationDoc.getRootElement().getChildren(SITE_TAG)) {
                clusterElement = this.getClusterElement(siteElement, clusterId);
                if (clusterElement == null) continue;
                return clusterElement;
            }
        }
        return null;
    }

    private Element getVSwitchElement(String vSwitchIp) {
        Element clusterElement = this.getClusterElement(vSwitchIp);
        return this.getVSwitchElement(clusterElement, vSwitchIp);
    }

    private Element getVSwitchElement(Element clusterElement, String vSwitchIp) {
        if (clusterElement != null) {
            for (Element vSwitchElement : clusterElement.getChildren(VSWITCH_TAG)) {
                Attribute ip = vSwitchElement.getAttribute(DBItem.VSWITCH_IP_ADDRESS.toString());
                if (!ip.getValue().equals(vSwitchIp)) continue;
                return vSwitchElement;
            }
        }
        return null;
    }

    private String getKeyName(CommVarBindKey key) {
        String keyString = key.getKey();
        return this.getKeyName(keyString);
    }

    private String getKeyName(String keyString) {
        int endIndex = keyString.indexOf(".");
        if (endIndex < 0) {
            endIndex = keyString.length();
        }
        String keyName = keyString.substring(0, endIndex);
        return keyName;
    }

    private String getVSwitchIpFromCommKeyValue(CommVarBindKey key) {
        String keyString = key.getKey();
        return this.getVSwitchIpFromCommKeyValue(keyString);
    }

    private String getVSwitchIpFromCommKeyValue(String keyString) {
        String keyName = this.getKeyName(keyString);
        String vSwitchIp = keyString.substring(keyName.length() + 1);
        return vSwitchIp;
    }

    private String getValue(Element vSwitchElement, String key) {
        Element valueElement = vSwitchElement.getChild(key);
        if (valueElement == null) {
            return null;
        }
        return valueElement.getText();
    }

    private DBVarBind getDBVarBind(DBItem dbItem, String commKeyIndex, String value) {
        DBVarBind vb = new DBVarBind(new DBKey(dbItem.toString(), commKeyIndex), dbItem.getByType(value));
        return vb;
    }

    private void createEmptyDatabase(String fileName) throws SrDatabaseException {
        try {
            Element rootElement = new Element(ROOT_TAG);
            this.sanConfigurationDoc = new Document(rootElement);
            FileOutputStream fos = new FileOutputStream(DATABASE_FULL_FILE_NAME);
            XMLOutputter xmlFile = new XMLOutputter("\t", true);
            xmlFile.output(this.sanConfigurationDoc, (OutputStream)fos);
        }
        catch (FileNotFoundException fnfe) {
            theLogger.trace(SrLogCategories.LEGACY, fnfe);
            throw new SrDatabaseException(fnfe.getMessage());
        }
        catch (IOException ioe) {
            theLogger.trace(SrLogCategories.LEGACY, ioe);
            throw new SrDatabaseException(ioe.getMessage());
        }
    }

    private CommVarBindList[] readClusterDataFromDb(Element siteElement) throws SrDatabaseException {
        ArrayList siteDataList = this.getClustersData(siteElement);
        CommVarBindList[] siteData = new CommVarBindList[siteDataList.size()];
        return siteDataList.toArray(siteData);
    }

    private CommVarBindList[] readVSwitchDataFromDb(Element clusterElement) throws SrDatabaseException {
        CommVarBindList[] clusterData = this.getVSwitchesData(clusterElement);
        return clusterData;
    }

    private ArrayList getAllClusterElements() {
        ArrayList allClusters = new ArrayList();
        Element root = this.sanConfigurationDoc.getRootElement();
        allClusters.addAll(root.getChildren(CLUSTER_TAG));
        for (Element site : root.getChildren(SITE_TAG)) {
            allClusters.addAll(site.getChildren(CLUSTER_TAG));
        }
        return allClusters;
    }

    public CommVarBindList[] readVSwitchDataFromDb(String fileName) throws SrDatabaseException {
        if (fileName == null) {
            fileName = DATABASE_FULL_FILE_NAME;
        }
        this.setXMLDocument(fileName);
        Vector<CommVarBindList> systemData = new Vector<CommVarBindList>();
        ArrayList allClusters = this.getAllClusterElements();
        for (Element cluster : allClusters) {
            CommVarBindList[] clusterData = this.readVSwitchDataFromDb(cluster);
            systemData.addAll(Arrays.asList(clusterData));
        }
        CommVarBindList[] systemDataArray = new CommVarBindList[systemData.size()];
        systemData.toArray(systemDataArray);
        return systemDataArray;
    }

    public void readVSwitchGroupDataFromDb(String fileName) throws SrDatabaseException {
        if (fileName == null) {
            fileName = DATABASE_FULL_FILE_NAME;
        }
        this.setXMLDocument(fileName);
    }

    public CommVarBindList[] readSiteDataFromDb(String fileName) throws SrDatabaseException {
        this.readVSwitchGroupDataFromDb(fileName);
        Element root = this.sanConfigurationDoc.getRootElement();
        List siteList = root.getChildren(SITE_TAG);
        CommVarBindList[] sitesData = new CommVarBindList[siteList.size()];
        DBItem[] siteData = new DBItem[]{DBItem.SITE_ALIAS, DBItem.GENERAL_POLL_INTERVAL, DBItem.ISCSI_POLL_INTERVAL, DBItem.VIRTUALIZATION_POLL_INTERVAL, DBItem.ACL_POLL_INTERVAL, DBItem.NET_POLL_INTERVAL, DBItem.STATISTIC_POLL_INTERVAL};
        for (int i = 0; i < siteList.size(); ++i) {
            Element siteElement = (Element)siteList.get(i);
            Attribute id = siteElement.getAttribute(DBItem.VSWITCH_GROUP_ID.toString());
            String siteId = id.getValue();
            sitesData[i] = new CommVarBindList();
            sitesData[i].add(this.getDBVarBind(DBItem.VSWITCH_GROUP_ID, siteId, siteId));
            for (int j = 0; j < siteData.length; ++j) {
                Attribute data = siteElement.getAttribute(siteData[j].toString());
                if (data == null) continue;
                sitesData[i].add(this.getDBVarBind(siteData[j], siteId, data.getValue()));
            }
        }
        return sitesData;
    }

    public CommVarBindList[] readClusterDataFromDb(String fileName) throws SrDatabaseException {
        this.readVSwitchGroupDataFromDb(fileName);
        Element root = this.sanConfigurationDoc.getRootElement();
        List clusterList = root.getChildren(CLUSTER_TAG);
        DBItem[] clusterData = new DBItem[]{DBItem.CLUSTER_ALIAS, DBItem.GENERAL_POLL_INTERVAL, DBItem.ISCSI_POLL_INTERVAL, DBItem.VIRTUALIZATION_POLL_INTERVAL, DBItem.ACL_POLL_INTERVAL, DBItem.NET_POLL_INTERVAL, DBItem.STATISTIC_POLL_INTERVAL, DBItem.PITS_POLL_INTERVAL, DBItem.CLUSTER_STORAGE_COMPARISON};
        ArrayList<CommVarBindList> clustersDataList = new ArrayList<CommVarBindList>(clusterList.size());
        for (int i = 0; i < clusterList.size(); ++i) {
            Element clusterElement = (Element)clusterList.get(i);
            Attribute id = clusterElement.getAttribute(DBItem.VSWITCH_GROUP_ID.toString());
            String clusterId = id.getValue();
            CommVarBindList clusterVarBindList = new CommVarBindList();
            clusterVarBindList.add(this.getDBVarBind(DBItem.VSWITCH_GROUP_ID, clusterId, clusterId));
            for (int j = 0; j < clusterData.length; ++j) {
                Attribute data = clusterElement.getAttribute(clusterData[j].toString());
                if (data == null) continue;
                clusterVarBindList.add(this.getDBVarBind(clusterData[j], clusterId, data.getValue()));
            }
            clustersDataList.add(clusterVarBindList);
        }
        List siteList = root.getChildren(SITE_TAG);
        ArrayList list = new ArrayList();
        for (int i = 0; i < siteList.size(); ++i) {
            Element siteElement = (Element)siteList.get(i);
            ArrayList currentList = this.getClustersData(siteElement);
            list.addAll(currentList);
        }
        clustersDataList.addAll(list);
        CommVarBindList[] clustersData = new CommVarBindList[clustersDataList.size()];
        return clustersDataList.toArray(clustersData);
    }

    public CommVarBindList[] readSysRootClusterDataFromDb(String fileName) throws SrDatabaseException {
        this.readVSwitchGroupDataFromDb(fileName);
        Element root = this.sanConfigurationDoc.getRootElement();
        List clusterList = root.getChildren(CLUSTER_TAG);
        DBItem[] clusterData = new DBItem[]{DBItem.CLUSTER_ALIAS, DBItem.GENERAL_POLL_INTERVAL, DBItem.ISCSI_POLL_INTERVAL, DBItem.VIRTUALIZATION_POLL_INTERVAL, DBItem.ACL_POLL_INTERVAL, DBItem.NET_POLL_INTERVAL, DBItem.STATISTIC_POLL_INTERVAL, DBItem.PITS_POLL_INTERVAL, DBItem.CLUSTER_STORAGE_COMPARISON};
        ArrayList<CommVarBindList> clustersDataList = new ArrayList<CommVarBindList>();
        for (int i = 0; i < clusterList.size(); ++i) {
            Element clusterElement = (Element)clusterList.get(i);
            Attribute id = clusterElement.getAttribute(DBItem.VSWITCH_GROUP_ID.toString());
            String clusterId = id.getValue();
            CommVarBindList clusterVarBindList = new CommVarBindList();
            clusterVarBindList.add(this.getDBVarBind(DBItem.VSWITCH_GROUP_ID, clusterId, clusterId));
            for (int index = 0; index < clusterData.length; ++index) {
                Attribute data = clusterElement.getAttribute(clusterData[index].toString());
                if (data == null) continue;
                clusterVarBindList.add(this.getDBVarBind(clusterData[index], clusterId, data.getValue()));
            }
            clustersDataList.add(clusterVarBindList);
        }
        CommVarBindList[] clustersData = new CommVarBindList[clustersDataList.size()];
        return clustersDataList.toArray(clustersData);
    }

    public CommVarBindList[] readAlarmTypesFromDb(String fileName, Integer clusterId) throws SrDatabaseException {
        if (fileName == null) {
            fileName = DATABASE_FULL_FILE_NAME;
        }
        theLogger.trace(SrLogCategories.LEGACY, "Reading alarm types... ");
        this.setAlarmsDocument(ALARMS_CONFIG_FULL_FILE_NAME);
        Element alarmsRoot = this.alarmsConfigurationDoc.getRootElement();
        Element alarmsElement = alarmsRoot.getChild(ALARMS_TAG);
        if (alarmsElement == null) {
            throw new SrDatabaseException("Alarms configuration file is corrupted !");
        }
        Element alarmTypesElement = alarmsElement.getChild(ALARM_TYPES_TAG);
        List alarmTypesList = alarmTypesElement.getChildren(ALARM_TYPE_TAG);
        CommVarBindList[] alarmTypesData = new CommVarBindList[alarmTypesList.size()];
        for (int i = 0; i < alarmTypesList.size(); ++i) {
            Attribute silentAttr;
            Attribute email;
            Attribute category;
            Attribute severity;
            Element alarmTypeElement = (Element)alarmTypesList.get(i);
            alarmTypesData[i] = new CommVarBindList();
            Attribute name = alarmTypeElement.getAttribute(DBItem.ALARM_TYPE_NAME.toString());
            String alarmTypeName = name.getValue();
            alarmTypesData[i].add(this.getDBVarBind(DBItem.ALARM_TYPE_NAME, alarmTypeName, alarmTypeName));
            Attribute id = alarmTypeElement.getAttribute(DBItem.ALARM_TYPE_ID.toString());
            if (id != null) {
                String alarmTypeId = id.getValue();
                alarmTypesData[i].add(this.getDBVarBind(DBItem.ALARM_TYPE_ID, alarmTypeName, alarmTypeId));
            }
            if ((severity = alarmTypeElement.getAttribute(DBItem.ALARM_TYPE_SEVERITY.toString())) != null) {
                String alarmTypeSeverity = severity.getValue();
                alarmTypesData[i].add(this.getDBVarBind(DBItem.ALARM_TYPE_SEVERITY, alarmTypeName, alarmTypeSeverity));
            }
            if ((category = alarmTypeElement.getAttribute(DBItem.ALARM_TYPE_CATEGORY.toString())) != null) {
                String alarmTypeCategory = category.getValue();
                alarmTypesData[i].add(this.getDBVarBind(DBItem.ALARM_TYPE_CATEGORY, alarmTypeName, alarmTypeCategory));
            }
            if ((email = this.getAttributeFromDBFile(DBItem.ALARM_TYPE_NAME.toString(), alarmTypeName, DBItem.ALARM_TYPE_EMAIL.toString())) == null) {
                email = alarmTypeElement.getAttribute(DBItem.ALARM_TYPE_EMAIL.toString());
            }
            String alarmTypeEmail = email.getValue();
            alarmTypesData[i].add(this.getDBVarBind(DBItem.ALARM_TYPE_EMAIL, alarmTypeName, alarmTypeEmail));
            Attribute troubleshootingAttr = alarmTypeElement.getAttribute(DBItem.ALARM_TYPE_TROUBLESHOOTING.toString());
            if (troubleshootingAttr != null) {
                String troubleshooting = troubleshootingAttr.getValue();
                alarmTypesData[i].add(this.getDBVarBind(DBItem.ALARM_TYPE_TROUBLESHOOTING, alarmTypeName, troubleshooting));
            }
            if ((silentAttr = alarmTypeElement.getAttribute(DBItem.ALARM_TYPE_SILENT.toString())) != null) {
                String silent = silentAttr.getValue();
                alarmTypesData[i].add(this.getDBVarBind(DBItem.ALARM_TYPE_SILENT, alarmTypeName, silent));
            }
            alarmTypesData[i].add(this.getDBVarBind(DBItem.VSWITCH_GROUP_ID, alarmTypeName, clusterId.toString()));
        }
        theLogger.trace(SrLogCategories.LEGACY, "Read ", alarmTypesData.length, " Alarm Types");
        return alarmTypesData;
    }

    private Attribute getAttributeFromDBFile(String keyAttributeName, String keyAttributeValue, String attributeToFind) throws SrDatabaseException {
        this.setXMLDocument(DATABASE_FULL_FILE_NAME);
        Element root = this.sanConfigurationDoc.getRootElement();
        Element alarmsElement = root.getChild(ALARMS_TAG);
        if (alarmsElement == null) {
            return null;
        }
        Element alarmTypesElement = alarmsElement.getChild(ALARM_TYPES_TAG);
        if (alarmTypesElement != null) {
            List alarmTypesList = alarmTypesElement.getChildren(ALARM_TYPE_TAG);
            for (int i = 0; i < alarmTypesList.size(); ++i) {
                Attribute attr;
                Element alarmTypeElement = (Element)alarmTypesList.get(i);
                Attribute key = alarmTypeElement.getAttribute(keyAttributeName);
                String value = key.getValue();
                if (!value.equalsIgnoreCase(keyAttributeValue) || (attr = alarmTypeElement.getAttribute(attributeToFind)) == null) continue;
                return attr;
            }
        }
        return null;
    }

    private CommVarBindList[] readAlarmEmailContact(String fileName, Integer clusterId) throws SrDatabaseException {
        if (fileName == null) {
            fileName = DATABASE_FULL_FILE_NAME;
        }
        theLogger.trace(SrLogCategories.LEGACY, "Reading alarm Email contact parmaeters... ");
        this.setXMLDocument(fileName);
        Element root = this.sanConfigurationDoc.getRootElement();
        Element alarmsElement = root.getChild(ALARMS_TAG);
        if (alarmsElement == null) {
            return null;
        }
        List contactList = alarmsElement.getChildren(CONTACT_TAG);
        CommVarBindList[] contact = new CommVarBindList[contactList.size()];
        for (int i = 0; i < contactList.size(); ++i) {
            contact[i] = new CommVarBindList();
            Element contactElement = (Element)contactList.get(i);
            Attribute from = contactElement.getAttribute(DBItem.EMAIL_CONTACT_FROM_ADDRESS.toString());
            String fromAddress = "";
            if (from != null) {
                fromAddress = from.getValue();
            }
            contact[i].add(this.getDBVarBind(DBItem.EMAIL_CONTACT_FROM_ADDRESS, fromAddress, fromAddress));
            Attribute to = contactElement.getAttribute(DBItem.EMAIL_CONTACT_TO_ADDRESS.toString());
            String toAddress = "";
            if (to != null) {
                toAddress = to.getValue();
            }
            contact[i].add(this.getDBVarBind(DBItem.EMAIL_CONTACT_TO_ADDRESS, fromAddress, toAddress));
            Attribute smtpHostAttribute = contactElement.getAttribute(DBItem.EMAIL_CONTACT_SMTP_HOST.toString());
            String smtpHost = "";
            if (smtpHostAttribute != null) {
                smtpHost = smtpHostAttribute.getValue();
            }
            contact[i].add(this.getDBVarBind(DBItem.EMAIL_CONTACT_SMTP_HOST, fromAddress, smtpHost));
            Attribute smtpUser = contactElement.getAttribute(DBItem.EMAIL_CONTACT_SMTP_USER.toString());
            String user = "";
            if (smtpUser != null) {
                user = smtpUser.getValue();
            }
            contact[i].add(this.getDBVarBind(DBItem.EMAIL_CONTACT_SMTP_USER, fromAddress, user));
            Attribute smtpPassword = contactElement.getAttribute(DBItem.EMAIL_CONTACT_SMTP_PASSWORD.toString());
            String password = "";
            if (smtpPassword != null) {
                password = smtpPassword.getValue();
            }
            contact[i].add(this.getDBVarBind(DBItem.EMAIL_CONTACT_SMTP_PASSWORD, fromAddress, password));
            contact[i].add(this.getDBVarBind(DBItem.VSWITCH_GROUP_ID, fromAddress, clusterId.toString()));
        }
        return contact;
    }

    private synchronized void saveXMLFile() throws SrDatabaseException {
        XmlFileUtil.writeXMLFile(DATABASE_FULL_FILE_NAME, this.sanConfigurationDoc);
    }

    private void setXMLDocument(String fileName) throws SrDatabaseException {
        if (this.sanConfigurationDoc == null) {
            SAXBuilder builder = new SAXBuilder();
            File xmlFile = new File(fileName);
            if (!xmlFile.isFile()) {
                this.createEmptyDatabase(fileName);
                this.setXMLDocument(fileName);
            }
            try {
                this.sanConfigurationDoc = builder.build(fileName);
            }
            catch (JDOMException jde) {
                String corruptExt = ".corrupt";
                File currentFile = new File(fileName);
                File oldFile = new File(fileName + corruptExt);
                boolean fileCorrupt = currentFile.renameTo(oldFile);
                theLogger.error(SrLogCategories.LEGACY, jde, new Object[0]);
                if (fileCorrupt) {
                    theLogger.warn(SrLogCategories.LEGACY, "File ", fileName, " is not well-formed (the corrupted file was saved with the extension ", corruptExt, "). An empty file is being created");
                }
                theLogger.info(SrLogCategories.LEGACY, "File ", fileName, " doesn't not exist. An empty file is being created");
            }
        }
    }

    private void setAlarmsDocument(String fileName) {
        if (this.alarmsConfigurationDoc == null) {
            SAXBuilder builder = new SAXBuilder();
            try {
                this.alarmsConfigurationDoc = builder.build(fileName);
            }
            catch (JDOMException jde) {
                theLogger.warn(SrLogCategories.LEGACY, new Object[]{jde, "File ", fileName, " not exists or not well-formed. An empty file is being created"});
            }
        }
    }

    private ArrayList getClustersData(Element siteElement) throws SrDatabaseException {
        Attribute id = siteElement.getAttribute(ID);
        String siteId = id.getValue();
        DBItem[] clusterData = new DBItem[]{DBItem.CLUSTER_ALIAS, DBItem.GENERAL_POLL_INTERVAL, DBItem.ISCSI_POLL_INTERVAL, DBItem.VIRTUALIZATION_POLL_INTERVAL, DBItem.ACL_POLL_INTERVAL, DBItem.NET_POLL_INTERVAL, DBItem.STATISTIC_POLL_INTERVAL, DBItem.CLUSTER_STORAGE_COMPARISON};
        List clusterElements = siteElement.getChildren(CLUSTER_TAG);
        ArrayList<CommVarBindList> clustersDataList = new ArrayList<CommVarBindList>(clusterElements.size());
        for (int i = 0; i < clusterElements.size(); ++i) {
            Element clusterElement = (Element)clusterElements.get(i);
            Attribute idAttr = clusterElement.getAttribute(DBItem.VSWITCH_GROUP_ID.toString());
            String clusterId = idAttr.getValue();
            CommVarBindList clusterDataVarBindList = new CommVarBindList();
            clusterDataVarBindList.add(this.getDBVarBind(DBItem.VSWITCH_GROUP_ID, clusterId, clusterId));
            clusterDataVarBindList.add(this.getDBVarBind(DBItem.PARENT_SITE_ID, clusterId, siteId));
            for (int j = 0; j < clusterData.length; ++j) {
                Attribute data = clusterElement.getAttribute(clusterData[j].toString());
                if (data == null) continue;
                clusterDataVarBindList.add(this.getDBVarBind(clusterData[j], clusterId, data.getValue()));
            }
            clustersDataList.add(clusterDataVarBindList);
        }
        return clustersDataList;
    }

    private CommVarBindList[] getVSwitchesData(Element clusterElement) throws SrDatabaseException {
        Attribute id = clusterElement.getAttribute(ID);
        String clusterId = id.getValue();
        List vSwitchElements = clusterElement.getChildren(VSWITCH_TAG);
        CommVarBindList[] vSwitchesData = new CommVarBindList[vSwitchElements.size()];
        DBItem[] vSwitchDbItemsList = new DBItem[]{DBItem.VSWITCH_READ_COMMUNITY, DBItem.VSWITCH_IP_MASK, DBItem.VSWITCH_SNMP_PORT, DBItem.VSWITCH_SNMP_VERSION, DBItem.VSWITCH_TRAP_PORT, DBItem.VSWITCH_TIMEOUT, DBItem.VSWITCH_RETRIES, DBItem.VSWITCH_WRITE_COMMUNITY, DBItem.GENERAL_POLL_INTERVAL, DBItem.ISCSI_POLL_INTERVAL, DBItem.VIRTUALIZATION_POLL_INTERVAL, DBItem.ACL_POLL_INTERVAL, DBItem.NET_POLL_INTERVAL, DBItem.STATISTIC_POLL_INTERVAL, DBItem.PITS_POLL_INTERVAL, DBItem.DR_POLL_INTERVAL};
        for (int i = 0; i < vSwitchElements.size(); ++i) {
            Element vSwitchElement = (Element)vSwitchElements.get(i);
            Attribute ipAttr = vSwitchElement.getAttribute(DBItem.VSWITCH_IP_ADDRESS.toString());
            String ip = ipAttr.getValue();
            vSwitchesData[i] = new CommVarBindList();
            vSwitchesData[i].add(this.getDBVarBind(DBItem.VSWITCH_GROUP_ID, ip, clusterId));
            vSwitchesData[i].add(this.getDBVarBind(DBItem.VSWITCH_IP_ADDRESS, ip, ip));
            for (int j = 0; j < vSwitchDbItemsList.length; ++j) {
                String data = vSwitchElement.getChildTextTrim(vSwitchDbItemsList[j].toString());
                if (data == null) continue;
                vSwitchesData[i].add(this.getDBVarBind(vSwitchDbItemsList[j], ip, data));
            }
        }
        return vSwitchesData;
    }

    @Override
    public CommVarBindList[] readSysRootClusterDataFromDb() throws SrDatabaseException {
        return this.readSysRootClusterDataFromDb(DATABASE_FULL_FILE_NAME);
    }
}

