/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.comm.database;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.alarm.AlarmSeverity;
import com.sanrad.nms.server.alarm.AlarmType;
import com.sanrad.nms.server.comm.CommVarBind;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.database.CommHistoryAlarm;
import com.sanrad.nms.server.comm.database.DBConnection;
import com.sanrad.nms.server.comm.database.DBItem;
import com.sanrad.nms.server.comm.database.DBVarBindList;
import com.sanrad.nms.server.comm.database.XmlDBConnection;
import com.sanrad.nms.server.comm.database.exception.SrDatabaseException;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.util.Util;
import com.sanrad.util.XmlFileUtil;
import com.sanrad.util.alarm.HistoryAlarmData;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;

public class DatabaseManager {
    private static final String HISTORY_ALARM_EXTENSION = ".xml";
    private static final String ACK_ATTR = "ack";
    private static final String CLUSTER_ATTR = "cluster";
    private static final String VS_ATTR = "vs";
    private static final String TYPE_ATTR = "type";
    private static final String XML_NULL_STR = "---";
    private static final String SOURCE_TYPE_ATTR = "source_type";
    private static final String SOURCE_ATTR = "source";
    private static final String SEVERITY_ATTR = "severity";
    private static final String MESSAGE_ATTR = "message";
    private static final String TIME_ATTR = "time";
    private static final String CLOSED_TIME_ATTR = "closed_time";
    private static final String CLOSED_BY_ATTR = "closed_by";
    private static final String HISTORY_ALARM_ELEMENT_NAME = "alarm";
    private static DatabaseManager theInstance = new DatabaseManager();
    public static final String dbIpDelimiter = ";";
    private static final String VSWITCH_PROPERTIES_FILE = "vSwitch.properties";
    public static final String USER_PSW = "users.dat";
    private static SrLogger theLogger = SrLogger.getLogger();
    private DBConnection dbConnection = this.getDBConnection();

    private DatabaseManager() {
    }

    public static DatabaseManager getInstance() {
        return theInstance;
    }

    private DBConnection getDBConnection() {
        return new XmlDBConnection();
    }

    public void setObjectToFile(String aFileName, Iterable<? extends HistoryAlarmData> aAlarms) throws SrDatabaseException {
        if (aFileName == null || aAlarms == null) {
            throw new IllegalArgumentException("The given arguments should not be null. aFileName = " + aFileName + "; aAlarms = " + aAlarms);
        }
        Element rootElement = new Element("Root");
        Document alarmsDoc = new Document(rootElement);
        for (HistoryAlarmData historyAlarmData : aAlarms) {
            Element newElement = this.createHistoryAlarmXmlNode(historyAlarmData);
            alarmsDoc.getRootElement().addContent(newElement);
        }
        String xmlFileName = aFileName + HISTORY_ALARM_EXTENSION;
        XmlFileUtil.writeXMLFile(xmlFileName, alarmsDoc);
    }

    private Element createHistoryAlarmXmlNode(HistoryAlarmData aAlarm) {
        if (aAlarm == null) {
            throw new IllegalArgumentException("The given arguments should not be null.");
        }
        Element retNode = new Element(HISTORY_ALARM_ELEMENT_NAME);
        String strVal = aAlarm.getClosedBy();
        Attribute closedByAttr = new Attribute(CLOSED_BY_ATTR, strVal == null ? XML_NULL_STR : strVal);
        retNode.addAttribute(closedByAttr);
        Long longVal = new Long(aAlarm.getClosedDateAndTime());
        Attribute closedTimeAttr = new Attribute(CLOSED_TIME_ATTR, longVal.toString());
        retNode.addAttribute(closedTimeAttr);
        longVal = aAlarm.getDateAndTime();
        Attribute timeAttr = new Attribute(TIME_ATTR, longVal == null ? XML_NULL_STR : longVal.toString());
        retNode.addAttribute(timeAttr);
        strVal = aAlarm.getMessage();
        Attribute msgAttr = new Attribute(MESSAGE_ATTR, strVal == null ? XML_NULL_STR : strVal);
        retNode.addAttribute(msgAttr);
        AlarmSeverity severityVal = aAlarm.getSeverity();
        Attribute severityAttr = new Attribute(SEVERITY_ATTR, severityVal == null ? XML_NULL_STR : severityVal.toString());
        retNode.addAttribute(severityAttr);
        strVal = aAlarm.getSource();
        Attribute sourceAttr = new Attribute(SOURCE_ATTR, strVal == null ? XML_NULL_STR : strVal);
        retNode.addAttribute(sourceAttr);
        ClassID classVal = aAlarm.getSourceType();
        Attribute sourceTypeAttr = new Attribute(SOURCE_TYPE_ATTR, classVal == null ? XML_NULL_STR : classVal.toString());
        retNode.addAttribute(sourceTypeAttr);
        AlarmType typeVal = aAlarm.getType();
        Attribute typeAttr = new Attribute(TYPE_ATTR, typeVal == null ? XML_NULL_STR : typeVal.toString());
        retNode.addAttribute(typeAttr);
        strVal = aAlarm.getVSwitch();
        Attribute vsAttr = new Attribute(VS_ATTR, strVal == null ? XML_NULL_STR : strVal);
        retNode.addAttribute(vsAttr);
        strVal = aAlarm.getClusterAlias();
        Attribute clusterAttr = new Attribute(CLUSTER_ATTR, strVal == null ? XML_NULL_STR : strVal);
        retNode.addAttribute(clusterAttr);
        boolean boolVal = aAlarm.isAcknowledged();
        Attribute ackAttr = new Attribute(ACK_ATTR, Boolean.toString(boolVal));
        retNode.addAttribute(ackAttr);
        return retNode;
    }

    public List<HistoryAlarmData> loadHistoryAlarmsFromFile(String aFileName) throws SrDatabaseException {
        Document alarmsDoc;
        if (aFileName == null) {
            throw new IllegalArgumentException("The given file name should not be null.");
        }
        String xmlFileName = aFileName;
        if (!aFileName.endsWith(HISTORY_ALARM_EXTENSION)) {
            xmlFileName = aFileName + HISTORY_ALARM_EXTENSION;
        }
        try {
            alarmsDoc = XmlFileUtil.readXMLFile(xmlFileName);
        }
        catch (FileNotFoundException exp1) {
            theLogger.error(SrLogCategories.EXCEPTION, exp1, "Could not open the file ", xmlFileName);
            throw new SrDatabaseException("Could not open the file " + xmlFileName + " because of the following exception: " + exp1);
        }
        catch (JDOMException exp1) {
            theLogger.error(SrLogCategories.EXCEPTION, exp1, "Could not parse the file ", xmlFileName);
            throw new SrDatabaseException("Could not parse the file " + xmlFileName + " because of the following exception: " + (Object)((Object)exp1));
        }
        ArrayList<HistoryAlarmData> retList = new ArrayList<HistoryAlarmData>();
        if (alarmsDoc == null) {
            return retList;
        }
        for (Object curChild : alarmsDoc.getRootElement().getChildren()) {
            try {
                retList.add(this.createHistoryAlarm((Element)curChild));
            }
            catch (DataConversionException exp) {
                theLogger.error(SrLogCategories.EXCEPTION, exp, "Could not transform the XML element ", curChild, " from the file ", xmlFileName, " to a history alarm.");
            }
        }
        return retList;
    }

    private HistoryAlarmData createHistoryAlarm(Element aElement) throws DataConversionException {
        if (aElement == null) {
            throw new IllegalArgumentException("The given arguments should not be null.");
        }
        Long newClosedDateAndTime = aElement.getAttribute(CLOSED_TIME_ATTR).getLongValue();
        String newSourceType = aElement.getAttributeValue(SOURCE_TYPE_ATTR);
        String newSource = aElement.getAttributeValue(SOURCE_ATTR);
        String newTypeDesc = aElement.getAttributeValue(TYPE_ATTR);
        Long newDateAndTime = aElement.getAttribute(TIME_ATTR).getLongValue();
        Boolean newAck = aElement.getAttribute(ACK_ATTR).getBooleanValue();
        String newVS = aElement.getAttributeValue(VS_ATTR);
        String newMsg = aElement.getAttributeValue(MESSAGE_ATTR);
        String newCluster = aElement.getAttributeValue(CLUSTER_ATTR);
        String newAlarmClosedBy = aElement.getAttributeValue(CLOSED_BY_ATTR);
        String newSeverity = aElement.getAttributeValue(SEVERITY_ATTR);
        return new CommHistoryAlarm(newClosedDateAndTime, newSourceType, newSource, newTypeDesc, newDateAndTime, newAck, newVS, newMsg, newCluster, newAlarmClosedBy, newSeverity);
    }

    public CommVarBindList[] readAlarmEmailContact(Integer clusterId) throws SrDatabaseException {
        return this.dbConnection.readAlarmEmailContact(clusterId);
    }

    public CommVarBindList[] readAlarmTypesFromDb(Integer clusterId) throws SrDatabaseException {
        return this.dbConnection.readAlarmTypesFromDb(clusterId);
    }

    public CommVarBindList[] readClustersDataFromDb() throws SrDatabaseException {
        return this.dbConnection.readClustersDataFromDb();
    }

    public CommVarBindList[] readSitesDataFromDb() throws SrDatabaseException {
        return this.dbConnection.readSitesDataFromDb();
    }

    public List<String> getVsIPs(String aClusterAlias, String aSiteAlias) throws SrDatabaseException {
        return this.dbConnection.getVsIPs(aClusterAlias, aSiteAlias);
    }

    public CommVarBindList[] readVSwitchDataFromDb() throws SrDatabaseException {
        return this.dbConnection.readVSwitchDataFromDb();
    }

    public void writeClusterDataToDb(CommVarBindList values) throws SrDatabaseException {
        this.dbConnection.writeClusterDataToDb(values);
    }

    public void writeSiteDataToDb(CommVarBindList values) throws SrDatabaseException {
        this.dbConnection.writeSiteDataToDb(values);
    }

    public CommVarBindList[] readVSwitchDataFromDb(Integer clusterId) throws SrDatabaseException {
        return this.dbConnection.readVSwitchDataFromDb(clusterId);
    }

    public void addCluster(CommVarBindList values) throws SrDatabaseException {
        this.dbConnection.addCluster(values);
    }

    public void addSite(CommVarBindList values) throws SrDatabaseException {
        this.dbConnection.addSite(values);
    }

    public void setAlarmTypeData(CommVarBindList values) throws SrDatabaseException {
        String typeName = (String)values.getValue(ParameterCode.ALARM_TYPE_NAME).value();
        Boolean emailEnabled = (Boolean)values.getValue(ParameterCode.ALARM_TYPE_EMAIL).value();
        this.dbConnection.writeAlarmTypeDataToDb(null, typeName, emailEnabled);
    }

    public void setContactData(CommVarBindList values) throws SrDatabaseException {
        String fromAddress = (String)values.getValue(ParameterCode.EMAIL_CONTACT_FROM_ADDRESS).value();
        String toAddresses = (String)values.getValue(ParameterCode.EMAIL_CONTACT_TO_ADDRESS).value();
        String smtpHost = (String)values.getValue(ParameterCode.EMAIL_CONTACT_SMTP_HOST).value();
        String smtpUser = (String)values.getValue(ParameterCode.EMAIL_CONTACT_SMTP_USER).value();
        String smtpPassword = (String)values.getValue(ParameterCode.EMAIL_CONTACT_SMTP_PASSWORD).value();
        this.dbConnection.writeContactDataToDb(null, fromAddress, toAddresses, smtpHost, smtpUser, smtpPassword);
    }

    public void addVSwitch(CommVarBindList values) throws SrDatabaseException {
        this.dbConnection.addVSwitch(values);
    }

    public void removeVSwitch(String ipToRemove) throws SrDatabaseException {
        this.dbConnection.removeVSwitch(ipToRemove);
    }

    public void removeCluster(Integer vSwitchGroupId) throws SrDatabaseException {
        this.dbConnection.removeCluster(vSwitchGroupId);
    }

    public void removeSite(Integer vSwitchGroupId) throws SrDatabaseException {
        this.dbConnection.removeSite(vSwitchGroupId);
    }

    public void dbSetList(CommVarBindList values) throws SrDatabaseException {
        this.dbConnection.writeVSwitchDataToDb(values);
    }

    public void dbSet(CommVarBind value) throws SrDatabaseException {
        CommVarBindList list = new CommVarBindList();
        list.add(value);
        this.dbSetList(list);
    }

    public DBVarBindList dbGetList(CommVarBindList list) throws SrDatabaseException {
        return this.dbConnection.dbGetList(list);
    }

    private void putValueFromOldDatabase(HashMap values, DBItem key, String ip, Properties oldDBValues) {
        String value = oldDBValues.getProperty(key.toString() + "." + ip);
        values.put(key, value);
    }

    private HashMap getVlauesOfVSwitchFromOldDatabase(String ip, Properties oldDBValues) {
        HashMap values = new HashMap();
        this.putValueFromOldDatabase(values, DBItem.VSWITCH_READ_COMMUNITY, ip, oldDBValues);
        this.putValueFromOldDatabase(values, DBItem.VSWITCH_IP_MASK, ip, oldDBValues);
        this.putValueFromOldDatabase(values, DBItem.VSWITCH_SNMP_PORT, ip, oldDBValues);
        this.putValueFromOldDatabase(values, DBItem.VSWITCH_TRAP_PORT, ip, oldDBValues);
        this.putValueFromOldDatabase(values, DBItem.VSWITCH_SNMP_VERSION, ip, oldDBValues);
        this.putValueFromOldDatabase(values, DBItem.VSWITCH_TIMEOUT, ip, oldDBValues);
        this.putValueFromOldDatabase(values, DBItem.VSWITCH_RETRIES, ip, oldDBValues);
        this.putValueFromOldDatabase(values, DBItem.VSWITCH_WRITE_COMMUNITY, ip, oldDBValues);
        return values;
    }

    private void convertOldDatabaseToNewDatabase(Properties oldDBValues) throws SrDatabaseException {
        String ip = oldDBValues.getProperty(DBItem.VSWITCH_IP_ADDRESS.toString());
        StringTokenizer tokens = new StringTokenizer(ip, dbIpDelimiter);
        String[] ips = new String[tokens.countTokens()];
        HashMap[] newDBValues = new HashMap[ips.length];
        int i = 0;
        while (tokens.hasMoreTokens()) {
            ips[i] = tokens.nextToken();
            newDBValues[i] = new HashMap();
            newDBValues[i].put(DBItem.VSWITCH_IP_ADDRESS, ips[i]);
            ++i;
        }
        for (i = 0; i < ips.length; ++i) {
            HashMap values = this.getVlauesOfVSwitchFromOldDatabase(ips[i], oldDBValues);
            newDBValues[i].putAll(values);
        }
        this.dbConnection.writeToNewDatabase(newDBValues);
    }

    public void convertOldDatabaseToNewDatabaseAndDeleteOldFile() {
        String oldFileName = VSWITCH_PROPERTIES_FILE;
        Properties oldDBValues = new Properties();
        try {
            File oldFile = new File(oldFileName);
            FileInputStream fis = new FileInputStream(oldFile);
            oldDBValues.load(fis);
            this.convertOldDatabaseToNewDatabase(oldDBValues);
            theLogger.trace(SrLogCategories.LEGACY, "Old database file converted to new database file successfully");
            fis.close();
            if (oldFile.delete()) {
                theLogger.trace(SrLogCategories.LEGACY, "Old database file was deleted successfully");
            } else {
                theLogger.trace(SrLogCategories.LEGACY, "Old database file couldn't be deleted");
            }
        }
        catch (FileNotFoundException fne) {
            return;
        }
        catch (IOException e) {
            theLogger.warn(SrLogCategories.LEGACY, e);
        }
        catch (SrDatabaseException sde) {
            theLogger.warn(SrLogCategories.LEGACY, sde);
        }
    }

    public void setPropertiesToFile(Properties aProperties, String aFileName) throws IOException {
        Util.saveProperties(aProperties, aFileName);
    }

    public Properties loadPropertiesFromFile(String aFileName) throws IOException {
        return Util.loadProperties(aFileName);
    }
}

