/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.comm.database;

import com.sanrad.nms.server.comm.CommItem;
import com.sanrad.nms.server.comm.database.DBVarBind;
import com.sanrad.nms.server.comm.snmp.SnmpVersion;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrBoolean;
import com.sanrad.nms.server.util.types.SrDouble;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrIpAddress;
import com.sanrad.nms.server.util.types.SrLong;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrType;
import java.util.Enumeration;
import java.util.Vector;

public class DBItem
implements CommItem {
    private static Vector itemsList;
    private static final int STRING_TYPE = 1;
    private static final int IP_ADDRESS_TYPE = 2;
    private static final int INTEGER_TYPE = 3;
    private static final int SNMP_VERSION_TYPE = 4;
    private static final int LONG_TYPE = 5;
    private static final int BOOLEAN_TYPE = 6;
    private static final int DOUBLE_TYPE = 7;
    public static final DBItem SITE_ALIAS;
    public static final DBItem CLUSTER_ALIAS;
    public static final DBItem VSWITCH_GROUP_ID;
    public static final DBItem PARENT_SITE_ID;
    public static final DBItem VSWITCH_IP_ADDRESS;
    public static final DBItem VSWITCH_IP_MASK;
    public static final DBItem VSWITCH_HOST_NAME;
    public static final DBItem VSWITCH_READ_COMMUNITY;
    public static final DBItem VSWITCH_WRITE_COMMUNITY;
    public static final DBItem VSWITCH_SNMP_PORT;
    public static final DBItem VSWITCH_TRAP_PORT;
    public static final DBItem VSWITCH_RETRIES;
    public static final DBItem VSWITCH_TIMEOUT;
    public static final DBItem VSWITCH_SNMP_VERSION;
    public static final DBItem VSWITCH_STATE;
    public static final DBItem VIRTUALIZATION_POLL_INTERVAL;
    public static final DBItem ACL_POLL_INTERVAL;
    public static final DBItem NET_POLL_INTERVAL;
    public static final DBItem GENERAL_POLL_INTERVAL;
    public static final DBItem ISCSI_POLL_INTERVAL;
    public static final DBItem PITS_POLL_INTERVAL;
    public static final DBItem DR_POLL_INTERVAL;
    public static final DBItem STATISTIC_POLL_INTERVAL;
    public static final DBItem ALARM_TYPE_NAME;
    public static final DBItem ALARM_TYPE_ID;
    public static final DBItem ALARM_TYPE_CATEGORY;
    public static final DBItem ALARM_TYPE_SEVERITY;
    public static final DBItem ALARM_TYPE_EMAIL;
    public static final DBItem ALARM_TYPE_CALL_HOME;
    public static final DBItem ALARM_TYPE_TROUBLESHOOTING;
    public static final DBItem ALARM_TYPE_SILENT;
    public static final DBItem EMAIL_CONTACT_TO_ADDRESS;
    public static final DBItem EMAIL_CONTACT_FROM_ADDRESS;
    public static final DBItem EMAIL_CONTACT_SMTP_HOST;
    public static final DBItem EMAIL_CONTACT_SMTP_USER;
    public static final DBItem EMAIL_CONTACT_SMTP_PASSWORD;
    public static final DBItem CLUSTER_STORAGE_COMPARISON;
    private String myDbName;
    private int myType;

    private DBItem(String dbName, int type, ParameterCode code) {
        this.myDbName = dbName;
        this.myType = type;
        if (itemsList == null) {
            itemsList = new Vector();
        }
        itemsList.add(this);
    }

    public static DBItem convertStringToDBItem(String str) {
        Enumeration valIter = itemsList.elements();
        while (valIter.hasMoreElements()) {
            DBItem currnt = (DBItem)valIter.nextElement();
            if (!currnt.toString().equals(str)) continue;
            return currnt;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DBItem) {
            return this.toString().equals(obj.toString());
        }
        if (obj instanceof DBVarBind) {
            return this.toString().equals(((DBVarBind)obj).getVarBindKey().getVarBindName());
        }
        return false;
    }

    public String toString() {
        return this.myDbName;
    }

    public SrType getByType(String value) {
        switch (this.myType) {
            case 1: {
                return new SrString(value);
            }
            case 3: {
                return new SrInteger(value);
            }
            case 7: {
                return new SrDouble(value);
            }
            case 5: {
                return new SrLong(value);
            }
            case 2: {
                return new SrIpAddress(value);
            }
            case 4: {
                return SnmpVersion.getVersion(value);
            }
            case 6: {
                return new SrBoolean(value);
            }
        }
        return new SrString(value);
    }

    static {
        SITE_ALIAS = new DBItem("siteAlias", 1, ParameterCode.SITE_ALIAS);
        CLUSTER_ALIAS = new DBItem("alias", 1, ParameterCode.CLUSTER_ALIAS);
        VSWITCH_GROUP_ID = new DBItem("id", 3, ParameterCode.VSWITCH_GROUP_ID);
        PARENT_SITE_ID = new DBItem("parentId", 3, ParameterCode.PARENT_SITE_ID);
        VSWITCH_IP_ADDRESS = new DBItem("IpAddress", 2, ParameterCode.VSWITCH_IP_ADDRESS);
        VSWITCH_IP_MASK = new DBItem("IpMask", 2, ParameterCode.VSWITCH_IP_MASK);
        VSWITCH_HOST_NAME = new DBItem("HostName", 1, ParameterCode.VSWITCH_HOST_NAME);
        VSWITCH_READ_COMMUNITY = new DBItem("ReadCommunity", 1, ParameterCode.VSWITCH_READ_COMMUNITY);
        VSWITCH_WRITE_COMMUNITY = new DBItem("WriteCommunity", 1, ParameterCode.VSWITCH_WRITE_COMMUNITY);
        VSWITCH_SNMP_PORT = new DBItem("SnmpPort", 3, ParameterCode.VSWITCH_SNMP_UDP_PORT);
        VSWITCH_TRAP_PORT = new DBItem("TrapPort", 3, ParameterCode.VSWITCH_TRAP_UDP_PORT);
        VSWITCH_RETRIES = new DBItem("MaxRetries", 3, ParameterCode.VSWITCH_MAX_RETRIES);
        VSWITCH_TIMEOUT = new DBItem("Timeout", 5, ParameterCode.VSWITCH_TIMEOUT);
        VSWITCH_SNMP_VERSION = new DBItem("SnmpVersion", 4, ParameterCode.VSWITCH_SNMP_VERSION);
        VSWITCH_STATE = new DBItem("state", 3, ParameterCode.VSWITCH_CONNECTIVITY_STATUS);
        VIRTUALIZATION_POLL_INTERVAL = new DBItem("VirtPollInterval", 7, ParameterCode.VIRTUALIZATION_POLL_INTERVAL);
        ACL_POLL_INTERVAL = new DBItem("AclPollInterval", 7, ParameterCode.ACL_POLL_INTERVAL);
        NET_POLL_INTERVAL = new DBItem("NetPollInterval", 7, ParameterCode.NET_POLL_INTERVAL);
        GENERAL_POLL_INTERVAL = new DBItem("GeneralPollInterval", 7, ParameterCode.GENERAL_POLL_INTERVAL);
        ISCSI_POLL_INTERVAL = new DBItem("IScsiPollInterval", 7, ParameterCode.ISCSI_POLL_INTERVAL);
        PITS_POLL_INTERVAL = new DBItem("PiTPollInterval", 7, ParameterCode.PIT_POLL_INTERVAL);
        DR_POLL_INTERVAL = new DBItem("DRPollInterval", 7, ParameterCode.DR_POLL_INTERVAL);
        STATISTIC_POLL_INTERVAL = new DBItem("StatisticPollInterval", 7, ParameterCode.STATISTIC_POLL_INTERVAL);
        ALARM_TYPE_NAME = new DBItem("name", 1, ParameterCode.ALARM_TYPE_NAME);
        ALARM_TYPE_ID = new DBItem("typeId", 3, ParameterCode.ALARM_TYPE_ID);
        ALARM_TYPE_CATEGORY = new DBItem("category", 1, ParameterCode.ALARM_TYPE_CATEGORY);
        ALARM_TYPE_SEVERITY = new DBItem("severity", 1, ParameterCode.ALARM_TYPE_SEVERITY);
        ALARM_TYPE_EMAIL = new DBItem("mail", 6, ParameterCode.ALARM_TYPE_EMAIL);
        ALARM_TYPE_CALL_HOME = new DBItem("callHome", 6, ParameterCode.ALARM_TYPE_CALL_HOME);
        ALARM_TYPE_TROUBLESHOOTING = new DBItem("troubleshooting", 1, ParameterCode.ALARM_TYPE_TROUBLESHOOTING);
        ALARM_TYPE_SILENT = new DBItem("Silent", 1, ParameterCode.ALARM_TYPE_SILENT);
        EMAIL_CONTACT_TO_ADDRESS = new DBItem("to", 1, ParameterCode.EMAIL_CONTACT_TO_ADDRESS);
        EMAIL_CONTACT_FROM_ADDRESS = new DBItem("from", 1, ParameterCode.EMAIL_CONTACT_FROM_ADDRESS);
        EMAIL_CONTACT_SMTP_HOST = new DBItem("smtpHost", 1, ParameterCode.EMAIL_CONTACT_SMTP_HOST);
        EMAIL_CONTACT_SMTP_USER = new DBItem("smtpUser", 1, ParameterCode.EMAIL_CONTACT_SMTP_USER);
        EMAIL_CONTACT_SMTP_PASSWORD = new DBItem("smtpPassword", 1, ParameterCode.EMAIL_CONTACT_SMTP_PASSWORD);
        CLUSTER_STORAGE_COMPARISON = new DBItem("StorCmp", 3, ParameterCode.CLUSTER_STORAGE_COMPARISON);
    }
}

