/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.comm;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.comm.CommItem;
import com.sanrad.nms.server.comm.CommVarBind;
import com.sanrad.nms.server.comm.CommVarBindKey;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrType;
import java.util.Vector;

public class CommVarBindList
extends Vector<CommVarBind> {
    private static SrLogger theLogger = SrLogger.getLogger();
    public static final CommVarBindList EMPTY = new CommVarBindList();
    private char snmpAgentIndex;

    public void add(CommVarBind[] commVarBinds) {
        for (CommVarBind commVarBind : commVarBinds) {
            this.add(commVarBind);
        }
    }

    public void add(CommVarBindList commVarBinds) {
        if (commVarBinds == null) {
            return;
        }
        this.addAll(commVarBinds);
    }

    public SrType getValue(CommItem aCommItem) {
        if (aCommItem == null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, "The given parameter should not be null.");
            return null;
        }
        for (CommVarBind curBind : this) {
            if (!curBind.getVarBindKey().getKey().startsWith(aCommItem.toString())) continue;
            return curBind.getValue();
        }
        return null;
    }

    public void copyValues(CommVarBindList list) {
        if (list == null) {
            return;
        }
        for (CommVarBind other : list) {
            int indexInThis = this.indexOf(other);
            if (indexInThis == -1) continue;
            Vector<Integer> indexes = this.getIndexesOfVarBindsInThisTheSameAs(other);
            this.setThisVarBindsValueWithOtherValue(indexes, other);
        }
    }

    private Vector<Integer> getIndexesOfVarBindsInThisTheSameAs(CommVarBind other) {
        Vector<Integer> indexes = new Vector<Integer>();
        for (int index = 0; index < this.size(); ++index) {
            CommVarBind currVarBindInThis = (CommVarBind)this.elementAt(index);
            if (!currVarBindInThis.getVarBindKey().equals(other.getVarBindKey())) continue;
            indexes.add(index);
        }
        return indexes;
    }

    private void setThisVarBindsValueWithOtherValue(Vector<Integer> thisVarBindsIndexes, CommVarBind other) {
        for (int vbIndex : thisVarBindsIndexes) {
            CommVarBind varBindInThis = (CommVarBind)this.elementAt(vbIndex);
            varBindInThis.setValue(other.getValue());
        }
    }

    public void copyAndAddValues(CommVarBindList list) {
        for (CommVarBind other : list) {
            int indexInThis = this.indexOf(other);
            if (indexInThis != -1) {
                CommVarBind varBindInThis = (CommVarBind)this.elementAt(indexInThis);
                varBindInThis.setValue(other.getValue());
                continue;
            }
            this.add(other);
        }
    }

    @Override
    public String toString() {
        return "CommVarBindList" + super.toString();
    }

    public SrType getValue(ParameterCode keyParameterCode) {
        for (CommVarBind varBind : this) {
            ParameterCode currentCode = varBind.getVarBindKey().getParameterCode();
            if (currentCode == null || !currentCode.equals(keyParameterCode)) continue;
            return varBind.getValue();
        }
        return null;
    }

    public void setValue(ParameterCode keyParameterCode, SrType value) {
        for (CommVarBind varBind : this) {
            ParameterCode currentCode = varBind.getVarBindKey().getParameterCode();
            if (currentCode == null || !currentCode.equals(keyParameterCode)) continue;
            varBind.setValue(value);
            break;
        }
    }

    public Object getValueOfParameterCode(ParameterCode keyParameterCode) {
        SrType value = this.getValue(keyParameterCode);
        if (value != null) {
            return value.value();
        }
        return null;
    }

    public String getOidList() {
        String oids = "";
        for (CommVarBind varBind : this) {
            oids = oids + " : " + varBind.getVarBindKey().toString();
        }
        return oids;
    }

    public void setSnmpAgentIndex(char c) {
        this.snmpAgentIndex = c;
    }

    public char getSnmpAgentIndex() {
        return this.snmpAgentIndex;
    }

    public CommVarBind getVarBind(CommItem aCommItem) {
        for (CommVarBind var : this) {
            String commItemStr;
            CommVarBindKey varbindKey = var.getVarBindKey();
            String name = varbindKey.getVarBindName();
            if (!name.equals(commItemStr = aCommItem.toString())) continue;
            return var;
        }
        return null;
    }
}

