/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.comm;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.comm.CommVarBind;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.database.DBItem;
import com.sanrad.nms.server.comm.database.DBVarBind;
import com.sanrad.nms.server.comm.database.DBVarBindList;
import com.sanrad.nms.server.comm.database.DatabaseManager;
import com.sanrad.nms.server.comm.database.exception.SrDatabaseException;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.comm.snmp.DefaultSnmpMgr;
import com.sanrad.nms.server.comm.snmp.SnmpAgentParams;
import com.sanrad.nms.server.comm.snmp.SnmpErrorAnalyzer;
import com.sanrad.nms.server.comm.snmp.SnmpVersion;
import com.sanrad.nms.server.comm.snmp.SrOid;
import com.sanrad.nms.server.comm.snmp.SrSnmpTable;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBindList;
import com.sanrad.nms.server.comm.snmp.raid.RaidConfigurationException;
import com.sanrad.nms.server.comm.snmp.raid.RaidSubsystem;
import com.sanrad.nms.server.comm.snmp.trap.TrapListener;
import com.sanrad.nms.server.comm.snmp.trap.TrapManager;
import com.sanrad.nms.server.mgr.VSwitchConfigurator;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrIpAddress;
import com.sanrad.nms.server.util.types.SrLong;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.util.Util;
import com.sanrad.util.alarm.HistoryAlarmData;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import monfox.toolkit.snmp.SnmpException;
import monfox.toolkit.snmp.engine.SnmpTransportException;
import monfox.toolkit.snmp.mgr.SnmpErrorException;
import monfox.toolkit.snmp.mgr.SnmpTimeoutException;

public class CommMgr {
    private static DefaultSnmpMgr[] snmpMgrs = null;
    private static HashMap commMgrs = new HashMap();
    private static SrLogger theLogger = SrLogger.getLogger();
    public static final char DB_COMM_MGR_KEY = 'z';
    private static DatabaseManager dbMgr = DatabaseManager.getInstance();

    private CommMgr() {
    }

    public static synchronized CommMgr getInstance(char index) {
        CommMgr commMgr = (CommMgr)commMgrs.get(new Character(index));
        if (commMgr == null) {
            commMgrs.put(new Character(index), new CommMgr());
        }
        commMgr = (CommMgr)commMgrs.get(new Character(index));
        return commMgr;
    }

    private void innerSetSnmpList(CommVarBindList aVarBindsToSet, char aAgentIndex) throws SrCommException {
        if (snmpMgrs == null) {
            throw new IllegalStateException("snmpMgrs was not initialized yet.");
        }
        if (aAgentIndex >= snmpMgrs.length || snmpMgrs[aAgentIndex] == null) {
            throw new IllegalArgumentException(CommMgr.getMessageForAgentNotFound(aAgentIndex));
        }
        String errorMsg = "innerSetSnmpList";
        String agentMgmtIP = snmpMgrs[aAgentIndex].getAgentHostname();
        try {
            snmpMgrs[aAgentIndex].snmpSetList(aVarBindsToSet);
        }
        catch (SnmpErrorException see) {
            SnmpErrorAnalyzer.rethrow(see, aVarBindsToSet, aAgentIndex, agentMgmtIP, errorMsg);
        }
        catch (SnmpTimeoutException stoe) {
            SnmpErrorAnalyzer.rethrow(stoe, aVarBindsToSet, aAgentIndex, agentMgmtIP, errorMsg);
        }
        catch (SnmpTransportException ste) {
            SnmpErrorAnalyzer.rethrow(ste, aVarBindsToSet, aAgentIndex, agentMgmtIP, errorMsg);
        }
        catch (SnmpException se) {
            SnmpErrorAnalyzer.rethrow(se, aVarBindsToSet, aAgentIndex, agentMgmtIP, errorMsg);
        }
    }

    public synchronized void setList(CommVarBindList varBindsToSet, char aAgentIndex) throws SrCommException {
        this.innerSetSnmpList(varBindsToSet, aAgentIndex);
        dbMgr.dbSetList(varBindsToSet);
    }

    public synchronized void setListSnmpOnly(CommVarBindList varBindsToSet, char aAgentIndex) throws SrCommException {
        this.innerSetSnmpList(varBindsToSet, aAgentIndex);
    }

    public void setSnmpOnly(CommVarBind value, char aAgentIndex) throws SrCommException {
        CommVarBindList list = new CommVarBindList();
        list.add(value);
        this.setListSnmpOnly(list, aAgentIndex);
    }

    private SrSnmpVarBindList innerSnmpGetList(CommVarBindList aVarBindsToSet, char aAgentIndex) throws SrCommException {
        SrSnmpVarBindList retVal = null;
        if (snmpMgrs == null) {
            throw new IllegalStateException("snmpMgrs was not initialized yet.");
        }
        if (aAgentIndex >= snmpMgrs.length || snmpMgrs[aAgentIndex] == null) {
            throw new IllegalArgumentException(CommMgr.getMessageForAgentNotFound(aAgentIndex));
        }
        String errorMsg = "innerSnmpGetList";
        String hostName = snmpMgrs[aAgentIndex].getAgentHostname();
        try {
            retVal = snmpMgrs[aAgentIndex].snmpGetList(aVarBindsToSet);
        }
        catch (SnmpErrorException see) {
            SnmpErrorAnalyzer.rethrow(see, aVarBindsToSet, aAgentIndex, hostName, errorMsg);
        }
        catch (SnmpTimeoutException stoe) {
            SnmpErrorAnalyzer.rethrow(stoe, aVarBindsToSet, aAgentIndex, hostName, errorMsg);
        }
        catch (SnmpTransportException ste) {
            SnmpErrorAnalyzer.rethrow(ste, aVarBindsToSet, aAgentIndex, hostName, errorMsg);
        }
        catch (SnmpException se) {
            SnmpErrorAnalyzer.rethrow(se, aVarBindsToSet, aAgentIndex, hostName, errorMsg);
        }
        return retVal;
    }

    public synchronized void getList(CommVarBindList list, char aAgentIndex) throws SrCommException {
        DBVarBindList dbList = dbMgr.dbGetList(list);
        list.copyValues(dbList);
        SrSnmpVarBindList snmpList = this.innerSnmpGetList(list, aAgentIndex);
        list.copyValues(snmpList);
        list.setSnmpAgentIndex(aAgentIndex);
    }

    public synchronized CommVarBindList[] getListsByKeyPrefix(CommVarBindList list, String keyPrefix, char aAgentIndex) throws SrCommException {
        CommVarBindList[] retVal = null;
        if (snmpMgrs == null) {
            throw new IllegalStateException("snmpMgrs was not initialized yet.");
        }
        if (aAgentIndex >= snmpMgrs.length || snmpMgrs[aAgentIndex] == null) {
            throw new IllegalArgumentException(CommMgr.getMessageForAgentNotFound(aAgentIndex));
        }
        if (list.size() > 0) {
            String[] errorMsg = new String[]{"getListsByKeyPrefix- keyPrefix(", keyPrefix, ")"};
            String hostName = snmpMgrs[aAgentIndex].getAgentHostname();
            try {
                retVal = snmpMgrs[aAgentIndex].snmpGetBulkByKeyPrefix(list, keyPrefix);
            }
            catch (SnmpErrorException see) {
                SnmpErrorAnalyzer.rethrow(see, CommVarBindList.EMPTY, aAgentIndex, hostName, errorMsg);
            }
            catch (SnmpTimeoutException stoe) {
                SnmpErrorAnalyzer.rethrow(stoe, CommVarBindList.EMPTY, aAgentIndex, hostName, errorMsg);
            }
            catch (SnmpTransportException ste) {
                SnmpErrorAnalyzer.rethrow(ste, CommVarBindList.EMPTY, aAgentIndex, hostName, errorMsg);
            }
            catch (SnmpException se) {
                SnmpErrorAnalyzer.rethrow(se, CommVarBindList.EMPTY, aAgentIndex, hostName, errorMsg);
            }
        }
        return retVal;
    }

    public synchronized void refreshTable(SrSnmpTable tableRef) throws SrCommException {
        char agentIndex = tableRef.getAgentIndex();
        if (snmpMgrs == null) {
            throw new IllegalStateException("snmpMgrs was not initialized yet.");
        }
        if (snmpMgrs[agentIndex] == null) {
            throw new IllegalArgumentException(CommMgr.getMessageForAgentNotFound(agentIndex));
        }
        String[] errorMsg = new String[]{"refreshTable- tableRef(", tableRef.toString(), ")"};
        String hostName = snmpMgrs[agentIndex].getAgentHostname();
        try {
            snmpMgrs[agentIndex].snmpRefreshTable(tableRef);
        }
        catch (SnmpErrorException see) {
            SnmpErrorAnalyzer.rethrow(see, CommVarBindList.EMPTY, agentIndex, hostName, errorMsg);
        }
        catch (SnmpTimeoutException stoe) {
            SnmpErrorAnalyzer.rethrow(stoe, CommVarBindList.EMPTY, agentIndex, hostName, errorMsg);
        }
        catch (SnmpTransportException ste) {
            SnmpErrorAnalyzer.rethrow(ste, CommVarBindList.EMPTY, agentIndex, hostName, errorMsg);
        }
        catch (SnmpException se) {
            SnmpErrorAnalyzer.rethrow(se, CommVarBindList.EMPTY, agentIndex, hostName, errorMsg);
        }
    }

    public synchronized CommVarBindList[] getAll(String tableName, char aAgentIndex) throws SrCommException {
        if (snmpMgrs == null) {
            throw new IllegalStateException("snmpMgrs was not initialized yet.");
        }
        if (aAgentIndex >= snmpMgrs.length || snmpMgrs[aAgentIndex] == null) {
            throw new IllegalArgumentException(CommMgr.getMessageForAgentNotFound(aAgentIndex));
        }
        CommVarBindList[] retVal = null;
        String[] errorMsg = new String[]{"CommVarBindList- tableName(", tableName, ")"};
        String hostName = snmpMgrs[aAgentIndex].getAgentHostname();
        try {
            retVal = snmpMgrs[aAgentIndex].snmpGetTable(tableName);
        }
        catch (SnmpErrorException see) {
            SnmpErrorAnalyzer.rethrow(see, CommVarBindList.EMPTY, aAgentIndex, hostName, errorMsg);
        }
        catch (SnmpTimeoutException stoe) {
            SnmpErrorAnalyzer.rethrow(stoe, CommVarBindList.EMPTY, aAgentIndex, hostName, errorMsg);
        }
        catch (SnmpTransportException ste) {
            SnmpErrorAnalyzer.rethrow(ste, CommVarBindList.EMPTY, aAgentIndex, hostName, errorMsg);
        }
        catch (SnmpException se) {
            SnmpErrorAnalyzer.rethrow(se, CommVarBindList.EMPTY, aAgentIndex, hostName, errorMsg);
        }
        return retVal;
    }

    public synchronized SrSnmpTable createTableRef(String tableName, char aAgentIndex) {
        if (snmpMgrs == null) {
            throw new IllegalStateException("snmpMgrs was not initialized yet.");
        }
        if (aAgentIndex >= snmpMgrs.length || snmpMgrs[aAgentIndex] == null) {
            throw new IllegalArgumentException(CommMgr.getMessageForAgentNotFound(aAgentIndex));
        }
        SrSnmpTable table = snmpMgrs[aAgentIndex].getTableRef(tableName);
        table.setAgentIndex(aAgentIndex);
        return table;
    }

    public static CommVarBindList getTableRow(SrSnmpTable table, CommKey rowIndex) throws SrCommException {
        char agentIndex = table.getAgentIndex();
        if (snmpMgrs == null) {
            throw new IllegalStateException("snmpMgrs was not initialized yet.");
        }
        if (snmpMgrs[agentIndex] == null) {
            throw new IllegalArgumentException(CommMgr.getMessageForAgentNotFound(agentIndex));
        }
        String[] errorMsg = new String[]{"getTableRow- table(", table.toString(), "), rowIndex(", rowIndex.toString(), ")"};
        CommVarBindList row = null;
        String hostName = snmpMgrs[agentIndex].getAgentHostname();
        try {
            row = DefaultSnmpMgr.snmpGetTableRow(table, rowIndex);
            theLogger.logAndAssert(SrLogCategories.ERROR, row != null, new Object[]{"In VS '", Character.valueOf(agentIndex), "', passed in row CommKey '", rowIndex, "' is null."});
            if (row != null) {
                row.setSnmpAgentIndex(agentIndex);
            }
        }
        catch (SnmpException se) {
            SnmpErrorAnalyzer.rethrow(se, CommVarBindList.EMPTY, agentIndex, hostName, errorMsg);
        }
        return row;
    }

    public synchronized CommVarBindList getOneRow(String[] tableNames, CommKey index) throws SrCommException {
        char agentIndex = ((SnmpCommKey)index).getSnmpAgentIndex();
        if (snmpMgrs == null) {
            throw new IllegalStateException("snmpMgrs was not initialized yet.");
        }
        if (snmpMgrs[agentIndex] == null) {
            throw new IllegalArgumentException(CommMgr.getMessageForAgentNotFound(agentIndex));
        }
        SrSnmpVarBindList retVal = null;
        String[] errorMsg = new String[]{"getOneRow- tableNames(", Util.getListAsString(Arrays.asList(tableNames)), "); index(", index.toString(), ")"};
        String hostName = snmpMgrs[agentIndex].getAgentHostname();
        try {
            retVal = snmpMgrs[agentIndex].snmpGetOneRow(tableNames, index);
        }
        catch (SnmpErrorException see) {
            SnmpErrorAnalyzer.rethrow(see, CommVarBindList.EMPTY, agentIndex, hostName, errorMsg);
        }
        catch (SnmpTimeoutException stoe) {
            SnmpErrorAnalyzer.rethrow(stoe, CommVarBindList.EMPTY, agentIndex, hostName, errorMsg);
        }
        catch (SnmpTransportException ste) {
            SnmpErrorAnalyzer.rethrow(ste, CommVarBindList.EMPTY, agentIndex, hostName, errorMsg);
        }
        catch (SnmpException se) {
            SnmpErrorAnalyzer.rethrow(se, CommVarBindList.EMPTY, agentIndex, hostName, errorMsg);
        }
        return retVal;
    }

    public synchronized CommVarBindList[] filterTableRowsByValue(SrSnmpTable table, CommVarBind columnValue) {
        String columnName = ((SrOid)columnValue.getVarBindKey()).getOid();
        SrType value = columnValue.getValue();
        char agentIndex = table.getAgentIndex();
        if (snmpMgrs == null) {
            throw new IllegalStateException("snmpMgrs was not initialized yet.");
        }
        if (snmpMgrs[agentIndex] == null) {
            throw new IllegalArgumentException(CommMgr.getMessageForAgentNotFound(agentIndex));
        }
        CommVarBindList[] rows = snmpMgrs[agentIndex].filterTableRowsByValue(table, columnName, value);
        if (rows != null) {
            for (int i = 0; i < rows.length; ++i) {
                rows[i].setSnmpAgentIndex(agentIndex);
            }
        }
        return rows;
    }

    public synchronized CommVarBindList[] getTableRowsByValue(String tableName, String columnName, SrType value, char agentIndex) throws SrCommException {
        if (snmpMgrs == null) {
            throw new IllegalStateException("snmpMgrs was not initialized yet.");
        }
        if (snmpMgrs[agentIndex] == null) {
            throw new IllegalArgumentException(CommMgr.getMessageForAgentNotFound(agentIndex));
        }
        CommVarBindList[] retVal = null;
        String[] errorMsg = new String[]{"getTableRowsByValue- tableName(", tableName, "); columnName(", columnName, "); value(", value.toDisplayString(), "); agentIndex(", Integer.valueOf(agentIndex).toString(), ")"};
        String hostName = snmpMgrs[agentIndex].getAgentHostname();
        try {
            retVal = snmpMgrs[agentIndex].snmpGetTableRowsByFilter(tableName, columnName, value, agentIndex);
        }
        catch (SnmpErrorException see) {
            SnmpErrorAnalyzer.rethrow(see, CommVarBindList.EMPTY, agentIndex, hostName, errorMsg);
        }
        catch (SnmpTimeoutException stoe) {
            SnmpErrorAnalyzer.rethrow(stoe, CommVarBindList.EMPTY, agentIndex, hostName, errorMsg);
        }
        catch (SnmpTransportException ste) {
            SnmpErrorAnalyzer.rethrow(ste, CommVarBindList.EMPTY, agentIndex, hostName, errorMsg);
        }
        catch (SnmpException se) {
            SnmpErrorAnalyzer.rethrow(se, CommVarBindList.EMPTY, agentIndex, hostName, errorMsg);
        }
        return retVal;
    }

    public synchronized void addSite(CommVarBindList newSiteData) {
        try {
            dbMgr.addSite(newSiteData);
        }
        catch (SrDatabaseException e) {
            theLogger.error(SrLogCategories.EXCEPTION, e, "Failed to create new Site in DB.", newSiteData);
        }
    }

    public synchronized void addCluster(CommVarBindList newClusterData) {
        try {
            dbMgr.addCluster(newClusterData);
        }
        catch (SrDatabaseException e) {
            theLogger.error(SrLogCategories.EXCEPTION, e, "Failed to create new Cluster in DB.", newClusterData);
        }
    }

    private static int innerCreateTrapMonitorIfNeeded(CommVarBindList aVarBindsToSet, char aAgentIndex, SnmpAgentParams aNewAgentParams) throws SrCommException {
        if (snmpMgrs == null) {
            throw new IllegalStateException("snmpMgrs was not initialized yet.");
        }
        if (aAgentIndex >= snmpMgrs.length || snmpMgrs[aAgentIndex] == null) {
            throw new IllegalArgumentException(CommMgr.getMessageForAgentNotFound(aAgentIndex));
        }
        int retVal = -1;
        String[] errorMsg = new String[]{"innerCreateTrapMonitorIfNeeded", aNewAgentParams.toString()};
        String hostName = snmpMgrs[aAgentIndex].getAgentHostname();
        try {
            retVal = TrapManager.getInstance().createTrapMonitorIfNeeded(aNewAgentParams.getTrapPort().intValue(), aAgentIndex, aNewAgentParams.getIpAddress());
        }
        catch (SnmpErrorException see) {
            SnmpErrorAnalyzer.rethrow(see, aVarBindsToSet, aAgentIndex, hostName, errorMsg);
        }
        catch (SnmpTimeoutException stoe) {
            SnmpErrorAnalyzer.rethrow(stoe, aVarBindsToSet, aAgentIndex, hostName, errorMsg);
        }
        catch (SnmpTransportException ste) {
            SnmpErrorAnalyzer.rethrow(ste, aVarBindsToSet, aAgentIndex, hostName, errorMsg);
        }
        catch (SnmpException se) {
            SnmpErrorAnalyzer.rethrow(se, aVarBindsToSet, aAgentIndex, hostName, errorMsg);
        }
        return retVal;
    }

    public static synchronized void addSnmpAgent(CommVarBindList newAgentData) throws SrCommException {
        if (snmpMgrs == null) {
            throw new IllegalStateException("snmpMgrs was not initialized yet.");
        }
        SnmpAgentParams newAgentParams = CommMgr.createSnmpParamsFromCommVarBindList(newAgentData);
        dbMgr.addVSwitch(newAgentData);
        int indexForNewAgent = -1;
        for (int i = 0; i < snmpMgrs.length; ++i) {
            if (snmpMgrs[i] != null) continue;
            indexForNewAgent = i;
        }
        if (indexForNewAgent == -1) {
            DefaultSnmpMgr[] newArray = new DefaultSnmpMgr[snmpMgrs.length + 1];
            System.arraycopy(snmpMgrs, 0, newArray, 0, snmpMgrs.length);
            indexForNewAgent = snmpMgrs.length;
            snmpMgrs = newArray;
        }
        String errorMsg = "addSnmpAgent";
        String hostName = newAgentParams.getHostname().toDisplayString();
        try {
            CommMgr.snmpMgrs[indexForNewAgent] = new DefaultSnmpMgr(newAgentParams, (char)indexForNewAgent);
            newAgentData.setSnmpAgentIndex((char)indexForNewAgent);
            CommMgr.innerCreateTrapMonitorIfNeeded(newAgentData, (char)indexForNewAgent, newAgentParams);
        }
        catch (SnmpErrorException see) {
            SnmpErrorAnalyzer.rethrow(see, newAgentData, (char)indexForNewAgent, hostName, errorMsg);
        }
        catch (SnmpTimeoutException stoe) {
            SnmpErrorAnalyzer.rethrow(stoe, newAgentData, (char)indexForNewAgent, hostName, errorMsg);
        }
        catch (SnmpTransportException ste) {
            SnmpErrorAnalyzer.rethrow(ste, newAgentData, (char)indexForNewAgent, hostName, errorMsg);
        }
        catch (SnmpException se) {
            SnmpErrorAnalyzer.rethrow(se, newAgentData, (char)indexForNewAgent, hostName, errorMsg);
        }
        catch (UnknownHostException uhe) {
            SnmpErrorAnalyzer.rethrow(uhe, newAgentData, (char)indexForNewAgent, hostName, errorMsg);
        }
    }

    public synchronized void removeSnmpAgent(char aAgentIndex) throws SrCommException {
        if (snmpMgrs == null) {
            throw new IllegalStateException("snmpMgrs was not initialized yet.");
        }
        if (aAgentIndex >= snmpMgrs.length || snmpMgrs[aAgentIndex] == null) {
            throw new IllegalArgumentException(CommMgr.getMessageForAgentNotFound(aAgentIndex));
        }
        DefaultSnmpMgr mgr = snmpMgrs[aAgentIndex];
        String ip = mgr.getAgentIpAddress();
        dbMgr.removeVSwitch(ip);
        try {
            commMgrs.remove(new Character(aAgentIndex));
            TrapManager.getInstance().removeTrapMonitorIfNeeded(aAgentIndex);
            mgr.shutdown();
            CommMgr.snmpMgrs[aAgentIndex] = null;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            theLogger.logAndAssert(SrLogCategories.LEGACY, e, "Array Error while removing SNMP agent - keep working");
        }
    }

    public static synchronized String getSnmpManagerIp(char aAgentIndex) throws SrCommException {
        char index = aAgentIndex;
        if (snmpMgrs.length > index && snmpMgrs[index] != null) {
            String hostName = snmpMgrs[aAgentIndex].getAgentHostname();
            String errorMsg = "getSnmpManagerIp";
            try {
                return snmpMgrs[index].getManagerIpAddress();
            }
            catch (SnmpErrorException see) {
                SnmpErrorAnalyzer.rethrow(see, CommVarBindList.EMPTY, aAgentIndex, hostName, errorMsg);
            }
            catch (SnmpTimeoutException stoe) {
                SnmpErrorAnalyzer.rethrow(stoe, CommVarBindList.EMPTY, aAgentIndex, hostName, errorMsg);
            }
            catch (SnmpTransportException ste) {
                SnmpErrorAnalyzer.rethrow(ste, CommVarBindList.EMPTY, aAgentIndex, hostName, errorMsg);
            }
            catch (SnmpException se) {
                SnmpErrorAnalyzer.rethrow(se, CommVarBindList.EMPTY, aAgentIndex, hostName, errorMsg);
            }
        }
        return null;
    }

    public static synchronized int getManagerTrapPort(char aAgentIndex) {
        return TrapManager.getInstance().getManagerTrapPort(aAgentIndex);
    }

    public synchronized void removeSite(Integer vSwitchGroupId) throws SrDatabaseException {
        dbMgr.removeSite(vSwitchGroupId);
    }

    public synchronized void removeCluster(Integer vSwitchGroupId) throws SrDatabaseException {
        dbMgr.removeCluster(vSwitchGroupId);
    }

    public synchronized void changeClusterParams(CommVarBindList params) throws SrDatabaseException {
        dbMgr.writeClusterDataToDb(params);
    }

    public synchronized void changeSiteParams(CommVarBindList params) throws SrDatabaseException {
        dbMgr.writeSiteDataToDb(params);
    }

    private static void innerChangeTrapPort(CommVarBindList aVarBindsToSet, char aAgentIndex, int port, String aIP) throws SrCommException {
        if (snmpMgrs == null) {
            throw new IllegalStateException("snmpMgrs was not initialized yet.");
        }
        if (aAgentIndex >= snmpMgrs.length || snmpMgrs[aAgentIndex] == null) {
            throw new IllegalArgumentException(CommMgr.getMessageForAgentNotFound(aAgentIndex));
        }
        String[] errorMsg = new String[]{"innerChangeTrapPort", Integer.toString(port), aIP};
        String hostName = snmpMgrs[aAgentIndex].getAgentHostname();
        try {
            TrapManager.getInstance().changeTrapPort(aAgentIndex, port, aIP);
        }
        catch (SnmpErrorException see) {
            SnmpErrorAnalyzer.rethrow(see, aVarBindsToSet, aAgentIndex, hostName, errorMsg);
        }
        catch (SnmpTimeoutException stoe) {
            SnmpErrorAnalyzer.rethrow(stoe, aVarBindsToSet, aAgentIndex, hostName, errorMsg);
        }
        catch (SnmpTransportException ste) {
            SnmpErrorAnalyzer.rethrow(ste, aVarBindsToSet, aAgentIndex, hostName, errorMsg);
        }
        catch (SnmpException se) {
            SnmpErrorAnalyzer.rethrow(se, aVarBindsToSet, aAgentIndex, hostName, errorMsg);
        }
    }

    public synchronized void changeSnmpAgentParams(CommVarBindList agentNewParams, char aAgentIndex) throws SrCommException {
        boolean portChangeError = false;
        if (snmpMgrs == null) {
            throw new IllegalStateException("snmpMgrs was not initialized yet.");
        }
        if (aAgentIndex >= snmpMgrs.length || snmpMgrs[aAgentIndex] == null) {
            throw new IllegalArgumentException(CommMgr.getMessageForAgentNotFound(aAgentIndex));
        }
        for (int i = 0; i < agentNewParams.size(); ++i) {
            CommVarBind vb = (CommVarBind)agentNewParams.get(i);
            if (!(vb instanceof DBVarBind)) continue;
            String key = vb.getVarBindKey().getVarBindName();
            SrType value = vb.getValue();
            if (key.equals("Timeout")) {
                snmpMgrs[aAgentIndex].setTimeout((Long)value.value());
                continue;
            }
            if (key.equals("MaxRetries")) {
                snmpMgrs[aAgentIndex].setRetries((Integer)value.value());
                continue;
            }
            if (key.equals("SnmpPort")) {
                String[] errorMsg = new String[]{"changeSnmpAgentParams"};
                String hostName = snmpMgrs[aAgentIndex].getAgentHostname();
                try {
                    snmpMgrs[aAgentIndex].setSnmpPort((Integer)value.value());
                }
                catch (SnmpErrorException see) {
                    SnmpErrorAnalyzer.rethrow(see, agentNewParams, aAgentIndex, hostName, errorMsg);
                }
                catch (SnmpTimeoutException stoe) {
                    SnmpErrorAnalyzer.rethrow(stoe, agentNewParams, aAgentIndex, hostName, errorMsg);
                }
                catch (SnmpTransportException ste) {
                    SnmpErrorAnalyzer.rethrow(ste, agentNewParams, aAgentIndex, hostName, errorMsg);
                }
                catch (SnmpException se) {
                    SnmpErrorAnalyzer.rethrow(se, agentNewParams, aAgentIndex, hostName, errorMsg);
                }
                catch (UnknownHostException uhe) {
                    SnmpErrorAnalyzer.rethrow(uhe, agentNewParams, aAgentIndex, hostName, errorMsg);
                }
                continue;
            }
            if (key.equals("ReadCommunity")) {
                snmpMgrs[aAgentIndex].setReadCommunity((String)value.value());
                continue;
            }
            if (key.equals("WriteCommunity")) {
                snmpMgrs[aAgentIndex].setWriteCommunity((String)value.value());
                continue;
            }
            if (key.equals("SnmpVersion")) {
                snmpMgrs[aAgentIndex].setSnmpVersion((SnmpVersion)value.value());
                continue;
            }
            if (!key.equals("TrapPort")) continue;
            String ipAddress = snmpMgrs[aAgentIndex].getAgentIpAddress();
            CommMgr.innerChangeTrapPort(agentNewParams, aAgentIndex, (Integer)value.value(), ipAddress);
        }
        dbMgr.dbSetList(agentNewParams);
    }

    public synchronized CommVarBindList[] getAllClustersData() throws SrDatabaseException {
        return dbMgr.readClustersDataFromDb();
    }

    public synchronized CommVarBindList[] getAllSitesData() throws SrDatabaseException {
        return dbMgr.readSitesDataFromDb();
    }

    public synchronized CommVarBindList[] getEmailContactData() throws SrDatabaseException {
        return dbMgr.readAlarmEmailContact(new Integer(0));
    }

    public synchronized CommVarBindList[] getEmailContactData(Integer clusterId) throws SrDatabaseException {
        return dbMgr.readAlarmEmailContact(clusterId);
    }

    public synchronized void setAlarmTypeData(CommVarBindList varBindList) {
        try {
            dbMgr.setAlarmTypeData(varBindList);
        }
        catch (SrDatabaseException dbe) {
            theLogger.error(SrLogCategories.EXCEPTION, dbe, "Failed to set AlarmType data in DB.", varBindList);
        }
    }

    public synchronized void setContactData(CommVarBindList varBindList) {
        try {
            dbMgr.setContactData(varBindList);
        }
        catch (SrDatabaseException dbe) {
            theLogger.error(SrLogCategories.EXCEPTION, dbe, "Failed to set contact data in DB.", varBindList);
        }
    }

    public synchronized CommVarBindList[] getAllAlarmTypesData() throws SrDatabaseException {
        return dbMgr.readAlarmTypesFromDb(new Integer(0));
    }

    public synchronized CommVarBindList[] getAllAlarmTypesData(Integer clusterId) throws SrDatabaseException {
        return dbMgr.readAlarmTypesFromDb(clusterId);
    }

    public static synchronized Map<SrIpAddress, SrInteger> getAndInitAllVSwitches(VSwitchConfigurator.VSwitchDataContainer data) throws SrDatabaseException {
        return CommMgr.getAndInitAllVSwitches((String)null, data);
    }

    private static Map<SrIpAddress, SrInteger> initVSwitchList(CommVarBindList[] vSwitchList, VSwitchConfigurator.VSwitchDataContainer data) {
        data.setVSwitchesData(vSwitchList);
        HashMap<SrIpAddress, SrInteger> trapPortErrorData = new HashMap<SrIpAddress, SrInteger>();
        snmpMgrs = new DefaultSnmpMgr[vSwitchList.length];
        for (int i = 0; i < vSwitchList.length; ++i) {
            SnmpAgentParams snmpParams = CommMgr.createSnmpParamsFromCommVarBindList(vSwitchList[i]);
            Throwable e = null;
            try {
                CommMgr.snmpMgrs[i] = new DefaultSnmpMgr(snmpParams, (char)i);
                vSwitchList[i].setSnmpAgentIndex((char)i);
            }
            catch (UnknownHostException uhe) {
                e = uhe;
            }
            catch (SnmpException se) {
                e = se;
            }
            if (e != null) {
                theLogger.error(SrLogCategories.EXCEPTION, e, snmpParams);
                data.setVSwitchDataNull(i);
                continue;
            }
            try {
                int trapPort = CommMgr.innerCreateTrapMonitorIfNeeded(vSwitchList[i], (char)i, snmpParams);
                vSwitchList[i].setValue(ParameterCode.VSWITCH_TRAP_UDP_PORT, new SrInteger(trapPort));
                continue;
            }
            catch (SrCommException stpibe) {
                theLogger.error(SrLogCategories.EXCEPTION, stpibe, "failed to register trap monitor. ", snmpParams);
                trapPortErrorData.put(snmpParams.getIpAddress(), snmpParams.getTrapPort());
            }
        }
        return trapPortErrorData;
    }

    public static synchronized Map<SrIpAddress, SrInteger> getAndInitAllVSwitches(Integer clusterId, VSwitchConfigurator.VSwitchDataContainer data) throws SrDatabaseException {
        CommVarBindList[] vSwitchesList = dbMgr.readVSwitchDataFromDb(clusterId);
        return CommMgr.initVSwitchList(vSwitchesList, data);
    }

    public static synchronized CommVarBindList[] getAllVSwitchesFromDB(Integer clusterId) throws SrDatabaseException {
        return dbMgr.readVSwitchDataFromDb(clusterId);
    }

    public static synchronized List<String> getVsIPsFromDB(String aClusterAlias, String aSiteAlias) throws SrDatabaseException {
        return dbMgr.getVsIPs(aClusterAlias, aSiteAlias);
    }

    private static Map<SrIpAddress, SrInteger> getAndInitAllVSwitches(String dbFileName, VSwitchConfigurator.VSwitchDataContainer data) throws SrDatabaseException {
        CommVarBindList[] vSwitchesList = dbMgr.readVSwitchDataFromDb();
        return CommMgr.initVSwitchList(vSwitchesList, data);
    }

    private static SnmpAgentParams createSnmpParamsFromCommVarBindList(CommVarBindList vbs) {
        int dataIndex = vbs.indexOf(DBItem.VSWITCH_IP_ADDRESS);
        SrIpAddress ip = (SrIpAddress)((DBVarBind)vbs.get(dataIndex)).getValue();
        SnmpAgentParams newAgentParams = new SnmpAgentParams(ip);
        dataIndex = vbs.indexOf(DBItem.VSWITCH_IP_MASK);
        newAgentParams.setIpMask((SrIpAddress)((DBVarBind)vbs.get(dataIndex)).getValue());
        dataIndex = vbs.indexOf(DBItem.VSWITCH_READ_COMMUNITY);
        newAgentParams.setReadCommunity((SrString)((DBVarBind)vbs.get(dataIndex)).getValue());
        dataIndex = vbs.indexOf(DBItem.VSWITCH_RETRIES);
        newAgentParams.setNumberOfRetries((SrInteger)((DBVarBind)vbs.get(dataIndex)).getValue());
        dataIndex = vbs.indexOf(DBItem.VSWITCH_SNMP_PORT);
        newAgentParams.setSnmpPort((SrInteger)((DBVarBind)vbs.get(dataIndex)).getValue());
        dataIndex = vbs.indexOf(DBItem.VSWITCH_SNMP_VERSION);
        newAgentParams.setSnmpVersion((SnmpVersion)((DBVarBind)vbs.get(dataIndex)).getValue());
        dataIndex = vbs.indexOf(DBItem.VSWITCH_TIMEOUT);
        newAgentParams.setTimeout((SrLong)((DBVarBind)vbs.get(dataIndex)).getValue());
        dataIndex = vbs.indexOf(DBItem.VSWITCH_TRAP_PORT);
        newAgentParams.setTrapPort((SrInteger)((DBVarBind)vbs.get(dataIndex)).getValue());
        dataIndex = vbs.indexOf(DBItem.VSWITCH_WRITE_COMMUNITY);
        newAgentParams.setWriteCommunity((SrString)((DBVarBind)vbs.get(dataIndex)).getValue());
        return newAgentParams;
    }

    public synchronized void setToFile(String fileName, Iterable<? extends HistoryAlarmData> aAlarms) throws SrDatabaseException {
        dbMgr.setObjectToFile(fileName, aAlarms);
    }

    public static synchronized void addTrapListenerToAllMonitors(TrapListener listener) {
        TrapManager.getInstance().addTrapListenerToAllMonitors(listener);
    }

    public synchronized List<HistoryAlarmData> loadHistoryAlarmsFromFile(String fileName) throws SrDatabaseException {
        return dbMgr.loadHistoryAlarmsFromFile(fileName);
    }

    public static synchronized char getSnmpMgrIndex(DefaultSnmpMgr mngr) {
        if (snmpMgrs == null) {
            throw new IllegalStateException("snmpMgrs was not initialized yet.");
        }
        for (int i = 0; i < snmpMgrs.length; ++i) {
            if (snmpMgrs[i] != mngr) continue;
            return (char)i;
        }
        return '\u0100';
    }

    public synchronized CommVarBindList[] snmpGetTable(CommVarBindList varBindsList, char aAgentIndex) throws SrCommException {
        CommVarBindList[] retVal = null;
        if (snmpMgrs == null) {
            throw new IllegalStateException("snmpMgrs was not initialized yet.");
        }
        if (aAgentIndex >= snmpMgrs.length || snmpMgrs[aAgentIndex] == null) {
            throw new IllegalArgumentException(CommMgr.getMessageForAgentNotFound(aAgentIndex));
        }
        String errorMsg = "snmpGetTable";
        String hostName = snmpMgrs[aAgentIndex].getAgentHostname();
        try {
            retVal = snmpMgrs[aAgentIndex].snmpGetTable(varBindsList);
        }
        catch (SnmpErrorException see) {
            SnmpErrorAnalyzer.rethrow(see, varBindsList, aAgentIndex, hostName, errorMsg);
        }
        catch (SnmpTimeoutException stoe) {
            SnmpErrorAnalyzer.rethrow(stoe, varBindsList, aAgentIndex, hostName, errorMsg);
        }
        catch (SnmpTransportException ste) {
            SnmpErrorAnalyzer.rethrow(ste, varBindsList, aAgentIndex, hostName, errorMsg);
        }
        catch (SnmpException se) {
            SnmpErrorAnalyzer.rethrow(se, varBindsList, aAgentIndex, hostName, errorMsg);
        }
        return retVal;
    }

    public synchronized CommVarBindList[] snmpGetBulk(CommVarBindList varBindsList, char aAgentIndex) throws SrCommException {
        CommVarBindList[] retVal = null;
        if (snmpMgrs == null) {
            throw new IllegalStateException("snmpMgrs was not initialized yet.");
        }
        if (aAgentIndex >= snmpMgrs.length || snmpMgrs[aAgentIndex] == null) {
            throw new IllegalArgumentException(CommMgr.getMessageForAgentNotFound(aAgentIndex));
        }
        String errorMsg = "snmpGetBulk";
        String hostName = snmpMgrs[aAgentIndex].getAgentHostname();
        try {
            retVal = snmpMgrs[aAgentIndex].snmpGetBulk(varBindsList);
        }
        catch (SnmpErrorException see) {
            SnmpErrorAnalyzer.rethrow(see, varBindsList, aAgentIndex, hostName, errorMsg);
        }
        catch (SnmpTimeoutException stoe) {
            SnmpErrorAnalyzer.rethrow(stoe, varBindsList, aAgentIndex, hostName, errorMsg);
        }
        catch (SnmpTransportException ste) {
            SnmpErrorAnalyzer.rethrow(ste, varBindsList, aAgentIndex, hostName, errorMsg);
        }
        catch (SnmpException se) {
            SnmpErrorAnalyzer.rethrow(se, varBindsList, aAgentIndex, hostName, errorMsg);
        }
        return retVal;
    }

    public synchronized String getManagerIpAddress(char aAgentIndex) throws SrCommException {
        String retVal = null;
        if (snmpMgrs == null) {
            throw new IllegalStateException("snmpMgrs was not initialized yet.");
        }
        if (aAgentIndex >= snmpMgrs.length || snmpMgrs[aAgentIndex] == null) {
            throw new IllegalArgumentException(CommMgr.getMessageForAgentNotFound(aAgentIndex));
        }
        String errorMsg = "getManagerIpAddress";
        String hostName = snmpMgrs[aAgentIndex].getAgentHostname();
        try {
            retVal = snmpMgrs[aAgentIndex].getManagerIpAddress();
        }
        catch (SnmpErrorException see) {
            SnmpErrorAnalyzer.rethrow(see, CommVarBindList.EMPTY, aAgentIndex, hostName, errorMsg);
        }
        catch (SnmpTimeoutException stoe) {
            SnmpErrorAnalyzer.rethrow(stoe, CommVarBindList.EMPTY, aAgentIndex, hostName, errorMsg);
        }
        catch (SnmpTransportException ste) {
            SnmpErrorAnalyzer.rethrow(ste, CommVarBindList.EMPTY, aAgentIndex, hostName, errorMsg);
        }
        catch (SnmpException se) {
            SnmpErrorAnalyzer.rethrow(se, CommVarBindList.EMPTY, aAgentIndex, hostName, errorMsg);
        }
        return retVal;
    }

    public synchronized void setPropertiesToFile(String aFileName, Properties aProperties) throws IOException {
        dbMgr.setPropertiesToFile(aProperties, aFileName);
    }

    public synchronized Properties loadPropertiesFromFile(String aFileName) throws IOException {
        return dbMgr.loadPropertiesFromFile(aFileName);
    }

    public static synchronized void setRaidSnmpMgr(TrapListener aTrapListener, SrString aVendorName, SrString aRaidName, SrIpAddress aRaidAddr1, SrIpAddress aRaidAddr2, char aAgentIndex) throws RaidConfigurationException {
        if (snmpMgrs == null || snmpMgrs[aAgentIndex] == null) {
            throw new IllegalStateException(CommMgr.getMessageForAgentNotFound(aAgentIndex));
        }
        snmpMgrs[aAgentIndex].setRaidManager(aTrapListener, aVendorName, aRaidName, aRaidAddr1, aRaidAddr2);
    }

    public static synchronized void removeRaidSnmpMgr(char aAgentIndex, SrIpAddress aRaidIp1, SrIpAddress aRaidIp2) throws RaidConfigurationException {
        if (snmpMgrs == null || snmpMgrs[aAgentIndex] == null) {
            throw new IllegalStateException(CommMgr.getMessageForAgentNotFound(aAgentIndex));
        }
        snmpMgrs[aAgentIndex].removeRaidManager(aRaidIp1, aRaidIp2);
    }

    public static synchronized RaidSubsystem getRaidSubsystem(char aAgentIndex, SrIpAddress aRaidIp1, SrIpAddress aRaidIp2) {
        if (snmpMgrs == null || snmpMgrs[aAgentIndex] == null) {
            throw new IllegalStateException(CommMgr.getMessageForAgentNotFound(aAgentIndex));
        }
        return snmpMgrs[aAgentIndex].getRaidSubsystem(aRaidIp1, aRaidIp2);
    }

    private static String getMessageForAgentNotFound(char aAgentIndex) {
        return "A SnmpMgr indexed '" + aAgentIndex + "' does not exist. snmpMgrs.length: " + snmpMgrs.length;
    }
}

