/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.cli.executor;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.Server;
import com.sanrad.nms.server.SrServerBundleKeys;
import com.sanrad.nms.server.cli.CliCommand;
import com.sanrad.nms.server.cli.CliCommandParameterType;
import com.sanrad.nms.server.cli.executor.CliCommandExecutor;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.LogicMgrAOImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.volume.SnapshotVolume;
import com.sanrad.nms.server.logic.volume.SnapshotVolumeImpl;
import com.sanrad.nms.server.util.types.constants.SnapshotActivateTypeConstants;
import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.concurrent.FailedFuture;
import com.sanrad.util.concurrent.SrFuture;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public abstract class SnapshotActivateOrDeactivateCommandExecutor
implements CliCommandExecutor {
    private static SrLogger theLogger = SrLogger.getLogger();

    @Override
    public List<SrFuture<Void>> executeCliCommand(ClusterImpl aCluster, CliCommand aCommand) {
        if (aCommand == null || aCluster == null) {
            throw new IllegalArgumentException("The given arguments should not be null. aCluster = " + aCluster + "; aCommand = " + aCommand);
        }
        String snapshotName = (String)aCommand.getParamList().get(CliCommandParameterType.VOLUME).getValue();
        ArrayList<SrFuture<Void>> retVal = new ArrayList<SrFuture<Void>>();
        if (snapshotName == null) {
            String expReason = Server.BUNDLE.getString(SrServerBundleKeys.CLI_INVALID_VOLUME);
            FailedFuture retFuture = new FailedFuture(new IllegalArgumentException(expReason), expReason);
            retVal.add(retFuture);
            return retVal;
        }
        SnapshotVolumeImpl curSnap = LogicMgrAOImpl.getInstance().getSnapshotByAlias(aCluster, snapshotName);
        if (curSnap == null) {
            String expReason = Server.BUNDLE.getString((BundleKeysInterface)SrServerBundleKeys.CLI_SNAP_NOT_FOUND, snapshotName);
            FailedFuture retFuture = new FailedFuture(new IllegalArgumentException(expReason), expReason);
            retVal.add(retFuture);
            return retVal;
        }
        try {
            retVal.add(aCluster.getStorage().activateDeactivateSnapshots(new SnapshotVolume[]{curSnap}, this.getActivationType()));
            return retVal;
        }
        catch (RemoteException e) {
            String errStr = "A remote exception has occured inside a server context.";
            theLogger.error(SrLogCategories.EXCEPTION, e, errStr);
            retVal.add(new FailedFuture(e, errStr));
            return retVal;
        }
        catch (IllegalValueException e) {
            String errStr = "A remote exception has occured inside a server context.";
            theLogger.error(SrLogCategories.EXCEPTION, e, errStr);
            retVal.add(new FailedFuture(e, errStr));
            return retVal;
        }
    }

    protected abstract SnapshotActivateTypeConstants getActivationType();
}

