/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.cli.executor;

import com.sanrad.nms.server.cli.CliCommand;
import com.sanrad.nms.server.cli.CliCommandParameterType;
import com.sanrad.nms.server.cli.executor.CliCommandExecutor;
import com.sanrad.nms.server.logic.DataMgrAdapter;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ConfigOperation;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrGauge;
import com.sanrad.util.concurrent.SrFuture;
import java.util.ArrayList;
import java.util.List;

public class QosLimitCommandExecutor
implements CliCommandExecutor {
    @Override
    public List<SrFuture<Void>> executeCliCommand(ClusterImpl aCluster, CliCommand aCommand) {
        if (aCommand == null || aCluster == null) {
            throw new IllegalArgumentException("The given arguments should not be null. aCluster = " + aCluster + "; aCommand = " + aCommand);
        }
        ArrayList<SrFuture<Void>> retList = new ArrayList<SrFuture<Void>>();
        int limit = Integer.parseInt((String)aCommand.getParamList().get(CliCommandParameterType.QOS_LIMIT).getValue());
        for (VSwitchImpl curVS : aCluster.getVSwitches()) {
            ConfigElementData qosCed = new ConfigElementData(curVS.getCommKeyClassId(), ConfigOperation.CHANGE);
            qosCed.addParameter(ParameterCode.VSWITCH_TGT_QOS_MAX_RATE_LIMIT, new SrGauge(limit));
            retList.add(DataMgrAdapter.getInstance().changeElement(qosCed));
        }
        return retList;
    }

    @Override
    public CliCommand.CliCommandType getCliCommandType() {
        return CliCommand.CliCommandType.QOS_LIMIT_COMMNAD;
    }
}

