/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.cli.executor;

import com.sanrad.nms.server.cli.CliCommand;
import com.sanrad.nms.server.cli.executor.CliCommandExecutor;
import com.sanrad.nms.server.logic.DataMgrAdapter;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ConfigOperation;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.constants.IscsiTgtQosActivityConstant;
import com.sanrad.util.concurrent.CompleteFuture;
import com.sanrad.util.concurrent.SrFuture;
import java.util.ArrayList;
import java.util.List;

public abstract class QosActivateDeactivateCommandExecutor
implements CliCommandExecutor {
    @Override
    public List<SrFuture<Void>> executeCliCommand(ClusterImpl aCluster, CliCommand aCommand) {
        if (aCommand == null || aCluster == null) {
            throw new IllegalArgumentException("The given arguments should not be null. aCluster = " + aCluster + "; aCommand = " + aCommand);
        }
        ArrayList<SrFuture<Void>> retList = new ArrayList<SrFuture<Void>>();
        IscsiTgtQosActivityConstant qosValue = this.getQosValue();
        for (VSwitchImpl curVS : aCluster.getVSwitches()) {
            if (qosValue.equals(curVS.getQosState())) continue;
            ConfigElementData qosCed = new ConfigElementData(curVS.getCommKeyClassId(), ConfigOperation.CHANGE);
            qosCed.addParameter(ParameterCode.VSWITCH_TGT_QOS_ACTIVITY, new SrInteger((Integer)qosValue.value()));
            retList.add(DataMgrAdapter.getInstance().changeElement(qosCed));
        }
        if (retList.isEmpty()) {
            retList.add(new CompleteFuture("QosActivateOrDeactivateCommandExecutor.executeCliCommand"));
        }
        return retList;
    }

    protected abstract IscsiTgtQosActivityConstant getQosValue();
}

