/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.cli.executor;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.cli.CliCommand;
import com.sanrad.nms.server.cli.executor.CliCommandExecutor;
import com.sanrad.nms.server.cli.executor.QosActivateCommandExecutor;
import com.sanrad.nms.server.cli.executor.QosDeactivateCommandExecutor;
import com.sanrad.nms.server.cli.executor.QosLimitCommandExecutor;
import com.sanrad.nms.server.cli.executor.SnapshotActivateCommandExecutor;
import com.sanrad.nms.server.cli.executor.SnapshotDeactivateCommandExecutor;
import java.util.HashMap;

public class CliCommandExecutorMap {
    private static SrLogger theLogger = SrLogger.getLogger();
    private static CliCommandExecutorMap theInstance = new CliCommandExecutorMap();
    private HashMap<CliCommand.CliCommandType, CliCommandExecutor> myCommandTypeToCommandExecutorMap = new HashMap();

    public static CliCommandExecutorMap getInstance() {
        return theInstance;
    }

    private CliCommandExecutorMap() {
        this.addCliCommandExecutor(CliCommand.CliCommandType.SNAPSHOT_ACTIVATE_COMMNAD, new SnapshotActivateCommandExecutor());
        this.addCliCommandExecutor(CliCommand.CliCommandType.SNAPSHOT_DEACTIVATE_COMMNAD, new SnapshotDeactivateCommandExecutor());
        this.addCliCommandExecutor(CliCommand.CliCommandType.QOS_DISABLE_COMMNAD, new QosDeactivateCommandExecutor());
        this.addCliCommandExecutor(CliCommand.CliCommandType.QOS_ENABLE_COMMNAD, new QosActivateCommandExecutor());
        this.addCliCommandExecutor(CliCommand.CliCommandType.QOS_LIMIT_COMMNAD, new QosLimitCommandExecutor());
    }

    public CliCommandExecutor addCliCommandExecutor(CliCommand.CliCommandType aType, CliCommandExecutor aExecutor) {
        if (aType == null || aExecutor == null) {
            throw new IllegalArgumentException("The given arguments should not be null. aType = " + (Object)((Object)aType) + "; aExecutor = " + aExecutor);
        }
        theLogger.debug(SrLogCategories.CLI, new Object[]{"Adding the CLI command executor: ", aExecutor, " to command type: ", aType});
        return this.myCommandTypeToCommandExecutorMap.put(aType, aExecutor);
    }

    public CliCommandExecutor getCliCommandExecutor(CliCommand.CliCommandType aType) {
        return this.myCommandTypeToCommandExecutorMap.get((Object)aType);
    }

    public CliCommandExecutor removeCliCommandExecutor(CliCommand.CliCommandType aType) {
        CliCommandExecutor retVal = this.myCommandTypeToCommandExecutorMap.remove((Object)aType);
        theLogger.debug(SrLogCategories.CLI, new Object[]{"Removing the CLI command executor: ", retVal, " from command type: ", aType});
        return retVal;
    }
}

