/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.cli;

import com.sanrad.nms.server.cli.CliCommandParameter;
import com.sanrad.nms.server.cli.CliCommandParameterType;
import java.util.HashMap;
import java.util.Map;

public class CliCommand {
    private HashMap<CliCommandParameterType, CliCommandParameter> myParamTypeToParamMap = new HashMap();
    private CliCommandType myType;
    private String myParsingError = null;
    private String myIP = null;

    public CliCommand(CliCommandType aType, String aIp) {
        this.myType = aType;
        this.myIP = aIp;
    }

    public boolean equals(Object aObj) {
        if (!(aObj instanceof CliCommand)) {
            return false;
        }
        CliCommand curCommand = (CliCommand)aObj;
        if (!this.myType.equals((Object)curCommand.getType())) {
            return false;
        }
        return this.myParamTypeToParamMap.equals(curCommand.getParamList());
    }

    public int hashCode() {
        return this.myType.hashCode();
    }

    public Map<CliCommandParameterType, CliCommandParameter> getParamList() {
        return new HashMap<CliCommandParameterType, CliCommandParameter>(this.myParamTypeToParamMap);
    }

    public CliCommandType getType() {
        return this.myType;
    }

    public void addParameter(CliCommandParameter aParam) {
        if (aParam == null) {
            throw new IllegalArgumentException("The given parameter should not be null.");
        }
        this.myParamTypeToParamMap.put(aParam.getType(), aParam);
    }

    public boolean isParsingSuccessful() {
        return this.myParsingError == null;
    }

    public void setParseError(String aError) {
        this.myParsingError = aError;
    }

    public String getIP() {
        return this.myIP;
    }

    void setType(CliCommandType aType) {
        this.myType = aType;
    }

    void setIp(String aIp) {
        this.myIP = aIp;
    }

    public static enum CliCommandType {
        UNKNOWN_TYPE_COMMAND,
        SNAPSHOT_ACTIVATE_COMMNAD,
        SNAPSHOT_DEACTIVATE_COMMNAD,
        QOS_LIMIT_COMMNAD,
        QOS_ENABLE_COMMNAD,
        QOS_DISABLE_COMMNAD;

    }
}

