/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.alarm.vswitch;

import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.AlarmImpl;
import com.sanrad.nms.server.alarm.AlarmType;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.vswitch.NeighborImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import java.rmi.RemoteException;
import java.util.List;

public class NeighborAlarmGenerator
extends AlarmGenerator {
    private static NeighborAlarmGenerator theInstance = new NeighborAlarmGenerator();

    private NeighborAlarmGenerator() {
    }

    public static NeighborAlarmGenerator getInstance() {
        return theInstance;
    }

    @Override
    public List<AlarmImpl> checkForAlarmsToOpen(GeneralLogicObject source, VSwitchImpl vSwitch) throws RemoteException {
        StringBuffer msg;
        NeighborImpl neighbor = (NeighborImpl)source;
        List<AlarmImpl> openAlarms = super.checkForAlarmsToOpen(source, vSwitch);
        if (neighbor.isDead()) {
            msg = new StringBuffer(vSwitch.getClassId().toString());
            msg.append(" ");
            msg.append(vSwitch.getName());
            msg.append(" lost connection with neighbor ");
            msg.append(source.toString());
            this.addAlarm(openAlarms, AlarmType.NEIGH_DEAD, source, msg.toString());
        }
        if (neighbor.isSuspicious()) {
            msg = new StringBuffer(vSwitch.getClassId().toString());
            msg.append(" ");
            msg.append(vSwitch.getName());
            msg.append(" suspects a lost connection with neighbor ");
            msg.append(source.toString());
            this.addAlarm(openAlarms, AlarmType.NEIGH_SUSP, source, msg.toString());
        }
        if (neighbor.isUnknown()) {
            msg = new StringBuffer(vSwitch.getClassId().toString());
            msg.append(" ");
            msg.append(vSwitch.getName());
            msg.append(".  State of the neighbor ");
            msg.append(source.toString());
            msg.append(" is unknown");
            this.addAlarm(openAlarms, AlarmType.NEIGH_UNK, source, msg.toString());
        }
        return openAlarms;
    }

    @Override
    public List<AlarmImpl> checkForAlarmsToClose(GeneralLogicObject source, VSwitchImpl vSwitch, List<AlarmImpl> openAlarms) throws RemoteException {
        NeighborImpl neighbor = (NeighborImpl)source;
        List<AlarmImpl> closeAlarms = super.checkForAlarmsToClose(source, vSwitch, openAlarms);
        for (AlarmImpl alarm : openAlarms) {
            if (alarm.getType().equals(AlarmType.NEIGH_DEAD)) {
                if (neighbor.isDead()) continue;
                closeAlarms.add(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.NEIGH_SUSP)) {
                if (neighbor.isSuspicious()) continue;
                closeAlarms.add(alarm);
                continue;
            }
            if (!alarm.getType().equals(AlarmType.NEIGH_UNK) || neighbor.isUnknown()) continue;
            closeAlarms.add(alarm);
        }
        return closeAlarms;
    }

    @Override
    protected boolean isRedundant(GeneralLogicObject source) throws RemoteException {
        return true;
    }
}

