/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.alarm.volume;

import com.sanrad.nms.server.alarm.AlarmImpl;
import com.sanrad.nms.server.alarm.AlarmType;
import com.sanrad.nms.server.alarm.AliasObjectAlarmGenerator;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.volume.SnapshotVolumeImpl;
import com.sanrad.nms.server.logic.volume.VolumeImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.util.ClassID;
import java.rmi.RemoteException;
import java.util.List;

public abstract class VolumeAlarmGenerator
extends AliasObjectAlarmGenerator {
    protected VolumeAlarmGenerator() {
    }

    @Override
    public List<AlarmImpl> checkForAlarmsToOpen(GeneralLogicObject source, VSwitchImpl vSwitch) throws RemoteException {
        StringBuffer msg;
        VolumeImpl volume = (VolumeImpl)source;
        List<AlarmImpl> openAlarms = super.checkForAlarmsToOpen(source, vSwitch);
        if (volume.isNeedSync(vSwitch)) {
            msg = new StringBuffer(vSwitch.getClassId().toString());
            msg.append(" ");
            msg.append(vSwitch.getName());
            msg.append(". Mirror child ");
            msg.append(source.getClassId());
            msg.append(" ");
            msg.append(source.toString());
            msg = this.getDefaultMessage(source, vSwitch);
            msg.append(" needs to be synchronized with one of its siblings.");
            this.addAlarm(openAlarms, AlarmType.VOLUME_NEED_SYNC, source, vSwitch, msg.toString());
        }
        if (volume.isMismatch(vSwitch)) {
            msg = new StringBuffer(vSwitch.getClassId().toString());
            msg.append(" ");
            msg.append(vSwitch.getName());
            msg.append(source.getClassId());
            msg.append(" ");
            msg.append(source.toString());
            msg = this.getDefaultMessage(source, vSwitch);
            msg.append(" is mismatch .");
            this.addAlarm(openAlarms, AlarmType.SUBDISK_MISMATCH, source, vSwitch, msg.toString());
        }
        if (volume.isNonValidate(vSwitch)) {
            msg = new StringBuffer(vSwitch.getClassId().toString());
            msg.append(" ");
            msg.append(vSwitch.getName());
            msg.append(source.getClassId());
            msg.append(" ");
            msg.append(source.toString());
            msg = this.getDefaultMessage(source, vSwitch);
            msg.append(" is non validated .");
            this.addAlarm(openAlarms, AlarmType.NON_VALIDATE, source, vSwitch, msg.toString());
        }
        if (volume.isNonFunctional(vSwitch) && !volume.isDROfflineLocalCopy()) {
            this.msg = this.getDefaultMessage(source, vSwitch);
            this.msg.append(" is not functioning");
            this.addAlarm(openAlarms, AlarmType.VOLUME_NON_FUNC, source, vSwitch, this.msg.toString());
        }
        if (volume.isIllegal()) {
            this.msg = this.getDefaultMessage(source, vSwitch);
            this.msg.append(" is configured inconsistently in the cluster");
            this.addAlarm(openAlarms, AlarmType.VOLUME_ILLEGAL, source, this.msg.toString());
        }
        if (volume.isSnapshotSource() && volume.isExposed()) {
            if (volume.isExposed()) {
                VSwitchImpl exposedOnVSwitch = volume.getExposedOnVSwitch();
                String exposedOn = null;
                if (exposedOnVSwitch != null) {
                    exposedOn = exposedOnVSwitch.getName();
                }
                List<SnapshotVolumeImpl> snapshots = volume.getSnapshotsIfSource();
                for (SnapshotVolumeImpl snapshot : snapshots) {
                    String snapshotExposedOn;
                    if (!snapshot.isExposed() || (snapshotExposedOn = snapshot.getExposedOnVSwitch().getName()).equals(exposedOn)) continue;
                    this.msg = this.getDefaultMessage(volume, vSwitch);
                    this.msg.append(" is exposed on a different ");
                    this.msg.append(ClassID.VSWITCH);
                    this.msg.append(" than its ");
                    this.msg.append(snapshot.getClassId());
                    this.msg.append(" ");
                    this.msg.append(snapshot);
                    this.msg.append(" (");
                    this.msg.append(exposedOn);
                    this.msg.append(", ");
                    this.msg.append(snapshotExposedOn);
                    this.msg.append(")");
                    this.addAlarm(openAlarms, AlarmType.SNAPSHOT_EXPOSED_INCONSISTENT, source, this.msg.toString(), snapshot);
                }
            }
            if (volume.getCluster().getCopyOperManager().isInvolvedInActiveRestoreOperation(volume)) {
                this.msg = this.getDefaultMessage(vSwitch);
                this.msg.append("Roll back operation for ");
                this.msg.append(volume.getClassId());
                this.msg.append(" ");
                this.msg.append(volume.getAlias(vSwitch));
                this.msg.append(" in progress.");
                this.addAlarm(openAlarms, AlarmType.VOLUME_OPER, (GeneralLogicObject)volume, vSwitch, this.msg.toString());
            }
        }
        return openAlarms;
    }

    @Override
    public List<AlarmImpl> checkForAlarmsToClose(GeneralLogicObject source, VSwitchImpl vSwitch, List<AlarmImpl> openAlarms) throws RemoteException {
        VolumeImpl volume = (VolumeImpl)source;
        List<AlarmImpl> closeAlarms = super.checkForAlarmsToClose(source, vSwitch, openAlarms);
        for (AlarmImpl alarm : openAlarms) {
            if (alarm.getType().equals(AlarmType.VOLUME_NEED_SYNC)) {
                if (volume.isNeedSync(vSwitch)) continue;
                closeAlarms.add(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.SUBDISK_MISMATCH)) {
                if (volume.isMismatch(vSwitch)) continue;
                closeAlarms.add(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.NON_VALIDATE)) {
                if (volume.isNonValidate(vSwitch)) continue;
                closeAlarms.add(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.VOLUME_NON_FUNC)) {
                if (volume.isNonFunctional(vSwitch)) continue;
                closeAlarms.add(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.VOLUME_ILLEGAL)) {
                if (volume.isIllegal()) continue;
                closeAlarms.add(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.VOLUME_INCONSISTENT)) {
                if (volume.isInconsistent()) continue;
                closeAlarms.add(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.SNAPSHOT_EXPOSED_INCONSISTENT)) {
                List<SnapshotVolumeImpl> snapshots = volume.getSnapshotsIfSource();
                for (SnapshotVolumeImpl snapshot : snapshots) {
                    if (!snapshot.equals(alarm.getAdditionalKeyObject())) continue;
                    closeAlarms.add(alarm);
                }
                continue;
            }
            if (!alarm.getType().equals(AlarmType.VOLUME_OPER) || volume.getCluster().getCopyOperManager().isInvolvedInActiveRestoreOperation(volume)) continue;
            closeAlarms.add(alarm);
        }
        return closeAlarms;
    }
}

