/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.alarm.volume;

import com.sanrad.nms.server.alarm.AlarmImpl;
import com.sanrad.nms.server.alarm.AlarmType;
import com.sanrad.nms.server.alarm.volume.VirtualVolumeAlarmGenerator;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.volume.JournalVolumeImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import java.rmi.RemoteException;
import java.util.List;

public class JournalAlarmGenerator
extends VirtualVolumeAlarmGenerator {
    private static JournalAlarmGenerator s_theInstance = new JournalAlarmGenerator();

    private JournalAlarmGenerator() {
    }

    public static JournalAlarmGenerator getInstance() {
        return s_theInstance;
    }

    @Override
    public List<AlarmImpl> checkForAlarmsToOpen(GeneralLogicObject source, VSwitchImpl vSwitch) throws RemoteException {
        JournalVolumeImpl volume = (JournalVolumeImpl)source;
        List<AlarmImpl> openAlarms = super.checkForAlarmsToOpen(source, vSwitch);
        VSwitchImpl vswitchActiveOn = volume.getActiveOnVSwitch();
        if (vSwitch.equals(vswitchActiveOn)) {
            if (volume.isOverUsed(vSwitch)) {
                Integer thresh = volume.getPercentageThreshold(vSwitch);
                this.msg = this.getDefaultMessage(source, vSwitch);
                this.msg.append(" has exceeded its threshold [");
                this.msg.append(thresh.toString());
                this.msg.append("%]");
                this.addAlarm(openAlarms, AlarmType.JOURNAL_OVER_USED, (GeneralLogicObject)volume, vSwitch, this.msg.toString());
            }
            if (volume.isOutOfSync(vSwitch)) {
                this.msg = this.getDefaultMessage(volume, vSwitch);
                this.msg.append(" data is not updated");
                this.addAlarm(openAlarms, AlarmType.JOURNAL_OUT_OF_SYNC, (GeneralLogicObject)volume, vSwitch, this.msg.toString());
            }
            if (volume.isFull(vSwitch)) {
                this.msg = this.getDefaultMessage(volume, vSwitch);
                this.msg.append(" is full");
                this.addAlarm(openAlarms, AlarmType.JOURNAL_FULL, (GeneralLogicObject)volume, vSwitch, this.msg.toString());
            }
        }
        return openAlarms;
    }

    @Override
    public List<AlarmImpl> checkForAlarmsToClose(GeneralLogicObject source, VSwitchImpl vSwitch, List<AlarmImpl> openAlarms) throws RemoteException {
        JournalVolumeImpl volume = (JournalVolumeImpl)source;
        List<AlarmImpl> closeAlarms = super.checkForAlarmsToClose(source, vSwitch, openAlarms);
        for (AlarmImpl alarm : openAlarms) {
            if (alarm.getType().equals(AlarmType.JOURNAL_OVER_USED)) {
                if (volume.isOverUsed(vSwitch)) continue;
                closeAlarms.add(alarm);
                continue;
            }
            if (!alarm.getType().equals(AlarmType.JOURNAL_FULL) && !alarm.getType().equals(AlarmType.JOURNAL_OUT_OF_SYNC) || volume.isOutOfSync(vSwitch)) continue;
            closeAlarms.add(alarm);
        }
        return closeAlarms;
    }
}

