/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.alarm.target;

import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.AlarmImpl;
import com.sanrad.nms.server.alarm.AlarmType;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTargetPortalImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import java.rmi.RemoteException;
import java.util.List;

public class ISCSIRemoteTargetPortalAlarmGenerator
extends AlarmGenerator {
    private static ISCSIRemoteTargetPortalAlarmGenerator s_theInstance = new ISCSIRemoteTargetPortalAlarmGenerator();

    protected ISCSIRemoteTargetPortalAlarmGenerator() {
    }

    public static ISCSIRemoteTargetPortalAlarmGenerator getInstance() {
        return s_theInstance;
    }

    @Override
    public List<AlarmImpl> checkForAlarmsToOpen(GeneralLogicObject source, VSwitchImpl vSwitch) throws RemoteException {
        ISCSIRemoteTargetPortalImpl remoteTargetPortal = (ISCSIRemoteTargetPortalImpl)source;
        List<AlarmImpl> openAlarms = super.checkForAlarmsToOpen(source, vSwitch);
        if (!remoteTargetPortal.isSynchronizedBetweenVSwitches(vSwitch)) {
            String remoteTargetName = remoteTargetPortal.getRemoteTarget().getName();
            VSwitchImpl[] vswitches = remoteTargetPortal.getConnectedVSwitches();
            VSwitchImpl otherVswitch = vswitches[0].equals(vSwitch) ? vswitches[1] : vswitches[0];
            this.msg = this.getDefaultMessage(remoteTargetPortal, vSwitch, vSwitch.getCluster());
            this.msg.append(" of the iSCSI remote target ");
            this.msg.append(remoteTargetName);
            this.msg.append(" is not configured at ");
            this.msg.append(vSwitch.getClassId().toString());
            this.msg.append(" ");
            this.msg.append(otherVswitch.getName());
            this.addAlarm(openAlarms, AlarmType.PORTAL_INCONSISTENCY, (GeneralLogicObject)remoteTargetPortal.getRemoteTarget(), vSwitch, this.msg.toString());
        }
        return openAlarms;
    }

    @Override
    public List<AlarmImpl> checkForAlarmsToClose(GeneralLogicObject source, VSwitchImpl vSwitch, List<AlarmImpl> openAlarms) throws RemoteException {
        List<AlarmImpl> closeAlarms = super.checkForAlarmsToClose(source, vSwitch, openAlarms);
        ISCSIRemoteTargetPortalImpl remoteTargetPortal = (ISCSIRemoteTargetPortalImpl)source;
        for (AlarmImpl alarm : openAlarms) {
            AlarmType alarmType = alarm.getType();
            if (!alarmType.equals(AlarmType.PORTAL_INCONSISTENCY) || !remoteTargetPortal.isSynchronizedBetweenVSwitches(vSwitch)) continue;
            closeAlarms.add(alarm);
        }
        return closeAlarms;
    }
}

