/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.alarm.target;

import com.sanrad.nms.server.alarm.AlarmImpl;
import com.sanrad.nms.server.alarm.AlarmType;
import com.sanrad.nms.server.alarm.AliasObjectAlarmGenerator;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTargetImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class ISCSIRemoteTargetAlarmGenerator
extends AliasObjectAlarmGenerator {
    private static ISCSIRemoteTargetAlarmGenerator s_theInstance = new ISCSIRemoteTargetAlarmGenerator();

    protected ISCSIRemoteTargetAlarmGenerator() {
    }

    public static ISCSIRemoteTargetAlarmGenerator getInstance() {
        return s_theInstance;
    }

    @Override
    public List<AlarmImpl> checkForAlarmsToOpen(GeneralLogicObject source, VSwitchImpl vSwitch) throws RemoteException {
        ISCSIRemoteTargetImpl remoteTarget = (ISCSIRemoteTargetImpl)source;
        List<AlarmImpl> openAlarms = super.checkForAlarmsToOpen(source, vSwitch);
        if (remoteTarget.getConfiguredAsLocalTargetOnSameCluster() != null) {
            return openAlarms;
        }
        if (!remoteTarget.isConnected(vSwitch)) {
            this.msg = this.getDefaultMessage(source, vSwitch);
            this.msg.append(" is not connected");
            this.addAlarm(openAlarms, AlarmType.TARGET_NOT_CONNECTED, source, vSwitch, this.msg.toString());
        }
        return openAlarms;
    }

    @Override
    public List<AlarmImpl> checkForAlarmsToClose(GeneralLogicObject source, VSwitchImpl vSwitch, List<AlarmImpl> openAlarms) throws RemoteException {
        List<AlarmImpl> closeAlarms = super.checkForAlarmsToClose(source, vSwitch, openAlarms);
        ISCSIRemoteTargetImpl remoteTarget = (ISCSIRemoteTargetImpl)source;
        this.changeRemoteTargetAliasInAlarms(remoteTarget, vSwitch, closeAlarms, openAlarms);
        for (AlarmImpl alarm : openAlarms) {
            AlarmType alarmType = alarm.getType();
            if (!alarmType.equals(AlarmType.TARGET_NOT_CONNECTED) || !alarm.isReplacedByANewAlarm() && !remoteTarget.isConnected(vSwitch)) continue;
            closeAlarms.add(alarm);
        }
        return closeAlarms;
    }

    private void changeRemoteTargetAliasInAlarms(ISCSIRemoteTargetImpl remoteTarget, VSwitchImpl vSwitch, List<AlarmImpl> closeAlarms, List<AlarmImpl> openAlarms) throws RemoteException {
        String remoteTargetAlias = remoteTarget.getAlias();
        boolean isAliasWithX = remoteTargetAlias.startsWith("X");
        if (!isAliasWithX) {
            String aliasToCheck = "X" + remoteTarget.getName();
            ArrayList<AlarmImpl> openAlarmList = new ArrayList<AlarmImpl>(openAlarms);
            for (AlarmImpl alarm : openAlarmList) {
                AlarmType alarmType = alarm.getType();
                String msg = alarm.getMessage();
                int indexOfAlias = msg.indexOf(aliasToCheck);
                if (!alarmType.equals(AlarmType.TARGET_NOT_CONNECTED) || indexOfAlias <= 0) continue;
                StringBuffer sb = new StringBuffer();
                sb.append(msg.substring(0, indexOfAlias));
                sb.append(remoteTargetAlias);
                sb.append(" ");
                sb.append(msg.substring(indexOfAlias + 1 + remoteTarget.getName().length() + 1));
                this.addAlarm(openAlarms, AlarmType.TARGET_NOT_CONNECTED, (GeneralLogicObject)remoteTarget, vSwitch, sb.toString());
                alarm.setReplacedByANewAlarm(true);
                closeAlarms.add(alarm);
            }
        }
    }
}

