/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.alarm.physstorage;

import com.sanrad.nms.server.alarm.AlarmImpl;
import com.sanrad.nms.server.alarm.AlarmType;
import com.sanrad.nms.server.alarm.physstorage.GeneralSCSIDeviceAlarmGenerator;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDevice;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.util.ClassID;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;

public class DirectAccessDeviceAlarmGenerator
extends GeneralSCSIDeviceAlarmGenerator {
    private static DirectAccessDeviceAlarmGenerator theInstance = new DirectAccessDeviceAlarmGenerator();

    private DirectAccessDeviceAlarmGenerator() {
    }

    public static DirectAccessDeviceAlarmGenerator getThisInstance() {
        return theInstance;
    }

    @Override
    public List<AlarmImpl> checkForAlarmsToOpen(GeneralLogicObject source, VSwitchImpl vSwitch) throws RemoteException {
        DirectAccessDeviceImpl directAccessDevice = (DirectAccessDeviceImpl)source;
        List<AlarmImpl> openAlarms = super.checkForAlarmsToOpen(source, vSwitch);
        HashMap inconsistentSubDirectAccessDevice = directAccessDevice.getInconsistentSubDirectAccessDevice();
        if (inconsistentSubDirectAccessDevice != null) {
            for (SubDirectAccessDeviceImpl sd1 : inconsistentSubDirectAccessDevice.keySet()) {
                SubDirectAccessDeviceImpl sd2 = (SubDirectAccessDeviceImpl)inconsistentSubDirectAccessDevice.get(sd1);
                this.msg = new StringBuffer("The ");
                this.msg.append(source.getClassId());
                this.msg.append(" ");
                this.msg.append(source);
                this.msg.append(" has inconsistent ");
                this.msg.append(sd1.getClassId());
                this.msg.append("s (");
                this.msg.append(sd1.getAlias());
                this.msg.append(", ");
                this.msg.append(sd2.getAlias());
                this.msg.append(")");
                this.addAlarm(openAlarms, AlarmType.SUB_DISK_INCONS, source, this.msg.toString(), this.getKeyObject(sd1, sd2));
            }
        }
        if (directAccessDevice.hasIllegalSubDirectAccessDevice()) {
            this.msg = new StringBuffer("The ");
            this.msg.append(source.getClassId());
            this.msg.append(" ");
            this.msg.append(source);
            this.msg.append(" has an illegal ");
            this.msg.append(ClassID.SUB_DIRECT_ACCESS_DEVICE);
            this.addAlarm(openAlarms, AlarmType.ILLEGAL_SUB_DISK, source, this.msg.toString());
        }
        return openAlarms;
    }

    @Override
    public List<AlarmImpl> checkForAlarmsToClose(GeneralLogicObject source, VSwitchImpl vSwitch, List<AlarmImpl> openAlarms) throws RemoteException {
        DirectAccessDeviceImpl directAccessDevice = (DirectAccessDeviceImpl)source;
        List<AlarmImpl> closeAlarms = super.checkForAlarmsToClose(source, vSwitch, openAlarms);
        for (AlarmImpl alarm : openAlarms) {
            if (alarm.getType().equals(AlarmType.SUB_DISK_INCONS)) {
                HashMap inconsistentSubDirectAccessDevice = directAccessDevice.getInconsistentSubDirectAccessDevice();
                if (inconsistentSubDirectAccessDevice == null) {
                    closeAlarms.add(alarm);
                } else {
                    for (SubDirectAccessDeviceImpl sd1 : inconsistentSubDirectAccessDevice.keySet()) {
                        SubDirectAccessDeviceImpl sd2 = (SubDirectAccessDeviceImpl)inconsistentSubDirectAccessDevice.get(sd1);
                        if (alarm.getAdditionalKeyObject().equals(this.getKeyObject(sd1, sd2))) continue;
                        closeAlarms.add(alarm);
                    }
                }
            }
            if (!alarm.getType().equals(AlarmType.ILLEGAL_SUB_DISK) || directAccessDevice.hasIllegalSubDirectAccessDevice()) continue;
            closeAlarms.add(alarm);
        }
        return closeAlarms;
    }

    private Object getKeyObject(SubDirectAccessDevice sd1, SubDirectAccessDevice sd2) throws RemoteException {
        return sd1.getAlias() + sd2.getAlias();
    }
}

