/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.alarm.identity;

import com.sanrad.nms.server.alarm.Alarm;
import com.sanrad.nms.server.alarm.AlarmImpl;
import com.sanrad.nms.server.alarm.AlarmType;
import com.sanrad.nms.server.alarm.AliasObjectAlarmGenerator;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.identity.IdentityImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class IdentityAlarmGenerator
extends AliasObjectAlarmGenerator {
    private static IdentityAlarmGenerator instance = new IdentityAlarmGenerator();

    private IdentityAlarmGenerator() {
    }

    public static IdentityAlarmGenerator getInstance() {
        return instance;
    }

    @Override
    public List<AlarmImpl> checkForAlarmsToOpen(GeneralLogicObject source, VSwitchImpl vSwitch) throws RemoteException {
        IdentityImpl identity = (IdentityImpl)source;
        if (identity.getAlias().startsWith("RemoteInitiator") || identity.isOfLocalInitiator() || identity.isOfRemoteInitiatorDR() || identity.isOfRemoteTarget() || identity.getAlias().startsWith("REMOTE_TARGET")) {
            return new ArrayList<AlarmImpl>();
        }
        List<AlarmImpl> alarms = super.checkForAlarmsToOpen(source, vSwitch);
        if (identity.isOfLocalTarget()) {
            Iterator<AlarmImpl> iter = alarms.iterator();
            while (iter.hasNext()) {
                Alarm alarm = iter.next();
                AlarmType alarmType = alarm.getType();
                if (!alarmType.equals(AlarmType.OBJ_NOT_REDUNDANT)) continue;
                iter.remove();
            }
        }
        return alarms;
    }
}

