/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.alarm.dr;

import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.AlarmImpl;
import com.sanrad.nms.server.alarm.AlarmType;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterPairImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import java.rmi.RemoteException;
import java.util.List;

public abstract class DrClusterPairAlarmGenerator
extends AlarmGenerator {
    protected DrClusterPairAlarmGenerator() {
    }

    @Override
    public List<AlarmImpl> checkForAlarmsToOpen(GeneralLogicObject source, VSwitchImpl vSwitch) throws RemoteException {
        List<AlarmImpl> openAlarms = super.checkForAlarmsToOpen(source, vSwitch);
        if (((DRClusterPairImpl)source).isIllegalVolPair()) {
            this.addAlarmAndMsg(source, vSwitch, openAlarms, " Illegal Volume ", AlarmType.ILLEAGAL_VOL_PAIR);
        }
        return openAlarms;
    }

    @Override
    public List<AlarmImpl> checkForAlarmsToClose(GeneralLogicObject source, VSwitchImpl vSwitch, List<AlarmImpl> openAlarms) throws RemoteException {
        List<AlarmImpl> closeAlarms = super.checkForAlarmsToClose(source, vSwitch, openAlarms);
        for (AlarmImpl alarm : openAlarms) {
            if (!alarm.getType().equals(AlarmType.ILLEAGAL_VOL_PAIR) || ((DRClusterPairImpl)source).isIllegalVolPair()) continue;
            closeAlarms.add(alarm);
        }
        return closeAlarms;
    }
}

