/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.alarm.dr;

import com.sanrad.nms.server.alarm.AlarmImpl;
import com.sanrad.nms.server.alarm.AlarmType;
import com.sanrad.nms.server.alarm.dr.DrAlarmGenerator;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.GeneralLogicObjectImpl;
import com.sanrad.nms.server.logic.dr.DRAsyncPairImpl;
import com.sanrad.nms.server.logic.dr.DRPairImpl;
import com.sanrad.nms.server.logic.validation.Validator;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public abstract class DRPairAlarmGenerator
extends DrAlarmGenerator {
    protected DRPairAlarmGenerator() {
    }

    @Override
    public List<AlarmImpl> checkForAlarmsToOpen(GeneralLogicObject source, VSwitchImpl vSwitch) throws RemoteException {
        ArrayList<AlarmImpl> openAlarms = new ArrayList();
        if (this.m_father != DrAlarmGenerator.class) {
            openAlarms = super.checkForAlarmsToOpen(source, vSwitch);
        }
        if (((DRPairImpl)source).isInvertedPair()) {
            this.addAlarmAndMsg(source, vSwitch, openAlarms, " Inverted Pair ", AlarmType.INVERTED_PAIR);
        }
        if (Boolean.TRUE.equals(Validator.getInstance().validAccordingToParameter((GeneralLogicObjectImpl)source, AlarmType.NEED_SYNC, vSwitch))) {
            this.addAlarmAndMsg(source, vSwitch, openAlarms, " is not synchronized ", AlarmType.NEED_SYNC);
        }
        if (((DRPairImpl)source).isUnequivelentPair()) {
            this.addAlarmAndMsg(source, vSwitch, openAlarms, " Inconsistent  Pair ", AlarmType.UNEQUIVALENT_PAIR);
        }
        if (!(((DRPairImpl)source).getPrimaryVolume().getLocalVolume() == null || ((DRPairImpl)source).getSecondaryVolume().getRemoteVolume() == null || ((DRPairImpl)source).getPrimaryVolume().getLocalVolume().getAccessibleSpace().equals(((DRPairImpl)source).getSecondaryVolume().getRemoteVolume().getAccessibleSpace()) && ((DRPairImpl)source).getPrimaryVolume().getLocalVolume().getBlockSize() == ((DRPairImpl)source).getSecondaryVolume().getRemoteVolume().getBlockSize())) {
            if (source instanceof DRAsyncPairImpl && ((DRAsyncPairImpl)source).getVolumeLocalCopySize() != null) {
                if (!((DRPairImpl)source).getPrimaryVolume().getLocalVolume().getAccessibleSpace().equals(((DRAsyncPairImpl)source).getVolumeLocalCopySize())) {
                    this.addAlarmAndMsg(source, vSwitch, openAlarms, " Primary has a different size or block size than Secondary", AlarmType.DIFF_SIZE);
                }
            } else {
                this.addAlarmAndMsg(source, vSwitch, openAlarms, " Primary has a different size or block size than Secondary", AlarmType.DIFF_SIZE);
            }
        }
        return openAlarms;
    }

    @Override
    public List<AlarmImpl> checkForAlarmsToClose(GeneralLogicObject source, VSwitchImpl vSwitch, List<AlarmImpl> openAlarms) throws RemoteException {
        ArrayList<AlarmImpl> closeAlarms = new ArrayList();
        if (this.m_father != DrAlarmGenerator.class) {
            closeAlarms = super.checkForAlarmsToClose(source, vSwitch, openAlarms);
        }
        for (AlarmImpl alarm : openAlarms) {
            if (alarm.getType().equals(AlarmType.INVERTED_PAIR) && !((DRPairImpl)source).isInvertedPair()) {
                closeAlarms.add(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.UNEQUIVALENT_PAIR) && !((DRPairImpl)source).isUnequivelentPair()) {
                closeAlarms.add(alarm);
                continue;
            }
            if (!alarm.getType().equals(AlarmType.DIFF_SIZE) || ((DRPairImpl)source).getPrimaryVolume().getLocalVolume() == null || ((DRPairImpl)source).getSecondaryVolume().getRemoteVolume() == null) continue;
            if (source instanceof DRAsyncPairImpl && ((DRAsyncPairImpl)source).getVolumeLocalCopySize() != null) {
                if (!((DRPairImpl)source).getPrimaryVolume().getLocalVolume().getAccessibleSpace().equals(((DRAsyncPairImpl)source).getVolumeLocalCopySize())) continue;
                closeAlarms.add(alarm);
                continue;
            }
            if (!((DRPairImpl)source).getPrimaryVolume().getLocalVolume().getAccessibleSpace().equals(((DRPairImpl)source).getSecondaryVolume().getRemoteVolume().getAccessibleSpace())) continue;
            closeAlarms.add(alarm);
        }
        return closeAlarms;
    }
}

