/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.alarm.cluster;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.Server;
import com.sanrad.nms.server.SrServerBundleKeys;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.AlarmImpl;
import com.sanrad.nms.server.alarm.AlarmType;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.target.ISCSITargetImpl;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.MasterParameterCode;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.ElementData;
import com.sanrad.nms.server.util.types.SrIpAddress;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.SrDebugLogObject;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClusterAlarmGenerator
extends AlarmGenerator {
    private static SrLogger theLogger = SrLogger.getLogger();
    private static ClusterAlarmGenerator theInstance = new ClusterAlarmGenerator();

    public static ClusterAlarmGenerator getInstance() {
        return theInstance;
    }

    private ClusterAlarmGenerator() {
    }

    @Override
    public List<AlarmImpl> checkForAlarmsToOpen(GeneralLogicObject source, VSwitchImpl vSwitch) throws RemoteException {
        ClusterImpl cluster = (ClusterImpl)source;
        List<AlarmImpl> openAlarms = super.checkForAlarmsToOpen(source, vSwitch);
        String removedNeighborName = cluster.getRemovedInconsistentNeighborName();
        if (removedNeighborName != null) {
            String msg = Server.BUNDLE.getString((BundleKeysInterface)SrServerBundleKeys.INCONSISTENT_NEIGHBOR_REMOVED_ALARM_MSG, removedNeighborName, cluster.getAlias());
            this.addAlarm(openAlarms, AlarmType.INCONSISTENT_NEIGHBOR_REMOVED, source, msg);
        }
        if (cluster.isRedundant() && !cluster.areVSwitchesNeighbors()) {
            StringBuffer msgBuffer;
            String[] names = cluster.getVSwitchesNamesAndIPs();
            if (names.length > 1) {
                msgBuffer = new StringBuffer(ClassID.VSWITCH.toString());
                msgBuffer.append(" ");
                msgBuffer.append(names[0]);
                msgBuffer.append(" and ");
                msgBuffer.append(ClassID.VSWITCH);
                msgBuffer.append(" ");
                msgBuffer.append(names[1]);
                msgBuffer.append(" are not neighbors.  Failover is not supported");
            } else {
                msgBuffer = new StringBuffer("Only neighboring ");
                msgBuffer.append(VSwitch.VSWITCHES_DISPLAY_STRING);
                msgBuffer.append(" can support failover.  To support failover, ");
                msgBuffer.append(VSwitch.VSWITCHES_DISPLAY_STRING);
                msgBuffer.append(" must be neighbors");
            }
            this.addAlarm(openAlarms, AlarmType.VSWITCHES_NOT_NEIGHBORS, source, msgBuffer.toString());
        }
        HashMap<VolumeNodeImpl, List<ISCSITargetImpl>> targets = cluster.getTargetListMgr().getTargetsWithSameVolume();
        for (VolumeNode volumeNode : targets.keySet()) {
            ISCSITargetImpl target2;
            ISCSITargetImpl target1;
            List<ISCSITargetImpl> badTargets = targets.get(volumeNode);
            if (badTargets.size() <= 1 || (target1 = badTargets.get(0)).equals(target2 = badTargets.get(1))) continue;
            StringBuffer msg = new StringBuffer(target1.getClassId().toString());
            msg.append(" ");
            msg.append(target1);
            msg.append(" and ");
            msg.append(target2.getClassId());
            msg.append(" ");
            msg.append(target2);
            msg.append(" both expose ");
            msg.append(volumeNode.getClassId());
            msg.append(" ");
            msg.append(volumeNode);
            this.addAlarm(openAlarms, AlarmType.TARGET_VOLUME_INCONS, (GeneralLogicObject)cluster, msg.toString(), volumeNode);
        }
        Set<Map.Entry<ElementData, Set<CommKeyClassId>>> inconsistentEDs = cluster.getCorruptionMgr().getCorruptedElementsForAlarms();
        for (Map.Entry<ElementData, Set<CommKeyClassId>> entry : inconsistentEDs) {
            CommKeyClassId id;
            ElementData ed = entry.getKey();
            CommKeyClassId vsID = ed.getVswitchId();
            VSwitchImpl vs = (VSwitchImpl)cluster.getCommKeyRefMap().getRefByCommKeyClassID(vsID);
            String vsName = null;
            if (!ed.getClassId().equals(ClassID.VSWITCH) && vs == null) {
                String assertMsg = "The inconsistent element has no " + VSwitch.VSWITCH_DISPLAY_STRING + " associated with it. If we got here, then it's a bug, because a DB can be found only in a " + VSwitch.VSWITCH_DISPLAY_STRING + ", hence there must be a " + VSwitch.VSWITCH_DISPLAY_STRING + " parameter in the CED. ";
                theLogger.error(SrLogCategories.ERROR, false, new SrDebugLogObject(assertMsg, ed));
                continue;
            }
            vsName = vs == null ? ((SrIpAddress)ed.getValue(ParameterCode.VSWITCH_IP_ADDRESS)).toDisplayString() : vs.getName();
            Set<CommKeyClassId> ckcidSet = entry.getValue();
            StringBuffer tmpMsg = new StringBuffer(VSwitch.VSWITCH_DISPLAY_STRING + " " + vsName + " has unexpected problem with the database: The element " + ed.getClassId());
            ParameterCode aliasPC = MasterParameterCode.ALIAS.getParameterCode(ed.getParametersList());
            SrString edAlias = (SrString)ed.getValue(aliasPC);
            if (edAlias != null) {
                tmpMsg.append("'" + edAlias.value() + "' ");
            }
            tmpMsg.append(" " + Arrays.toString(ed.getCommKey()));
            StringBuffer alarmMsg = new StringBuffer(tmpMsg);
            StringBuffer errorMsg = new StringBuffer(tmpMsg);
            Iterator<CommKeyClassId> itr = ckcidSet.iterator();
            if (itr.hasNext()) {
                String classIdStr;
                String idStr;
                id = itr.next();
                if (id == null) {
                    idStr = " is inconsistent (self validation).";
                    classIdStr = " is problematic.";
                } else {
                    idStr = ", depends on missing elements: " + id;
                    classIdStr = ", depends on missing elements: " + id.getClassID() + " " + Arrays.toString(id.getCommKeys());
                }
                alarmMsg.append(classIdStr);
                errorMsg.append(idStr);
            }
            while (itr.hasNext()) {
                id = itr.next();
                alarmMsg.append(", " + id.getClassID() + " " + Arrays.toString(id.getCommKeys()));
                errorMsg.append(", " + id);
            }
            theLogger.error(SrLogCategories.ERROR, new SrDebugLogObject(errorMsg.toString(), ed));
            this.addAlarm(openAlarms, AlarmType.DB_INCONSISTENT, (GeneralLogicObject)cluster, alarmMsg.toString(), ed.getCommKeyClassId());
        }
        return openAlarms;
    }

    @Override
    public List<AlarmImpl> checkForAlarmsToClose(GeneralLogicObject source, VSwitchImpl vSwitch, List<AlarmImpl> openAlarms) throws RemoteException {
        ClusterImpl cluster = (ClusterImpl)source;
        List<AlarmImpl> closeAlarms = super.checkForAlarmsToClose(source, vSwitch, openAlarms);
        for (AlarmImpl alarm : openAlarms) {
            if (AlarmType.INCONSISTENT_NEIGHBOR_REMOVED.equals(alarm.getType())) {
                if (cluster.getRemovedInconsistentNeighborName() != null) continue;
                closeAlarms.add(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.VSWITCHES_NOT_NEIGHBORS)) {
                if (!cluster.areVSwitchesNeighbors()) continue;
                closeAlarms.add(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.TARGET_VOLUME_INCONS)) {
                HashMap<VolumeNodeImpl, List<ISCSITargetImpl>> targets = cluster.getTargetListMgr().getTargetsWithSameVolume();
                if (targets.get(alarm.getAdditionalKeyObject()) != null) continue;
                closeAlarms.add(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.DB_INCONSISTENT)) {
                Set<Map.Entry<ElementData, Set<CommKeyClassId>>> inconsistentEDs = cluster.getCorruptionMgr().getCorruptedElementsForAlarms();
                boolean isShouldBeClosed = true;
                for (Map.Entry<ElementData, Set<CommKeyClassId>> entry : inconsistentEDs) {
                    CommKeyClassId ckcid = entry.getKey().getCommKeyClassId();
                    if (!ckcid.equals(alarm.getAdditionalKeyObject())) continue;
                    isShouldBeClosed = false;
                    break;
                }
                if (!isShouldBeClosed) continue;
                closeAlarms.add(alarm);
                continue;
            }
            theLogger.logAndAssert(SrLogCategories.ERROR, false, new Object[]{"all possible alarms should be handled here. type: " + alarm.getType()});
        }
        return closeAlarms;
    }

    @Override
    protected boolean isRedundant(GeneralLogicObject source) throws RemoteException {
        return true;
    }
}

