/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.alarm;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.RemoteObjectImpl;
import com.sanrad.nms.server.alarm.Alarm;
import com.sanrad.nms.server.alarm.AlarmSeverity;
import com.sanrad.nms.server.alarm.AlarmType;
import com.sanrad.nms.server.alarm.HistoryAlarm;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.util.alarm.HistoryAlarmData;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.HashMap;

public class HistoryAlarmImpl
extends RemoteObjectImpl
implements HistoryAlarm,
Serializable,
HistoryAlarmData {
    private String closedBy = "";
    private Long closedDateAndTime;
    private String sourceType;
    private String source;
    private String typeDescription;
    private Long dateAndTime;
    private Boolean acknowledged = Boolean.FALSE;
    private String vSwitch = null;
    private String message;
    private String cluster = null;
    private static SrLogger theLogger = SrLogger.getLogger();

    public HistoryAlarmImpl(Long aClosedDateAndTime, String aSourceType, String aSource, String aTypeDesc, Long aDateAndTime, boolean aAck, String aVS, String aMsg, String aCluster, String aClosedBy) throws RemoteException {
        this.init(aClosedDateAndTime, aSourceType, aSource, aTypeDesc, aDateAndTime, aAck, aVS, aMsg, aCluster, aClosedBy);
    }

    public HistoryAlarmImpl(HistoryAlarmData aAlarm) throws RemoteException {
        this(aAlarm.getClosedDateAndTime(), aAlarm.getSourceType().toString(), aAlarm.getSource(), aAlarm.getType().toString(), aAlarm.getDateAndTime(), aAlarm.isAcknowledged(), aAlarm.getVSwitch(), aAlarm.getMessage(), aAlarm.getClusterAlias(), aAlarm.getClosedBy());
    }

    public HistoryAlarmImpl(Alarm alarm, String closedBy) throws RemoteException {
        Long alarmClosedDateAndTime = new Long(System.currentTimeMillis());
        String alarmSourceType = alarm.getSource().getClassId().toString();
        GeneralLogicObject source = alarm.getSource();
        String alarmSource = source.toString();
        String clusterAlias = "";
        if (source.getCluster() != null) {
            clusterAlias = source.getCluster().getAlias();
        }
        VSwitch vSwitch = alarm.getVSwitch();
        String alarmVS = "---";
        if (vSwitch != null) {
            if (vSwitch instanceof VSwitch) {
                alarmVS = vSwitch.getName();
            } else {
                theLogger.trace(SrLogCategories.LEGACY, "vSwitch is ", vSwitch, " in HistoryAlarmImpl");
                alarmVS = vSwitch.toString();
            }
        }
        String alarmTypeDescription = alarm.getType().toString();
        Long alarmDateAndTime = new Long(alarm.getDateAndTime());
        Boolean alarmAcknowledged = new Boolean(alarm.isAcknowledged());
        String alarmMessage = alarm.getMessage();
        this.init(alarmClosedDateAndTime, alarmSourceType, alarmSource, alarmTypeDescription, alarmDateAndTime, alarmAcknowledged, alarmVS, alarmMessage, clusterAlias, closedBy);
    }

    private void init(Long aClosedDateAndTime, String aSourceType, String aSource, String aTypeDesc, Long aDateAndTime, boolean aAck, String aVS, String aMsg, String aCluster, String aClosedBy) {
        this.closedDateAndTime = aClosedDateAndTime;
        this.source = aSource;
        this.sourceType = aSourceType;
        this.typeDescription = aTypeDesc;
        this.dateAndTime = aDateAndTime;
        this.acknowledged = aAck;
        this.vSwitch = aVS;
        this.message = aMsg;
        this.cluster = aCluster;
        this.closedBy = aClosedBy == null ? "---" : aClosedBy;
    }

    @Override
    public String getClusterAlias() {
        return this.cluster;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    public String getCluster() {
        return this.cluster;
    }

    @Override
    public String getVSwitch() {
        return this.vSwitch;
    }

    @Override
    public AlarmType getType() {
        return AlarmType.getAlarmType(this.typeDescription);
    }

    @Override
    public AlarmSeverity getSeverity() {
        AlarmType type = this.getType();
        return type == null ? null : this.getType().getSeverity();
    }

    @Override
    public Long getDateAndTime() {
        return this.dateAndTime;
    }

    @Override
    public Boolean isAcknowledged() {
        return this.acknowledged;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public ClassID getSourceType() {
        return ClassID.getClassId(this.sourceType);
    }

    @Override
    public String getClosedBy() {
        return this.closedBy;
    }

    @Override
    public Long getClosedDateAndTime() {
        return this.closedDateAndTime;
    }

    @Override
    public boolean equals(Object obj) {
        boolean equal = super.equals(obj);
        if (equal && obj instanceof HistoryAlarm) {
            HistoryAlarmImpl alarmObj = (HistoryAlarmImpl)obj;
            return alarmObj.closedDateAndTime == this.closedDateAndTime && alarmObj.closedBy.equals(this.closedBy);
        }
        return false;
    }

    public HashMap<ClientParameterCode, Object> toClientHashMap() throws RemoteException {
        HashMap<ClientParameterCode, Object> alarmToClient = new HashMap<ClientParameterCode, Object>();
        alarmToClient.put(ClientParameterCode.ALARM_SOURCE, this.getSource());
        alarmToClient.put(ClientParameterCode.ALARM_VSWITCH, this.getVSwitch());
        alarmToClient.put(ClientParameterCode.ALARM_SEVERITY, this.getSeverity());
        alarmToClient.put(ClientParameterCode.ALARM_TYPE, this.getType());
        alarmToClient.put(ClientParameterCode.ALARM_DATE_AND_TIME, this.getDateAndTime());
        alarmToClient.put(ClientParameterCode.ALARM_ACKNOWLEDGED, this.isAcknowledged());
        alarmToClient.put(ClientParameterCode.ALARM_MESSAGE, this.getMessage());
        alarmToClient.put(ClientParameterCode.ALARM_SOURCE_TYPE, this.getSourceType());
        alarmToClient.put(ClientParameterCode.ALARM_CLOSED_BY, this.getClosedBy());
        alarmToClient.put(ClientParameterCode.ALARM_CLOSED_DATE_AND_TIME, this.getClosedDateAndTime());
        alarmToClient.put(ClientParameterCode.ALARM_SOURCE_CLUSTER, this.getCluster());
        return alarmToClient;
    }

    public String toString() {
        StringBuffer strValue = new StringBuffer("Source type: ");
        strValue.append(this.getSourceType());
        strValue.append("; Source: ");
        strValue.append(this.getSource());
        strValue.append("; Cluster: ");
        strValue.append(this.getCluster());
        strValue.append("; ");
        strValue.append(ClassID.VSWITCH);
        strValue.append(": ");
        strValue.append(this.getVSwitch());
        strValue.append("; Severity: ");
        strValue.append(this.getSeverity());
        strValue.append("; Type: ");
        strValue.append(this.getType());
        return strValue.toString();
    }
}

