/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.alarm;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.alarm.Alarm;
import com.sanrad.nms.server.alarm.AlarmList;
import com.sanrad.nms.server.alarm.AlarmMgr;
import com.sanrad.nms.server.alarm.DrAlarmMgr;
import com.sanrad.nms.server.alarm.GeneralAlarmMgrImpl;
import com.sanrad.nms.server.alarm.PendingAlarmList;
import com.sanrad.nms.server.event.DataMgrListener;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.VSwitchGroupImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterLogicObjectImpl;
import com.sanrad.nms.server.logic.dr.DRLogicObjectImpl;
import com.sanrad.nms.server.logic.dr.DRRootImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.util.types.constants.DrSiteConstant;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public class DrAlarmMgrImpl
extends GeneralAlarmMgrImpl
implements AlarmMgr,
DataMgrListener,
DrAlarmMgr {
    private static final SrLogger theLogger = SrLogger.getLogger();
    private static DrAlarmMgrImpl theInstance = null;

    protected DrAlarmMgrImpl() throws RemoteException {
    }

    public static synchronized DrAlarmMgrImpl getInstance() {
        if (theInstance == null) {
            try {
                theInstance = new DrAlarmMgrImpl();
            }
            catch (RemoteException e) {
                theLogger.error(SrLogCategories.EXCEPTION, "Failed to instantiate DrAlarmMgrImpl", e);
            }
        }
        return theInstance;
    }

    @Override
    protected PendingAlarmList createPendingAlarmList() throws IllegalValueException, RemoteException {
        return this.createPendingAlarmList(DrSiteConstant.DR_VSWITCH_GROUP_ID.getValue());
    }

    @Override
    protected AlarmList getAlarmList() throws IllegalValueException, RemoteException {
        return super.getAlarmList(DrSiteConstant.DR_VSWITCH_GROUP_ID.getValue());
    }

    @Override
    protected PendingAlarmList getPendingAlarmList() throws IllegalValueException, RemoteException {
        return new PendingAlarmList(this.pendingAlarmLists);
    }

    public void generateAlarms(int change_element_event, DRLogicObjectImpl drObj, VSwitchImpl activateVswitch) {
        this.generateAlarms(null, change_element_event, drObj, activateVswitch);
    }

    @Override
    public void removeAlarmList(VSwitchGroupImpl vSwitchGroup) throws RemoteException, IllegalValueException {
        this.clear(vSwitchGroup);
    }

    public void clear(VSwitchGroupImpl vSwitchGroup) throws RemoteException {
        AlarmList drAlarmList = (AlarmList)this.alarmLists.get(DrSiteConstant.DR_VSWITCH_GROUP_ID.getValue());
        this.createPendingAlarmList(DrSiteConstant.DR_VSWITCH_GROUP_ID.getValue());
        if (drAlarmList != null) {
            Hashtable<GeneralLogicObject, List<Alarm>> alarmList = drAlarmList.getAllAlarms();
            Iterator<GeneralLogicObject> iter = alarmList.keySet().iterator();
            while (iter.hasNext()) {
                int i;
                DRLogicObjectImpl source = (DRLogicObjectImpl)iter.next();
                DRClusterLogicObjectImpl localElement = source.getLocalElement();
                DRClusterLogicObjectImpl remoteElement = source.getRemoteElement();
                if (localElement != null && localElement.getCluster().equals(vSwitchGroup)) {
                    for (i = 0; i < source.getLocalElement().getConnectedVSwitchCounter(); ++i) {
                        drAlarmList.removeAlarm(source, source.getLocalElement().getConnectedVSwitches()[i]);
                    }
                    iter.remove();
                    continue;
                }
                if (remoteElement == null || !remoteElement.getCluster().equals(vSwitchGroup)) continue;
                for (i = 0; i < source.getRemoteElement().getConnectedVSwitchCounter(); ++i) {
                    drAlarmList.removeAlarm(source, source.getRemoteElement().getConnectedVSwitches()[i]);
                }
                iter.remove();
            }
        }
    }

    @Override
    protected void closePendingAlarms() throws RemoteException, IllegalValueException {
        if (this.pendingAlarmLists.get(DrSiteConstant.DR_VSWITCH_GROUP_ID.getValue()) != null) {
            this.pendingAlarmLists.remove(DrSiteConstant.DR_VSWITCH_GROUP_ID.getValue());
        }
    }

    @Override
    protected void updateSourceOfAlarms(AlarmList alarmList) throws RemoteException {
        Hashtable<GeneralLogicObject, List<Alarm>> alarms = alarmList.getAllAlarms();
        for (DRLogicObjectImpl dRLogicObjectImpl : alarms.keySet()) {
            DRLogicObjectImpl dRLogicObjectImpl2 = DRRootImpl.getInstance().getRefByStub(dRLogicObjectImpl.hashKey());
        }
    }
}

