/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.alarm;

import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.AlarmImpl;
import com.sanrad.nms.server.alarm.AlarmType;
import com.sanrad.nms.server.logic.GeneralAliasObject;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import java.rmi.RemoteException;
import java.util.List;

public abstract class AliasObjectAlarmGenerator
extends AlarmGenerator {
    protected AliasObjectAlarmGenerator() {
    }

    @Override
    public List<AlarmImpl> checkForAlarmsToOpen(GeneralLogicObject source, VSwitchImpl vSwitch) throws RemoteException {
        GeneralAliasObject aliasObject = (GeneralAliasObject)source;
        List<AlarmImpl> openAlarms = super.checkForAlarmsToOpen(source, vSwitch);
        String[] aliases = aliasObject.checkAliasConsistencyBetweenVSwitches();
        if (aliases != null) {
            StringBuffer msg = new StringBuffer("The ");
            msg.append(source.getClassId());
            msg.append(" ");
            msg.append(source.toString());
            msg.append(" has two different aliases (");
            msg.append(aliases[0]);
            msg.append(", ");
            if (aliases[1] != null) {
                msg.append(aliases[1]);
            }
            msg.append(")");
            this.addAlarm(openAlarms, AlarmType.ALIAS_INCONS, source, msg.toString());
        }
        return openAlarms;
    }

    @Override
    public List<AlarmImpl> checkForAlarmsToClose(GeneralLogicObject source, VSwitchImpl vSwitch, List<AlarmImpl> openAlarms) throws RemoteException {
        GeneralAliasObject aliasObject = (GeneralAliasObject)source;
        List<AlarmImpl> closeAlarms = super.checkForAlarmsToClose(source, vSwitch, openAlarms);
        for (AlarmImpl alarm : openAlarms) {
            if (!alarm.getType().equals(AlarmType.ALIAS_INCONS) || aliasObject.checkAliasConsistencyBetweenVSwitches() != null) continue;
            closeAlarms.add(alarm);
        }
        return closeAlarms;
    }
}

