/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.alarm;

import com.sanrad.SrTestUtils;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.alarm.AlarmHistoryFileMgr;
import com.sanrad.nms.server.alarm.AlarmHistoryIteratorImpl;
import com.sanrad.nms.server.alarm.HistoryAlarmImpl;
import com.sanrad.nms.server.logic.ClientParameterCode;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import junit.framework.TestCase;

public class AlarmHistoryIteratorImplTest
extends TestCase {
    private static SrTestUtils myTestUtils;
    private static int MAX_ALARMS_IN_FILE;
    private long myStartTime = System.currentTimeMillis();
    private long myAlarmCount = 0L;

    public AlarmHistoryIteratorImplTest(String arg0) {
        super(arg0);
        if (myTestUtils == null) {
            myTestUtils = SrTestUtils.getInstance();
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        SrLogger.init(new Properties());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testNext() throws RemoteException {
        AlarmHistoryFileMgr almHistoryMgr = AlarmHistoryFileMgr.getInstance();
        List<String> fileList1 = almHistoryMgr.getFileNames();
        AlarmHistoryIteratorImpl alarmIterator1 = new AlarmHistoryIteratorImpl(almHistoryMgr);
        for (int i = 0; i < MAX_ALARMS_IN_FILE; ++i) {
            almHistoryMgr.addToHistory(this.createNewHistryAlarm());
        }
        List<String> fileList2 = almHistoryMgr.getFileNames();
        AlarmHistoryIteratorImpl alarmIterator2 = new AlarmHistoryIteratorImpl(almHistoryMgr);
        fileList2.remove(fileList2.size() - 1);
        AlarmHistoryIteratorImplTest.assertTrue((String)"File lists are not consistent", (boolean)((Object)fileList2).equals(fileList1));
        boolean isFirstLoop = true;
        AlarmHistoryIteratorImpl i = alarmIterator2;
        while (i.hasNext()) {
            List<HashMap<ClientParameterCode, Object>> alarmsList2 = alarmIterator2.next();
            if (isFirstLoop) {
                isFirstLoop = false;
                continue;
            }
            List<HashMap<ClientParameterCode, Object>> alarmsList1 = alarmIterator1.next();
            AlarmHistoryIteratorImplTest.assertTrue((String)"The alarmIterator2 and alarmIterator1 elements are not equals", (boolean)((Object)alarmsList2).equals(alarmsList1));
        }
        AlarmHistoryIteratorImplTest.assertFalse((String)"The alarmIterator2 got to its end but alarmIterator1 not", (boolean)alarmIterator1.hasNext());
    }

    public void testPrevious() {
    }

    private HistoryAlarmImpl createNewHistryAlarm() {
        try {
            ++this.myAlarmCount;
            HistoryAlarmImpl alarm = new HistoryAlarmImpl(this.myStartTime + this.myAlarmCount * 1000L, "Cluster", "SP team", "No fans", this.myStartTime, false, "NGP V-Switch", "There are to many bugs", "NGP cluster", "me");
            return alarm;
        }
        catch (RemoteException e) {
            AlarmHistoryIteratorImplTest.fail((String)e.getMessage());
            AlarmHistoryIteratorImplTest.fail((String)"Failed to create history alarm");
            return null;
        }
    }

    static {
        MAX_ALARMS_IN_FILE = 100;
    }
}

