/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.alarm;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.ServerPropertiesFetcher;
import com.sanrad.nms.server.alarm.HistoryAlarm;
import com.sanrad.nms.server.alarm.HistoryAlarmImpl;
import com.sanrad.nms.server.logic.DataMgrAdapter;
import com.sanrad.util.alarm.HistoryAlarmData;
import java.io.File;
import java.io.FilenameFilter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AlarmHistoryFileMgr {
    private static SrLogger theLogger = SrLogger.getLogger();
    private static AlarmHistoryFileMgr theInstance = new AlarmHistoryFileMgr();
    private static final int ALARMS_FILE_BULK_SIZE = 100;
    private static final String HISTORY_FILE_PATH_NAME = "alarms/";
    private static final String HISTORY_FILE_FULL_PATH_NAME = "alarms/";
    static final String HISTORY_FILE_NAME_PREFIX = "alarms";
    static final String HISTORY_FILE_NAME_SUFFIX = ".history";
    private static final String HISTORY_CACHE_FILE_NAME = "alarmsCache.history";
    private List<String> historyFileNames = new ArrayList<String>();
    private int[] historyFileIndices = null;
    private int numberOfAlarmsInHistoryCacheList = 0;
    private ArrayList<HistoryAlarmImpl> historyCacheList = null;

    private AlarmHistoryFileMgr() {
        this.initHistoryFileLists();
    }

    public void initHistoryFileLists() {
        this.setHistoryFileNames();
        this.setHistoryFileIndices();
        this.setHistoryCacheList();
    }

    public static AlarmHistoryFileMgr getInstance() {
        return theInstance;
    }

    public int getAlarmCount() {
        int counter = this.historyFileIndices.length - 1;
        return counter * 100 + this.numberOfAlarmsInHistoryCacheList;
    }

    List<String> getFileNames() {
        ArrayList<String> fileNames = new ArrayList<String>(this.historyFileNames);
        fileNames.remove("");
        return fileNames;
    }

    List<HistoryAlarmImpl> getAlarmsFromFile(String fileName) {
        List<HistoryAlarmData> loadedHistoryList = null;
        loadedHistoryList = DataMgrAdapter.getInstance().loadFromFile("alarms/" + fileName);
        ArrayList<HistoryAlarmImpl> retList = new ArrayList<HistoryAlarmImpl>();
        if (loadedHistoryList != null) {
            for (HistoryAlarmData curAlarm : loadedHistoryList) {
                try {
                    if (curAlarm.getSourceType() == null || curAlarm.getType() == null) continue;
                    retList.add(new HistoryAlarmImpl(curAlarm));
                }
                catch (RemoteException exp) {
                    theLogger.error(SrLogCategories.EXCEPTION, exp, "A remote exception has occured inside a server context.");
                }
            }
        }
        return retList;
    }

    public synchronized void addToHistory(HistoryAlarm aAlarm) {
        theLogger.trace(SrLogCategories.INFORMATIVE, "Adding alarm to history. Alarm = ", aAlarm);
        if (this.historyCacheList == null) {
            this.historyCacheList = new ArrayList();
            this.numberOfAlarmsInHistoryCacheList = 0;
        }
        this.historyCacheList.add((HistoryAlarmImpl)aAlarm);
        ++this.numberOfAlarmsInHistoryCacheList;
        if (this.historyCacheList.size() >= 100) {
            theLogger.trace(SrLogCategories.INFORMATIVE, "Saving an alarm bulk.");
            this.save(this.getNextFileNameToSave());
            this.numberOfAlarmsInHistoryCacheList = 0;
        }
    }

    List<HistoryAlarmImpl> getCachedHistoryList() {
        return new ArrayList<HistoryAlarmImpl>(this.historyCacheList);
    }

    private void addFile(String fileName) {
        if (this.historyFileNames.size() > 0) {
            this.historyFileNames.add(this.historyFileNames.size() - 1, fileName);
        } else {
            this.historyFileNames.add(0, fileName);
        }
        this.setHistoryFileIndices();
    }

    private void save(String fileName) {
        if (!ServerPropertiesFetcher.isHistoryAlarmsEnabled()) {
            return;
        }
        theLogger.trace(SrLogCategories.INFORMATIVE, "Saving alarm history file named: ", fileName);
        DataMgrAdapter.getInstance().synchSetToFile("alarms/" + fileName, this.historyCacheList);
        if (!fileName.equals(HISTORY_CACHE_FILE_NAME)) {
            theLogger.trace(SrLogCategories.INFORMATIVE, "adding hostory file: ", fileName);
            this.historyCacheList = new ArrayList();
            this.addFile(fileName);
        } else {
            theLogger.trace(SrLogCategories.INFORMATIVE, "The history file that was saved is a cache file");
        }
    }

    private int getNextAvailableFileIndexToSave() {
        int index = 0;
        if (this.historyFileIndices != null && this.historyFileIndices.length > 0) {
            index = this.historyFileIndices[this.historyFileIndices.length - 1] + 1;
        }
        return index;
    }

    private String getFileName(int index) {
        StringBuffer fileName = new StringBuffer(HISTORY_FILE_NAME_PREFIX);
        if (index >= 0) {
            fileName.append(index);
        }
        fileName.append(HISTORY_FILE_NAME_SUFFIX);
        return fileName.toString();
    }

    private String getNextFileNameToSave() {
        int index = this.getNextAvailableFileIndexToSave();
        return this.getFileName(index);
    }

    private int getFileIndexOf(String fileName) {
        int fileIndexSuffix;
        if (fileName.equals("")) {
            return -1;
        }
        String fileIndexPrefix = fileName.substring(HISTORY_FILE_NAME_PREFIX.length());
        String index = fileIndexPrefix.substring(0, fileIndexSuffix = fileIndexPrefix.indexOf(HISTORY_FILE_NAME_SUFFIX));
        if (index.equals("")) {
            return 0;
        }
        try {
            return Integer.parseInt(index);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    private void setHistoryFileIndices() {
        theLogger.trace(SrLogCategories.INFORMATIVE, "Entering method setHistoryFileIndices. historyFileNames.size = ", this.historyFileNames.size());
        this.historyFileIndices = new int[this.historyFileNames.size()];
        for (int i = 0; i < this.historyFileNames.size(); ++i) {
            this.historyFileIndices[i] = this.getFileIndexOf(this.historyFileNames.get(i));
        }
        Arrays.sort(this.historyFileIndices);
        theLogger.trace(SrLogCategories.INFORMATIVE, "In the setHistoryFileIndices. historyFileIndices after the sort is: ", this.historyFileIndices);
    }

    private boolean isValidName(String fileName) {
        return this.getFileIndexOf(fileName) >= 0;
    }

    private void setHistoryCacheList() {
        this.historyCacheList = (ArrayList)this.getAlarmsFromFile(HISTORY_CACHE_FILE_NAME);
        if (this.historyCacheList == null) {
            this.historyCacheList = new ArrayList();
        }
        this.numberOfAlarmsInHistoryCacheList = this.historyCacheList.size();
    }

    private void setHistoryFileNames() {
        File path = new File("alarms/");
        path.mkdir();
        StringBuilder regexSb = new StringBuilder();
        regexSb.append(HISTORY_FILE_NAME_PREFIX);
        regexSb.append("\\d+\\");
        regexSb.append(HISTORY_FILE_NAME_SUFFIX);
        regexSb.append("\\.xml");
        final String regex = regexSb.toString();
        String[] fileNames = path.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.matches(regex);
            }
        });
        if (fileNames != null) {
            this.historyFileNames = new ArrayList<String>();
            for (int i = 0; i < fileNames.length; ++i) {
                if (!this.isValidName(fileNames[i])) continue;
                this.historyFileNames.add(fileNames[i]);
            }
            this.historyFileNames.add("");
        }
    }

    public void saveCachedClosedAlarms() {
        this.save(HISTORY_CACHE_FILE_NAME);
    }
}

