/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.alarm;

import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.alarm.Alarm;
import com.sanrad.nms.server.alarm.AlarmImpl;
import com.sanrad.nms.server.alarm.AlarmMgrImpl;
import com.sanrad.nms.server.alarm.AlarmType;
import com.sanrad.nms.server.alarm.PendingAlarmList;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.GeneralLogicObjectImpl;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterLogicObjectImpl;
import com.sanrad.nms.server.logic.dr.DRLogicObjectImpl;
import com.sanrad.nms.server.logic.dr.DRRootImpl;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.MasterParameterCode;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class AlarmGenerator {
    protected static SrLogger logger = SrLogger.getLogger();
    protected StringBuffer msg = null;
    private PendingAlarmList pendingAlarmList = null;

    protected AlarmGenerator() {
    }

    protected PendingAlarmList getPendingAlarmList() {
        return this.pendingAlarmList;
    }

    protected void setPendingAlarmList(PendingAlarmList pendingAlarmList) {
        this.pendingAlarmList = pendingAlarmList;
    }

    public List<AlarmImpl> checkForAlarmsToOpen(GeneralLogicObject source, VSwitchImpl vSwitch, PendingAlarmList pendingAlarmList) throws RemoteException {
        this.setPendingAlarmList(pendingAlarmList);
        return this.checkForAlarmsToOpen(source, vSwitch);
    }

    public List<AlarmImpl> checkForAlarmsToOpen(GeneralLogicObject source, VSwitchImpl vSwitch) throws RemoteException {
        HashMap inconsistentValues;
        ArrayList<AlarmImpl> openAlarms = new ArrayList<AlarmImpl>();
        if (!this.isRedundant(source)) {
            StringBuffer msg = new StringBuffer("The ");
            msg.append(source.getClassId());
            msg.append(" ");
            msg.append(source.toString());
            msg.append(" is defined only in the ");
            if (vSwitch != null) {
                if (source instanceof DRLogicObjectImpl) {
                    msg.append(vSwitch.getCluster().getClassId().toString());
                    msg.append(" ");
                    msg.append(vSwitch.getCluster().getAlias());
                } else {
                    msg.append(vSwitch.getClassId().toString());
                    msg.append(" ");
                    msg.append(vSwitch.getName());
                }
            }
            msg.append(". Check consistency of the parent volume when applicable.");
            if (source instanceof DRLogicObjectImpl) {
                this.addAlarm(openAlarms, AlarmType.NOT_SYMTRIC_DR, source, msg.toString());
            } else if (source instanceof DRClusterLogicObjectImpl) {
                this.addAlarm(openAlarms, AlarmType.OBJ_NOT_REDUNDANT, source, null, msg.toString(), source.getCluster());
            } else {
                this.addAlarm(openAlarms, AlarmType.OBJ_NOT_REDUNDANT, source, msg.toString());
            }
        }
        if (((GeneralLogicObjectImpl)source).getConnectedVSwitches().length > 1 && (inconsistentValues = ((GeneralLogicObjectImpl)source).checkConsistencyBetweenVSwitches()) != null) {
            for (Object code : inconsistentValues.keySet()) {
                Object value = null;
                Object[] values = null;
                if (source instanceof DRLogicObjectImpl && MasterParameterCode.DR_ROLE.equals(code)) continue;
                values = (Object[])inconsistentValues.get(code);
                StringBuffer msg = new StringBuffer("The ");
                msg.append(source.getClassId());
                msg.append(" ");
                msg.append(source.toString());
                msg.append(" has two different values for the parameter ");
                msg.append(code.toString());
                msg.append(" (");
                if (value != null) {
                    msg.append((Object)value);
                } else {
                    msg.append(values[0] + ", " + values[1]);
                }
                msg.append(")");
                if (source instanceof DRLogicObjectImpl) {
                    this.addAlarm(openAlarms, AlarmType.ASYMETRIC_ATTRIBUTE, source, msg.toString(), code);
                    continue;
                }
                if (source instanceof DirectAccessDeviceImpl) {
                    DirectAccessDeviceImpl disk = (DirectAccessDeviceImpl)source;
                    if (disk.isDisabled()) continue;
                    this.addAlarm(openAlarms, AlarmType.ATTRIBUTE_INCONS, source, msg.toString(), code);
                    continue;
                }
                this.addAlarm(openAlarms, AlarmType.ATTRIBUTE_INCONS, source, msg.toString(), code);
            }
        }
        return openAlarms;
    }

    public List<AlarmImpl> checkForAlarmsToClose(GeneralLogicObject source, VSwitchImpl vSwitch, List<AlarmImpl> openAlarms) throws RemoteException {
        ArrayList<AlarmImpl> closeAlarms = new ArrayList<AlarmImpl>();
        for (AlarmImpl alarm : openAlarms) {
            HashMap inconsistentValues;
            if (alarm.getType().equals(AlarmType.OBJ_NOT_REDUNDANT)) {
                if (!(source instanceof LogicObjectImpl) || !this.isRedundant(source)) continue;
                if (source instanceof DRClusterLogicObjectImpl) {
                    if (!alarm.getAdditionalKeyObject().equals(source.getCluster())) continue;
                    closeAlarms.add(alarm);
                    continue;
                }
                closeAlarms.add(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.NOT_SYMTRIC_DR)) {
                if (!(source instanceof DRLogicObjectImpl) || !this.isRedundant(source)) continue;
                closeAlarms.add(alarm);
                continue;
            }
            if (!alarm.getType().equals(AlarmType.ATTRIBUTE_INCONS) && !alarm.getType().equals(AlarmType.ASYMETRIC_ATTRIBUTE) || (inconsistentValues = ((GeneralLogicObjectImpl)source).checkConsistencyBetweenVSwitches()) != null && inconsistentValues.containsKey(alarm.getAdditionalKeyObject())) continue;
            closeAlarms.add(alarm);
        }
        return closeAlarms;
    }

    protected List<AlarmImpl> hasBadValues(List<AlarmImpl> openAlarms, GeneralLogicObject source, VSwitch vSwitch) throws RemoteException {
        return openAlarms;
    }

    protected StringBuffer getDefaultMessage(GeneralLogicObject source, VSwitch vSwitch) throws RemoteException {
        StringBuffer msg = new StringBuffer(ClassID.VSWITCH.toString());
        msg.append(" ");
        if (vSwitch != null) {
            msg.append(vSwitch.getName());
        }
        msg.append(". The ");
        msg.append(source.getClassId());
        msg.append(" ");
        msg.append(source.toString());
        return msg;
    }

    protected StringBuffer getDefaultMessage(VSwitch vSwitch) throws RemoteException {
        StringBuffer msg = new StringBuffer(ClassID.VSWITCH.toString());
        msg.append(" ");
        if (vSwitch != null) {
            msg.append(vSwitch.getName());
        }
        msg.append(". ");
        return msg;
    }

    protected StringBuffer getDefaultMessage(GeneralLogicObject source, VSwitch vSwitch, Cluster cluster) throws RemoteException {
        StringBuffer msg = new StringBuffer(cluster.getClassId().toString());
        msg.append(" ");
        msg.append(cluster.getAlias());
        msg.append(" ");
        msg.append(vSwitch.getClassId().toString());
        msg.append(" ");
        msg.append(vSwitch.getName());
        msg.append(".  The ");
        msg.append(source.getClassId());
        msg.append(" ");
        msg.append(source.toString());
        return msg;
    }

    protected boolean isRedundant(GeneralLogicObject source) throws RemoteException {
        return ((GeneralLogicObjectImpl)source).isRedundant();
    }

    protected void addAlarm(List<AlarmImpl> alarms, AlarmType type, GeneralLogicObject source, String msg) throws RemoteException {
        this.addAlarm(alarms, type, source, (VSwitchImpl)null, msg);
    }

    protected void addAlarm(List<AlarmImpl> alarms, AlarmType type, GeneralLogicObject source, VSwitchImpl vSwitch, String msg) throws RemoteException {
        this.addAlarm(alarms, type, source, vSwitch, msg, null);
    }

    protected void addAlarm(List<AlarmImpl> alarms, AlarmType type, GeneralLogicObject source, String msg, Object additionalKeyObject) throws RemoteException {
        this.addAlarm(alarms, type, source, null, msg, additionalKeyObject);
    }

    protected void addAlarm(List<AlarmImpl> alarms, AlarmType type, GeneralLogicObject source, VSwitchImpl vSwitch, String msg, Object additionalKeyObject) throws RemoteException {
        AlarmImpl pendingAlarm;
        msg = msg + ".";
        AlarmImpl alarm = null;
        if (source instanceof DRClusterLogicObjectImpl) {
            source = DRRootImpl.getInstance().findDRObjectWithIdenticalElement((DRClusterLogicObjectImpl)source);
        }
        alarm = new AlarmImpl(type, source, vSwitch, msg);
        if (this.getPendingAlarmList() != null && (pendingAlarm = this.getPendingAlarmList().getAlarm(type, source, vSwitch, additionalKeyObject)) != null) {
            alarm.setReopened();
            alarm.setSource(source);
            alarm.setDateAndTime(pendingAlarm.getDateAndTime());
            if (pendingAlarm.isAcknowledged()) {
                alarm.setAcknowledged(pendingAlarm.getAcknowledgedBy(), pendingAlarm.getAckDateAndTime());
            }
            if (pendingAlarm.isSilent()) {
                alarm.setSilent();
            }
        }
        if (type.getSilentValue()) {
            return;
        }
        alarm.addAdditionalKeyObject(additionalKeyObject);
        alarms.add(alarm);
    }

    protected boolean isAlarmOpen(List<AlarmImpl> alarms, AlarmType alarmType) throws RemoteException {
        for (AlarmImpl alarm : alarms) {
            if (!alarm.getType().equals(alarmType)) continue;
            return true;
        }
        return false;
    }

    protected void addAlarmAndMsg(GeneralLogicObject source, VSwitchImpl vSwitch, List<AlarmImpl> openAlarms, String addedMsg, AlarmType alarm) throws RemoteException {
        this.msg = this.getDefaultMessage(source, vSwitch);
        this.msg.append(addedMsg);
        this.addAlarm(openAlarms, alarm, source, vSwitch, this.msg.toString());
    }

    public Class calculateAnacestor(Class innerClass) {
        if (innerClass == null) {
            innerClass = AlarmGenerator.class;
            return innerClass;
        }
        Class anacestor1 = innerClass;
        for (Class<?> anacestor2 = this.getClass(); anacestor1 != anacestor2; anacestor2 = anacestor2.getSuperclass()) {
            while (anacestor1 != AlarmGenerator.class) {
                if ((anacestor1 = anacestor1.getSuperclass()) != anacestor2) continue;
                return anacestor1;
            }
            anacestor1 = innerClass;
        }
        return anacestor1;
    }

    protected boolean alarmAlreadyIncluded(GeneralLogicObjectImpl logicObj, AlarmType alarmType) throws RemoteException {
        ArrayList<AlarmImpl> alreadyOpenAlarms = null;
        List<Alarm> alreadyOpenAlarms_Patch = AlarmMgrImpl.getInstance().getAlarms(logicObj);
        if (alreadyOpenAlarms_Patch != null) {
            alreadyOpenAlarms = new ArrayList<AlarmImpl>();
            for (Alarm alarm : alreadyOpenAlarms_Patch) {
                alreadyOpenAlarms.add((AlarmImpl)alarm);
            }
        }
        if (alreadyOpenAlarms != null) {
            for (AlarmImpl alarmImpl : alreadyOpenAlarms) {
                AlarmType type = alarmImpl.getType();
                if (!type.equals(alarmType)) continue;
                return true;
            }
        }
        return false;
    }
}

