/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.ServerPropertiesFetcher;
import com.sanrad.nms.server.SrServerBundleKeys;
import com.sanrad.nms.server.alarm.AlarmMgrImpl;
import com.sanrad.nms.server.alarm.AlarmType;
import com.sanrad.nms.server.comm.database.DatabaseManager;
import com.sanrad.nms.server.logic.LogicMgrAOImpl;
import com.sanrad.nms.server.logic.SystemRootImpl;
import com.sanrad.nms.server.user.UserManagerImpl;
import com.sanrad.util.EditAsciiFile;
import com.sanrad.util.NetUtil;
import com.sanrad.util.SrConstantsBundleKeys;
import com.sanrad.util.SrResourceBundle;
import com.sanrad.util.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.ExportException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;

public class Server {
    private static final String CONF_FILE = "config" + File.separator + "log.properties";
    private static SrLogger theLogger;
    public static SrResourceBundle BUNDLE;
    public static SrResourceBundle VENDOR_BUNDLE;
    public static SrResourceBundle CONSTANSTS_BUNDLE;
    public static final String VENDOR_NAME;
    public static final String PRODUCT_NAME;
    public static final String FULL_PRODUCT_NAME;
    public static String VERSION;
    public static final int PORT_NOT_SET;
    public static final String APP_ICON;
    public static final String ABOUT_IMAGE;
    private static final String RMI_POLICY_FILE_NAME;
    public static final String RMI_EXPORT_PORT_PROPERTY;
    public static final String CLIENT_APPLICATION_LOCATION_PROPERTY;
    public static final String ATTACH_RAID_PROPERTY;
    public static final String CLIENT_APPLET_LOCATION_PROPERTY;
    private static final String CLIENT_APPLICATION_PROPERTIES_FILE_NAME;
    private static final String CLIENT_APPLET_PROPERTIES_FILE_NAME;
    private static InetAddress hostInetAddress;
    private static int rmiregistryPort;
    public static String SYS_ROOT_SITE_NAME;

    public static int getRMIExportPort() {
        String port = null;
        port = ServerPropertiesFetcher.getServerPropertyValue(RMI_EXPORT_PORT_PROPERTY);
        if (port == null) {
            return PORT_NOT_SET;
        }
        return Integer.parseInt(port);
    }

    public static String getClientApplicationPropertyPath() {
        return ServerPropertiesFetcher.getServerPropertyValue(CLIENT_APPLICATION_LOCATION_PROPERTY);
    }

    public static String getClientAppletPropertyPath() {
        return ServerPropertiesFetcher.getServerPropertyValue(CLIENT_APPLET_LOCATION_PROPERTY);
    }

    private static Registry getRegistry(int registryPort) {
        Registry registry = null;
        try {
            registry = LocateRegistry.createRegistry(registryPort);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return registry;
    }

    public static void main(String[] args) {
        StringBuffer os = new StringBuffer("OS: ");
        os.append(Util.getOSName());
        os.append(" version ");
        os.append(Util.getOSVersion());
        StringBuffer jvm = new StringBuffer("JVM version: ");
        jvm.append(Util.getCurrentJVMVersion());
        StringBuffer locale = new StringBuffer("Locale: ");
        locale.append(Util.getLocale());
        StringBuffer productVersion = new StringBuffer(PRODUCT_NAME + " version: ");
        productVersion.append(VERSION);
        if (args.length > 0 && args[0].equals("-version")) {
            System.out.println(os);
            System.out.println(jvm);
            System.out.println(locale);
            System.out.println(productVersion);
            System.exit(0);
        }
        if (Util.lockApplicationInstanceIfNotActive(".lock")) {
            System.err.println(PRODUCT_NAME + " already runs");
            System.exit(0);
        }
        theLogger.info(SrLogCategories.SYSTEM, os);
        theLogger.info(SrLogCategories.SYSTEM, jvm);
        theLogger.info(SrLogCategories.SYSTEM, locale);
        theLogger.info(SrLogCategories.SYSTEM, productVersion);
        if (!Util.isJavaVersion14Compatible()) {
            String version = "1.4";
            System.err.println("You must use Java(TM) version " + version + " or higher in order to run " + FULL_PRODUCT_NAME + "\nCurrently you use Java(TM) version " + Util.getCurrentJavaVersion() + ".\nThe Java Runtime Environment can be downloaded from:\nhttp://java.sun.com");
            System.exit(0);
        }
        Server.setJavaSecurityPolicy();
        String hostname = ServerPropertiesFetcher.getHostname();
        String rmiregistryPortStr = ServerPropertiesFetcher.getRMIRegistryPort();
        rmiregistryPort = Server.getFreePortAndSaveIfDifferent(Integer.parseInt(rmiregistryPortStr));
        if (hostname != null && !hostname.equals("")) {
            System.setProperty("java.rmi.server.hostname", hostname);
            theLogger.info(SrLogCategories.LEGACY, "Setting java.rmi.server.hostname to ", hostname);
        }
        AlarmType.removeIfNonSupportedAlarm(VENDOR_BUNDLE.getString(SrServerBundleKeys.MismSFP), SrServerBundleKeys.MismSFP.getKey());
        LogicMgrAOImpl.getInstance();
        SystemRootImpl.setStatusInProcess("Initializing server...");
        try {
            if (System.getSecurityManager() == null) {
                System.setSecurityManager(new RMISecurityManager());
            }
            Server.getHostAddress();
            if (hostInetAddress != null) {
                int originalRegistryPort;
                StringBuffer host = new StringBuffer(hostInetAddress.getHostAddress());
                theLogger.trace(SrLogCategories.LEGACY, "Host is: ", host);
                int registryPort = originalRegistryPort = Server.getRegistryPort();
                Registry registry = Server.getRegistry(registryPort);
                if (registry != null) {
                    UserManagerImpl userManager = UserManagerImpl.getInstance();
                    userManager.bindToRMIRegistry(registry, "UserManager");
                    userManager.loadUsersFromFile();
                    LogicMgrAOImpl.getInstance().bindToRMIRegistry(registry, "ServerConnectionMgr");
                    DatabaseManager.getInstance().convertOldDatabaseToNewDatabaseAndDeleteOldFile();
                    LogicMgrAOImpl.getInstance().systemDiscovery();
                } else {
                    SystemRootImpl.setStatusError("Failed to load");
                }
            } else {
                theLogger.fatal(SrLogCategories.LEGACY, "Hostname not found - cannot proceed.  You must set an IP address.");
                SystemRootImpl.setStatusReady();
            }
        }
        catch (ExportException ee) {
            theLogger.fatal(SrLogCategories.LEGACY, ee, "Port ", rmiregistryPortStr, " is already in use!");
            SystemRootImpl.setStatusError("Failed to initialize");
        }
        catch (RemoteException re) {
            theLogger.fatal(SrLogCategories.LEGACY, re, new Object[0]);
        }
        catch (Exception e) {
            theLogger.fatal(SrLogCategories.LEGACY, e.getMessage() + " in Server::main()", e);
        }
        try {
            Runtime.getRuntime().addShutdownHook(new Thread("Shutdown"){

                @Override
                public void run() {
                    AlarmMgrImpl.getInstance().saveCachedClosedAlarms();
                }
            });
        }
        catch (SecurityException se) {
            theLogger.warn(SrLogCategories.LEGACY, se);
        }
    }

    private static int getFreePortAndSaveIfDifferent(int defaultPort) {
        if (NetUtil.isPortBusy(defaultPort)) {
            try {
                defaultPort = NetUtil.getRandomFreePort();
                Properties newProperties = new Properties();
                newProperties.setProperty("rmiRegPort", Integer.toString(defaultPort));
                Server.setNewProperties(newProperties);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return defaultPort;
    }

    public static String[] getHostAddressListAsStringArray() {
        InetAddress[] inetAddress = ServerPropertiesFetcher.getHostAddressList();
        String[] ips = new String[inetAddress.length];
        for (int i = 0; i < inetAddress.length; ++i) {
            ips[i] = inetAddress[i].getHostAddress();
        }
        return ips;
    }

    public static int getRegistryPort() {
        return rmiregistryPort;
    }

    public static String getHostAddress() {
        if (hostInetAddress == null) {
            hostInetAddress = ServerPropertiesFetcher.getHostInetAddress();
        }
        return hostInetAddress.getHostAddress();
    }

    public static void setNewProperties(Properties newProperties) {
        if (newProperties != null) {
            try {
                Properties serverPropertiesToSave = Server.getPropertiesToSave(newProperties, "server.properties");
                Util.saveProperties(serverPropertiesToSave, "server.properties");
                String clientApplicationPropertyPath = Server.getClientApplicationPropertyPath();
                String clientApplicationPropertyFileName = clientApplicationPropertyPath + File.separator + CLIENT_APPLICATION_PROPERTIES_FILE_NAME;
                Properties clientApplicationPropertiesToSave = Server.getPropertiesToSave(newProperties, clientApplicationPropertyFileName);
                Util.saveProperties(clientApplicationPropertiesToSave, clientApplicationPropertyFileName);
                String clientAppletPropertyPath = Server.getClientAppletPropertyPath();
                String clientAppletPropertyFileName = clientAppletPropertyPath + File.separator + CLIENT_APPLET_PROPERTIES_FILE_NAME;
                EditAsciiFile.changeAppletValues(newProperties, clientAppletPropertyFileName);
            }
            catch (IOException ioe) {
                theLogger.warn(SrLogCategories.LEGACY, ioe);
            }
        }
    }

    private static Properties getPropertiesToSave(Properties newProperties, String propertiesFileName) {
        try {
            Properties propertiesToSave = new Properties();
            Properties currentProperties = Util.loadProperties(propertiesFileName);
            Enumeration<Object> e = currentProperties.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                if (!newProperties.containsKey(key)) {
                    propertiesToSave.put(key, currentProperties.get(key));
                    continue;
                }
                propertiesToSave.put(key, newProperties.get(key));
            }
            return propertiesToSave;
        }
        catch (IOException ioe) {
            theLogger.warn(SrLogCategories.LEGACY, ioe);
            return null;
        }
    }

    private static boolean setJavaSecurityPolicy() {
        String localDir = Server.getLocalDir() + "/";
        String policyProperty = "file:" + localDir;
        if (Server.createRMIPolicyFile(policyProperty, localDir + RMI_POLICY_FILE_NAME)) {
            System.setProperty("java.security.policy", policyProperty + RMI_POLICY_FILE_NAME);
            return true;
        }
        return false;
    }

    private static boolean createRMIPolicyFile(String policyProperty, String fileName) {
        StringBuffer policy = new StringBuffer("grant codeBase \"");
        policy.append(policyProperty);
        policy.append("-\"\n");
        policy.append("{\n");
        policy.append("\t// Allow everything for now\n");
        policy.append("\tpermission java.net.SocketPermission  \"*:1024-65535\", \"accept, connect, listen\";\n");
        policy.append("\tpermission java.security.AllPermission;\n");
        policy.append("};\n");
        File policyFile = new File(fileName);
        if (policyFile.delete()) {
            theLogger.info(SrLogCategories.LEGACY, "Old RMI policy file ", fileName, " with the policy: ", policy, " was removed");
        }
        if (!policyFile.isFile()) {
            policyFile.deleteOnExit();
            theLogger.trace(SrLogCategories.LEGACY, "Trying to create RMI policy file ", fileName, " with the policy: ", policy);
            try {
                FileOutputStream fos = new FileOutputStream(policyFile);
                fos.write(policy.toString().getBytes());
                fos.flush();
                fos.close();
            }
            catch (FileNotFoundException fnfe) {
                theLogger.fatal(SrLogCategories.LEGACY, "Failed to create RMI policy file ", fileName, " due to ", fnfe.getMessage(), fnfe);
                return false;
            }
            catch (IOException ioe) {
                theLogger.fatal(SrLogCategories.LEGACY, "Failed to create RMI policy file ", fileName, " due to ", ioe.getMessage(), ioe);
                return false;
            }
            theLogger.trace(SrLogCategories.LEGACY, "Create RMI policy file succeeded");
        } else {
            theLogger.trace(SrLogCategories.LEGACY, "RMI policy file ", fileName, " exists");
        }
        return true;
    }

    private static String getLocalDir() {
        String localDir = System.getProperty("user.dir");
        StringTokenizer tokens = new StringTokenizer(localDir, "\\");
        StringBuffer location = new StringBuffer();
        while (tokens.hasMoreTokens()) {
            location.append(tokens.nextToken());
            location.append(tokens.hasMoreTokens() ? "/" : "");
        }
        return location.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        FileInputStream inFile = null;
        try {
            inFile = new FileInputStream(CONF_FILE);
            Properties logProps = new Properties();
            logProps.load(inFile);
            SrLogger.init(logProps);
            theLogger = SrLogger.getLogger();
        }
        catch (FileNotFoundException exp) {
            System.err.println("Could not load the logging configuration file because of the following exception: " + exp);
            SrLogger.init(null);
            theLogger = SrLogger.getDummyLogger();
        }
        catch (IOException exp) {
            System.err.println("Could not load the logging configuration file because of the following exception: " + exp);
            SrLogger.init(null);
            theLogger = SrLogger.getDummyLogger();
        }
        finally {
            try {
                if (inFile != null) {
                    inFile.close();
                }
            }
            catch (IOException e) {
                System.err.println("Can not close the logger configuration file.");
            }
        }
        BUNDLE = SrResourceBundle.getInstance("product_server", Locale.US);
        VENDOR_BUNDLE = SrResourceBundle.getInstance(SrResourceBundle.DEFAULT_VENDOR_SERVER_BUNDLE_NAME, Locale.US);
        CONSTANSTS_BUNDLE = SrResourceBundle.getInstance("constants", Locale.US);
        VENDOR_NAME = CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.VENDOR_NAME);
        PRODUCT_NAME = CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.PRODUCT_NAME);
        FULL_PRODUCT_NAME = PRODUCT_NAME + " Server";
        VERSION = BUNDLE.getString(SrServerBundleKeys.SERVER_VERSION);
        if (VERSION == null) {
            VERSION = Util.getCVSTagVersionString();
        }
        VERSION = VERSION + " (" + Util.getCurrentJVMVersion() + ")";
        SYS_ROOT_SITE_NAME = BUNDLE.getString(SrServerBundleKeys.SYS_ROOT_SITE_NAME);
        PORT_NOT_SET = -1;
        APP_ICON = "images/app-icon.gif";
        ABOUT_IMAGE = "images/about.jpg";
        RMI_POLICY_FILE_NAME = "rmi.policy";
        RMI_EXPORT_PORT_PROPERTY = "rmiExportPort";
        CLIENT_APPLICATION_LOCATION_PROPERTY = "clientApplicationLocation";
        ATTACH_RAID_PROPERTY = "attachRaid";
        CLIENT_APPLET_LOCATION_PROPERTY = "clientAppletionLocation";
        CLIENT_APPLICATION_PROPERTIES_FILE_NAME = "client.properties";
        CLIENT_APPLET_PROPERTIES_FILE_NAME = "index.html";
        hostInetAddress = null;
        rmiregistryPort = PORT_NOT_SET;
    }
}

