/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server;

import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.ServerPropertiesFetcher;
import com.sanrad.nms.server.SrSocketFactory;
import com.sanrad.nms.server.alarm.event.AlarmEvent;
import com.sanrad.nms.server.alarm.event.PropagatedStateEvent;
import com.sanrad.nms.server.comm.snmp.SnmpVersion;
import com.sanrad.nms.server.logic.ElementEvent;
import com.sanrad.nms.server.logic.ElementListener;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.Site;
import com.sanrad.nms.server.logic.SiteImpl;
import com.sanrad.nms.server.logic.SystemRoot;
import com.sanrad.nms.server.logic.VSwitchGroup;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.dr.DRBlockingEvent;
import com.sanrad.nms.server.logic.dr.DRConsistencyGroup;
import com.sanrad.nms.server.logic.dr.DRListener;
import com.sanrad.nms.server.logic.dr.DRRoot;
import com.sanrad.nms.server.logic.dr.DRSyncPair;
import com.sanrad.nms.server.logic.volume.SnapshotManager;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.logic.volume.VolumeTree;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.user.UserManager;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.types.constants.SnapshotActivateTypeConstants;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.Vector;

public class ClientSimulator
implements ElementListener {
    private SystemRoot systemRoot = null;
    private static final String DEVELOPMENT_PROPERTIES_FILE_PATH = "/Program Files/SANRAD/VSS/StoragePro/server";

    private void test() throws RemoteException {
        ArrayList clusters = this.systemRoot.getClusters();
        if (clusters == null || clusters.size() == 0) {
            System.out.println("Test failed, because there were no clusters found.");
            return;
        }
        Cluster localCluster = (Cluster)clusters.get(0);
        Vector vec = localCluster.getStorage().getVolumeForest();
        VolumeNode source = ((VolumeTree)vec.elementAt(0)).getTreeRoot();
        VolumeNode target = ((VolumeTree)vec.elementAt(1)).getTreeRoot();
        try {
            localCluster.getStorage().createSnapshotVolume("EranSnap", source.getCommKeyClassId(), target.getCommKeyClassId(), 10, SnapshotActivateTypeConstants.SNAPSHOT_ACTIVE);
        }
        catch (RemoteException e1) {
            e1.printStackTrace();
        }
        catch (IllegalValueException e1) {
            e1.printStackTrace();
        }
        SnapshotManager snapImpl = ((ClusterImpl)localCluster).getVolumeMgr().getSnapshotManager();
        System.out.println("End of Eran's snapshot test.");
        DRRoot drRoot = this.systemRoot.getDRRoot();
        DRConsistencyGroup[] groups = drRoot.getConsistencyGroups();
        DRSyncPair[] syncPairs = drRoot.getSyncPairs();
        boolean a = false;
        try {
            DRConsistencyGroup[] groups1 = drRoot.getConsistencyGroups();
            ClusterImpl cl1 = ((SiteImpl)this.systemRoot.getSites().get(0)).getClusters().get(0);
            LogicObjectImpl pair1 = null;
            DRBlockingEvent drEvent = new DRBlockingEvent((Object)cl1, pair1, 1);
            ((DRListener)((Object)drRoot)).invokeDREventAndWait(drEvent);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        System.out.println("Test ended");
    }

    private void printClusters(Site site) throws RemoteException {
        if (site.getVSwitchGroups().isEmpty() && site.getClusters().isEmpty()) {
            System.out.println(site.getClassId() + " " + site.getAlias() + " is empty");
        }
        for (Cluster cluster : site.getVSwitchGroups()) {
            String alias = cluster.getAlias();
            System.out.println(site.getClassId() + " " + site.getAlias());
            this.printVSwitches(cluster, true);
        }
    }

    private void printVSwitches(Cluster cluster, boolean hasParentSite) throws RemoteException {
        String tabs = "\t";
        if (hasParentSite) {
            System.out.println(tabs + cluster.getClassId() + " " + cluster.getAlias());
            tabs = tabs + "\t";
        } else {
            System.out.println(cluster.getClassId() + " " + cluster.getAlias());
        }
        if (cluster.getVSwitches().isEmpty()) {
            String alias = cluster.getAlias();
            System.out.println(cluster.getClassId() + " " + alias + " is empty");
        }
        for (VSwitch vSwitch : cluster.getVSwitches()) {
            String name = vSwitch.getName();
            System.out.println(tabs + vSwitch.getClassId() + " " + name);
        }
    }

    private void addVSwitch() {
        try {
            ArrayList vSwitchGroups = this.systemRoot.getVSwitchGroups();
            for (VSwitchGroup vSwitchGroup : vSwitchGroups) {
                if (!vSwitchGroup.getClassId().equals(ClassID.SITE)) continue;
                ArrayList clusters = ((Site)vSwitchGroup).getClusters();
                if (!clusters.isEmpty()) {
                    this.addVSwitch((Cluster)clusters.iterator().next());
                }
                break;
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private void addVSwitch(Cluster cluser) {
        try {
            cluser.addVSwitch("172.17.200.153", "255.255.255.0", 161, 162, "public", "private", 3000L, 3, SnmpVersion.V2C);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (IllegalValueException e) {
            e.printStackTrace();
        }
    }

    private void addCluster() {
        try {
            this.systemRoot.createCluster("Shay");
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (IllegalValueException e) {
            e.printStackTrace();
        }
    }

    private ClientSimulator() {
        Registry registry = ClientSimulator.getRegistry();
        String serverObjectName = "UserManager";
        try {
            UserManager userManager = (UserManager)registry.lookup(serverObjectName);
            this.systemRoot = userManager.getSystemRoot();
            this.test();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Registry getRegistry() {
        try {
            Registry registry = LocateRegistry.getRegistry(null, Integer.parseInt(ClientSimulator.getPort()), new SrSocketFactory(null));
            return registry;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static String getPort() {
        String port = ServerPropertiesFetcher.getRMIRegistryPort();
        if (port == null) {
            return "2917";
        }
        return port;
    }

    public static void main(String[] args) {
        new ClientSimulator();
        System.exit(0);
    }

    @Override
    public void elementCreate(ElementEvent e) throws RemoteException {
        RemoteObject element = e.getElement();
        System.out.println("elementCreate " + element);
    }

    @Override
    public void elementRemove(ElementEvent e) throws RemoteException {
        RemoteObject element = e.getElement();
        System.out.println("elementRemove " + element);
    }

    @Override
    public void elementChanged(ElementEvent e) throws RemoteException {
        RemoteObject element = e.getElement();
        System.out.println("elementChanged " + element);
    }

    @Override
    public void startDiscovering(ElementEvent e) throws RemoteException {
        RemoteObject element = e.getElement();
        System.out.println("startDiscovering " + element);
    }

    @Override
    public void discoverCompleted(ElementEvent e) throws RemoteException {
        RemoteObject element = e.getElement();
        System.out.println("discoverCompleted " + element);
    }

    @Override
    public void connectionTimeOut(ElementEvent e) throws RemoteException {
        RemoteObject element = e.getElement();
        System.out.println("connectionTimeOut " + element);
    }

    @Override
    public void configurationError(ElementEvent e) throws RemoteException {
        RemoteObject element = e.getElement();
        System.out.println("configurationError " + element);
    }

    @Override
    public void fatalConfigurationError(ElementEvent e) throws RemoteException {
        RemoteObject element = e.getElement();
        System.out.println("fatalConfigurationError " + element);
    }

    @Override
    public void startManualDiscovering(ElementEvent e) throws RemoteException {
        RemoteObject element = e.getElement();
        System.out.println("startManualDiscovering " + element);
    }

    @Override
    public void startReset(ElementEvent e) throws RemoteException {
        RemoteObject element = e.getElement();
        System.out.println("startReset " + element);
    }

    @Override
    public void alreadyKnownByVSwitch(ElementEvent e) throws RemoteException {
        RemoteObject element = e.getElement();
        System.out.println("alreadyKnownByVSwitch " + element);
    }

    @Override
    public void fireElementRemoveFromVSwitch(ElementEvent e) throws RemoteException {
        RemoteObject element = e.getElement();
        System.out.println("fireElementRemoveFromVSwitch " + element);
    }

    @Override
    public void alarmOpened(AlarmEvent e) throws RemoteException {
        GeneralLogicObject element = e.getSourceObject();
        System.out.println("alarmOpened " + element);
    }

    @Override
    public void alarmClosed(AlarmEvent e) throws RemoteException {
        GeneralLogicObject element = e.getSourceObject();
        System.out.println("alarmClosed " + element);
    }

    @Override
    public void alarmChanged(AlarmEvent e) throws RemoteException {
        GeneralLogicObject element = e.getSourceObject();
        System.out.println("alarmChanged " + element);
    }

    @Override
    public void propagatedStateChanged(PropagatedStateEvent e) throws RemoteException {
        GeneralLogicObject element = e.getSourceObject();
        System.out.println("propagatedStateChanged " + element);
    }

    @Override
    public void snmpError(ElementEvent e) throws RemoteException {
        RemoteObject element = e.getElement();
        System.out.println("snmpError " + element);
    }

    @Override
    public void checkConnectivity() throws RemoteException {
        System.out.println("checkConnectivity");
    }

    @Override
    public void serverWasShutdown(ElementEvent e) throws RemoteException {
        RemoteObject element = e.getElement();
        System.out.println("serverWasShutdown " + element);
    }

    @Override
    public String hashKey() throws RemoteException {
        return null;
    }

    @Override
    public void drDiscoveryStarted(ElementEvent e) throws RemoteException {
    }

    @Override
    public void drDiscoveryCompleted(ElementEvent e) throws RemoteException {
    }

    @Override
    public void systemDiscoveryCompleted(ElementEvent e) throws RemoteException {
    }

    private void createSites() throws RemoteException, IllegalValueException {
        String local = "local";
        String remote = "remote";
        this.systemRoot.createSite(local);
        this.systemRoot.createSite(remote);
    }

    private Site getSite(String role) throws RemoteException {
        ArrayList sites = this.systemRoot.getSites();
        for (int i = 0; i < sites.size(); ++i) {
            if (!((Site)sites.get(i)).getAlias().equals(role)) continue;
            return (Site)sites.get(i);
        }
        return null;
    }

    private CommKeyClassId createVolume(Cluster cluster) {
        return null;
    }
}

