/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.FixedPortRMISocketFactory;
import com.sanrad.nms.server.Server;
import com.sanrad.nms.server.SrSocketFactory;
import java.io.IOException;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.UnicastRemoteObject;

public abstract class AbstractBoundedStub
implements Remote {
    protected static SrLogger theLogger = SrLogger.getLogger();

    protected AbstractBoundedStub() {
        try {
            if (RMISocketFactory.getSocketFactory() == null) {
                RMISocketFactory.setSocketFactory(new FixedPortRMISocketFactory());
            }
        }
        catch (IOException ioe) {
            theLogger.error(SrLogCategories.EXCEPTION, ioe, new Object[0]);
        }
    }

    public void bindToRMIRegistry(Registry registry, String aRegName) throws RemoteException {
        String hostname = Server.getHostAddress();
        int exportPort = Server.getRMIExportPort();
        if (exportPort > 0) {
            UnicastRemoteObject.exportObject(this, exportPort, new SrSocketFactory(hostname), new SrSocketFactory(hostname));
            theLogger.trace(SrLogCategories.LEGACY, this, " was exported via port ", exportPort);
        } else {
            UnicastRemoteObject.exportObject(this);
            theLogger.trace(SrLogCategories.LEGACY, this, " was exported via \"any\" (no special) port ");
        }
        String serverObjectName = aRegName;
        theLogger.trace(SrLogCategories.LEGACY, "Trying to bind ", this, " to ", serverObjectName);
        try {
            registry.bind(serverObjectName, this);
        }
        catch (AccessException ae) {
            theLogger.fatal(SrLogCategories.LEGACY, ae, new Object[0]);
        }
        catch (AlreadyBoundException abe) {
            theLogger.fatal(SrLogCategories.LEGACY, abe, new Object[0]);
        }
        theLogger.trace(SrLogCategories.LEGACY, this, " binding to ", serverObjectName, " succeeded");
    }
}

