/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.log;

import com.sanrad.log.SrLogger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.RollingFileAppender;

public class SrRollingFileAppender
extends RollingFileAppender {
    private final int myZipBuffer = 2048;

    public void rollOver() {
        String newFileName = "";
        String newFileExt = "";
        String[] fileNameParts = this.fileName.split("\\.");
        if (fileNameParts == null || fileNameParts.length < 2) {
            newFileName = this.fileName;
        } else {
            newFileName = fileNameParts[0];
            newFileExt = "." + fileNameParts[1];
        }
        if (this.maxBackupIndex > 0) {
            File target;
            File file = new File(newFileName + '.' + this.maxBackupIndex + newFileExt);
            if (file.exists()) {
                file.delete();
            }
            for (int i = this.maxBackupIndex - 1; i >= 1; --i) {
                file = new File(newFileName + "." + i + newFileExt);
                if (!file.exists()) continue;
                target = new File(newFileName + '.' + (i + 1) + newFileExt);
                file.renameTo(target);
            }
            target = new File(newFileName + ".1" + newFileExt);
            this.closeFile();
            file = new File(this.fileName);
            file.renameTo(target);
        }
        try {
            this.setFile(this.fileName, false, this.bufferedIO, this.bufferSize);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.zipFiles();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void zipFiles() throws IOException {
        List<String> files = this.getFilesForZipping();
        this.zipFiles(files);
    }

    public void zipAllFiles() throws IOException {
        List<String> files = this.getAllFiles();
        this.zipFiles(files);
    }

    private void zipFiles(List<String> aFiles) throws IOException {
        if (aFiles.isEmpty()) {
            return;
        }
        BufferedInputStream origin = null;
        byte[] data = new byte[2048];
        String zipDir = this.getLogDirectory();
        FileOutputStream dest = new FileOutputStream(this.getZipFileName());
        ZipOutputStream outFile = new ZipOutputStream(new BufferedOutputStream(dest));
        for (String curFile : aFiles) {
            int count;
            FileInputStream fileIn = new FileInputStream(zipDir + File.separator + curFile);
            origin = new BufferedInputStream(fileIn, 2048);
            ZipEntry entry = new ZipEntry(curFile);
            outFile.putNextEntry(entry);
            while ((count = origin.read(data, 0, 2048)) != -1) {
                outFile.write(data, 0, count);
            }
            origin.close();
            fileIn.close();
            File fileToDelete = new File(zipDir + File.separator + curFile);
            fileToDelete.delete();
        }
        outFile.close();
        while (this.removeOneZipFile(zipDir, this.getLogNameAndExtension().split("\\.")[0])) {
        }
    }

    private boolean removeOneZipFile(String aDir, String aFileName) {
        if (aDir == null || aFileName == null || aDir.equals("") || aFileName.equals("")) {
            assert (false) : "The given parameters are invalid.";
            return false;
        }
        File dir = new File(aDir);
        if (dir == null) {
            return false;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return false;
        }
        long minModTime = Long.MAX_VALUE;
        int deleteIndex = -1;
        int zipCount = 0;
        for (int index = 0; index < files.length; ++index) {
            if (files[index] == null) {
                assert (false) : "You do not have sufficient permissions to read the files from the directory: " + aDir;
                continue;
            }
            String curFileName = this.getFileNameAndExtension(files[index].getName());
            if (!curFileName.startsWith(aFileName) || !curFileName.endsWith("zip")) continue;
            ++zipCount;
            if (minModTime <= files[index].lastModified()) continue;
            minModTime = files[index].lastModified();
            deleteIndex = index;
        }
        if (deleteIndex != -1 && files[deleteIndex] != null && zipCount > SrLogger.getNumOfZipFiles()) {
            files[deleteIndex].delete();
            return true;
        }
        return false;
    }

    private List<String> getAllFiles() {
        File[] files;
        ArrayList<String> retList = new ArrayList<String>();
        if (this.fileName == null) {
            return retList;
        }
        String logFileName = this.getLogNameAndExtension();
        String newFileName = "";
        String newFileExt = "";
        String[] fileNameParts = logFileName.split("\\.");
        if (fileNameParts == null || fileNameParts.length < 2) {
            newFileName = this.fileName;
        } else {
            newFileName = fileNameParts[0];
            newFileExt = "." + fileNameParts[1];
        }
        String matchString = newFileName + ".([0-9])+" + newFileExt;
        File dir = new File(this.getLogDirectory());
        if (dir == null) {
            return retList;
        }
        for (File curFile : files = dir.listFiles()) {
            String curFileName;
            if (curFile == null || (curFileName = this.getFileNameAndExtension(curFile.getName())) == null || !curFileName.matches(matchString) && !curFileName.equals(newFileName + newFileExt) || curFile.length() <= 0L) continue;
            retList.add(curFile.getName());
        }
        return retList;
    }

    private List<String> getFilesForZipping() {
        List<String> retList = new ArrayList<String>();
        String logFileName = this.getLogNameAndExtension();
        String newFileName = "";
        String newFileExt = "";
        String[] fileNameParts = logFileName.split("\\.");
        if (fileNameParts == null || fileNameParts.length < 2) {
            newFileName = this.fileName;
        } else {
            newFileName = fileNameParts[0];
            newFileExt = "." + fileNameParts[1];
        }
        String matchString = newFileName + ".([0-9])+" + newFileExt;
        File dir = new File(this.getLogDirectory());
        if (dir == null) {
            return retList;
        }
        File[] files = dir.listFiles();
        ArrayList<String> tmpList = new ArrayList<String>();
        for (File curFile : files) {
            String curFileName;
            if (curFile == null || !(curFileName = this.getFileNameAndExtension(curFile.getName())).matches(matchString) || curFile.length() <= 0L) continue;
            tmpList.add(curFile.getName());
        }
        int zipNumFiles = SrLogger.getNumOfFilesInZip();
        retList = this.getLastFiles(tmpList, zipNumFiles, newFileName, newFileExt);
        if (!retList.contains(newFileName + "." + this.maxBackupIndex + newFileExt)) {
            return new ArrayList<String>();
        }
        return retList;
    }

    private List<String> getLastFiles(List<String> aFiles, int aNum, String aFileName, String aExtension) {
        ArrayList<String> retList = new ArrayList<String>();
        if (aFiles == null || aFileName == null || aExtension == null || aFileName.equals("") || aExtension.equals("")) {
            return retList;
        }
        if (aFileName.length() == 0) {
            return retList;
        }
        for (int index = this.maxBackupIndex; index > 0; --index) {
            String curFile = aFileName + "." + index + aExtension;
            if (aFiles.contains(curFile)) {
                retList.add(curFile);
            }
            if (retList.size() == aNum) break;
        }
        return retList;
    }

    private String getZipFileName() {
        String zipFileName = this.getLogDirectory();
        String noExtension = this.getLogNameAndExtension().split("\\.")[0];
        zipFileName = zipFileName + File.separator + noExtension;
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
        String curTimeStr = formatter.format(new Date());
        zipFileName = zipFileName + "_" + curTimeStr + ".zip";
        return zipFileName;
    }

    private String getLogDirectory() {
        int unixSeperPlace;
        if (this.fileName == null) {
            return null;
        }
        int winSeperPlace = this.fileName.lastIndexOf(92);
        int lastChar = winSeperPlace > (unixSeperPlace = this.fileName.lastIndexOf(47)) ? winSeperPlace : unixSeperPlace;
        String retStr = this.fileName.substring(0, lastChar);
        return retStr;
    }

    private String getLogNameAndExtension() {
        return this.getFileNameAndExtension(this.fileName);
    }

    private String getFileNameAndExtension(String aFile) {
        int unixSeperPlace;
        if (aFile == null || aFile.equals("")) {
            return "";
        }
        int winSeperPlace = aFile.lastIndexOf(92);
        int lastChar = winSeperPlace > (unixSeperPlace = aFile.lastIndexOf(47)) ? winSeperPlace : unixSeperPlace;
        String retStr = aFile.substring(lastChar + 1);
        return retStr;
    }
}

