/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.log;

import com.sanrad.log.EmptyOutputStream;
import java.io.PrintStream;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class LoggerStream
extends PrintStream {
    private Logger logger;
    private Level level;
    private ThreadLocal recursiveCheck = new ThreadLocal();

    public LoggerStream(Logger logger) {
        this(logger, Level.INFO);
    }

    public LoggerStream(Logger logger, Level level) {
        super(new EmptyOutputStream());
        this.logger = logger;
        this.level = level;
    }

    @Override
    public void println(String aMsg) {
        if (aMsg == null) {
            aMsg = "null";
        }
        byte[] bytes = aMsg.getBytes();
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public void println(Object aMsg) {
        if (aMsg == null) {
            aMsg = "null";
        }
        byte[] bytes = aMsg.toString().getBytes();
        this.write(bytes, 0, bytes.length);
    }

    public void write(byte b) {
        byte[] bytes = new byte[]{b};
        this.write(bytes, 0, 1);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        Boolean recursed = (Boolean)this.recursiveCheck.get();
        if (recursed != null && recursed.equals(Boolean.TRUE)) {
            return;
        }
        while (len > 0 && (b[len - 1] == 10 || b[len - 1] == 13) && len > off) {
            --len;
        }
        if (len > 0) {
            String msg = new String(b, off, len);
            this.recursiveCheck.set(Boolean.TRUE);
            Level oldLevel = this.logger.getLevel();
            this.logger.setLevel(Level.ALL);
            this.logger.log((Priority)this.level, (Object)msg);
            this.logger.setLevel(oldLevel);
            this.recursiveCheck.set(Boolean.FALSE);
        }
    }
}

