/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.jmx;

import com.sun.jdmk.comm.HtmlAdaptorServer;
import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class SrHtmlAgent {
    private static final int JMX_PORT = 8000;
    private static String JMX_NAME_PREFIX = "VintageServer:name=";
    private static String JMX_TYPE_PREFIX = "VintageServer:type=";
    private static SrHtmlAgent theInstance = new SrHtmlAgent();
    private MBeanServer myMBeanServer = ManagementFactory.getPlatformMBeanServer();

    public static SrHtmlAgent getInstance() {
        return theInstance;
    }

    private SrHtmlAgent() {
        HtmlAdaptorServer adapter = new HtmlAdaptorServer();
        try {
            ObjectName adapterName = new ObjectName(JMX_NAME_PREFIX + "htmladapter,port=" + 8000);
            adapter.setPort(8000);
            System.out.println("The JMX HTML port is 8000");
            this.myMBeanServer.registerMBean(adapter, adapterName);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        adapter.start();
    }

    void registerMBean(String aName, Object aMBean) {
        this.registerBean(aName, aMBean, JMX_NAME_PREFIX);
    }

    void unregisterMBean(String aName) {
        this.unregisterBean(aName, JMX_NAME_PREFIX);
    }

    void registerMXBean(String aName, Object aMXBean) {
        this.registerBean(aName, aMXBean, JMX_TYPE_PREFIX);
    }

    void unregisterMXBean(String aName) {
        this.unregisterBean(aName, JMX_TYPE_PREFIX);
    }

    private void registerBean(String aName, Object aBean, String aPrefix) {
        if (aName == null || aBean == null) {
            throw new IllegalArgumentException("The given arguments should not be null. aName = " + aName + "; aBean = " + aBean);
        }
        String newName = this.convertName(aName);
        try {
            ObjectName beanName = new ObjectName(aPrefix + newName);
            this.myMBeanServer.registerMBean(aBean, beanName);
        }
        catch (InstanceAlreadyExistsException exp) {
            System.out.println("The Bean: " + aBean + " is already registered.");
            exp.printStackTrace();
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    private String convertName(String aName) {
        String retVal = aName.replace(':', '_');
        retVal = retVal.replace(',', '_');
        return retVal;
    }

    private void unregisterBean(String aName, String aPrefix) {
        if (aName == null) {
            throw new IllegalArgumentException("The given arguments should not be null");
        }
        String newName = this.convertName(aName);
        try {
            ObjectName beanName = new ObjectName(aPrefix + newName);
            this.myMBeanServer.unregisterMBean(beanName);
        }
        catch (InstanceNotFoundException exp) {
            System.out.println("The Bean: " + aName + " was not found in the registered beans.");
            exp.printStackTrace();
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }
}

