/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad;

import com.sanrad.SrTestUtils;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.target.Target;
import com.sanrad.nms.server.logic.volume.CubeVolume;
import com.sanrad.nms.server.logic.volume.Volume;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.util.concurrent.IFuture;
import java.rmi.RemoteException;
import java.util.concurrent.ExecutionException;

public class SrVolumeTestUtils {
    public void exposeVolume(VolumeNode aVolume, int aLun, Target aTarget) throws RemoteException {
        if (aLun < 0 || aVolume == null || aVolume.equals("") || aTarget == null) {
            assert (false) : "The given parameters are invalid. aVolume = " + aVolume + "; aLun = " + aLun + "; aTarget = " + aTarget;
            return;
        }
        this.exposeVolume(aVolume, aLun, aTarget.getName());
    }

    public void exposeVolume(VolumeNode aVolume, int aLun, String aTargetName) throws RemoteException {
        block10: {
            if (aLun < 0 || aVolume == null || aVolume.equals("") || aTargetName == null || aTargetName.equals("")) {
                assert (false) : "The given parameters are invalid. aVolume = " + aVolume + "; aLun = " + aLun + "; aTargetName = " + aTargetName;
                return;
            }
            Cluster curCluster = aVolume.getCluster();
            if (curCluster == null) {
                assert (false) : "Can not find the cluster for the given volume";
                return;
            }
            Target target = SrTestUtils.getInstance().getTarget(curCluster, aTargetName);
            if (target == null) {
                assert (false) : "Can not find the given target.";
                return;
            }
            IFuture<Void> actionFuture = SrTestUtils.getInstance().getServerLogic().exposeVolume(curCluster.getStorage().hashKey(), aLun, aVolume.getCommKeyClassId(), target.getCommKeyClassId());
            try {
                actionFuture.get();
            }
            catch (InterruptedException exp) {
                assert (false) : "Could not expose the volume because of the following exception: " + exp;
            }
            catch (ExecutionException exp) {
                if ($assertionsDisabled) break block10;
                throw new AssertionError((Object)("Could not expose the volume because of the following exception: " + exp));
            }
        }
    }

    public Volume getVolumeByAlias(Cluster aCluster, String aAlias) {
        Volume retVol;
        block8: {
            if (aCluster == null || aAlias == null || aAlias.equals("")) {
                assert (false) : "The parameters are invalid. aCluster = " + aCluster + "; aAlias = " + aAlias;
                return null;
            }
            retVol = null;
            try {
                retVol = SrTestUtils.getInstance().getServerLogic().getExposedOrUnexposedVolumeByAlias(aCluster.getStorage().hashKey(), aAlias).get();
            }
            catch (RemoteException exp) {
                assert (false) : "The volume could not be found because of the following exception: " + exp;
            }
            catch (InterruptedException exp) {
                assert (false) : "The volume could not be found because of the following exception: " + exp;
            }
            catch (ExecutionException exp) {
                if ($assertionsDisabled) break block8;
                throw new AssertionError((Object)("The volume could not be found because of the following exception: " + exp));
            }
        }
        return retVol;
    }

    public void removeVolume(Cluster aCluster, VolumeNode aVolume) {
        block8: {
            if (aCluster == null || aVolume == null) {
                assert (false) : "The parameters are invalid. aCluster = " + aCluster + "; aVolume = " + aVolume;
                return;
            }
            try {
                IFuture<Void> actionFuture = SrTestUtils.getInstance().getServerLogic().deleteElement(aVolume.getCommKeyClassId());
                actionFuture.get();
            }
            catch (RemoteException exp) {
                assert (false) : "The removal operation could not be completed because of the following exception: " + exp;
            }
            catch (InterruptedException exp) {
                assert (false) : "The removal operation could not be completed because of the following exception: " + exp;
            }
            catch (ExecutionException exp) {
                if ($assertionsDisabled) break block8;
                throw new AssertionError((Object)("The removal operation could not be completed because of the following exception: " + exp));
            }
        }
    }

    public void resizeVolume(VolumeNode aSource, VolumeNode aExtension, String aCubeName) throws RemoteException {
        block6: {
            if (aSource == null || aExtension == null || aCubeName == null || aCubeName.equals("")) {
                assert (false) : "The parameters are invalid. aSource = " + aSource + "; aExtension = " + aExtension + "; aCubeName = " + aCubeName;
                return;
            }
            IFuture<Void> actionFuture = SrTestUtils.getInstance().getServerLogic().resize(aSource.getCommKeyClassId(), aExtension.getCommKeyClassId(), aCubeName);
            try {
                actionFuture.get();
            }
            catch (InterruptedException exp) {
                assert (false) : "The resize operation could not be completed because of the following exception: " + exp;
            }
            catch (ExecutionException exp) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError((Object)("The resize operation could not be completed because of the following exception: " + exp));
            }
        }
    }

    public void retractVolume(Cluster aCluster, String aCubeName) throws RemoteException {
        block6: {
            if (aCluster == null || aCubeName == null || aCubeName.equals("")) assert (false) : "The parameters are invalid. aCluster = " + aCluster + "; aCubeName = " + aCubeName;
            Volume cube = this.getVolumeByAlias(aCluster, aCubeName);
            if (cube == null) assert (false) : "The given cube alias could not be found or is not a cube.";
            try {
                SrTestUtils.getInstance().getServerLogic().retract(((CubeVolume)cube).getCommKeyClassId()).get();
            }
            catch (InterruptedException exp) {
                assert (false) : "The retract operation could not be completed because of the following exception: " + exp;
            }
            catch (ExecutionException exp) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError((Object)("The retract operation could not be completed because of the following exception: " + exp));
            }
        }
    }
}

