/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad;

import com.sanrad.SrCliTestUtils;
import com.sanrad.SrClusterTestUtils;
import com.sanrad.SrConcatTestUtils;
import com.sanrad.SrCopyOpTestUtils;
import com.sanrad.SrJournalTestUtils;
import com.sanrad.SrMirrorTestUtils;
import com.sanrad.SrPairTestUtils;
import com.sanrad.SrSimpleVolTestUtils;
import com.sanrad.SrSiteTestUtils;
import com.sanrad.SrSnapshotTestUtils;
import com.sanrad.SrStorageTestUtils;
import com.sanrad.SrStripeTestUtils;
import com.sanrad.SrTargetTestUtils;
import com.sanrad.SrUserTestUtils;
import com.sanrad.SrVolumeTestUtils;
import com.sanrad.TestServerEventsListener;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.Server;
import com.sanrad.nms.server.SrServerBundleKeys;
import com.sanrad.nms.server.alarm.AlarmType;
import com.sanrad.nms.server.comm.database.DatabaseManager;
import com.sanrad.nms.server.comm.snmp.SnmpVersion;
import com.sanrad.nms.server.logic.LogicMgrAOImpl;
import com.sanrad.nms.server.logic.ServerFacade;
import com.sanrad.nms.server.logic.Site;
import com.sanrad.nms.server.logic.SystemRoot;
import com.sanrad.nms.server.logic.SystemRootImpl;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.dr.DRAsyncPair;
import com.sanrad.nms.server.logic.dr.DRPair;
import com.sanrad.nms.server.logic.dr.DRSyncPair;
import com.sanrad.nms.server.logic.identity.CHAPCredentials;
import com.sanrad.nms.server.logic.identity.Credentials;
import com.sanrad.nms.server.logic.identity.Identity;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDevice;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDevice;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.target.Target;
import com.sanrad.nms.server.logic.volume.Volume;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.volume.copy.CopyOperation;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.user.User;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.util.SrConstantsBundleKeys;
import com.sanrad.util.SrResourceBundle;
import com.sanrad.util.Util;
import com.sanrad.util.concurrent.SrExecutionException;
import com.sanrad.util.concurrent.SrFuture;
import java.io.File;
import java.io.FileInputStream;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.ExecutionException;

public class SrTestUtils {
    public static SrResourceBundle CONSTANSTS_BUNDLE = SrResourceBundle.getInstance("constants", Locale.US);
    private static final String PRODUCT_NAME = CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.PRODUCT_NAME);
    public static SrResourceBundle VENDOR_BUNDLE = SrResourceBundle.getInstance(SrResourceBundle.DEFAULT_VENDOR_SERVER_BUNDLE_NAME, Locale.US);
    public static final int NUM_OF_RETRIES = 10;
    public static final long RETRY_INTERVAL_IN_MILLISEC = 5000L;
    public static final long VS_TIMEOUT_IN_MILLISEC = 15000L;
    private TestServerEventsListener myListener = null;
    private SrStorageTestUtils myStorageUtil = null;
    private SrSimpleVolTestUtils mySimpleVolUtil = null;
    private SrCopyOpTestUtils myCopyOpUtil = null;
    private SrMirrorTestUtils myMirrorUtil = null;
    private SrTargetTestUtils myTargetUtil = null;
    private SrVolumeTestUtils myVolumeUtil = null;
    private SrSnapshotTestUtils mySnapshotUtil = null;
    private SrConcatTestUtils myConcatUtil = null;
    private SrStripeTestUtils myStripeUtil = null;
    private SrJournalTestUtils myJournalUtil = null;
    private SrPairTestUtils myPairUtil = null;
    private SrSiteTestUtils mySiteUtil = null;
    private SrClusterTestUtils myClusterUtil = null;
    private SrUserTestUtils myUserUtil = null;
    private SrCliTestUtils myCliUtil = null;
    private ServerFacade myServer = null;
    private Properties myGeneralProperties = new Properties();
    private static SrTestUtils theInstance = new SrTestUtils();
    private SystemRoot mySystemRoot;

    protected SrTestUtils() {
        SrLogger.init(new Properties());
        try {
            this.myGeneralProperties.load(new FileInputStream("test//config//general.properties"));
            this.backupSanXml();
            this.initServer();
            this.myListener = new TestServerEventsListener(1);
            this.myServer = LogicMgrAOImpl.getInstance().openSession(this.myListener);
            this.mySystemRoot = SystemRootImpl.getInstance();
            this.myServer.rediscover(this.mySystemRoot.getCommKeyClassId()).get();
            this.myStorageUtil = new SrStorageTestUtils();
            this.mySimpleVolUtil = new SrSimpleVolTestUtils();
            this.myCopyOpUtil = new SrCopyOpTestUtils();
            this.myMirrorUtil = new SrMirrorTestUtils();
            this.myTargetUtil = new SrTargetTestUtils();
            this.myVolumeUtil = new SrVolumeTestUtils();
            this.mySnapshotUtil = new SrSnapshotTestUtils();
            this.myConcatUtil = new SrConcatTestUtils();
            this.myStripeUtil = new SrStripeTestUtils();
            this.myJournalUtil = new SrJournalTestUtils();
            this.myPairUtil = new SrPairTestUtils();
            this.mySiteUtil = new SrSiteTestUtils();
            this.myClusterUtil = new SrClusterTestUtils();
            this.myUserUtil = new SrUserTestUtils();
            this.myCliUtil = new SrCliTestUtils();
            while (!SystemRootImpl.getInstance().isDiscoverCompleted()) {
                Thread.sleep(100L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static SrTestUtils getInstance() {
        return theInstance;
    }

    public void initServer() {
        block7: {
            SrLogger.init(new Properties());
            if (Util.lockApplicationInstanceIfNotActive(".lock")) {
                System.err.println(PRODUCT_NAME + " already runs");
                System.exit(0);
            }
            AlarmType.removeIfNonSupportedAlarm(VENDOR_BUNDLE.getString(SrServerBundleKeys.MismSFP), SrServerBundleKeys.MismSFP.getKey());
            DatabaseManager.getInstance().convertOldDatabaseToNewDatabaseAndDeleteOldFile();
            try {
                SrFuture<Void> initFuture = LogicMgrAOImpl.getInstance().systemDiscovery();
                initFuture.get();
            }
            catch (InterruptedException exp) {
                assert (false) : "Could not initiate the server because of the following exception: " + exp;
            }
            catch (ExecutionException exp) {
                if ($assertionsDisabled) break block7;
                throw new AssertionError((Object)("Could not initiate the server because of the following exception: " + exp));
            }
        }
        try {
            Runtime.getRuntime().addShutdownHook(new Thread("Shutdown"){

                @Override
                public void run() {
                    SrTestUtils.this.restoreSanXml();
                }
            });
        }
        catch (SecurityException se) {
            se.printStackTrace();
        }
    }

    public List<ClusterImpl> getClusters() {
        ArrayList<ClusterImpl> retList = new ArrayList<ClusterImpl>();
        ArrayList clusters = null;
        if (this.mySystemRoot == null) {
            return retList;
        }
        try {
            clusters = this.mySystemRoot.getClusters();
            List<Site> sites = this.getAllSites();
            if (sites != null) {
                for (Site curSite : sites) {
                    ArrayList siteClusters = curSite.getClusters();
                    for (Object curObj : siteClusters) {
                        if (!(curObj instanceof Cluster)) continue;
                        clusters.add(curObj);
                    }
                }
            }
        }
        catch (RemoteException e) {
            assert (false) : "The clusters could not be queried.";
            return retList;
        }
        if (clusters == null || clusters.size() == 0) {
            assert (false) : "The clusters could not be queried.";
            return retList;
        }
        for (Object curCluster : clusters) {
            if (!(curCluster instanceof Cluster)) {
                assert (false) : "The cluster list contains in invalid object.";
                continue;
            }
            retList.add((ClusterImpl)curCluster);
        }
        return retList;
    }

    public List<SubDirectAccessDevice> getAllSubDisks(ClusterImpl aCluster) {
        return this.myStorageUtil.getAllSubDisks(aCluster);
    }

    public List<SubDirectAccessDevice> getAllSubDisksForDisk(DirectAccessDevice aDisk) {
        return this.myStorageUtil.getAllSubDisksForDisk(aDisk);
    }

    public List<DirectAccessDeviceImpl> getAllDisks(ClusterImpl aCluster) {
        return this.myStorageUtil.getAllDisks(aCluster);
    }

    public DirectAccessDevice getDiskByAlias(Cluster aCluster, String aAlias) {
        return this.myStorageUtil.getDiskByAlias(aCluster, aAlias);
    }

    public boolean isDiskUsed(DirectAccessDevice aDisk) {
        return this.myStorageUtil.isDiskUsed(aDisk);
    }

    public boolean isSubDiskUsed(SubDirectAccessDevice aSubDisk) {
        return this.myStorageUtil.isSubDiskUsed(aSubDisk);
    }

    public boolean isSubDiskDefined(DirectAccessDevice aDisk) {
        return this.myStorageUtil.isSubDiskDefined(aDisk);
    }

    public SubDirectAccessDevice getSubDiskByAlias(Cluster aCluster, String aAlias) {
        return this.myStorageUtil.getSubDiskByAlias(aCluster, aAlias);
    }

    public Volume getVolumeByAlias(Cluster aCluster, String aAlias) {
        return this.myVolumeUtil.getVolumeByAlias(aCluster, aAlias);
    }

    public SubDirectAccessDeviceImpl createSubDisk(DirectAccessDevice aDisk, String aAlias, BigInteger aSize) {
        return this.myStorageUtil.createSubDisk(aDisk, aAlias, aSize);
    }

    public VolumeNode createSnapshot(Cluster aCluster, VolumeNode aSource, VolumeNode aTarget, String aAlias) {
        return this.mySnapshotUtil.createSnapshot(aCluster, aSource, aTarget, aAlias);
    }

    public VolumeNode createJournal(ClusterImpl aCluster, VolumeNodeImpl aVolume, String aAlias, int aThreshold) {
        return this.myJournalUtil.createJournal(aCluster, aVolume, aAlias, aThreshold);
    }

    public void addChildToMirror(VolumeNode aMirror, CommKeyClassId aChild, boolean aAutoSync) {
        this.myMirrorUtil.addChildToMirror(aMirror, aChild, aAutoSync);
    }

    public VolumeNode createMirror(Cluster aCluster, CommKeyClassId[] aChildren, String aAlias) {
        return this.myMirrorUtil.createMirror(aCluster, aChildren, aAlias);
    }

    public void removeMirror(Cluster aCluster, VolumeNode aVolume) {
        this.myMirrorUtil.removeMirror(aCluster, aVolume);
    }

    public void removeConcat(Cluster aCluster, VolumeNode aVolume) {
        this.myConcatUtil.removeConcat(aCluster, aVolume);
    }

    public void removeJournal(Cluster aCluster, VolumeNode aVolume) {
        this.myJournalUtil.removeJournal(aCluster, aVolume);
    }

    public void removeStripe(Cluster aCluster, VolumeNode aVolume) {
        this.myStripeUtil.removeStripe(aCluster, aVolume);
    }

    public void removeTransparent(Cluster aCluster, VolumeNode aVolume) {
        this.myStorageUtil.removeTransparent(aCluster, aVolume);
    }

    public void removeSnapshot(Cluster aCluster, VolumeNode aVolume) {
        this.mySnapshotUtil.removeSnapshot(aCluster, aVolume);
    }

    public void removeVolume(Cluster aCluster, VolumeNode aVolume) {
        this.myVolumeUtil.removeVolume(aCluster, aVolume);
    }

    public void removeIdentity(Identity aIden) {
        this.myTargetUtil.removeIdentity(aIden);
    }

    public void removeSubDisk(Cluster aCluster, String aAlias) throws RemoteException {
        this.myStorageUtil.removeSubDisk(aCluster, aAlias);
    }

    public void removeSubDisk(SubDirectAccessDevice aSubDisk) throws RemoteException {
        this.myStorageUtil.removeSubDisk(aSubDisk);
    }

    public void exposeVolume(VolumeNode aVolume, int aLun, Target aTarget) throws RemoteException {
        this.myVolumeUtil.exposeVolume(aVolume, aLun, aTarget);
    }

    public void exposeVolume(VolumeNode aVolume, int aLun, String aTargetName) throws RemoteException {
        this.myVolumeUtil.exposeVolume(aVolume, aLun, aTargetName);
    }

    public String getSimpleVolByPhysStor(ClusterImpl aCluster, CommKeyClassId aPhysStor) {
        return this.mySimpleVolUtil.getSimpleVolByPhysStor(aCluster, aPhysStor);
    }

    public void removeTarget(Target aTarget) {
        this.myTargetUtil.removeTarget(aTarget);
    }

    public Target createNewTarget(ClusterImpl aCluster, String aTargetName) {
        return this.myTargetUtil.createNewTarget(aCluster, aTargetName);
    }

    public Identity createNewIdentity(Cluster aCluster, String aAlias, String aDescription) {
        return this.myTargetUtil.createNewIdentity(aCluster, aAlias, aDescription);
    }

    public Identity getIdentity(Cluster aCluster, String aIdentityAlias) {
        return this.myTargetUtil.getIdentity(aCluster, aIdentityAlias);
    }

    public Target createNewTarget(ClusterImpl aCluster, String aTargetName, String aAlias) {
        return this.myTargetUtil.createNewTarget(aCluster, aTargetName, aAlias);
    }

    public Target getTarget(Cluster aCluster, String aTargetName) {
        return this.myTargetUtil.getTarget(aCluster, aTargetName);
    }

    public CHAPCredentials createChapCredential(Identity aIden, String aName, String aPassword, boolean aIsRadiusEnabled) {
        return this.myTargetUtil.createChapCredential(aIden, aName, aPassword, aIsRadiusEnabled);
    }

    public void removeChapCredentials(CHAPCredentials aCredentials) {
        this.myTargetUtil.removeChapCredentials(aCredentials);
    }

    public Credentials getCredentials(Identity aIden, String aName) throws RemoteException {
        return this.myTargetUtil.getCredentials(aIden, aName);
    }

    public CommKeyClassId getPhysStorBySimpleVol(ClusterImpl aCluster, String aSimpleVol) {
        return this.mySimpleVolUtil.getPhysStorBySimpleVol(aCluster, aSimpleVol);
    }

    public VolumeNode createStripe(Cluster aCluster, CommKeyClassId[] aChildren, String aAlias, BigInteger aSize) {
        return this.myStripeUtil.createStripe(aCluster, aChildren, aAlias, aSize);
    }

    public VolumeNode createConcat(Cluster aCluster, CommKeyClassId[] aChildren, String aAlias) {
        return this.myConcatUtil.createConcat(aCluster, aChildren, aAlias);
    }

    public VolumeNode createTransparent(Cluster aCluster, String aAlias, DirectAccessDevice aDisk) {
        return this.myStorageUtil.createTransparent(aCluster, aAlias, aDisk);
    }

    public List<DirectAccessDeviceImpl> getUnusedDisks(ClusterImpl aCluster, int aNumOfDisks) {
        return this.myStorageUtil.getUnusedDisks(aCluster, aNumOfDisks);
    }

    public CopyOperation createOfflineCopy(VolumeNode aSource, VolumeNode aDestination) {
        return this.myCopyOpUtil.createOfflineCopy(aSource, aDestination);
    }

    public CopyOperation getCopyOperation(Cluster aCluster, VolumeNode aSource, VolumeNode aDestination) {
        return this.myCopyOpUtil.getCopyOperation(aCluster, aSource, aDestination);
    }

    public void removeCopyOperation(CopyOperation aCopyOp) {
        this.myCopyOpUtil.removeCopyOperation(aCopyOp);
    }

    public void retractVolume(Cluster aCluster, String aCubeName) throws RemoteException {
        this.myVolumeUtil.retractVolume(aCluster, aCubeName);
    }

    public void resizeVolume(VolumeNode aSource, VolumeNode aExtension, String aCubeName) throws RemoteException {
        this.myVolumeUtil.resizeVolume(aSource, aExtension, aCubeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForVS() {
        SrTestUtils srTestUtils = this;
        synchronized (srTestUtils) {
            block5: {
                try {
                    this.wait(15000L);
                }
                catch (InterruptedException e) {
                    if ($assertionsDisabled) break block5;
                    throw new AssertionError((Object)"Could not wait for the timeout to complete.");
                }
            }
        }
    }

    public DRSyncPair createSyncPair(VolumeNode primaryVolume, VolumeNode secondaryVolume, String localTarget, int localLun, String remoteTarget, int remoteLun) throws RemoteException {
        return this.myPairUtil.createSyncPair(primaryVolume, secondaryVolume, localTarget, localLun, remoteTarget, remoteLun);
    }

    public DRPair getPairByVolumes(VolumeNode aPrimary, VolumeNode aSecondary) {
        return this.myPairUtil.getPairByVolumes(aPrimary, aSecondary);
    }

    public DRAsyncPair createAsyncPair(VolumeNode aPrimaryVolume, VolumeNode aSecondaryVolume, String aLocalTarget, int aLocalLun, String aRemoteTarget, int aRemoteLun, CommKeyClassId aPrimarySnapshotId, CommKeyClassId aSecondarySnapshotId, HashMap aSecondarySnapshotParams, CommKeyClassId aPrimaryJournalId, CommKeyClassId aSecondaryJournalId, String aCG) throws RemoteException {
        return this.createAsyncPair(aPrimaryVolume, aSecondaryVolume, aLocalTarget, aLocalLun, aRemoteTarget, aRemoteLun, aPrimarySnapshotId, aSecondarySnapshotId, aSecondarySnapshotParams, aPrimaryJournalId, aSecondaryJournalId, aCG);
    }

    public List<Site> getAllSites() {
        ArrayList<Site> retList = new ArrayList<Site>();
        ArrayList sites = null;
        try {
            sites = this.mySystemRoot.getSites();
        }
        catch (RemoteException e) {
            assert (false) : "Could not access the server's sites list.";
            return retList;
        }
        if (sites == null) {
            assert (false) : "Could not access the server's sites list.";
            return retList;
        }
        for (Object curObj : sites) {
            if (curObj instanceof Site) {
                retList.add((Site)curObj);
                continue;
            }
            assert (false) : "The site list contained an instance which is not of a site type.";
        }
        return retList;
    }

    public SystemRoot getSystemRoot() {
        return this.mySystemRoot;
    }

    public ServerFacade getServerLogic() {
        return this.myServer;
    }

    public void removePair(DRPair aPair) {
        this.myPairUtil.removePair(aPair);
    }

    public void removePair(VolumeNode aPrimary, VolumeNode aSecondary) {
        this.myPairUtil.removePair(aPrimary, aSecondary);
    }

    public Site createSite(String aAlias) {
        return this.mySiteUtil.createSite(aAlias);
    }

    public void removeSite(Site aSite) {
        this.mySiteUtil.removeSite(aSite);
    }

    public Site getSite(String aAlias) {
        return this.mySiteUtil.getSite(aAlias);
    }

    public ClusterImpl createCluster(String aAlias, Site aSite) {
        return this.myClusterUtil.createCluster(aAlias, aSite);
    }

    public void removeCluster(Cluster aCluster) {
        this.myClusterUtil.removeCluster(aCluster);
    }

    public void removeUser(String aHash) {
        this.myUserUtil.removeUser(aHash);
    }

    public User addUser(String aName, String aPassword) {
        return this.myUserUtil.addUser(aName, aPassword);
    }

    public User getUser(String aName) {
        return this.myUserUtil.getUser(aName);
    }

    public static ConfigElementData generateClusterCED() {
        ConfigElementData clusterCED = new ConfigElementData(ClassID.CLUSTER);
        clusterCED.addParameter(ParameterCode.CLUSTER_ALIAS, "tmpCluster");
        clusterCED.addParameter(ParameterCode.PARENT_SITE_ID, null);
        clusterCED.addParameter(ParameterCode.GENERAL_POLL_INTERVAL, null);
        clusterCED.addParameter(ParameterCode.ISCSI_POLL_INTERVAL, null);
        clusterCED.addParameter(ParameterCode.VIRTUALIZATION_POLL_INTERVAL, null);
        clusterCED.addParameter(ParameterCode.ACL_POLL_INTERVAL, null);
        clusterCED.addParameter(ParameterCode.NET_POLL_INTERVAL, null);
        clusterCED.addParameter(ParameterCode.STATISTIC_POLL_INTERVAL, null);
        clusterCED.addParameter(ParameterCode.VSWITCH_GROUP_ID, null);
        clusterCED.addParameter(ParameterCode.PARENT_SITE_ID, null);
        return clusterCED;
    }

    public void activateSnapshots(Cluster aCluster, List<CommKeyClassId> aSnapshots) {
        this.mySnapshotUtil.activateSnapshots(aCluster, aSnapshots);
    }

    public void activateSnapshot(Cluster aCluster, VolumeNode aSnapshot) {
        this.mySnapshotUtil.activateSnapshot(aCluster, aSnapshot);
    }

    public void deactivateSnapshots(Cluster aCluster, List<CommKeyClassId> aSnapshots) {
        this.mySnapshotUtil.deactivateSnapshots(aCluster, aSnapshots);
    }

    public void deactivateSnapshot(Cluster aCluster, VolumeNode aSnapshot) {
        this.mySnapshotUtil.deactivateSnapshot(aCluster, aSnapshot);
    }

    public void cliRemoveNeighbor(String aHost, String aUser, String aPassword, String aNeighbor) {
        this.myCliUtil.cliRemoveNeighbor(aHost, aUser, aPassword, aNeighbor);
    }

    public void cliSetAsNeighbors(String aHost, String aNeighbor, String aUser, String aPassword) {
        this.myCliUtil.cliSetAsNeighbors(aHost, aNeighbor, aUser, aPassword);
    }

    public String cliGetNeighborIP(String aHost, String aUser, String aPassword) {
        return this.myCliUtil.cliGetNeighborIP(aHost, aUser, aPassword);
    }

    public SrCliTestUtils getCliTestUtil() {
        return this.myCliUtil;
    }

    public static ConfigElementData generateGeneralSCSIDeviceCED() {
        ConfigElementData gsdCED = new ConfigElementData(ClassID.GENERAL_SCSI_DEVICE);
        gsdCED.addParameter(ParameterCode.PHYSICAL_STORAGE_ALIAS, null);
        gsdCED.addParameter(ParameterCode.PHYSICAL_STORAGE_ENTITY_NAME, null);
        gsdCED.addParameter(ParameterCode.PHYSICAL_STORAGE_LUN, null);
        gsdCED.addParameter(ParameterCode.PHYSICAL_STORAGE_INFO, null);
        gsdCED.addParameter(ParameterCode.PHYSICAL_STORAGE_VENDOR_NAME, null);
        gsdCED.addParameter(ParameterCode.PHYSICAL_STORAGE_OPERATIONAL_STATUS, null);
        gsdCED.addParameter(ParameterCode.PHYSICAL_STORAGE_TRANSPORT_TYPE, null);
        gsdCED.addParameter(ParameterCode.PHYSICAL_STORAGE_TYPE, null);
        gsdCED.addParameter(ParameterCode.PHYSICAL_STORAGE_COM_ADMIN_STATUS, null);
        gsdCED.addParameter(ParameterCode.PHYSICAL_STORAGE_COM_OPER_STATUS, null);
        gsdCED.addParameter(ParameterCode.PHYSICAL_STORAGE_COM_DURATION, null);
        gsdCED.addParameter(ParameterCode.PHYSICAL_STORAGE_SERIAL_NUMBER, null);
        gsdCED.addParameter(ParameterCode.PHYSICAL_STORAGE_PRODUCT_ID, null);
        gsdCED.addParameter(ParameterCode.PHYSICAL_STORAGE_REVISION_LEVEL, null);
        gsdCED.addParameter(ParameterCode.PHYSICAL_STORAGE_SCSI_VER, null);
        gsdCED.addParameter(ParameterCode.PHYSICAL_STORAGE_LU_IDENTIFIER, null);
        gsdCED.addParameter(ParameterCode.VOLUME_STATE, null);
        gsdCED.addParameter(ParameterCode.VIRTUAL_VOLUME_MIRROR_SYNCH_OPER_STATUS, null);
        gsdCED.addParameter(ParameterCode.VIRTUAL_VOLUME_PARENT, null);
        gsdCED.addParameter(ParameterCode.VOLUME_POSITION, null);
        return gsdCED;
    }

    public static ConfigElementData generateVSwitchCED() {
        ConfigElementData vswitchCED = new ConfigElementData(ClassID.VSWITCH);
        vswitchCED.addParameter(ParameterCode.VSWITCH_SYS_OID, null);
        vswitchCED.addParameter(ParameterCode.VSWITCH_IP_ADDRESS, null);
        vswitchCED.addParameter(ParameterCode.VSWITCH_IP_MASK, null);
        vswitchCED.addParameter(ParameterCode.VSWITCH_READ_COMMUNITY, null);
        vswitchCED.addParameter(ParameterCode.VSWITCH_WRITE_COMMUNITY, null);
        vswitchCED.addParameter(ParameterCode.VSWITCH_SNMP_UDP_PORT, null);
        vswitchCED.addParameter(ParameterCode.VSWITCH_TRAP_UDP_PORT, null);
        vswitchCED.addParameter(ParameterCode.VSWITCH_SNMP_VERSION, null);
        vswitchCED.addParameter(ParameterCode.VSWITCH_MAX_RETRIES, null);
        vswitchCED.addParameter(ParameterCode.VSWITCH_TIMEOUT, null);
        vswitchCED.addParameter(ParameterCode.VSWITCH_CONTACT, null);
        vswitchCED.addParameter(ParameterCode.VSWITCH_DATE_AND_TIME, null);
        vswitchCED.addParameter(ParameterCode.VSWITCH_DESCRIPTION, null);
        vswitchCED.addParameter(ParameterCode.VSWITCH_LAST_RESET, null);
        vswitchCED.addParameter(ParameterCode.VSWITCH_LOCATION, null);
        vswitchCED.addParameter(ParameterCode.VSWITCH_NAME, null);
        vswitchCED.addParameter(ParameterCode.VSWITCH_CONNECTIVITY_STATUS, null);
        vswitchCED.addParameter(ParameterCode.VSWITCH_TELNET_PORT, null);
        vswitchCED.addParameter(ParameterCode.VSWITCH_LAST_KEEPALIVE, null);
        vswitchCED.addParameter(ParameterCode.VSWITCH_KEEPALIVE_INTERVAL, null);
        vswitchCED.addParameter(ParameterCode.VSWITCH_SUSPICIOUS_INTERVAL, null);
        vswitchCED.addParameter(ParameterCode.VSWITCH_FAULTY_INTERVAL, null);
        vswitchCED.addParameter(ParameterCode.VSWITCH_TAKE_OVER_STATE, null);
        vswitchCED.addParameter(ParameterCode.VSWITCH_FAILOVER_ENABLE, null);
        vswitchCED.addParameter(ParameterCode.VSWITCH_SWITCH_ID, null);
        vswitchCED.addParameter(ParameterCode.VSWITCH_REPORT_LUN_DISCOVERY, null);
        vswitchCED.addParameter(ParameterCode.VSWITCH_STATUS, null);
        vswitchCED.addParameter(ParameterCode.TEMPERATURE_UNITS, null);
        vswitchCED.addParameter(ParameterCode.GENERAL_POLL_INTERVAL, null);
        vswitchCED.addParameter(ParameterCode.ISCSI_POLL_INTERVAL, null);
        vswitchCED.addParameter(ParameterCode.VIRTUALIZATION_POLL_INTERVAL, null);
        vswitchCED.addParameter(ParameterCode.ACL_POLL_INTERVAL, null);
        vswitchCED.addParameter(ParameterCode.NET_POLL_INTERVAL, null);
        vswitchCED.addParameter(ParameterCode.STATISTIC_POLL_INTERVAL, null);
        vswitchCED.addParameter(ParameterCode.VSWITCH_CAPABILITY, null);
        vswitchCED.addParameter(ParameterCode.VSWITCH_LICENSE_PACK, null);
        vswitchCED.addParameter(ParameterCode.VSWITCH_TARGETS_COUNT, null);
        return vswitchCED;
    }

    public TestServerEventsListener getServerEventsListener() {
        return this.myListener;
    }

    public void backupSanXml() {
        File oldSanXml = new File("config\\san.xml.backup");
        if (oldSanXml.exists()) {
            oldSanXml.delete();
        }
        File sanXml = new File("config\\san.xml");
        sanXml.renameTo(oldSanXml);
    }

    public void restoreSanXml() {
        File oldFile = new File("config\\san.xml");
        if (oldFile.exists()) {
            oldFile.delete();
        }
        File sanXml = new File("config\\san.xml.backup");
        sanXml.renameTo(new File("config\\san.xml"));
    }

    public String getGeneralProperty(String aProp) {
        return this.myGeneralProperties.getProperty(aProp);
    }

    public VSwitchImpl createDefaultVswitch(ClusterImpl aCluster, String aVsIp) {
        if (aCluster == null) {
            throw new IllegalArgumentException("The given cluster should not be null.");
        }
        String defIpMask = Server.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.SNMP_DEFAULT_IP_MASK);
        int defRetries = new Integer(Server.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.SNMP_DEFAULT_NUM_OF_RETRIES));
        int defSnmpPort = new Integer(Server.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.SNMP_DEFAULT_PORT));
        int defTrapPort = new Integer(Server.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.SNMP_DEFAULT_TRAP_PORT));
        String defWriteComm = Server.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.SNMP_DEFAULT_WRITE_COMMUNITY);
        String defReadComm = Server.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.SNMP_DEFAULT_READ_COMMUNITY);
        int defTimeout = new Integer(Server.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.SNMP_DEFAULT_TIMEOUT_MILISEC));
        SnmpVersion defVersion = SnmpVersion.V2C;
        try {
            LogicMgrAOImpl.getInstance().addClusterVSwitch(aCluster.getCommKeyClassId(), aVsIp, defIpMask, defSnmpPort, defTrapPort, defReadComm, defWriteComm, defTimeout, defRetries, defVersion).get();
        }
        catch (SrExecutionException exp) {
            exp.printStackTrace();
            return null;
        }
        catch (InterruptedException exp) {
            exp.printStackTrace();
            return null;
        }
        while (!aCluster.isDiscoverCompleted()) {
            try {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (InterruptedException exp) {
                System.err.println("The createDefaultVswitch method with the parameters aCluster = " + aCluster + "; aVsIP = " + aVsIp + " was interrupted while waiting for cluster discovery to complete.");
            }
        }
        return aCluster.getVSwitchByIPAddress(aVsIp);
    }

    public void waitMillis(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void waitForDiscoveryToComplete() {
        try {
            while (!SystemRootImpl.getInstance().isDiscoverCompleted()) {
                this.waitMillis(100L);
            }
        }
        catch (RemoteException e) {
            throw new IllegalStateException(e);
        }
    }
}

