/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad;

import com.sanrad.SrTestUtils;
import com.sanrad.nms.server.logic.LogicObject;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.identity.CHAPCredentials;
import com.sanrad.nms.server.logic.identity.Credentials;
import com.sanrad.nms.server.logic.identity.IdentitiesList;
import com.sanrad.nms.server.logic.identity.Identity;
import com.sanrad.nms.server.logic.lu.LU;
import com.sanrad.nms.server.logic.target.ISCSITarget;
import com.sanrad.nms.server.logic.target.Target;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ConfigOperation;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.util.concurrent.IFuture;
import com.sanrad.util.concurrent.SrExecutionException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Vector;
import java.util.concurrent.ExecutionException;

public class SrTargetTestUtils {
    public Target createNewTarget(ClusterImpl aCluster, String aTargetName) {
        block8: {
            if (aCluster == null || aTargetName == null || aTargetName.equals("")) {
                assert (false) : "The parameters are invalid. aCluster = " + aCluster + "; aTargetName = " + aTargetName;
                return null;
            }
            try {
                String hashKey = aCluster.getStorage().hashKey();
                VSwitchImpl actVs = aCluster.getVSwitches().get(0);
                String vsName = actVs.getName();
                IFuture<Void> actionFuture = SrTestUtils.getInstance().getServerLogic().createISCSITarget(hashKey, aTargetName, aTargetName, vsName);
                actionFuture.get();
                return this.getTarget(aCluster, aTargetName);
            }
            catch (RemoteException exp) {
                assert (false) : "The create target action failed because of the following exception: " + exp;
            }
            catch (InterruptedException exp) {
                assert (false) : "The create target action failed because of the following exception: " + exp;
            }
            catch (ExecutionException exp) {
                if ($assertionsDisabled) break block8;
                throw new AssertionError((Object)("The create target action failed because of the following exception: " + exp));
            }
        }
        return null;
    }

    public Identity createNewIdentity(Cluster aCluster, String aAlias, String aDescription) {
        block8: {
            if (aCluster == null || aAlias == null || aDescription.equals("")) {
                assert (false) : "The parameters are invalid. aCluster = " + aCluster + "; aAlias = " + aAlias + "; aDescription = " + aDescription;
                return null;
            }
            try {
                IFuture<Void> actionFuture = SrTestUtils.getInstance().getServerLogic().createIdentity(aCluster.getCommKeyClassId(), aAlias, aDescription);
                actionFuture.get();
                return this.getIdentity(aCluster, aAlias);
            }
            catch (RemoteException exp) {
                assert (false) : "The create identity action failed because of the following exception: " + exp;
            }
            catch (InterruptedException exp) {
                assert (false) : "The create identity action failed because of the following exception: " + exp;
            }
            catch (ExecutionException exp) {
                if ($assertionsDisabled) break block8;
                throw new AssertionError((Object)("The create identity action failed because of the following exception: " + exp));
            }
        }
        return null;
    }

    public Target createNewTarget(ClusterImpl aCluster, String aTargetName, String aAlias) {
        block8: {
            if (aCluster == null || aTargetName == null || aAlias == null || aTargetName.equals("")) {
                assert (false) : "The parameters are invalid. aCluster = " + aCluster + "; aTargetName = " + aTargetName + "; aAlias = " + aAlias;
                return null;
            }
            try {
                IFuture<Void> actionFuture = SrTestUtils.getInstance().getServerLogic().createISCSITarget(aCluster.getStorage().hashKey(), aTargetName, aAlias, aCluster.getActiveVswitch().getName());
                actionFuture.get();
                return this.getTarget(aCluster, aTargetName);
            }
            catch (RemoteException exp) {
                assert (false) : "The create target action failed because of the following exception: " + exp;
            }
            catch (InterruptedException exp) {
                assert (false) : "The create target action failed because of the following exception: " + exp;
            }
            catch (ExecutionException exp) {
                if ($assertionsDisabled) break block8;
                throw new AssertionError((Object)("The create target action failed because of the following exception: " + exp));
            }
        }
        return null;
    }

    public CHAPCredentials createChapCredential(Identity aIden, String aName, String aPassword, boolean aIsRadiusEnabled) {
        block6: {
            try {
                IFuture<Void> actionFuture = SrTestUtils.getInstance().getServerLogic().createCHAPCredentials(aIden.getCommKeyClassId(), aName, aPassword, aIsRadiusEnabled);
                actionFuture.get();
                return (CHAPCredentials)this.getCredentials(aIden, aName);
            }
            catch (RemoteException exp) {
                assert (false) : "The create credentials action failed because of the following exception: " + exp;
            }
            catch (InterruptedException exp) {
                assert (false) : "The create credentials action failed because of the following exception: " + exp;
            }
            catch (ExecutionException exp) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError((Object)("The create credentials action failed because of the following exception: " + exp));
            }
        }
        return null;
    }

    public Target getTarget(Cluster aCluster, String aTargetName) {
        if (aCluster == null || aTargetName == null || aTargetName.equals("")) {
            assert (false) : "The given parameters are invalid. aCluster = " + aCluster + "; aTargetName = " + aTargetName;
            return null;
        }
        try {
            Vector<? extends ISCSITarget> targets = aCluster.getStorage().getTargetList();
            for (Object e : targets) {
                if (!(e instanceof Target)) {
                    assert (false) : "The list contains a non ISCSITarget instance";
                    continue;
                }
                Target curTarget = (Target)e;
                if (!curTarget.getName().equals(aTargetName)) continue;
                return curTarget;
            }
        }
        catch (RemoteException e) {
            assert (false) : "The target list could not be queried.";
            return null;
        }
        return null;
    }

    public Identity getIdentity(Cluster aCluster, String aIdentityAlias) {
        if (aCluster == null || aIdentityAlias == null || aIdentityAlias.equals("")) {
            assert (false) : "The given parameters are invalid. aCluster = " + aCluster + "; aIdentityAlias = " + aIdentityAlias;
            return null;
        }
        IdentitiesList identities = ((ClusterImpl)aCluster).getIdentitiesList();
        return identities.getIdentityByAlias(aIdentityAlias);
    }

    public Credentials getCredentials(Identity aIden, String aName) throws RemoteException {
        if (aIden == null || aName == null) {
            assert (false) : "The parameters are invalid. aIden = " + aIden + "; aName = " + aName;
            return null;
        }
        Vector<? extends Credentials> credentials = aIden.getCredentials();
        if (credentials == null) {
            return null;
        }
        for (Credentials credentials2 : credentials) {
            Credentials curCred;
            if (!(credentials2 instanceof Credentials) || !aName.equals((curCred = credentials2).getUserName())) continue;
            return curCred;
        }
        return null;
    }

    public void removeTarget(Target aTarget) {
        block9: {
            if (aTarget == null) {
                assert (false) : "The given target should not be null";
                return;
            }
            try {
                ArrayList<? extends LU> lus = new ArrayList<LU>();
                lus.addAll(aTarget.getLUs());
                for (Object e : lus) {
                    IFuture<Void> actionFuture = SrTestUtils.getInstance().getServerLogic().deleteElement(((LU)e).getCommKeyClassId());
                    actionFuture.get();
                }
                IFuture<Void> actionTarget = SrTestUtils.getInstance().getServerLogic().deleteElement(aTarget.getCommKeyClassId());
                actionTarget.get();
            }
            catch (InterruptedException exp) {
                assert (false) : "The target could not be removed because of the following exception: " + exp;
            }
            catch (RemoteException exp) {
                assert (false) : "The target could not be removed because of the following exception: " + exp;
            }
            catch (ExecutionException exp) {
                if ($assertionsDisabled) break block9;
                throw new AssertionError((Object)("The target could not be removed because of the following exception: " + exp));
            }
        }
    }

    public void removeIdentity(Identity aIden) {
        if (aIden == null) {
            assert (false) : "The parameters are invalid. aIden = " + aIden;
            return;
        }
        this.removeLogicObject(aIden);
    }

    public void removeChapCredentials(CHAPCredentials aCredentials) {
        if (aCredentials == null) {
            assert (false) : "The parameters are invalid. aCredentials = " + aCredentials;
            return;
        }
        this.removeLogicObject(aCredentials);
    }

    private void removeLogicObject(LogicObject aObj) {
        block8: {
            if (aObj == null) {
                assert (false) : "The parameters are invalid. aObj = " + aObj;
                return;
            }
            try {
                SrTestUtils.getInstance().getServerLogic().deleteObjects(aObj.getCluster().getCommKeyClassId(), new CommKeyClassId[]{aObj.getCommKeyClassId()}).get();
            }
            catch (RemoteException exp) {
                assert (false) : "The removal operation could not be completed because of the following exception: " + exp;
            }
            catch (SrExecutionException exp) {
                assert (false) : "The removal operation could not be completed because of the following exception: " + exp;
            }
            catch (InterruptedException exp) {
                if ($assertionsDisabled) break block8;
                throw new AssertionError((Object)("The removal operation could not be completed because of the following exception: " + exp));
            }
        }
    }

    public static ConfigElementData getCEDForTargetCreation(String aTargetAlias, ClusterImpl aCluster) {
        ConfigElementData ced = new ConfigElementData(ClassID.ISCSI_TARGET, ConfigOperation.CREATE);
        ced.setValue(ParameterCode.ISCSI_TARGET_NAME, new SrString(aTargetAlias));
        ced.setValue(ParameterCode.ISCSI_TARGET_ALIAS, new SrString(aTargetAlias));
        VSwitchImpl[] vswitches = aCluster.getConnectedVSwitches();
        if (vswitches.length == 0) {
            throw new IllegalArgumentException("Cluster " + aCluster + " doesn't contain connected V-Switches");
        }
        String vsName = vswitches[0].getName();
        ced.setValue(ParameterCode.ISCSI_TARGET_DEFAULT_EXPOSE_ON, new SrString(vsName));
        aCluster.prepareVSwitchIDs(ced, "SrTargetTestUtils.getCEDForNewTarget", null);
        return ced;
    }
}

