/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad;

import com.sanrad.SrTestUtils;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDevice;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDevice;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.util.concurrent.IFuture;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ExecutionException;

public class SrStorageTestUtils {
    public List<SubDirectAccessDevice> getAllSubDisks(ClusterImpl aCluster) {
        ArrayList<SubDirectAccessDevice> retVal = new ArrayList<SubDirectAccessDevice>();
        if (aCluster == null) {
            assert (false) : "The cluster that was given as a parameter is null.";
            return retVal;
        }
        List<DirectAccessDeviceImpl> disks = this.getAllDisks(aCluster);
        for (DirectAccessDeviceImpl curDisk : disks) {
            Vector<SubDirectAccessDeviceImpl> subs = curDisk.getSubDirectAccessDevices();
            for (Object e : subs) {
                if (!(e instanceof SubDirectAccessDevice)) continue;
                retVal.add((SubDirectAccessDevice)e);
            }
        }
        return retVal;
    }

    public List<DirectAccessDeviceImpl> getAllDisks(ClusterImpl aCluster) {
        ArrayList<DirectAccessDeviceImpl> retVal = new ArrayList<DirectAccessDeviceImpl>();
        if (aCluster == null) {
            assert (false) : "The cluster that was given as a parameter is null.";
            return retVal;
        }
        List storages = aCluster.getStorage().getStorageDevices();
        for (Object curStor : storages) {
            if (!(curStor instanceof DirectAccessDevice)) {
                assert (false) : "The returned object has to be of type DirectAccessDevice but it is of type " + curStor.getClass();
                continue;
            }
            retVal.add((DirectAccessDeviceImpl)curStor);
        }
        return retVal;
    }

    public DirectAccessDevice getDiskByAlias(Cluster aCluster, String aAlias) {
        if (aCluster == null || aAlias == null || aAlias.equals("")) {
            assert (false) : "The parameters are invalid. aCluster = " + aCluster + "; aAlias = " + aAlias;
            return null;
        }
        try {
            List storages = aCluster.getStorage().getStorageDevices();
            for (Object curStor : storages) {
                if (!(curStor instanceof DirectAccessDevice)) {
                    assert (false) : "The returned object has to be of type DirectAccessDevice but it is of type " + curStor.getClass();
                    continue;
                }
                DirectAccessDevice stor = (DirectAccessDevice)curStor;
                if (!stor.getAlias().equals(aAlias)) continue;
                return stor;
            }
        }
        catch (RemoteException e) {
            return null;
        }
        return null;
    }

    public boolean isDiskUsed(DirectAccessDevice aDisk) {
        if (aDisk == null) {
            assert (false) : "The given disk should not be null.";
            return false;
        }
        try {
            if (aDisk.getParentVolume() != null) {
                return true;
            }
            if (aDisk.getSubDirectAccessDevices() != null && aDisk.getSubDirectAccessDevices().size() > 0) {
                return true;
            }
        }
        catch (RemoteException e1) {
            e1.printStackTrace();
            return false;
        }
        return false;
    }

    public boolean isSubDiskUsed(SubDirectAccessDevice aSubDisk) {
        if (aSubDisk == null) {
            assert (false) : "The given sub disk should not be null.";
            return false;
        }
        try {
            if (aSubDisk.getParentVolume() != null) {
                return true;
            }
        }
        catch (RemoteException e1) {
            e1.printStackTrace();
            return false;
        }
        return false;
    }

    public List<SubDirectAccessDevice> getAllSubDisksForDisk(DirectAccessDevice aDisk) {
        ArrayList<SubDirectAccessDevice> retVal;
        block7: {
            retVal = new ArrayList<SubDirectAccessDevice>();
            if (aDisk == null) {
                assert (false) : "The parameters are invalid. aDisk = " + aDisk;
                return retVal;
            }
            try {
                Vector subdisks = aDisk.getSubDirectAccessDevices();
                for (Object curSub : subdisks) {
                    if (!(curSub instanceof SubDirectAccessDevice)) {
                        assert (false) : "The returned object has to be of type SubDirectAccessDevice but it is of type " + curSub.getClass();
                        continue;
                    }
                    retVal.add((SubDirectAccessDevice)curSub);
                }
            }
            catch (RemoteException e) {
                if ($assertionsDisabled) break block7;
                throw new AssertionError((Object)("The subdisks could not be queried because of the following exception: " + e));
            }
        }
        return retVal;
    }

    public boolean isSubDiskDefined(DirectAccessDevice aDisk) {
        if (aDisk == null) {
            assert (false) : "The given disk should not be null.";
            return false;
        }
        List<SubDirectAccessDevice> subs = this.getAllSubDisksForDisk(aDisk);
        return subs != null && subs.size() != 0;
    }

    public SubDirectAccessDeviceImpl getSubDiskByAlias(Cluster aCluster, String aAlias) {
        if (aCluster == null || aAlias == null || aAlias.equals("")) {
            assert (false) : "The parameters are invalid. aCluster = " + aCluster + "; aAlias = " + aAlias;
            return null;
        }
        try {
            List storages = aCluster.getStorage().getStorageDevices();
            for (Object curStor : storages) {
                if (!(curStor instanceof DirectAccessDevice)) {
                    assert (false) : "The returned object has to be of type DirectAccessDevice but it is of type " + curStor.getClass();
                    continue;
                }
                DirectAccessDevice stor = (DirectAccessDevice)curStor;
                Vector subdisks = stor.getSubDirectAccessDevices();
                for (Object curSub : subdisks) {
                    if (!(curSub instanceof SubDirectAccessDevice)) {
                        assert (false) : "The returned object has to be of type SubDirectAccessDevice but it is of type " + curStor.getClass();
                        continue;
                    }
                    SubDirectAccessDeviceImpl subdisk = (SubDirectAccessDeviceImpl)curSub;
                    if (!subdisk.getAlias().equals(aAlias)) continue;
                    return subdisk;
                }
            }
        }
        catch (RemoteException e) {
            return null;
        }
        return null;
    }

    public SubDirectAccessDeviceImpl createSubDisk(DirectAccessDevice aDisk, String aAlias, BigInteger aSize) {
        SubDirectAccessDeviceImpl retVal;
        block8: {
            retVal = null;
            if (aDisk == null || aAlias == null || aAlias.equals("") || aSize == null || aSize.longValue() < 1L) {
                assert (false) : "The given parameters are invalid. aDisk = " + aDisk + "; aAlias = " + aAlias + "; aSize = " + aSize;
                return null;
            }
            try {
                IFuture<Void> actionFuture = SrTestUtils.getInstance().getServerLogic().createSubDirectAccessDevice(aDisk.getCommKeyClassId(), aAlias, aSize);
                actionFuture.get();
                return this.getSubDiskByAlias(aDisk.getCluster(), aAlias);
            }
            catch (RemoteException exp) {
                assert (false) : "The sub disk creation could not be completed because of the following exception: " + exp;
            }
            catch (InterruptedException exp) {
                assert (false) : "The sub disk creation could not be completed because of the following exception: " + exp;
            }
            catch (ExecutionException exp) {
                if ($assertionsDisabled) break block8;
                throw new AssertionError((Object)("The sub disk creation could not be completed because of the following exception: " + exp));
            }
        }
        return retVal;
    }

    public void removeSubDisk(Cluster aCluster, String aAlias) throws RemoteException {
        if (aCluster == null || aAlias == null || aAlias.equals("")) {
            assert (false) : "The parameters are invalid. aCluster = " + aCluster + "; aAlias = " + aAlias;
            return;
        }
        SubDirectAccessDeviceImpl sub = this.getSubDiskByAlias(aCluster, aAlias);
        if (sub != null && sub.isFree()) {
            this.removeSubDisk(sub);
        } else if (sub == null) {
            assert (false) : "Could not remove the sub disk because it was not found.";
        } else assert (false) : "Could not remove the sub disk because it is not free.";
    }

    public void removeSubDisk(SubDirectAccessDevice aSubDisk) throws RemoteException {
        block6: {
            if (aSubDisk == null) {
                assert (false) : "The parameters are invalid. aSubDisk = " + aSubDisk;
                return;
            }
            IFuture<Void> actionFuture = SrTestUtils.getInstance().getServerLogic().deleteElement(aSubDisk.getCommKeyClassId());
            try {
                actionFuture.get();
            }
            catch (InterruptedException exp) {
                assert (false) : "The sub disk could not be removed because of the following exception: " + exp;
            }
            catch (ExecutionException exp) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError((Object)("The sub disk could not be removed because of the following exception: " + exp));
            }
        }
    }

    public List<DirectAccessDeviceImpl> getUnusedDisks(ClusterImpl aCluster, int aNumOfDisks) {
        ArrayList<DirectAccessDeviceImpl> retVal = new ArrayList<DirectAccessDeviceImpl>(aNumOfDisks);
        if (aCluster == null || aNumOfDisks < 1) {
            assert (false) : "The parameters are invalid. aCluster = " + aCluster + "; aNumOfDisks = " + aNumOfDisks;
            return null;
        }
        int disksFound = 0;
        List<DirectAccessDeviceImpl> disks = this.getAllDisks(aCluster);
        if (disks == null || aNumOfDisks > disks.size()) {
            return null;
        }
        for (DirectAccessDeviceImpl curDisk : disks) {
            if (curDisk != null && !this.isDiskUsed(curDisk) && !this.isSubDiskDefined(curDisk) && SrTestUtils.getInstance().getSimpleVolByPhysStor(aCluster, curDisk.getCommKeyClassId()) == null) {
                retVal.add(curDisk);
                ++disksFound;
            }
            if (disksFound != aNumOfDisks) continue;
            break;
        }
        if (retVal.size() != aNumOfDisks) {
            return null;
        }
        return retVal;
    }

    public void removeTransparent(Cluster aCluster, VolumeNode aVolume) {
        SrTestUtils.getInstance().removeVolume(aCluster, aVolume);
    }

    public VolumeNode createTransparent(Cluster aCluster, String aAlias, DirectAccessDevice aDisk) {
        block8: {
            if (aCluster == null || aAlias == null || aAlias.equals("") || aDisk == null) {
                assert (false) : "The given parameters are invalid. aCluster = " + aCluster + "; aAlias = " + aAlias + "; aDisk = " + aDisk;
                return null;
            }
            try {
                IFuture<Void> actionFuture = SrTestUtils.getInstance().getServerLogic().createTransparentVolume(aCluster.getStorage().hashKey(), aAlias, aDisk.getCommKeyClassId());
                actionFuture.get();
                return SrTestUtils.getInstance().getVolumeByAlias(aCluster, aAlias);
            }
            catch (RemoteException exp) {
                assert (false) : "The transparent creation could not be completed because of the following exception: " + exp;
            }
            catch (InterruptedException exp) {
                assert (false) : "The transparent creation could not be completed because of the following exception: " + exp;
            }
            catch (ExecutionException exp) {
                if ($assertionsDisabled) break block8;
                throw new AssertionError((Object)("The transparent creation could not be completed because of the following exception: " + exp));
            }
        }
        return null;
    }
}

