/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad;

import com.sanrad.SrTestUtils;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.types.constants.SnapshotActivateTypeConstants;
import com.sanrad.util.concurrent.IFuture;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;

public class SrSnapshotTestUtils {
    public VolumeNode createSnapshot(Cluster aCluster, VolumeNode aSource, VolumeNode aTarget, String aAlias) {
        block6: {
            try {
                IFuture<Void> actionFuture = SrTestUtils.getInstance().getServerLogic().createSnapshotVolume(aCluster.getStorage().hashKey(), aAlias, aSource.getCommKeyClassId(), aTarget.getCommKeyClassId(), 80, SnapshotActivateTypeConstants.SNAPSHOT_ACTIVE);
                actionFuture.get();
                return SrTestUtils.getInstance().getVolumeByAlias(aCluster, aAlias);
            }
            catch (RemoteException exp) {
                assert (false) : "The snapshot could not be created because of the following exception: " + exp;
            }
            catch (InterruptedException exp) {
                assert (false) : "The snapshot could not be created because of the following exception: " + exp;
            }
            catch (ExecutionException exp) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError((Object)("The snapshot could not be created because of the following exception: " + exp));
            }
        }
        return null;
    }

    public void removeSnapshot(Cluster aCluster, VolumeNode aVolume) {
        SrTestUtils.getInstance().removeVolume(aCluster, aVolume);
    }

    public void activateSnapshots(Cluster aCluster, List<CommKeyClassId> aSnapshots) {
        block7: {
            if (aCluster == null || aSnapshots == null) assert (false) : "The given parameters are invalid. aCluster = " + aCluster + "; aSnapshots = " + aSnapshots;
            try {
                SrTestUtils.getInstance().getServerLogic().activateDeactivateSnapshots(aCluster.getStorage().hashKey(), aSnapshots.toArray(new CommKeyClassId[1]), SnapshotActivateTypeConstants.SNAPSHOT_ACTIVE).get();
            }
            catch (RemoteException exp) {
                assert (false) : "The snapshots could not be activated because of a remote error.";
            }
            catch (InterruptedException exp) {
                assert (false) : "The snapshots could not be activated because the action was interrupted.";
            }
            catch (ExecutionException exp) {
                if ($assertionsDisabled) break block7;
                throw new AssertionError((Object)("The snapshots could not be activated because of the following error: " + exp));
            }
        }
    }

    public void activateSnapshot(Cluster aCluster, VolumeNode aSnapshot) {
        ArrayList<CommKeyClassId> snaps;
        block3: {
            if (aCluster == null || aSnapshot == null) assert (false) : "The given parameters are invalid. aCluster = " + aCluster + "; aSnapshot = " + aSnapshot;
            snaps = new ArrayList<CommKeyClassId>();
            try {
                snaps.add(aSnapshot.getCommKeyClassId());
            }
            catch (RemoteException exp) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)"Could not get the snapshot's CKCI because of a remote error.");
            }
        }
        this.activateSnapshots(aCluster, snaps);
    }

    public void deactivateSnapshots(Cluster aCluster, List<CommKeyClassId> aSnapshots) {
        block7: {
            if (aCluster == null || aSnapshots == null) assert (false) : "The given parameters are invalid. aCluster = " + aCluster + "; aSnapshots = " + aSnapshots;
            try {
                SrTestUtils.getInstance().getServerLogic().activateDeactivateSnapshots(aCluster.getStorage().hashKey(), aSnapshots.toArray(new CommKeyClassId[1]), SnapshotActivateTypeConstants.SNAPSHOT_INACTIVE).get();
            }
            catch (RemoteException exp) {
                assert (false) : "The snapshots could not be deactivated because of a remote error.";
            }
            catch (InterruptedException exp) {
                assert (false) : "The snapshots could not be deactivated because the action was interrupted.";
            }
            catch (ExecutionException exp) {
                if ($assertionsDisabled) break block7;
                throw new AssertionError((Object)("The snapshots could not be deactivated because of the following error: " + exp));
            }
        }
    }

    public void deactivateSnapshot(Cluster aCluster, VolumeNode aSnapshot) {
        ArrayList<CommKeyClassId> snaps;
        block3: {
            if (aCluster == null || aSnapshot == null) assert (false) : "The given parameters are invalid. aCluster = " + aCluster + "; aSnapshot = " + aSnapshot;
            snaps = new ArrayList<CommKeyClassId>();
            try {
                snaps.add(aSnapshot.getCommKeyClassId());
            }
            catch (RemoteException exp) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)"Could not get the snapshot's CKCI because of a remote error.");
            }
        }
        this.deactivateSnapshots(aCluster, snaps);
    }
}

