/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad;

import com.sanrad.SrTestUtils;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.Site;
import com.sanrad.nms.server.logic.VSwitchGroup;
import java.rmi.RemoteException;
import java.util.List;
import java.util.concurrent.ExecutionException;

public class SrSiteTestUtils {
    public Site createSite(String aAlias) {
        block11: {
            try {
                SrTestUtils.getInstance().getSystemRoot().createSite(aAlias).get();
            }
            catch (RemoteException exp) {
                assert (false) : "Could not create a new site, because of the following error: " + exp;
                return null;
            }
            catch (IllegalValueException exp) {
                assert (false) : "Could not create a new site, because of the following error: " + exp;
                return null;
            }
            catch (InterruptedException exp) {
                assert (false) : "Could not create a new site, because of the following error: " + exp;
                return null;
            }
            catch (ExecutionException exp) {
                assert (false) : "Could not create a new site, because of the following error: " + exp;
                return null;
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException exp) {
                if ($assertionsDisabled) break block11;
                throw new AssertionError((Object)("The test was interrupted which searching for the site: " + exp));
            }
        }
        return this.getSite(aAlias);
    }

    public Site getSite(String aAlias) {
        VSwitchGroup retVal = null;
        List<Site> allSites = SrTestUtils.getInstance().getAllSites();
        for (Site curSite : allSites) {
            try {
                if (!curSite.getAlias().equals(aAlias)) continue;
                retVal = curSite;
            }
            catch (RemoteException exp) {
                assert (false) : "Could not get the alias for the site.";
            }
        }
        if (retVal == null) {
            return null;
        }
        try {
            while (!retVal.isDiscoverCompleted()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException exp) {
                    System.err.println("The getSite method with the parameters aAlias = " + aAlias + " was interrupted while waiting for cluster discovery to complete.");
                }
            }
        }
        catch (RemoteException exp) {
            System.err.println("A remote exception has occurred inside a server context.");
        }
        return retVal;
    }

    public void removeSite(Site aSite) {
        block6: {
            try {
                SrTestUtils.getInstance().getServerLogic().deleteElement(aSite.getCommKeyClassId()).get();
            }
            catch (RemoteException exp) {
                assert (false) : "Could not remove the site because of a remote error.";
            }
            catch (InterruptedException exp) {
                assert (false) : "Could not remove the site because the operation was interrupted.";
            }
            catch (ExecutionException exp) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError((Object)("Could not remove the site because of the following error; " + exp));
            }
        }
    }
}

