/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad;

import com.sanrad.SrTestUtils;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.dr.DRAsyncPair;
import com.sanrad.nms.server.logic.dr.DRPair;
import com.sanrad.nms.server.logic.dr.DRRoot;
import com.sanrad.nms.server.logic.dr.DRSyncPair;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.types.constants.DRPairInitialSyncTypeConstant;
import com.sanrad.util.concurrent.IFuture;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;

public class SrPairTestUtils {
    public static final int PAIR_TIMEOUT = 60000;

    public DRSyncPair createSyncPair(VolumeNode aPrimaryVolume, VolumeNode aSecondaryVolume, String aLocalTarget, int aLocalLun, String aRemoteTarget, int aRemoteLun) throws RemoteException {
        block8: {
            if (aPrimaryVolume == null || aSecondaryVolume == null || aLocalTarget == null || aLocalTarget.equals("") || aLocalLun < 0 || aRemoteTarget == null || aRemoteLun < 0) {
                assert (false) : "The given parameters are invalid. aPrimaryVolume = " + aPrimaryVolume + "; aSecondaryVolume = " + aSecondaryVolume + "; aLocalTarget = " + aLocalTarget + "; aLocalLun = " + aLocalLun + "; aRemoteTarget = " + aRemoteTarget + "; aRemoteLun = " + aRemoteLun;
                return null;
            }
            CommKeyClassId primaryId = aPrimaryVolume.getCommKeyClassId();
            CommKeyClassId secondaryId = aSecondaryVolume.getCommKeyClassId();
            IFuture<Void> actionFuture = SrTestUtils.getInstance().getServerLogic().createSyncPair(DRPairInitialSyncTypeConstant.NONE, primaryId, secondaryId, aLocalTarget, aLocalLun, aRemoteTarget, aRemoteLun);
            try {
                actionFuture.get();
            }
            catch (InterruptedException exp) {
                assert (false) : "The pair could not be created because of the following exception: " + exp;
            }
            catch (ExecutionException exp) {
                if ($assertionsDisabled) break block8;
                throw new AssertionError((Object)("The pair could not be created because of the following exception: " + exp));
            }
        }
        DRPair retPair = this.getPairByVolumes(aPrimaryVolume, aSecondaryVolume);
        if (retPair instanceof DRSyncPair) {
            return (DRSyncPair)retPair;
        }
        assert (false) : "The object found is not a synchronous pair.";
        return null;
    }

    public DRAsyncPair createAsyncPair(VolumeNode aPrimaryVolume, VolumeNode aSecondaryVolume, String aLocalTarget, int aLocalLun, String aRemoteTarget, int aRemoteLun, CommKeyClassId aPrimarySnapshotId, CommKeyClassId aSecondarySnapshotId, HashMap aSecondarySnapshotParams, CommKeyClassId aPrimaryJournalId, CommKeyClassId aSecondaryJournalId, String aCG) throws RemoteException {
        block8: {
            if (aPrimaryVolume == null || aSecondaryVolume == null || aLocalTarget == null || aLocalTarget.equals("") || aLocalLun < 0 || aRemoteTarget == null || aRemoteLun < 0 || aPrimarySnapshotId == null || aSecondaryJournalId == null || aSecondarySnapshotParams == null || aPrimaryJournalId == null || aSecondarySnapshotId == null) {
                assert (false) : "The given parameters are invalid. aPrimaryVolume = " + aPrimaryVolume + "; aSecondaryVolume = " + aSecondaryVolume + "; aLocalTarget = " + aLocalTarget + "; aLocalLun = " + aLocalLun + "; aRemoteTarget = " + aRemoteTarget + "; aRemoteLun = " + aRemoteLun + "; aPrimarySnapshotId = " + aPrimarySnapshotId + "; aSecondarySnapshotId = " + aSecondarySnapshotId + "; aSecondarySnapshotParams = " + aSecondarySnapshotParams + "; aPrimaryJournalId = " + aPrimaryJournalId + "; aSecondaryJournalId = " + aSecondaryJournalId + "; aCG = " + aCG;
                return null;
            }
            CommKeyClassId primaryId = aPrimaryVolume.getCommKeyClassId();
            CommKeyClassId secondaryId = aSecondaryVolume.getCommKeyClassId();
            IFuture<Void> actionFuture = SrTestUtils.getInstance().getServerLogic().createAsyncPair(DRPairInitialSyncTypeConstant.NONE, primaryId, secondaryId, aLocalTarget, aLocalLun, aRemoteTarget, aRemoteLun, aPrimarySnapshotId, aSecondarySnapshotId, aSecondarySnapshotParams, aPrimaryJournalId, aSecondaryJournalId, aCG);
            try {
                actionFuture.get();
            }
            catch (InterruptedException exp) {
                assert (false) : "The pair could not be created because of the following exception: " + exp;
            }
            catch (ExecutionException exp) {
                if ($assertionsDisabled) break block8;
                throw new AssertionError((Object)("The pair could not be created because of the following exception: " + exp));
            }
        }
        DRPair retPair = this.getPairByVolumes(aPrimaryVolume, aSecondaryVolume);
        if (retPair instanceof DRAsyncPair) {
            return (DRAsyncPair)retPair;
        }
        assert (false) : "The pair found is not an asynchronous pair.";
        return null;
    }

    public void removePair(VolumeNode aPrimary, VolumeNode aSecondary) {
        if (aPrimary == null || aSecondary == null) {
            assert (false) : "The given parameters are invalid. aPrimaryVolume = " + aPrimary + "; aSecondaryVolume = " + aSecondary;
            return;
        }
        DRPair remPair = null;
        remPair = this.getPairByVolumes(aPrimary, aSecondary);
        if (remPair != null) {
            this.removePair(remPair);
        }
    }

    public void removePair(DRPair aPair) {
        block8: {
            if (aPair == null) {
                assert (false) : "The given pair is null";
                return;
            }
            try {
                IFuture<Void> actionFuture = SrTestUtils.getInstance().getServerLogic().deleteElement(aPair.hashKey());
                actionFuture.get();
            }
            catch (RemoteException exp) {
                assert (false) : "Could not remove the pair because of the following exception: " + exp;
            }
            catch (InterruptedException exp) {
                assert (false) : "Could not remove the pair because of the following exception: " + exp;
            }
            catch (ExecutionException exp) {
                if ($assertionsDisabled) break block8;
                throw new AssertionError((Object)("Could not remove the pair because of the following exception: " + exp));
            }
        }
    }

    private List<DRSyncPair> getSyncPairs(DRRoot aDrRoot) {
        if (aDrRoot == null) {
            assert (false) : "The given parameter should not be null.";
            return null;
        }
        ArrayList<DRSyncPair> retList = new ArrayList<DRSyncPair>();
        try {
            ArrayList drObjs = aDrRoot.getDRObjects();
            for (Object curObj : drObjs) {
                if (!(curObj instanceof DRSyncPair)) continue;
                retList.add((DRSyncPair)curObj);
            }
        }
        catch (RemoteException e) {
            assert (false) : "Could not retrieve the DR objects.";
            return null;
        }
        return retList;
    }

    private List<DRPair> getPairs(DRRoot aDrRoot) {
        if (aDrRoot == null) {
            assert (false) : "The given parameter should not be null.";
            return null;
        }
        ArrayList<DRPair> retList = new ArrayList<DRPair>();
        try {
            ArrayList drObjs = aDrRoot.getDRObjects();
            for (Object curObj : drObjs) {
                if (!(curObj instanceof DRPair)) continue;
                retList.add((DRPair)curObj);
            }
        }
        catch (RemoteException e) {
            assert (false) : "Could not retrieve the DR objects.";
            return null;
        }
        return retList;
    }

    public DRPair getPairByVolumes(VolumeNode aPrimary, VolumeNode aSecondary) {
        if (aPrimary == null || aSecondary == null) assert (false) : "The given parameters are invalid. aPrimary = " + aPrimary + "; aSecondary = " + aSecondary;
        DRRoot DrRoot = null;
        try {
            DrRoot = SrTestUtils.getInstance().getSystemRoot().getDRRoot();
        }
        catch (RemoteException exp) {
            assert (false) : "Could not get the dr root.";
            return null;
        }
        CommKeyClassId primaryId = null;
        CommKeyClassId secondaryId = null;
        try {
            primaryId = aPrimary.getCommKeyClassId();
            secondaryId = aSecondary.getCommKeyClassId();
        }
        catch (RemoteException e1) {
            assert (false) : "Could not get the CKCI for the given volumes.";
            return null;
        }
        List<DRPair> drPairs = this.getPairs(DrRoot);
        for (DRPair curPair : drPairs) {
            Object primaryObj = null;
            Object secondaryObj = null;
            try {
                primaryObj = curPair.getClientParameterList().get(ClientParameterCode.DR_PAIR_PRIMARY_VOLUME);
                secondaryObj = curPair.getClientParameterList().get(ClientParameterCode.DR_PAIR_SECONDARY_VOLUME);
                if (primaryObj == null || !(primaryObj instanceof VolumeNode) || secondaryObj == null || !(secondaryObj instanceof VolumeNode)) continue;
                VolumeNode primaryVol = (VolumeNode)curPair.getClientParameterList().get(ClientParameterCode.DR_PAIR_PRIMARY_VOLUME);
                VolumeNode secondaryVol = (VolumeNode)curPair.getClientParameterList().get(ClientParameterCode.DR_PAIR_SECONDARY_VOLUME);
                if (!primaryVol.getCommKeyClassId().equals(primaryId) || !secondaryVol.getCommKeyClassId().equals(secondaryId)) continue;
                return curPair;
            }
            catch (RemoteException e) {
                assert (false) : "Could not get the primary volume from the pair.";
            }
            catch (IllegalValueException e) {
                assert (false) : "Could not get the primary volume from the pair.";
            }
        }
        return null;
    }
}

