/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad;

import com.sanrad.SrTestUtils;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.util.concurrent.IFuture;
import java.rmi.RemoteException;
import java.util.concurrent.ExecutionException;

public class SrMirrorTestUtils {
    public void addChildToMirror(VolumeNode aMirror, CommKeyClassId aChild, boolean aAutoSync) {
        block8: {
            if (aMirror == null || aChild == null) {
                assert (false) : "The given parameters are invalid. aMirror = " + aMirror + "; aChildren = " + aChild;
                return;
            }
            try {
                IFuture<Void> actionFuture = SrTestUtils.getInstance().getServerLogic().addMirror(aMirror.getCommKeyClassId(), aChild, aMirror.getAlias(), aAutoSync);
                actionFuture.get();
            }
            catch (RemoteException e) {
                e.printStackTrace();
                assert (false) : "Could not add the child to the mirror because of the following exception: " + e;
            }
            catch (InterruptedException exp) {
                exp.printStackTrace();
                assert (false) : "Could not add the child to the mirror because of the following exception: " + exp;
            }
            catch (ExecutionException exp) {
                exp.printStackTrace();
                if ($assertionsDisabled) break block8;
                throw new AssertionError((Object)("Could not add the child to the mirror because of the following exception: " + exp));
            }
        }
    }

    public VolumeNode createMirror(Cluster aCluster, CommKeyClassId[] aChildren, String aAlias) {
        block6: {
            try {
                IFuture<Void> actionFuture = SrTestUtils.getInstance().getServerLogic().createMirrorVolume(aCluster.getStorage().hashKey(), aAlias, aChildren);
                actionFuture.get();
                return SrTestUtils.getInstance().getVolumeByAlias(aCluster, aAlias);
            }
            catch (RemoteException e1) {
                assert (false) : "The mirror could not be created because of the following exception: " + e1;
            }
            catch (InterruptedException e) {
                assert (false) : "The mirror could not be created because of the following exception: " + e;
            }
            catch (ExecutionException exp) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError((Object)("The mirror could not be created because of the following exception: " + exp));
            }
        }
        return null;
    }

    public void removeMirror(Cluster aCluster, VolumeNode aVolume) {
        SrTestUtils.getInstance().removeVolume(aCluster, aVolume);
    }
}

